/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntArray;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataIntField;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataStruct;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationUtilsKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleMetadataCache;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleTypeTransformer;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.lower.StaticMembersLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.wasm.ir.TypesKt;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020%H\u0016J8\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,2\u0010\b\u0002\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0006\u00100\u001a\u00020\u000bH\u0002J\u0010\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u001c2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00108\u001a\u00020\u001c2\u0006\u0010 \u001a\u000206H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000203H\u0002J\u0010\u0010<\u001a\u00020:2\u0006\u0010;\u001a\u000203H\u0002J\u0010\u0010=\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020>H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFileCodegenContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmModuleTypeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;", "wasmModuleMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;", "allowIncompleteImplementations", "", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;Z)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstanceFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstanceFunction$delegate", "Lkotlin/Lazy;", "unitPrimaryConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getUnitPrimaryConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "unitPrimaryConstructor$delegate", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitProperty", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "createVirtualTableStruct", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "methods", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/VirtualMethodMetadata;", "name", "", "superType", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "isFinal", "createVTable", "metadata", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "addClassInterfaceInheritanceStructure", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "createClassITable", "visitClass", "binaryDataStruct", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataStruct;", "classMetadata", "interfaceTable", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDeclarationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilderKt\n*L\n1#1,548:1\n1557#2:549\n1628#2,3:550\n1557#2:554\n1628#2,3:555\n1872#2,3:560\n1557#2:564\n1628#2,3:565\n1628#2,3:571\n1557#2:574\n1628#2,3:575\n1#3:553\n297#4,2:558\n299#4:563\n297#4,3:568\n*S KotlinDebug\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n*L\n83#1:549\n83#1:550,3\n193#1:554\n193#1:555,3\n228#1:560,3\n255#1:564\n255#1:565,3\n347#1:571,3\n420#1:574\n420#1:575,3\n226#1:558,2\n226#1:563\n269#1:568,3\n*E\n"})
public final class DeclarationGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmFileCodegenContext wasmFileCodegenContext;
    @NotNull
    private final WasmModuleTypeTransformer wasmModuleTypeTransformer;
    @NotNull
    private final WasmModuleMetadataCache wasmModuleMetadataCache;
    private final boolean allowIncompleteImplementations;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstanceFunction$delegate;
    @NotNull
    private final Lazy unitPrimaryConstructor$delegate;

    public DeclarationGenerator(@NotNull WasmBackendContext backendContext, @NotNull WasmFileCodegenContext wasmFileCodegenContext, @NotNull WasmModuleTypeTransformer wasmModuleTypeTransformer, @NotNull WasmModuleMetadataCache wasmModuleMetadataCache, boolean allowIncompleteImplementations) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFileCodegenContext, (String)"wasmFileCodegenContext");
        Intrinsics.checkNotNullParameter((Object)wasmModuleTypeTransformer, (String)"wasmModuleTypeTransformer");
        Intrinsics.checkNotNullParameter((Object)wasmModuleMetadataCache, (String)"wasmModuleMetadataCache");
        this.backendContext = backendContext;
        this.wasmFileCodegenContext = wasmFileCodegenContext;
        this.wasmModuleTypeTransformer = wasmModuleTypeTransformer;
        this.wasmModuleMetadataCache = wasmModuleMetadataCache;
        this.allowIncompleteImplementations = allowIncompleteImplementations;
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstanceFunction$delegate = LazyKt.lazy(() -> DeclarationGenerator.unitGetInstanceFunction_delegate$lambda$0(this));
        this.unitPrimaryConstructor$delegate = LazyKt.lazy(() -> DeclarationGenerator.unitPrimaryConstructor_delegate$lambda$1(this));
    }

    private final IrSimpleFunction getUnitGetInstanceFunction() {
        Lazy lazy = this.unitGetInstanceFunction$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    private final IrConstructor getUnitPrimaryConstructor() {
        Lazy lazy = this.unitPrimaryConstructor$delegate;
        return (IrConstructor)lazy.getValue();
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    public void visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isExternal()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    /*
     * WARNING - void declaration
     */
    public void visitFunction(@NotNull IrFunction declaration) {
        String nameIfExported;
        WasmImportDescriptor importedName;
        WasmImportDescriptor wasmImportDescriptor;
        void $this$mapTo$iv$iv;
        boolean isIntrinsic;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrConstructor && (this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)declaration))) || AnnotationsKt.hasWasmPrimitiveConstructorAnnotation((IrAnnotationContainer)declaration))) {
            return;
        }
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)declaration) || AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)declaration) != null;
        if (isIntrinsic) {
            return;
        }
        if (IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)declaration))) {
            return;
        }
        String watName = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
        List<IrValueParameter> irParameters = DeclarationGeneratorKt.getEffectiveValueParameters(declaration);
        IrFunction irFunction = declaration;
        WasmType resultType = Intrinsics.areEqual((Object)irFunction, (Object)this.getUnitGetInstanceFunction()) || Intrinsics.areEqual((Object)irFunction, (Object)this.getUnitPrimaryConstructor()) ? this.wasmModuleTypeTransformer.transformType(declaration.getReturnType()) : this.wasmModuleTypeTransformer.transformResultType(declaration.getReturnType());
        Iterable $this$map$iv22 = irParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.wasmModuleTypeTransformer.transformValueParameterType((IrValueParameter)it));
        }
        List list = CollectionsKt.listOfNotNull((Object)resultType);
        List list2 = (List)destination$iv$iv;
        WasmFunctionType wasmFunctionType = new WasmFunctionType(list2, list);
        this.wasmFileCodegenContext.defineFunctionType(declaration.getSymbol(), wasmFunctionType);
        if (declaration instanceof IrSimpleFunction && ((IrSimpleFunction)declaration).getModality() == Modality.ABSTRACT) {
            return;
        }
        boolean $this$map$iv22 = Intrinsics.areEqual((Object)declaration, (Object)IrResolveUtilsKt.getRealOverrideTarget(declaration));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-DeclarationGenerator$visitFunction$22 = false;
            String $i$a$-assert-DeclarationGenerator$visitFunction$22 = "Sanity check that " + declaration + " is a real function that can be used in calls";
            throw new AssertionError((Object)$i$a$-assert-DeclarationGenerator$visitFunction$22);
        }
        WasmSymbol<WasmFunctionType> functionTypeSymbol = this.wasmFileCodegenContext.referenceFunctionType(declaration.getSymbol());
        WasmImportDescriptor wasmImportModule = AnnotationsKt.getWasmImportDescriptor(declaration);
        String jsCode = AnnotationsKt.getJsFunAnnotation((IrAnnotationContainer)declaration);
        if (wasmImportModule != null) {
            if (!declaration.isExternal()) {
                boolean $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = false;
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = "Non-external fun with @WasmImport " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
                throw new IllegalStateException($i$a$-check-DeclarationGenerator$visitFunction$importedName$22.toString());
            }
            this.wasmFileCodegenContext.addJsModuleImport(declaration.getSymbol(), wasmImportModule.getModuleName());
            wasmImportDescriptor = wasmImportModule;
        } else if (jsCode != null) {
            if (!(declaration instanceof IrSimpleFunction)) {
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$22 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-check-DeclarationGenerator$visitFunction$importedName$22.toString());
            }
            WasmSymbol jsFunName = new WasmSymbol((Object)String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration))));
            this.wasmFileCodegenContext.addJsFun((IrFunctionSymbol)((IrSimpleFunction)declaration).getSymbol(), (WasmSymbol<String>)jsFunName, jsCode);
            wasmImportDescriptor = new WasmImportDescriptor("js_code", (WasmSymbolReadOnly)jsFunName);
        } else {
            wasmImportDescriptor = importedName = null;
        }
        if (importedName != null) {
            this.wasmFileCodegenContext.defineFunction(declaration.getSymbol(), (WasmFunction)new WasmFunction.Imported(watName, (WasmSymbolReadOnly)functionTypeSymbol, importedName));
            return;
        }
        WasmFunction.Defined function2 = new WasmFunction.Defined(watName, (WasmSymbolReadOnly)functionTypeSymbol, null, null, 12, null);
        WasmFunctionCodegenContext functionCodegenContext = new WasmFunctionCodegenContext(declaration, function2, this.backendContext, this.wasmFileCodegenContext, this.wasmModuleTypeTransformer);
        for (IrValueParameter irParameter : irParameters) {
            functionCodegenContext.defineLocal((IrValueSymbol)irParameter.getSymbol());
        }
        WasmExpressionBuilder exprGen = functionCodegenContext.getBodyGen();
        BodyGenerator bodyBuilder = new BodyGenerator(this.backendContext, this.wasmFileCodegenContext, functionCodegenContext, this.wasmModuleMetadataCache, this.wasmModuleTypeTransformer);
        if (declaration instanceof IrConstructor) {
            bodyBuilder.generateObjectCreationPrefixIfNeeded((IrConstructor)declaration);
        }
        if (!(declaration.getBody() instanceof IrBlockBody)) {
            boolean bl3 = false;
            String string = "Only IrBlockBody is supported";
            throw new IllegalArgumentException(string.toString());
        }
        IrBody irBody = declaration.getBody();
        if (irBody != null) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irBody), (IrElementVisitorVoid)bodyBuilder);
        }
        if (declaration instanceof IrConstructor) {
            exprGen.buildGetLocal((WasmLocal)function2.getLocals().get(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
            exprGen.buildInstr(WasmOp.RETURN, SourceLocation.Companion.NoLocation("Implicit return from constructor"), new WasmImmediate[0]);
        }
        if (!((Collection)wasmFunctionType.getResultTypes()).isEmpty()) {
            LocationUtilsKt.buildUnreachableForVerifier(exprGen);
        }
        this.wasmFileCodegenContext.defineFunction(declaration.getSymbol(), (WasmFunction)function2);
        String string = nameIfExported = AnnotationUtilsKt.isJsExport((IrAnnotationContainer)declaration) ? AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).getIdentifier() : AnnotationsKt.getWasmExportNameIfWasmExport(declaration);
        if (nameIfExported != null) {
            this.wasmFileCodegenContext.addExport((WasmExport)new WasmExport.Function(nameIfExported, (WasmFunction)function2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WasmStructDeclaration createVirtualTableStruct(List<VirtualMethodMetadata> methods2, String name, WasmSymbolReadOnly<? extends WasmTypeDeclaration> superType, boolean isFinal) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = methods2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getSignature().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            collection.add(new WasmStructFieldDeclaration(string, (WasmType)new WasmRefNullType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.wasmFileCodegenContext.referenceFunctionType((IrFunctionSymbol)it.getFunction().getSymbol()))), false));
        }
        List tableFields = (List)destination$iv$iv;
        return new WasmStructDeclaration(name, tableFields, superType, isFinal);
    }

    static /* synthetic */ WasmStructDeclaration createVirtualTableStruct$default(DeclarationGenerator declarationGenerator, List list, String string, WasmSymbolReadOnly wasmSymbolReadOnly, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            wasmSymbolReadOnly = null;
        }
        return declarationGenerator.createVirtualTableStruct(list, string, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)wasmSymbolReadOnly, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void createVTable(ClassMetadata metadata) {
        WasmSymbol<WasmTypeDeclaration> wasmSymbol;
        IrClass klass = metadata.getKlass();
        IrClassSymbol symbol = klass.getSymbol();
        String vtableName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + ".vtable";
        DeclarationGenerator declarationGenerator = this;
        List<VirtualMethodMetadata> list = metadata.getVirtualMethods();
        String string = vtableName;
        ClassMetadata classMetadata = metadata.getSuperClass();
        if (classMetadata != null && (classMetadata = classMetadata.getKlass()) != null && (classMetadata = classMetadata.getSymbol()) != null) {
            void p0;
            ClassMetadata classMetadata2 = classMetadata;
            WasmFileCodegenContext wasmFileCodegenContext = this.wasmFileCodegenContext;
            ClassMetadata classMetadata3 = classMetadata2;
            String string2 = string;
            List<VirtualMethodMetadata> list2 = list;
            DeclarationGenerator declarationGenerator2 = declarationGenerator;
            boolean bl = false;
            WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = wasmFileCodegenContext.referenceVTableGcType((IrClassSymbol)p0);
            declarationGenerator = declarationGenerator2;
            list = list2;
            string = string2;
            wasmSymbol = wasmSymbol2;
        } else {
            wasmSymbol = null;
        }
        WasmStructDeclaration vtableStruct = declarationGenerator.createVirtualTableStruct(list, string, (WasmSymbolReadOnly<? extends WasmTypeDeclaration>)((WasmSymbolReadOnly)wasmSymbol), klass.getModality() == Modality.FINAL);
        this.wasmFileCodegenContext.defineVTableGcType(metadata.getKlass().getSymbol(), (WasmTypeDeclaration)vtableStruct);
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        WasmSymbol<WasmTypeDeclaration> vTableTypeReference = this.wasmFileCodegenContext.referenceVTableGcType(symbol);
        WasmRefType vTableRefGcType = new WasmRefType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)vTableTypeReference));
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createVTable_u24lambda_u249 = new WasmExpressionBuilder(res$iv);
        boolean bl = false;
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of vtable struct");
        Iterable $this$forEachIndexed$iv = metadata.getVirtualMethods();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void method;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv;
            int i = n;
            boolean bl2 = false;
            if (method.getFunction().getModality() != Modality.ABSTRACT) {
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(this.wasmFileCodegenContext.referenceFunction((IrFunctionSymbol)method.getFunction().getSymbol()))};
                $this$createVTable_u24lambda_u249.buildInstr(WasmOp.REF_FUNC, location, wasmImmediateArray);
                continue;
            }
            if (!this.allowIncompleteImplementations) {
                boolean bl3 = false;
                String string3 = "Cannot find class implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass));
                throw new IllegalStateException(string3.toString());
            }
            $this$createVTable_u24lambda_u249.buildRefNull(TypesKt.getHeapType((WasmType)((WasmStructFieldDeclaration)vtableStruct.getFields().get(i)).getType()), location);
        }
        $this$createVTable_u24lambda_u249.buildStructNew(vTableTypeReference, location);
        List initVTableGlobal = res$iv;
        this.wasmFileCodegenContext.defineGlobalVTable(symbol, new WasmGlobal(vtableName, (WasmType)vTableRefGcType, false, initVTableGlobal, null, 16, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void addClassInterfaceInheritanceStructure(IrClass klass) {
        if (klass.isExternal()) {
            return;
        }
        if (AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)klass) != null) {
            return;
        }
        if (IrUtilsKt.isInterface((IrClass)klass)) {
            return;
        }
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        ClassMetadata classMetadata = this.wasmModuleMetadataCache.getClassMetadata(klass.getSymbol());
        if (!((Collection)classMetadata.getInterfaces()).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = classMetadata.getInterfaces();
            WasmFileCodegenContext wasmFileCodegenContext = this.wasmFileCodegenContext;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrClass irClass = (IrClass)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            wasmFileCodegenContext.addInterfaceUnion((List)destination$iv$iv);
        }
    }

    private final void createClassITable(ClassMetadata metadata) {
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of itable struct");
        IrClass klass = metadata.getKlass();
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        IrClass irClass = (IrClass)CollectionsKt.firstOrNull(metadata.getInterfaces());
        if (irClass == null || (irClass = irClass.getSymbol()) == null) {
            return;
        }
        IrClass supportedInterface = irClass;
        this.addClassInterfaceInheritanceStructure(klass);
        WasmSymbol<WasmTypeDeclaration> classInterfaceType = this.wasmFileCodegenContext.referenceClassITableGcType((IrClassSymbol)supportedInterface);
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createClassITable_u24lambda_u2412 = new WasmExpressionBuilder(res$iv);
        boolean bl = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.SymbolI32(this.wasmFileCodegenContext.referenceClassITableInterfaceTableSize((IrClassSymbol)supportedInterface))};
        $this$createClassITable_u24lambda_u2412.buildInstr(WasmOp.MACRO_TABLE, location, wasmImmediateArray);
        for (IrClass iFace : metadata.getInterfaces()) {
            WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.SymbolI32(this.wasmFileCodegenContext.referenceClassITableInterfaceSlot(iFace.getSymbol()))};
            $this$createClassITable_u24lambda_u2412.buildInstr(WasmOp.MACRO_TABLE_INDEX, location, wasmImmediateArray2);
            WasmSymbol<WasmTypeDeclaration> iFaceVTableGcType = this.wasmFileCodegenContext.referenceVTableGcType(iFace.getSymbol());
            for (VirtualMethodMetadata method : this.wasmModuleMetadataCache.getInterfaceMetadata(iFace.getSymbol()).getMethods()) {
                Object v1;
                WasmImmediate[] wasmImmediateArray3;
                block7: {
                    wasmImmediateArray3 = (WasmImmediate[])metadata.getVirtualMethods();
                    for (Object t : wasmImmediateArray3) {
                        VirtualMethodMetadata it = (VirtualMethodMetadata)t;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getSignature(), (Object)method.getSignature()) && it.getFunction().getModality() != Modality.ABSTRACT)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                VirtualMethodMetadata classMethod = v1;
                if (classMethod == null && !this.allowIncompleteImplementations && !this.backendContext.getPartialLinkageSupport().isEnabled()) {
                    throw new IllegalStateException(("Cannot find interface implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass))).toString());
                }
                if (classMethod != null) {
                    WasmSymbol<WasmFunction> functionTypeReference = this.wasmFileCodegenContext.referenceFunction((IrFunctionSymbol)classMethod.getFunction().getSymbol());
                    wasmImmediateArray3 = new WasmImmediate[]{new WasmImmediate.FuncIdx(functionTypeReference)};
                    $this$createClassITable_u24lambda_u2412.buildInstr(WasmOp.REF_FUNC, location, wasmImmediateArray3);
                    continue;
                }
                $this$createClassITable_u24lambda_u2412.buildRefNull((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.wasmFileCodegenContext.referenceFunctionType((IrFunctionSymbol)method.getFunction().getSymbol())), location);
            }
            $this$createClassITable_u24lambda_u2412.buildStructNew(iFaceVTableGcType, location);
        }
        $this$createClassITable_u24lambda_u2412.buildInstr(WasmOp.MACRO_TABLE_END, location, new WasmImmediate[0]);
        $this$createClassITable_u24lambda_u2412.buildStructNew(classInterfaceType, location);
        List initITableGlobal = res$iv;
        WasmGlobal wasmClassIFaceGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + ".classITable", (WasmType)new WasmRefType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)classInterfaceType)), false, initITableGlobal, null, 16, null);
        this.wasmFileCodegenContext.defineGlobalClassITable(klass.getSymbol(), wasmClassIFaceGlobal);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isExternal()) {
            return;
        }
        IrClassSymbol symbol = declaration.getSymbol();
        WasmArrayInfo wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)declaration);
        if (wasmArrayInfo != null) {
            WasmArrayInfo wasmArrayAnnotation = wasmArrayInfo;
            boolean bl = false;
            String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
            WasmArrayDeclaration wasmArrayDeclaration = new WasmArrayDeclaration(nameStr, new WasmStructFieldDeclaration("field", this.wasmModuleTypeTransformer.transformFieldType(wasmArrayAnnotation.getType()), true));
            this.wasmFileCodegenContext.defineGcType(symbol, (WasmTypeDeclaration)wasmArrayDeclaration);
            return;
        }
        String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
        if (IrUtilsKt.isInterface((IrClass)declaration)) {
            WasmStructDeclaration vtableStruct = DeclarationGenerator.createVirtualTableStruct$default(this, this.wasmModuleMetadataCache.getInterfaceMetadata(symbol).getMethods(), nameStr + ".itable", null, true, 4, null);
            this.wasmFileCodegenContext.defineVTableGcType(symbol, (WasmTypeDeclaration)vtableStruct);
        } else {
            WasmSymbol<WasmTypeDeclaration> wasmSymbol;
            ClassMetadata metadata = this.wasmModuleMetadataCache.getClassMetadata(symbol);
            this.createVTable(metadata);
            this.createClassITable(metadata);
            WasmRefType vtableRefGcType = new WasmRefType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.wasmFileCodegenContext.referenceVTableGcType(symbol)));
            WasmRefNullType classITableRefGcType = new WasmRefNullType((WasmHeapType)WasmHeapType.Simple.Struct.INSTANCE);
            List fields2 = new ArrayList();
            fields2.add(new WasmStructFieldDeclaration("vtable", (WasmType)vtableRefGcType, false));
            fields2.add(new WasmStructFieldDeclaration("itable", (WasmType)classITableRefGcType, false));
            Iterable $this$mapTo$iv = ClassInfoKt.allFields(declaration, this.irBuiltIns);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                IrField irField = (IrField)item$iv;
                Collection collection = fields2;
                boolean bl = false;
                String string = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(new WasmStructFieldDeclaration(string, this.wasmModuleTypeTransformer.transformFieldType(it.getType()), true));
            }
            ClassMetadata superClass = metadata.getSuperClass();
            String string = nameStr;
            List list = fields2;
            ClassMetadata classMetadata = superClass;
            if (classMetadata != null) {
                Object item$iv;
                item$iv = classMetadata;
                List list2 = list;
                String string2 = string;
                boolean bl = false;
                WasmSymbol<WasmTypeDeclaration> wasmSymbol2 = this.wasmFileCodegenContext.referenceGcType(superClass.getKlass().getSymbol());
                string = string2;
                list = list2;
                wasmSymbol = wasmSymbol2;
            } else {
                wasmSymbol = null;
            }
            boolean bl = declaration.getModality() == Modality.FINAL;
            WasmSymbolReadOnly wasmSymbolReadOnly = (WasmSymbolReadOnly)wasmSymbol;
            List list3 = list;
            String string3 = string;
            WasmStructDeclaration structType = new WasmStructDeclaration(string3, list3, wasmSymbolReadOnly, bl);
            this.wasmFileCodegenContext.defineGcType(symbol, (WasmTypeDeclaration)structType);
            this.wasmFileCodegenContext.generateTypeInfo(symbol, this.binaryDataStruct(metadata));
        }
        for (IrDeclaration member : declaration.getDeclarations()) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)member), (IrElementVisitorVoid)this);
        }
    }

    private final ConstantDataStruct binaryDataStruct(ClassMetadata classMetadata) {
        ConstantDataIntField constantDataIntField;
        IrClass superClass;
        String string;
        boolean fqnShouldBeEmitted = (Boolean)CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)this.backendContext.getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        IrClass klass = classMetadata.getKlass();
        if (fqnShouldBeEmitted) {
            FqName fqName = StaticMembersLoweringKt.getOriginalFqName(klass);
            if (fqName == null) {
                fqName = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)klass));
            }
            if ((string = FqNamesUtilKt.parentOrNull((FqName)fqName)) == null || (string = string.asString()) == null) {
                string = "";
            }
        } else {
            string = "";
        }
        String qualifier = string;
        String string2 = klass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String simpleName = string2;
        Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair = this.wasmFileCodegenContext.referenceStringLiteralAddressAndId(qualifier);
        WasmSymbol packageNameAddress = (WasmSymbol)pair.component1();
        WasmSymbol packageNamePoolId = (WasmSymbol)pair.component2();
        Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> pair2 = this.wasmFileCodegenContext.referenceStringLiteralAddressAndId(simpleName);
        WasmSymbol simpleNameAddress = (WasmSymbol)pair2.component1();
        WasmSymbol simpleNamePoolId = (WasmSymbol)pair2.component2();
        Object[] objectArray = new ConstantDataIntField[]{new ConstantDataIntField("TypePackageNameLength", qualifier.length()), new ConstantDataIntField("TypePackageNameId", (WasmSymbol<Integer>)packageNamePoolId), new ConstantDataIntField("TypePackageNamePtr", (WasmSymbol<Integer>)packageNameAddress), new ConstantDataIntField("TypeNameLength", simpleName.length()), new ConstantDataIntField("TypeNameId", (WasmSymbol<Integer>)simpleNamePoolId), new ConstantDataIntField("TypeNamePtr", (WasmSymbol<Integer>)simpleNameAddress)};
        ConstantDataStruct typeInfo = new ConstantDataStruct("TypeInfo", CollectionsKt.listOf((Object[])objectArray));
        IrClass irClass = superClass = ClassInfoKt.getSuperClass(klass, this.backendContext.getIrBuiltIns());
        if (irClass != null) {
            IrClass it = irClass;
            boolean bl = false;
            constantDataIntField = new ConstantDataIntField("SuperTypeId", this.wasmFileCodegenContext.referenceTypeId(it.getSymbol()));
        } else {
            constantDataIntField = new ConstantDataIntField("SuperTypeId", -1);
        }
        ConstantDataIntField superTypeId = constantDataIntField;
        Object[] objectArray2 = new ConstantDataElement[]{typeInfo, superTypeId};
        List typeInfoContent = CollectionsKt.mutableListOf((Object[])objectArray2);
        if (!UtilsKt.isAbstractOrSealed(klass)) {
            typeInfoContent.add(this.interfaceTable(classMetadata));
        }
        return new ConstantDataStruct("Class TypeInfo: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + ' ', typeInfoContent);
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantDataStruct interfaceTable(ClassMetadata classMetadata) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<IrClass> interfaces = classMetadata.getInterfaces();
        ConstantDataIntField size = new ConstantDataIntField("size", interfaces.size());
        Object[] objectArray = (Object[])interfaces;
        String string = "interfaceIds";
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrClass irClass = (IrClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.wasmFileCodegenContext.referenceTypeId(it.getSymbol()));
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        ConstantDataIntArray interfaceIds = new ConstantDataIntArray(string2, list);
        objectArray = new ConstantDataElement[]{size, interfaceIds};
        return new ConstantDataStruct("Class interface table: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)classMetadata.getKlass())) + ' ', CollectionsKt.listOf((Object[])objectArray));
    }

    public void visitField(@NotNull IrField declaration) {
        IrExpression initValue;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isStatic()) {
            return;
        }
        WasmType wasmType = this.wasmModuleTypeTransformer.transformType(declaration.getType());
        List initBody = new ArrayList();
        WasmExpressionBuilder wasmExpressionGenerator = new WasmExpressionBuilder(initBody);
        IrExpressionBody irExpressionBody = declaration.getInitializer();
        Object object = initValue = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (initValue != null) {
            if (initValue instanceof IrConst && !(((IrConst)initValue).getKind() instanceof IrConstKind.String)) {
                DeclarationGeneratorKt.generateConstExpression((IrConst)initValue, wasmExpressionGenerator, this.wasmFileCodegenContext, this.backendContext, LocationUtilsKt.getSourceLocation$default((IrElement)declaration, (IrSymbol)declaration.getSymbol(), IrUtilsKt.getFileOrNull((IrDeclaration)((IrDeclaration)declaration)), null, 4, null));
            } else {
                WasmFunction.Defined stubFunction = new WasmFunction.Defined("static_fun_stub", (WasmSymbolReadOnly)new WasmSymbol(null, 1, null), null, null, 12, null);
                WasmFunctionCodegenContext functionCodegenContext = new WasmFunctionCodegenContext(null, stubFunction, this.backendContext, this.wasmFileCodegenContext, this.wasmModuleTypeTransformer);
                BodyGenerator bodyGenerator = new BodyGenerator(this.backendContext, this.wasmFileCodegenContext, functionCodegenContext, this.wasmModuleMetadataCache, this.wasmModuleTypeTransformer);
                bodyGenerator.generateExpression$backend_wasm(initValue);
                this.wasmFileCodegenContext.addFieldInitializer(declaration.getSymbol(), stubFunction.getInstructions(), IrJsUtilsKt.isObjectInstanceField(declaration));
                DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
            }
        } else {
            DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
        }
        WasmGlobal global = new WasmGlobal(String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration))), wasmType, true, initBody, null, 16, null);
        this.wasmFileCodegenContext.defineGlobalField(declaration.getSymbol(), global);
    }

    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
    }

    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
    }

    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
    }

    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
    }

    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
    }

    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
    }

    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
    }

    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
    }

    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
    }

    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
    }

    public void visitVariable(@NotNull IrVariable declaration) {
        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
    }

    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
    }

    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
    }

    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
    }

    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
    }

    public void visitBody(@NotNull IrBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body, (Void)data);
    }

    public void visitBody(@NotNull IrBody body) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body, (Void)data);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body);
    }

    public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body, (Void)data);
    }

    public void visitBlockBody(@NotNull IrBlockBody body) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2);
    }

    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
    }

    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
    }

    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
    }

    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
    }

    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2, (Void)data);
    }

    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2);
    }

    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock, (Void)data);
    }

    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body, (Void)data);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
    }

    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
    }

    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump);
    }

    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
    }

    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump);
    }

    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
    }

    public void visitCall(@NotNull IrCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
    }

    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
    }

    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
    }

    public void visitConst(@NotNull IrConst expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, (IrConst)expression2, (Void)data);
    }

    public void visitConst(@NotNull IrConst expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, (IrConst)expression2);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
    }

    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
    }

    public void visitGetField(@NotNull IrGetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2);
    }

    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
    }

    public void visitSetField(@NotNull IrSetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
    }

    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
    }

    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
    }

    public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
    }

    public void visitLoop(@NotNull IrLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop);
    }

    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
    }

    public void visitReturn(@NotNull IrReturn expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
    }

    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
    }

    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2);
    }

    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
    }

    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry);
    }

    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
    }

    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
    }

    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
    }

    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2);
    }

    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
    }

    public void visitSetValue(@NotNull IrSetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2);
    }

    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
    }

    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
    }

    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
    }

    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2);
    }

    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
    }

    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
    }

    private static final IrSimpleFunction unitGetInstanceFunction_delegate$lambda$0(DeclarationGenerator this$0) {
        return MiscKt.findUnitGetInstanceFunction(this$0.backendContext);
    }

    private static final IrConstructor unitPrimaryConstructor_delegate$lambda$1(DeclarationGenerator this$0) {
        return IrUtilsKt.getPrimaryConstructor((IrClass)((IrClass)this$0.backendContext.getIrBuiltIns().getUnitClass().getOwner()));
    }
}

