/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.data;

import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.data.ActionsDataProvider;
import com.intellij.ide.startup.importSettings.data.Config;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.JbService;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsContributor;
import com.intellij.ide.startup.importSettings.jb.JbProductInfo;
import com.intellij.ide.startup.importSettings.statistics.ImportSettingsEventsCollector;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0016\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006#"}, d2={"Lcom/intellij/ide/startup/importSettings/data/JBrActionsDataProvider;", "Lcom/intellij/ide/startup/importSettings/data/ActionsDataProvider;", "Lcom/intellij/ide/startup/importSettings/data/JbService;", "<init>", "()V", "productService", "getProductService", "()Lcom/intellij/ide/startup/importSettings/data/JbService;", "map", "", "Lcom/intellij/ide/startup/importSettings/data/ActionsDataProvider$popUpPlace;", "", "Lcom/intellij/ide/startup/importSettings/data/Product;", "getProductIcon", "Ljavax/swing/Icon;", "productId", "", "size", "Lcom/intellij/ide/startup/importSettings/data/IconProductSize;", "getText", "contributor", "Lcom/intellij/ide/startup/importSettings/data/SettingsContributor;", "title", "Lorg/jetbrains/annotations/Nls;", "getTitle", "()Ljava/lang/String;", "getComment", "main", "getMain", "()Ljava/util/List;", "other", "getOther", "productSelected", "", "Companion", "intellij.ide.startup.importSettings"})
public final class JBrActionsDataProvider
implements ActionsDataProvider<JbService> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JbService productService = this.getSettingsService().getJbService();
    @Nullable
    private Map<ActionsDataProvider.popUpPlace, ? extends List<? extends Product>> map = ActionsDataProvider.Companion.prepareMap(this.getProductService());
    @NotNull
    private static final JBrActionsDataProvider provider = new JBrActionsDataProvider();

    private JBrActionsDataProvider() {
    }

    @Override
    @NotNull
    public JbService getProductService() {
        return this.productService;
    }

    @Override
    @Nullable
    public Icon getProductIcon(@NotNull String productId, @NotNull IconProductSize size) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
        return this.getProductService().getProductIcon(productId, size);
    }

    @Override
    @NotNull
    public String getText(@NotNull SettingsContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        return contributor.getName();
    }

    @Override
    @NotNull
    public String getTitle() {
        return ImportSettingsBundle.INSTANCE.message("jetbrains.ides", new Object[0]);
    }

    @Override
    @Nullable
    public String getComment(@NotNull SettingsContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (contributor instanceof Config) {
            return ((Config)contributor).getPath();
        }
        if (contributor instanceof Product) {
            return ActionsDataProvider.Companion.toRelativeFormat(((Product)contributor).getLastUsage(), "used");
        }
        return null;
    }

    @Override
    @Nullable
    public List<Product> getMain() {
        Map<ActionsDataProvider.popUpPlace, ? extends List<? extends Product>> map = this.map;
        return map != null ? map.get((Object)ActionsDataProvider.popUpPlace.MAIN) : null;
    }

    @Override
    @Nullable
    public List<Product> getOther() {
        Map<ActionsDataProvider.popUpPlace, ? extends List<? extends Product>> map = this.map;
        return map != null ? map.get((Object)ActionsDataProvider.popUpPlace.OTHER) : null;
    }

    @Override
    public void productSelected(@NotNull SettingsContributor contributor) {
        boolean actual;
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        List<Product> list = this.getMain();
        boolean bl = list != null ? CollectionsKt.contains((Iterable)list, (Object)contributor) : (actual = false);
        Object object = contributor instanceof JbProductInfo ? (JbProductInfo)contributor : null;
        if (object == null || (object = ((JbProductInfo)object).getCodeName$intellij_ide_startup_importSettings()) == null) {
            object = "";
        }
        Object productCodeName = object;
        ImportSettingsEventsCollector.INSTANCE.jbIdeSelected((String)productCodeName, actual);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/startup/importSettings/data/JBrActionsDataProvider$Companion;", "", "<init>", "()V", "provider", "Lcom/intellij/ide/startup/importSettings/data/JBrActionsDataProvider;", "getInstance", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBrActionsDataProvider getInstance() {
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

