/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.webp;

import com.android.tools.adtui.webp.WebpImageWriteParam;
import com.android.tools.adtui.webp.WebpMetadata;
import com.android.tools.adtui.webp.WebpNativeLibHelper;
import com.google.webp.libwebp;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.jetbrains.annotations.NotNull;

public final class WebpImageWriterSpi
extends ImageWriterSpi {
    WebpImageWriterSpi() {
        this.vendorName = "Google LLC";
        this.version = WebpNativeLibHelper.getEncoderVersion();
        this.suffixes = WebpMetadata.Companion.getWEBP_SUFFIXES();
        this.names = WebpMetadata.Companion.getWEBP_FORMAT_NAMES();
        this.MIMETypes = WebpMetadata.Companion.getWEBP_MIME_TYPES();
        this.pluginClassName = WebpWriter.class.getName();
        this.outputTypes = new Class[]{ImageOutputStream.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(@NotNull BufferedImage image, @NotNull OutputStream outputStream, boolean lossless, int quality) throws IOException {
        ImageTypeSpecifier type;
        Iterator<ImageWriter> iterator;
        if (image == null) {
            WebpImageWriterSpi.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            WebpImageWriterSpi.$$$reportNull$$$0(1);
        }
        if ((iterator = ImageIO.getImageWriters(type = ImageTypeSpecifier.createFromRenderedImage(image), "webp")).hasNext()) {
            ImageWriter writer = iterator.next();
            try (ImageOutputStream stream = ImageIO.createImageOutputStream(outputStream);){
                writer.setOutput(stream);
                try {
                    WebpImageWriteParam param = new WebpImageWriteParam(writer.getLocale(), !lossless, (float)quality / 100.0f);
                    writer.write(null, new IIOImage(image, null, null), param);
                }
                finally {
                    writer.dispose();
                    stream.flush();
                }
            }
        }
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return WebpImageWriterSpi.canWriteImage(type);
    }

    public static boolean canWriteImage(ImageTypeSpecifier type) {
        SampleModel sm = type.getSampleModel();
        ColorModel cm = type.getColorModel();
        return (sm.getNumBands() >= 2 && sm.getNumBands() <= 4 || cm instanceof IndexColorModel) && sm.getSampleSize(0) <= 8 && sm.getWidth() <= 65535 && sm.getHeight() <= 65535 && (cm == null || cm.getComponentSize()[0] <= 8) && WebpNativeLibHelper.loadNativeLibraryIfNeeded();
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        WebpNativeLibHelper.requireNativeLibrary();
        return new WebpWriter(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "WebP Image Encoder";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "image";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "outputStream";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/webp/WebpImageWriterSpi";
        objectArray[2] = "writeImage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WebpWriter
    extends ImageWriter {
        private ImageOutputStream stream = null;

        private WebpWriter(ImageWriterSpi originatingProvider) {
            super(originatingProvider);
        }

        @Override
        public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
            return new WebpMetadata();
        }

        @Override
        public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
            return new WebpMetadata();
        }

        @Override
        public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
            return null;
        }

        @Override
        public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
            return null;
        }

        @Override
        public void setOutput(Object output) {
            super.setOutput(output);
            if (output != null) {
                if (!(output instanceof ImageOutputStream)) {
                    throw new IllegalArgumentException("output is not an ImageOutputStream");
                }
                this.stream = (ImageOutputStream)output;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.stream = null;
            }
        }

        @Override
        public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
            if (this.stream == null) {
                throw new IllegalStateException("output == null!");
            }
            boolean lossless = true;
            float quality = 0.75f;
            if (param != null && param.canWriteCompressed()) {
                lossless = false;
                if (param.getCompressionMode() == 2) {
                    quality = param.getCompressionQuality();
                }
            }
            Raster srcRas = WebpWriter.getRaster(image);
            int minX = srcRas.getMinX();
            int minY = srcRas.getMinY();
            int width = srcRas.getWidth();
            int height = srcRas.getHeight();
            int maxX = minX + width;
            int maxY = minY + height;
            byte[] data = new byte[width * height * 4];
            int index = 0;
            SampleModel sampleModel = srcRas.getSampleModel();
            int bands = sampleModel.getNumBands();
            if (bands == 1) {
                return;
            }
            assert (bands >= 2 && bands <= 4);
            DataBuffer buffer = srcRas.getDataBuffer();
            if (bands >= 3) {
                for (y = minY; y < maxY; ++y) {
                    for (int x = minX; x < maxX; ++x) {
                        for (int band = 0; band < bands; ++band) {
                            int sample = sampleModel.getSample(x, y, band, buffer);
                            data[index++] = (byte)sample;
                        }
                        if (bands != 3) continue;
                        data[index++] = -1;
                    }
                }
            } else {
                assert (bands == 2);
                for (y = minY; y < maxY; ++y) {
                    for (int x = minX; x < maxX; ++x) {
                        byte sample = (byte)sampleModel.getSample(x, y, 0, buffer);
                        data[index++] = sample;
                        data[index++] = sample;
                        data[index++] = sample;
                        byte alpha = (byte)sampleModel.getSample(x, y, 1, buffer);
                        data[index++] = alpha;
                    }
                }
            }
            byte[] encoded = lossless ? libwebp.WebPEncodeLosslessRGBA(data, width, height, 4 * width) : libwebp.WebPEncodeRGBA(data, width, height, 4 * width, (int)(100.0f * quality));
            this.stream.write(encoded);
        }

        @NotNull
        private static Raster getRaster(@NotNull IIOImage image) {
            boolean rasterOnly;
            if (image == null) {
                WebpWriter.$$$reportNull$$$0(0);
            }
            if (rasterOnly = image.hasRaster()) {
                Raster raster = image.getRaster();
                if (raster == null) {
                    WebpWriter.$$$reportNull$$$0(1);
                }
                return raster;
            }
            RenderedImage renderedImage = image.getRenderedImage();
            if (renderedImage instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)renderedImage;
                if (renderedImage.getColorModel() instanceof IndexColorModel) {
                    BufferedImage rgb = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                    Graphics2D graphics = rgb.createGraphics();
                    graphics.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics.dispose();
                    WritableRaster writableRaster = rgb.getRaster();
                    if (writableRaster == null) {
                        WebpWriter.$$$reportNull$$$0(2);
                    }
                    return writableRaster;
                }
                WritableRaster writableRaster = bufferedImage.getRaster();
                if (writableRaster == null) {
                    WebpWriter.$$$reportNull$$$0(3);
                }
                return writableRaster;
            }
            if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
                Raster raster = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
                if (raster.getWidth() != renderedImage.getWidth() || raster.getHeight() != renderedImage.getHeight()) {
                    raster = raster.createChild(raster.getMinX(), raster.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), raster.getMinX(), raster.getMinY(), null);
                }
                Raster raster2 = raster;
                if (raster2 == null) {
                    WebpWriter.$$$reportNull$$$0(4);
                }
                return raster2;
            }
            Raster raster = renderedImage.getData();
            if (raster == null) {
                WebpWriter.$$$reportNull$$$0(5);
            }
            return raster;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/webp/WebpImageWriterSpi$WebpWriter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/webp/WebpImageWriterSpi$WebpWriter";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRaster";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRaster";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

