/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/impl/ConstructorProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "Lcom/intellij/psi/scope/NameHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind$Hint;", "Lcom/intellij/psi/scope/ElementClassHint;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "state", "Lcom/intellij/psi/ResolveState;", "shouldProcess", "", "kind", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "Lcom/intellij/psi/scope/ElementClassHint$DeclarationKind;", "myCandidates", "Lcom/intellij/util/SmartList;", "Lcom/intellij/psi/PsiMethod;", "execute", "element", "Lcom/intellij/psi/PsiElement;", "candidates", "", "getCandidates", "()Ljava/util/List;", "intellij.groovy.psi"})
final class ConstructorProcessor
extends ProcessorWithHints
implements NameHint,
GroovyResolveKind.Hint,
ElementClassHint {
    @NotNull
    private final String name;
    @NotNull
    private final SmartList<PsiMethod> myCandidates;

    public ConstructorProcessor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.hint(NameHint.KEY, this);
        this.hint(GroovyResolveKind.HINT_KEY, this);
        this.hint(ElementClassHint.KEY, this);
        this.myCandidates = new SmartList();
    }

    @NotNull
    public String getName(@NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.name;
    }

    @Override
    public boolean shouldProcess(@NotNull GroovyResolveKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return kind == GroovyResolveKind.METHOD;
    }

    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(element instanceof PsiMethod)) {
            if (Intrinsics.areEqual((Object)state.get(ResolveUtilKt.sorryCannotKnowElementKind), (Object)true)) {
                return true;
            }
            throw new IllegalStateException(("Unexpected element. " + PsiUtilKt.elementInfo(element)).toString());
        }
        if (!((PsiMethod)element).isConstructor()) {
            return true;
        }
        ((Collection)this.myCandidates).add(element);
        return true;
    }

    @NotNull
    public final List<PsiMethod> getCandidates() {
        return (List)this.myCandidates;
    }
}

