/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class ConvertMultilineStringToSingleLineIntention
extends GrPsiUpdateIntention {
    private static final Logger LOG = Logger.getInstance(ConvertMultilineStringToSingleLineIntention.class);

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        GrExpression old;
        if (element == null) {
            ConvertMultilineStringToSingleLineIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ConvertMultilineStringToSingleLineIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            ConvertMultilineStringToSingleLineIntention.$$$reportNull$$$0(2);
        }
        String quote = element.getText().substring(0, 1);
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        if (element instanceof GrLiteralImpl) {
            ConvertMultilineStringToSingleLineIntention.appendSimpleStringValue(element, buffer, quote);
            old = (GrExpression)element;
        } else {
            GrStringImpl gstring = (GrStringImpl)element;
            for (GroovyPsiElement child : gstring.getAllContentParts()) {
                if (child instanceof GrStringContent) {
                    ConvertMultilineStringToSingleLineIntention.appendSimpleStringValue(child, buffer, "\"");
                    continue;
                }
                if (!(child instanceof GrStringInjection)) continue;
                buffer.append(child.getText());
            }
            old = gstring;
        }
        buffer.append(quote);
        try {
            int offset = context.offset();
            TextRange range = old.getTextRange();
            int shift = range.getStartOffset() == offset ? 0 : (range.getStartOffset() == offset - 1 ? -1 : (range.getEndOffset() == offset ? -4 : (range.getEndOffset() == offset + 1 ? -3 : -2)));
            GrExpression newLiteral = GroovyPsiElementFactory.getInstance(context.project()).createExpressionFromText(buffer.toString());
            old.replaceWithExpression(newLiteral, true);
            if (shift != 0) {
                updater.moveCaretTo(offset + shift);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void appendSimpleStringValue(PsiElement element, StringBuilder buffer, String quote) {
        String text = GrStringUtil.removeQuotes(element.getText());
        if ("'".equals(quote)) {
            GrStringUtil.escapeAndUnescapeSymbols(text, "\n'", "", buffer);
        } else {
            GrStringUtil.escapeAndUnescapeSymbols(text, "\"\n", "", buffer);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(element instanceof GrLiteral)) {
                    return false;
                }
                String text = element.getText();
                String quote = GrStringUtil.getStartQuote(text);
                return "'''".equals(quote) || "\"\"\"".equals(quote);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertMultilineStringToSingleLineIntention$1", "satisfiedBy"));
            }
        };
    }

    public static String getHint() {
        return GroovyIntentionsBundle.message("convert.multiline.string.to.single.line.intention.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertMultilineStringToSingleLineIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

