/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"isPossibleLooseOfPrecision", "", "targetType", "Lcom/intellij/psi/PsiType;", "actualType", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "extractLiteralValue", "", "commonNegate", "num", "intellij.groovy.psi"})
@JvmName(name="PrecisionUtil")
public final class PrecisionUtil {
    public static final boolean isPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        int targetRank = TypeConstants.getTypeRank(targetType);
        int actualRank = TypeConstants.getTypeRank(actualType);
        if (targetRank == 2 || actualRank == 2 || targetRank == 7) {
            return false;
        }
        if (actualRank == 0 || targetRank == 0 || actualRank <= targetRank) {
            return false;
        }
        Number number = PrecisionUtil.extractLiteralValue(expression);
        if (number == null) {
            return true;
        }
        Number value = number;
        return switch (targetRank) {
            case 1 -> {
                byte byteVal = value.byteValue();
                Number var7_11 = value;
                if (var7_11 instanceof Short) {
                    if ((short)byteVal != value.shortValue()) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_11 instanceof Integer) {
                    if (!Intrinsics.areEqual((Object)byteVal, (Object)value)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_11 instanceof Long) {
                    if (!Intrinsics.areEqual((Object)byteVal, (Object)value)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_11 instanceof Float) {
                    if (!((Object)Float.valueOf(byteVal)).equals(value)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)byteVal, (Object)value)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                short shortVal = value.shortValue();
                Number var7_12 = value;
                if (var7_12 instanceof Integer) {
                    if (!Intrinsics.areEqual((Object)shortVal, (Object)value)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_12 instanceof Long) {
                    if (!Intrinsics.areEqual((Object)shortVal, (Object)value)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_12 instanceof Float) {
                    if (!((Object)Float.valueOf(shortVal)).equals(value)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)shortVal, (Object)value)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                int intVal = value.intValue();
                Number var7_13 = value;
                if (var7_13 instanceof Long) {
                    if (!Intrinsics.areEqual((Object)intVal, (Object)value)) {
                        yield true;
                    }
                    yield false;
                }
                if (var7_13 instanceof Float) {
                    if (!((Object)Float.valueOf(intVal)).equals(value)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)intVal, (Object)value)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                long longVal = value.longValue();
                if (value instanceof Float) {
                    if (!((Object)Float.valueOf(longVal)).equals(value)) {
                        yield true;
                    }
                    yield false;
                }
                if (!Intrinsics.areEqual((Object)longVal, (Object)value)) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                float floatVal = value.floatValue();
                if (!Intrinsics.areEqual((Object)floatVal, (Object)value)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static final Number extractLiteralValue(GrExpression expression) {
        GrExpression grExpression;
        boolean negativeNumber = false;
        GrExpression valueExpression = expression;
        if (expression instanceof GrUnaryExpression) {
            IElementType iElementType = ((GrUnaryExpression)expression).getOperationTokenType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationTokenType(...)");
            IElementType operationTokenType = iElementType;
            Object[] objectArray = new IElementType[]{GroovyElementTypes.T_PLUS, GroovyElementTypes.T_MINUS};
            if (ArraysKt.contains((Object[])objectArray, (Object)operationTokenType)) {
                negativeNumber = Intrinsics.areEqual((Object)operationTokenType, (Object)GroovyElementTypes.T_MINUS);
                valueExpression = ((GrUnaryExpression)expression).getOperand();
            }
        }
        GrLiteral grLiteral = (grExpression = valueExpression) instanceof GrLiteral ? (GrLiteral)grExpression : null;
        Object object = grLiteral != null ? grLiteral.getValue() : null;
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        if (number == null) {
            return null;
        }
        Number value = number;
        return negativeNumber ? (Number)PrecisionUtil.commonNegate(value) : (Number)value;
    }

    private static final Number commonNegate(Number num) {
        Number number;
        Number number2 = num;
        if (number2 instanceof Byte) {
            number = (int)(-num.byteValue());
        } else if (number2 instanceof Short) {
            number = (int)(-num.shortValue());
        } else if (number2 instanceof Integer) {
            number = -num.intValue();
        } else if (number2 instanceof Long) {
            number = -num.longValue();
        } else if (number2 instanceof BigInteger) {
            BigInteger bigInteger = ((BigInteger)num).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate(...)");
            number = bigInteger;
        } else if (number2 instanceof Float) {
            number = Float.valueOf(-num.floatValue());
        } else if (number2 instanceof Double) {
            number = -num.doubleValue();
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)num).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"negate(...)");
            number = bigDecimal;
        } else {
            number = null;
        }
        return number;
    }
}

