/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.control.ConditionalUtils;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public final class GroovyTrivialIfInspection
extends BaseInspection {
    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.ref.statement.can.be.simplified", new Object[0]);
    }

    @Override
    public LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyTrivialIfInspection.$$$reportNull$$$0(0);
        }
        return new TrivialIfFix();
    }

    public static boolean isSimplifiableImplicitReturn(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableImplicitReturnNegated(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableReturn(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "true") && ConditionalUtils.isReturn(elseBranch, "false");
    }

    public static boolean isSimplifiableReturnNegated(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        return ConditionalUtils.isReturn(thenBranch, "false") && ConditionalUtils.isReturn(elseBranch, "true");
    }

    public static boolean isSimplifiableAssignment(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableAssignmentNegated(GrIfStatement ifStatement) {
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        GrStatement elseBranch = ifStatement.getElseBranch();
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignment(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "true") && ConditionalUtils.isAssignment(elseBranch, "false")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignmentNegated(GrIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        GrStatement thenBranch = ifStatement.getThenBranch();
        thenBranch = ConditionalUtils.stripBraces(thenBranch);
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)ifStatement);
        if (!(nextStatement instanceof GrStatement)) {
            return false;
        }
        GrStatement elseBranch = (GrStatement)nextStatement;
        elseBranch = ConditionalUtils.stripBraces(elseBranch);
        if (ConditionalUtils.isAssignment(thenBranch, "false") && ConditionalUtils.isAssignment(elseBranch, "true")) {
            IElementType elseSign;
            GrAssignmentExpression thenExpression = (GrAssignmentExpression)thenBranch;
            GrAssignmentExpression elseExpression = (GrAssignmentExpression)elseBranch;
            IElementType thenSign = thenExpression.getOperationTokenType();
            if (!thenSign.equals(elseSign = elseExpression.getOperationTokenType())) {
                return false;
            }
            GrExpression thenLhs = thenExpression.getLValue();
            GrExpression elseLhs = elseExpression.getLValue();
            return EquivalenceChecker.expressionsAreEquivalent(thenLhs, elseLhs);
        }
        return false;
    }

    @NonNls
    private static String getTextForOperator(IElementType operator) {
        if (operator.equals(GroovyTokenTypes.mASSIGN)) {
            return "=";
        }
        if (operator.equals(GroovyTokenTypes.mNOT_EQUAL)) {
            return "!=";
        }
        if (operator.equals(GroovyTokenTypes.mLE)) {
            return "<=";
        }
        if (operator.equals(GroovyTokenTypes.mGE)) {
            return ">=";
        }
        if (operator.equals(GroovyTokenTypes.mLT)) {
            return "<=";
        }
        if (operator.equals(GroovyTokenTypes.mGT)) {
            return ">=";
        }
        if (operator.equals(GroovyTokenTypes.mELVIS)) {
            return "==";
        }
        if (operator.equals(GroovyTokenTypes.mPLUS_ASSIGN)) {
            return "+=";
        }
        if (operator.equals(GroovyTokenTypes.mMINUS_ASSIGN)) {
            return "-=";
        }
        if (operator.equals(GroovyTokenTypes.mSTAR_ASSIGN)) {
            return "*=";
        }
        if (operator.equals(GroovyTokenTypes.mDIV_ASSIGN)) {
            return "/=";
        }
        if (operator.equals(GroovyTokenTypes.mMOD_ASSIGN)) {
            return "%=";
        }
        if (operator.equals(GroovyTokenTypes.mBXOR_ASSIGN)) {
            return "^=";
        }
        if (operator.equals(GroovyTokenTypes.mBAND_ASSIGN)) {
            return "&=";
        }
        if (operator.equals(GroovyTokenTypes.mBOR_ASSIGN)) {
            return "|=";
        }
        return "unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection", "buildFix"));
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
            if (ifStatement == null) {
                TrivialIfVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(ifStatement);
            GrExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            PsiType type = condition.getType();
            if (type == null || !PsiTypes.booleanType().isAssignableFrom(type)) {
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableAssignment(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableReturn(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitReturn(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableAssignmentNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableReturnNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitReturnNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignment(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
                return;
            }
            if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignmentNegated(ifStatement)) {
                this.registerStatementError(ifStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection$TrivialIfVisitor", "visitIfStatement"));
        }
    }

    private static class TrivialIfFix
    extends PsiUpdateModCommandQuickFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.simplify", new Object[0]);
            if (string == null) {
                TrivialIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement ifKeywordElement, @NotNull ModPsiUpdater updater) {
            GrIfStatement statement;
            if (project == null) {
                TrivialIfFix.$$$reportNull$$$0(1);
            }
            if (ifKeywordElement == null) {
                TrivialIfFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                TrivialIfFix.$$$reportNull$$$0(3);
            }
            if (GroovyTrivialIfInspection.isSimplifiableAssignment(statement = (GrIfStatement)ifKeywordElement.getParent())) {
                TrivialIfFix.replaceSimplifiableAssignment(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableReturn(statement)) {
                TrivialIfFix.replaceSimplifiableReturn(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitReturn(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturn(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableAssignmentNegated(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableReturnNegated(statement)) {
                TrivialIfFix.replaceSimplifiableReturnNegated(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitReturnNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitReturnNegated(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignment(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignment(statement);
            } else if (GroovyTrivialIfInspection.isSimplifiableImplicitAssignmentNegated(statement)) {
                TrivialIfFix.replaceSimplifiableImplicitAssignmentNegated(statement);
            }
        }

        private static void replaceSimplifiableImplicitReturn(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
            @NonNls String newStatement = "return " + conditionText + ";";
            GroovyFix.replaceStatement((GrStatement)statement, newStatement);
            assert (nextStatement != null);
            nextStatement.delete();
        }

        private static void replaceSimplifiableReturn(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            @NonNls String newStatement = "return " + conditionText + ";";
            GroovyFix.replaceStatement((GrStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignment(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            String operatorText = GroovyTrivialIfInspection.getTextForOperator(operator);
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            GroovyFix.replaceStatement((GrStatement)statement, lhsText + operatorText + conditionText + ";");
        }

        private static void replaceSimplifiableImplicitAssignment(GrIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
            if (prevStatement == null) {
                return;
            }
            GrExpression condition = statement.getCondition();
            String conditionText = condition.getText();
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            GroovyFix.replaceStatement((GrStatement)statement, lhsText + operator + conditionText + ";");
            prevStatement.delete();
        }

        private static void replaceSimplifiableImplicitAssignmentNegated(GrIfStatement statement) throws IncorrectOperationException {
            PsiElement prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            String operatorText = GroovyTrivialIfInspection.getTextForOperator(operator);
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            GroovyFix.replaceStatement((GrStatement)statement, lhsText + operatorText + conditionText + ";");
            assert (prevStatement != null);
            prevStatement.delete();
        }

        private static void replaceSimplifiableImplicitReturnNegated(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
            if (nextStatement == null) {
                return;
            }
            @NonNls String newStatement = "return " + conditionText + ";";
            GroovyFix.replaceStatement((GrStatement)statement, newStatement);
            nextStatement.delete();
        }

        private static void replaceSimplifiableReturnNegated(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            @NonNls String newStatement = "return " + conditionText + ";";
            GroovyFix.replaceStatement((GrStatement)statement, newStatement);
        }

        private static void replaceSimplifiableAssignmentNegated(GrIfStatement statement) throws IncorrectOperationException {
            GrExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            String conditionText = BoolUtils.getNegatedExpressionText(condition);
            GrStatement thenBranch = statement.getThenBranch();
            GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)ConditionalUtils.stripBraces(thenBranch);
            IElementType operator = assignmentExpression.getOperationTokenType();
            String operatorText = GroovyTrivialIfInspection.getTextForOperator(operator);
            GrExpression lhs = assignmentExpression.getLValue();
            String lhsText = lhs.getText();
            GroovyFix.replaceStatement((GrStatement)statement, lhsText + operatorText + conditionText + ";");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection$TrivialIfFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifKeywordElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/control/GroovyTrivialIfInspection$TrivialIfFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

