/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicMembersContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "<init>", "()V", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "intellij.groovy"})
public final class DynamicMembersContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (aClass == null) {
            return;
        }
        boolean shouldProcessMethods = ResolveUtilKt.shouldProcessMethods(processor);
        boolean shouldProcessProperties = ResolveUtilKt.shouldProcessProperties(processor);
        if (!shouldProcessMethods && !shouldProcessProperties) {
            return;
        }
        DynamicManager dynamicManager = DynamicManager.getInstance(aClass.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dynamicManager, (String)"getInstance(...)");
        DynamicManager manager = dynamicManager;
        for (String qName : ClassUtil.getSuperClassesWithCache(aClass).keySet()) {
            if (shouldProcessMethods) {
                for (PsiMethod method : manager.getMethods(qName)) {
                    if (ResolveUtil.processElement(processor, (PsiNamedElement)method, state)) continue;
                    return;
                }
            }
            if (!shouldProcessProperties) continue;
            for (PsiVariable property : manager.getProperties(qName)) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)property, state)) continue;
                return;
            }
        }
    }
}

