/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.maven.server;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryEvent;
import org.jetbrains.maven.server.EventInfoPrinter;

@Named(value="Intellij Idea Maven Embedded Event Spy")
@Singleton
public class IntellijMavenSpy
extends AbstractEventSpy {
    public void onEvent(Object event) {
        try {
            if (event instanceof ExecutionEvent) {
                IntellijMavenSpy.onExecutionEvent((ExecutionEvent)event);
            } else if (event instanceof RepositoryEvent) {
                IntellijMavenSpy.onRepositoryEvent((RepositoryEvent)event);
            } else if (event instanceof DependencyResolutionRequest) {
                IntellijMavenSpy.onDependencyResolutionRequest((DependencyResolutionRequest)event);
            } else if (event instanceof DependencyResolutionResult) {
                IntellijMavenSpy.onDependencyResolutionResult((DependencyResolutionResult)event);
            }
        }
        catch (Throwable e) {
            IntellijMavenSpy.collectAndPrintLastLinesForEA(e);
        }
    }

    private static void onDependencyResolutionRequest(DependencyResolutionRequest event) {
        String projectId = event.getMavenProject() == null ? "unknown" : event.getMavenProject().getId();
        EventInfoPrinter.printMavenEventInfo("DependencyResolutionRequest", "id", projectId);
    }

    private static void onDependencyResolutionResult(DependencyResolutionResult event) {
        List errors = event.getCollectionErrors();
        StringBuilder result = new StringBuilder();
        for (Exception e : errors) {
            if (result.length() > 0) {
                result.append("-[N]-");
            }
            result.append(e.getMessage());
        }
        EventInfoPrinter.printMavenEventInfo("DependencyResolutionResult", "error", result);
    }

    private static void collectAndPrintLastLinesForEA(Throwable e) {
        int lines = Math.max(e.getStackTrace().length, 3);
        StringBuilder builder = new StringBuilder();
        builder.append(e.getMessage());
        for (int i = 0; i < lines; ++i) {
            builder.append(e.getStackTrace()[i]).append("\n");
        }
        EventInfoPrinter.printMavenEventInfo("INTERR", "error", builder);
    }

    private static void onRepositoryEvent(RepositoryEvent event) {
        RepositoryEvent.EventType type = event.getType();
        if (type != RepositoryEvent.EventType.ARTIFACT_DOWNLOADING && type != RepositoryEvent.EventType.ARTIFACT_RESOLVING) {
            return;
        }
        String errMessage = event.getException() == null ? "" : event.getException().getMessage();
        String path = event.getFile() == null ? "" : event.getFile().getPath();
        String artifactCoord = event.getArtifact() == null ? "" : event.getArtifact().toString();
        EventInfoPrinter.printMavenEventInfo(type, "path", path, "artifactCoord", artifactCoord, "error", errMessage);
    }

    private static void onExecutionEvent(ExecutionEvent event) {
        String projectId;
        MojoExecution mojoExec = event.getMojoExecution();
        String string = projectId = event.getProject() == null ? "unknown" : event.getProject().getId();
        if (mojoExec != null) {
            String errMessage = event.getException() == null ? "" : IntellijMavenSpy.getErrorMessage(event.getException());
            EventInfoPrinter.printMavenEventInfo(event.getType(), "source", String.valueOf(mojoExec.getSource()), "goal", mojoExec.getGoal(), "id", projectId, "error", errMessage);
        } else if (event.getType() == ExecutionEvent.Type.SessionStarted) {
            IntellijMavenSpy.printSessionStartedEventAndReactorData(event, projectId);
        } else {
            EventInfoPrinter.printMavenEventInfo(event.getType(), "id", projectId);
        }
    }

    private static String getErrorMessage(Exception exception) {
        String baseMessage = exception.getMessage();
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        String rootMessage = rootCause != null ? rootCause.getMessage() : "";
        return StringUtils.isNotEmpty((CharSequence)rootMessage) ? rootMessage : baseMessage;
    }

    private static void printSessionStartedEventAndReactorData(ExecutionEvent event, String projectId) {
        MavenSession session = event.getSession();
        if (session != null) {
            ArrayList projectsInReactor = session.getProjects();
            if (projectsInReactor == null) {
                projectsInReactor = new ArrayList();
            }
            StringBuilder builder = new StringBuilder();
            for (MavenProject project : projectsInReactor) {
                builder.append(project.getGroupId()).append(":").append(project.getArtifactId()).append(":").append(project.getVersion()).append("&&");
            }
            EventInfoPrinter.printMavenEventInfo(ExecutionEvent.Type.SessionStarted, "id", projectId, "projects", builder);
        } else {
            EventInfoPrinter.printMavenEventInfo(ExecutionEvent.Type.SessionStarted, "id", projectId, "projects", "");
        }
    }
}

