/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.action.ChainResolver;
import com.intellij.debugger.streams.diagnostic.ex.TraceCompilationException;
import com.intellij.debugger.streams.diagnostic.ex.TraceEvaluationException;
import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.psi.DebuggerPositionResolver;
import com.intellij.debugger.streams.psi.impl.DebuggerPositionResolverImpl;
import com.intellij.debugger.streams.trace.EvaluateExpressionTracer;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.trace.TracingCallback;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.TraceResultInterpreterImpl;
import com.intellij.debugger.streams.ui.ChooserOption;
import com.intellij.debugger.streams.ui.impl.ElementChooserImpl;
import com.intellij.debugger.streams.ui.impl.EvaluationAwareTraceWindow;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class TraceStreamAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(TraceStreamAction.class);
    private static final ChainResolver CHAIN_RESOLVER = new ChainResolver();
    private final DebuggerPositionResolver myPositionResolver = new DebuggerPositionResolverImpl();

    public void update(@NotNull AnActionEvent e) {
        XDebugSession session;
        if (e == null) {
            TraceStreamAction.$$$reportNull$$$0(0);
        }
        PsiElement element = (session = DebuggerUIUtil.getSession((AnActionEvent)e)) == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        Presentation presentation = e.getPresentation();
        if (element == null) {
            presentation.setVisible(true);
            presentation.setEnabled(false);
        } else {
            ChainResolver.ChainStatus chainStatus = CHAIN_RESOLVER.tryFindChain(element);
            switch (chainStatus) {
                case LANGUAGE_NOT_SUPPORTED: {
                    presentation.setEnabledAndVisible(false);
                    break;
                }
                case FOUND: {
                    presentation.setEnabledAndVisible(true);
                    break;
                }
                case COMPUTING: 
                case NOT_FOUND: {
                    presentation.setVisible(true);
                    presentation.setEnabled(false);
                }
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TraceStreamAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element;
        if (e == null) {
            TraceStreamAction.$$$reportNull$$$0(2);
        }
        XDebugSession session = DebuggerUIUtil.getSession((AnActionEvent)e);
        LibrarySupportProvider.EP_NAME.getExtensionList();
        XSourcePosition position = session == null ? null : session.getCurrentPosition();
        PsiElement psiElement = element = session == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        if (element == null || position == null) {
            LOG.info("element at cursor not found");
            return;
        }
        List<ChainResolver.StreamChainWithLibrary> chains = CHAIN_RESOLVER.getChains(element);
        if (chains.isEmpty()) {
            LOG.warn("stream chain is not built");
            return;
        }
        if (chains.size() == 1) {
            TraceStreamAction.runTrace(chains.get((int)0).chain, chains.get((int)0).provider, session);
        } else {
            Project project = session.getProject();
            VirtualFile file = position.getFile();
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), true);
            LOG.assertTrue(editor != null);
            ApplicationManager.getApplication().invokeLater(() -> new MyStreamChainChooser(editor).show(ContainerUtil.map((Collection)chains, StreamChainOption::new), provider -> TraceStreamAction.runTrace(provider.chain, provider.provider, session)));
        }
    }

    private static void runTrace(@NotNull StreamChain chain, final @NotNull LibrarySupportProvider provider, @NotNull XDebugSession session) {
        if (chain == null) {
            TraceStreamAction.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            TraceStreamAction.$$$reportNull$$$0(4);
        }
        if (session == null) {
            TraceStreamAction.$$$reportNull$$$0(5);
        }
        final EvaluationAwareTraceWindow window = new EvaluationAwareTraceWindow(session, chain);
        ApplicationManager.getApplication().invokeLater(() -> ((EvaluationAwareTraceWindow)window).show());
        Project project = session.getProject();
        TraceExpressionBuilder expressionBuilder = provider.getExpressionBuilder(project);
        TraceResultInterpreterImpl resultInterpreter = new TraceResultInterpreterImpl(provider.getLibrarySupport().getInterpreterFactory());
        EvaluateExpressionTracer tracer = new EvaluateExpressionTracer(session, expressionBuilder, resultInterpreter);
        tracer.trace(chain, new TracingCallback(){

            @Override
            public void evaluated(@NotNull TracingResult result, @NotNull EvaluationContextImpl context) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                ResolvedTracingResult resolvedTrace = result.resolve(provider.getLibrarySupport().getResolverFactory());
                ApplicationManager.getApplication().invokeLater(() -> window.setTrace(resolvedTrace, context));
            }

            @Override
            public void evaluationFailed(@NotNull String traceExpression, @NotNull String message) {
                if (traceExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.notifyUI(message);
                throw new TraceEvaluationException(message, traceExpression);
            }

            @Override
            public void compilationFailed(@NotNull String traceExpression, @NotNull String message) {
                if (traceExpression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.notifyUI(message);
                throw new TraceCompilationException(message, traceExpression);
            }

            private void notifyUI(@NotNull @Nls String message) {
                if (message == null) {
                    1.$$$reportNull$$$0(6);
                }
                ApplicationManager.getApplication().invokeLater(() -> window.setFailMessage(message));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "traceExpression";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/streams/action/TraceStreamAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluationFailed";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compilationFailed";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "notifyUI";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/action/TraceStreamAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/action/TraceStreamAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runTrace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class MyStreamChainChooser
    extends ElementChooserImpl<StreamChainOption> {
        MyStreamChainChooser(@NotNull Editor editor) {
            if (editor == null) {
                MyStreamChainChooser.$$$reportNull$$$0(0);
            }
            super(editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/debugger/streams/action/TraceStreamAction$MyStreamChainChooser", "<init>"));
        }
    }

    private static final class StreamChainOption
    implements ChooserOption {
        final StreamChain chain;
        final LibrarySupportProvider provider;

        StreamChainOption(@NotNull ChainResolver.StreamChainWithLibrary chain) {
            if (chain == null) {
                StreamChainOption.$$$reportNull$$$0(0);
            }
            this.chain = chain.chain;
            this.provider = chain.provider;
        }

        @Override
        @NotNull
        public Stream<TextRange> rangeStream() {
            Stream<TextRange> stream = Stream.of(new TextRange(this.chain.getQualifierExpression().getTextRange().getStartOffset(), this.chain.getTerminationCall().getTextRange().getEndOffset()));
            if (stream == null) {
                StreamChainOption.$$$reportNull$$$0(1);
            }
            return stream;
        }

        @Override
        @NotNull
        public String getText() {
            String string = this.chain.getCompactText();
            if (string == null) {
                StreamChainOption.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chain";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/streams/action/TraceStreamAction$StreamChainOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/streams/action/TraceStreamAction$StreamChainOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rangeStream";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

