/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.Retry;
import org.jetbrains.idea.maven.aether.ThrowingSupplier;

public final class RetryProvider {
    private static final Random RANDOM = new Random();
    private static final double EXP_BACKOFF_FACTOR = 2.0;
    private static final double EXP_BACKOFF_JITTER = 0.1;
    private static final Retry DISABLED_SINGLETON = new Retry(){

        @Override
        public <R> R retry(@NotNull ThrowingSupplier<? extends R> supplier, @NotNull Logger logger) throws Exception {
            if (supplier == null) {
                1.$$$reportNull$$$0(0);
            }
            if (logger == null) {
                1.$$$reportNull$$$0(1);
            }
            return supplier.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "supplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logger";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/aether/RetryProvider$1";
            objectArray[2] = "retry";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static Retry disabled() {
        return DISABLED_SINGLETON;
    }

    public static Retry withExponentialBackOff(final long initialDelayMs, final long backoffLimitMs, final int maxAttempts) {
        if (initialDelayMs <= 0L || backoffLimitMs <= 0L || maxAttempts <= 0) {
            throw new IllegalArgumentException("Wrong arguments provided: initialDelayMs=" + initialDelayMs + "backoffLimitMs=" + backoffLimitMs + " maxAttempts=" + maxAttempts);
        }
        return new Retry(){

            @Override
            public <R> R retry(@NotNull ThrowingSupplier<? extends R> supplier, @NotNull Logger logger) throws Exception {
                if (supplier == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (logger == null) {
                    2.$$$reportNull$$$0(1);
                }
                return RetryProvider.exponentialBackOffRetry(initialDelayMs, backoffLimitMs, maxAttempts, supplier, logger);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "supplier";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "logger";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/aether/RetryProvider$2";
                objectArray[2] = "retry";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private RetryProvider() {
    }

    /*
     * WARNING - void declaration
     */
    private static <R> R exponentialBackOffRetry(long initialDelayMs, long backoffLimitMs, int maxAttempts, @NotNull ThrowingSupplier<? extends R> throwingSupplier, @NotNull Logger logger) throws Exception {
        if (throwingSupplier == null) {
            RetryProvider.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            RetryProvider.$$$reportNull$$$0(1);
        }
        long effectiveDelay = initialDelayMs;
        for (int i = 1; i <= maxAttempts; ++i) {
            try {
                void supplier;
                return supplier.get();
            }
            catch (Exception e) {
                void logger2;
                if (i == maxAttempts) {
                    logger2.warn("Retry attempts limit exceeded, tried " + maxAttempts + " times. Cause: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
                logger2.warn("Attempt " + i + " of " + maxAttempts + " failed, retrying in " + effectiveDelay + "ms. Cause: " + e.getMessage(), (Throwable)e);
                effectiveDelay = RetryProvider.exponentialBackOff(effectiveDelay, backoffLimitMs);
                continue;
            }
        }
        throw new RuntimeException("Should not be reached");
    }

    private static long exponentialBackOff(long effectiveDelayMs, long backoffLimitMs) {
        try {
            Thread.sleep(effectiveDelayMs);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Unexpected thread interrupt", ex);
        }
        long nextRawDelay = (long)Math.min((double)effectiveDelayMs * 2.0, (double)backoffLimitMs);
        long jitter = (long)(RANDOM.nextDouble() * (double)nextRawDelay * 0.1);
        long jitterSign = RANDOM.nextBoolean() ? 1L : -1L;
        return nextRawDelay + jitter * jitterSign;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "supplier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/aether/RetryProvider";
        objectArray[2] = "exponentialBackOffRetry";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

