/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util.telemetry;

import com.intellij.gradle.toolingExtension.impl.telemetry.GradleTelemetryFormat;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.OtlpConfiguration;
import com.intellij.util.text.StringKt;
import java.net.URI;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J7\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u0014*\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00140\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gradle/util/telemetry/GradleDaemonOpenTelemetryUtil;", "", "<init>", "()V", "DAEMON_TELEMETRY_ENABLED_KEY", "Lcom/intellij/openapi/util/Key;", "", "DAEMON_TELEMETRY_FORMAT_KEY", "Lcom/intellij/gradle/toolingExtension/impl/telemetry/GradleTelemetryFormat;", "DAEMON_TELEMETRY_TARGET_FOLDER_KEY", "Ljava/nio/file/Path;", "DAEMON_TELEMETRY_TARGET_ENDPOINT_KEY", "Ljava/net/URI;", "isDaemonTracingEnabled", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "getTelemetryFormat", "getTargetFolder", "getTargetEndpoint", "providedOrElse", "T", "key", "fn", "Ljava/util/function/Supplier;", "(Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;Lcom/intellij/openapi/util/Key;Ljava/util/function/Supplier;)Ljava/lang/Object;", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleDaemonOpenTelemetryUtil {
    @NotNull
    public static final GradleDaemonOpenTelemetryUtil INSTANCE = new GradleDaemonOpenTelemetryUtil();
    @JvmField
    @NotNull
    public static final Key<Boolean> DAEMON_TELEMETRY_ENABLED_KEY;
    @JvmField
    @NotNull
    public static final Key<GradleTelemetryFormat> DAEMON_TELEMETRY_FORMAT_KEY;
    @JvmField
    @NotNull
    public static final Key<Path> DAEMON_TELEMETRY_TARGET_FOLDER_KEY;
    @JvmField
    @NotNull
    public static final Key<URI> DAEMON_TELEMETRY_TARGET_ENDPOINT_KEY;

    private GradleDaemonOpenTelemetryUtil() {
    }

    @JvmStatic
    public static final boolean isDaemonTracingEnabled(@NotNull GradleExecutionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Boolean bl = (Boolean)settings.getUserData(DAEMON_TELEMETRY_ENABLED_KEY);
        return bl != null ? bl.booleanValue() : Registry.Companion.is("gradle.daemon.opentelemetry.enabled", false);
    }

    @JvmStatic
    @NotNull
    public static final GradleTelemetryFormat getTelemetryFormat(@NotNull GradleExecutionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        GradleTelemetryFormat gradleTelemetryFormat = INSTANCE.providedOrElse(settings, DAEMON_TELEMETRY_FORMAT_KEY, GradleDaemonOpenTelemetryUtil::getTelemetryFormat$lambda$0);
        if (gradleTelemetryFormat == null) {
            gradleTelemetryFormat = GradleTelemetryFormat.PROTOBUF;
        }
        return gradleTelemetryFormat;
    }

    @JvmStatic
    @Nullable
    public static final Path getTargetFolder(@NotNull GradleExecutionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        return INSTANCE.providedOrElse(settings, DAEMON_TELEMETRY_TARGET_FOLDER_KEY, GradleDaemonOpenTelemetryUtil::getTargetFolder$lambda$1);
    }

    @JvmStatic
    @Nullable
    public static final URI getTargetEndpoint(@NotNull GradleExecutionSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        return INSTANCE.providedOrElse(settings, DAEMON_TELEMETRY_TARGET_ENDPOINT_KEY, GradleDaemonOpenTelemetryUtil::getTargetEndpoint$lambda$2);
    }

    private final <T> T providedOrElse(GradleExecutionSettings $this$providedOrElse, Key<T> key, Supplier<T> fn) {
        Object provided = $this$providedOrElse.getUserData(key);
        if (provided != null) {
            return (T)provided;
        }
        try {
            return fn.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final GradleTelemetryFormat getTelemetryFormat$lambda$0() {
        String format = Registry.Companion.stringValue("gradle.daemon.opentelemetry.format");
        String string = format.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return GradleTelemetryFormat.valueOf((String)string);
    }

    private static final Path getTargetFolder$lambda$1() {
        String folder;
        String string = folder = StringKt.nullize$default((String)Registry.Companion.stringValue("gradle.daemon.opentelemetry.folder"), (boolean)false, (int)1, null);
        return string != null ? NioPathUtil.toNioPathOrNull((String)string) : null;
    }

    private static final URI getTargetEndpoint$lambda$2() {
        String string = OtlpConfiguration.getTraceEndpoint();
        if (string == null) {
            return null;
        }
        String uri = string;
        return URI.create(uri);
    }

    static {
        Key key = Key.create((String)"DAEMON_TELEMETRY_ENABLED");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DAEMON_TELEMETRY_ENABLED_KEY = key;
        Key key2 = Key.create((String)"DAEMON_TELEMETRY_FORMAT");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        DAEMON_TELEMETRY_FORMAT_KEY = key2;
        Key key3 = Key.create((String)"DAEMON_TELEMETRY_TARGET_FOLDER");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        DAEMON_TELEMETRY_TARGET_FOLDER_KEY = key3;
        Key key4 = Key.create((String)"DAEMON_TELEMETRY_TARGET_ENDPOINT");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"create(...)");
        DAEMON_TELEMETRY_TARGET_ENDPOINT_KEY = key4;
    }
}

