/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.gradle.toolingExtension.impl.util.GradleTreeTraverserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0002'(B/\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0012\b\u0002\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002J\u0014\u0010\u0013\u001a\u00020\r2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0001H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u0001H\u0002J(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030 H\u0002J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\u0014\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#0\u0003H\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0001H\u0002J\u0014\u0010%\u001a\u00020\n2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J\u0016\u0010&\u001a\u0004\u0018\u00010\n2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser;", "", "classesToSkip", "", "Ljava/lang/Class;", "classesToSkipChildren", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "classInfoCache", "Ljava/util/HashMap;", "Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser$ClassInfo;", "visitedObjects", "Ljava/util/IdentityHashMap;", "", "walk", "", "root", "consumer", "Ljava/util/function/Consumer;", "isShouldBeTraversed", "anObject", "aClass", "getChildElementsForTraversing", "", "traverserPath", "", "getArrayElementsForTraversing", "anArray", "getCollectionElementsForTraversing", "aCollection", "getMapElementsForTraversing", "map", "", "getMapEntryElementsForTraversing", "entries", "", "getObjectElementsForTraversing", "getCachedClassInfo", "createClassInfo", "ClassInfo", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleObjectTraverser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleObjectTraverser.kt\norg/jetbrains/plugins/gradle/util/GradleObjectTraverser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,197:1\n1#2:198\n14#3:199\n*S KotlinDebug\n*F\n+ 1 GradleObjectTraverser.kt\norg/jetbrains/plugins/gradle/util/GradleObjectTraverser\n*L\n190#1:199\n*E\n"})
public final class GradleObjectTraverser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Class<?>> classesToSkip;
    @NotNull
    private final Set<Class<?>> classesToSkipChildren;
    @NotNull
    private final HashMap<Class<?>, ClassInfo> classInfoCache;
    @NotNull
    private final IdentityHashMap<Object, Boolean> visitedObjects;
    @NotNull
    private static final Logger LOG;

    public GradleObjectTraverser(@NotNull Set<? extends Class<?>> classesToSkip, @NotNull Set<? extends Class<?>> classesToSkipChildren) {
        Intrinsics.checkNotNullParameter(classesToSkip, (String)"classesToSkip");
        Intrinsics.checkNotNullParameter(classesToSkipChildren, (String)"classesToSkipChildren");
        this.classesToSkip = classesToSkip;
        this.classesToSkipChildren = classesToSkipChildren;
        this.classInfoCache = new HashMap();
        this.visitedObjects = new IdentityHashMap();
    }

    public /* synthetic */ GradleObjectTraverser(Set set, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        this(set, set2);
    }

    public final void walk(@NotNull Object root, @NotNull Consumer<Object> consumer) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        GradleTreeTraverserUtil.depthFirstTraverseTreeWithPath((Object)root, (arg_0, arg_1) -> GradleObjectTraverser.walk$lambda$1((arg_0, arg_1) -> GradleObjectTraverser.walk$lambda$0(this, consumer, arg_0, arg_1), arg_0, arg_1));
    }

    private final boolean isShouldBeTraversed(Object anObject) {
        return this.visitedObjects.containsKey(anObject) ? false : this.isShouldBeTraversed(anObject.getClass());
    }

    private final boolean isShouldBeTraversed(Class<?> aClass) {
        return this.classesToSkip.contains(aClass) ? false : (aClass.isPrimitive() ? false : !ClassUtils.isPrimitiveOrWrapper(aClass));
    }

    private final Collection<Object> getChildElementsForTraversing(List<? extends Object> traverserPath, Object anObject) {
        Class<?> aClass = anObject.getClass();
        return this.classesToSkipChildren.contains(aClass) ? (Collection<Object>)CollectionsKt.emptyList() : (aClass.isArray() ? this.getArrayElementsForTraversing(traverserPath, anObject) : (anObject instanceof Collection ? this.getCollectionElementsForTraversing(traverserPath, (Collection)anObject) : (anObject instanceof Map ? this.getMapElementsForTraversing(traverserPath, (Map)anObject) : this.getObjectElementsForTraversing(traverserPath, anObject))));
    }

    private final Collection<Object> getArrayElementsForTraversing(List<? extends Object> traverserPath, Object anArray) {
        if (anArray.getClass().getComponentType().isPrimitive()) {
            return CollectionsKt.emptyList();
        }
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            int length = Array.getLength(anArray);
            for (int index = 0; index < length; ++index) {
                Object element = Array.get(anArray, index);
                if (element == null || !this.isShouldBeTraversed(element)) continue;
                result.add(element);
            }
            return result;
        }
        catch (Throwable exception) {
            GradleObjectTraverser.Companion.logTraverseError("Cannot traverse array elements", traverserPath, exception);
            return CollectionsKt.emptyList();
        }
    }

    private final Collection<Object> getCollectionElementsForTraversing(List<? extends Object> traverserPath, Collection<?> aCollection) {
        try {
            return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)aCollection)), arg_0 -> GradleObjectTraverser.getCollectionElementsForTraversing$lambda$2(this, arg_0)));
        }
        catch (Throwable exception) {
            GradleObjectTraverser.Companion.logTraverseError("Cannot traverse collection elements", traverserPath, exception);
            return CollectionsKt.emptyList();
        }
    }

    private final Collection<Object> getMapElementsForTraversing(List<? extends Object> traverserPath, Map<?, ?> map) {
        Throwable throwable;
        Object $this$getMapElementsForTraversing_u24lambda_u243;
        ArrayList<Object> result = new ArrayList<Object>();
        Object object = this;
        try {
            $this$getMapElementsForTraversing_u24lambda_u243 = object;
            boolean bl = false;
            $this$getMapElementsForTraversing_u24lambda_u243 = Result.constructor-impl(map.entrySet());
        }
        catch (Throwable bl) {
            $this$getMapElementsForTraversing_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getMapElementsForTraversing_u24lambda_u243;
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Object it = $this$getMapElementsForTraversing_u24lambda_u243 = throwable2;
            boolean bl = false;
            GradleObjectTraverser.Companion.logTraverseError("Cannot traverse map entries", traverserPath, (Throwable)it);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Set it = (Set)object;
            boolean bl = false;
            result.addAll(this.getMapEntryElementsForTraversing(traverserPath, it));
        }
        if ((throwable = Result.exceptionOrNull-impl((Object)object)) != null) {
            Object $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u249;
            Collection it;
            Object $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u246;
            Throwable it2 = throwable;
            boolean bl = false;
            Object object2 = this;
            try {
                $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u246 = object2;
                boolean bl2 = false;
                $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u246 = Result.constructor-impl(map.keySet());
            }
            catch (Throwable bl2) {
                $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u246;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 != null) {
                Object it3 = $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u246 = throwable3;
                boolean bl3 = false;
                GradleObjectTraverser.Companion.logTraverseError("Cannot traverse map keys", traverserPath, (Throwable)it3);
            }
            if (Result.isSuccess-impl((Object)object2)) {
                it = (Set)object2;
                boolean bl4 = false;
                result.addAll(this.getCollectionElementsForTraversing(traverserPath, it));
            }
            object2 = this;
            try {
                $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u249 = (GradleObjectTraverser)object2;
                boolean bl5 = false;
                $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u249 = Result.constructor-impl(map.values());
            }
            catch (Throwable bl5) {
                $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
            }
            object2 = $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u249;
            Throwable throwable4 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable4 != null) {
                Object it4 = $this$getMapElementsForTraversing_u24lambda_u2412_u24lambda_u249 = throwable4;
                boolean bl6 = false;
                GradleObjectTraverser.Companion.logTraverseError("Cannot traverse map values", traverserPath, (Throwable)it4);
            }
            if (Result.isSuccess-impl((Object)object2)) {
                it = (Collection)object2;
                boolean bl7 = false;
                result.addAll(this.getCollectionElementsForTraversing(traverserPath, it));
            }
            Result.constructor-impl((Object)Result.box-impl((Object)object2));
        }
        return result;
    }

    private final Collection<Object> getMapEntryElementsForTraversing(List<? extends Object> traverserPath, Set<? extends Map.Entry<?, ?>> entries) {
        try {
            ArrayList result = new ArrayList();
            for (Map.Entry<?, ?> entry : entries) {
                Object value;
                Object key = entry.getKey();
                if (key != null && this.isShouldBeTraversed(key)) {
                    result.add(key);
                }
                if ((value = entry.getValue()) == null || !this.isShouldBeTraversed(value)) continue;
                result.add(value);
            }
            return result;
        }
        catch (Throwable exception) {
            GradleObjectTraverser.Companion.logTraverseError("Cannot traverse collection elements", traverserPath, exception);
            return CollectionsKt.emptyList();
        }
    }

    private final Collection<Object> getObjectElementsForTraversing(List<? extends Object> traverserPath, Object anObject) {
        ArrayList<Object> result = new ArrayList<Object>();
        ClassInfo classInfo = this.getCachedClassInfo(anObject.getClass());
        for (Field field : classInfo.getFields()) {
            try {
                Object value = field.get(anObject);
                if (value == null || !this.isShouldBeTraversed(value)) continue;
                result.add(value);
            }
            catch (IllegalAccessException value) {
            }
            catch (Throwable exception) {
                GradleObjectTraverser.Companion.logTraverseError("Cannot traverse object fields", traverserPath, exception);
            }
        }
        return result;
    }

    private final ClassInfo getCachedClassInfo(Class<?> aClass) {
        ClassInfo classInfo = this.classInfoCache.computeIfAbsent(aClass, arg_0 -> GradleObjectTraverser.getCachedClassInfo$lambda$14(arg_0 -> GradleObjectTraverser.getCachedClassInfo$lambda$13(this, aClass, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)classInfo, (String)"computeIfAbsent(...)");
        return classInfo;
    }

    private final ClassInfo createClassInfo(Class<?> aClass) {
        String packageName = aClass.getPackageName();
        Intrinsics.checkNotNull((Object)packageName);
        if (StringsKt.startsWith$default((String)packageName, (String)"jdk.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)packageName, (String)"java.lang.module", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)packageName, (String)"com.sun.proxy", (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            List fieldsForTraversing = new ArrayList();
            List list = ReflectionUtil.collectFields(aClass);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"collectFields(...)");
            List fields = list;
            for (Field field : fields) {
                Class<?> clazz = field.getType();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"getType(...)");
                if (!this.isShouldBeTraversed(clazz)) continue;
                field.setAccessible(true);
                ((Collection)fieldsForTraversing).add(field);
            }
            return new ClassInfo(fieldsForTraversing);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static final Collection walk$lambda$0(GradleObjectTraverser this$0, Consumer $consumer, List path, Object anObject) {
        Collection<Object> collection;
        Intrinsics.checkNotNull((Object)anObject);
        if (!this$0.isShouldBeTraversed(anObject)) {
            collection = CollectionsKt.emptyList();
        } else {
            ((Map)this$0.visitedObjects).put(anObject, true);
            $consumer.accept(anObject);
            Intrinsics.checkNotNull((Object)path);
            collection = this$0.getChildElementsForTraversing(path, anObject);
        }
        return collection;
    }

    private static final Collection walk$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Collection)$tmp0.invoke(p0, p1);
    }

    private static final boolean getCollectionElementsForTraversing$lambda$2(GradleObjectTraverser this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isShouldBeTraversed(it);
    }

    private static final ClassInfo getCachedClassInfo$lambda$13(GradleObjectTraverser this$0, Class $aClass, Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClassInfo classInfo = this$0.createClassInfo($aClass);
        if (classInfo == null) {
            classInfo = ClassInfo.Companion.getEMPTY();
        }
        return classInfo;
    }

    private static final ClassInfo getCachedClassInfo$lambda$14(Function1 $tmp0, Object p0) {
        return (ClassInfo)$tmp0.invoke(p0);
    }

    public GradleObjectTraverser() {
        this(null, null, 3, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleObjectTraverser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser$ClassInfo;", "", "fields", "", "Ljava/lang/reflect/Field;", "<init>", "(Ljava/util/List;)V", "getFields", "()Ljava/util/List;", "Companion", "intellij.gradle"})
    private static final class ClassInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Field> fields;
        @NotNull
        private static final ClassInfo EMPTY = new ClassInfo(CollectionsKt.emptyList());

        public ClassInfo(@NotNull List<Field> fields) {
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            this.fields = fields;
        }

        @NotNull
        public final List<Field> getFields() {
            return this.fields;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser$ClassInfo$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser$ClassInfo;", "getEMPTY", "()Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser$ClassInfo;", "intellij.gradle"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ClassInfo getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleObjectTraverser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "logTraverseError", "", "message", "", "traverserPath", "", "exception", "", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        private final void logTraverseError(String message, List<? extends Object> traverserPath, Throwable exception) {
            String rawTraverserPath = CollectionsKt.joinToString$default((Iterable)traverserPath, (CharSequence)"\n", null, null, (int)0, null, Companion::logTraverseError$lambda$0, (int)30, null);
            LOG.error(message + "\nObject path:\n" + rawTraverserPath, exception);
        }

        private static final CharSequence logTraverseError$lambda$0(Object it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return " - " + it;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

