/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathMapper;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.gradle.issue.IncorrectGradleJdkIssue;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAwareUtilsKt;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.service.execution.LocalBuildLayoutParameters;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u0000 12\u00020\u0001:\u000201B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\tH\u0016J*\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J+\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!*\u00020\u000f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H!0#H\u0002\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020\tH\u0002J \u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J!\u0010+\u001a\u0004\u0018\u00010,2\u0010\u0010-\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010,\u0018\u00010.H\u0002\u00a2\u0006\u0002\u0010/\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware;", "<init>", "()V", "prepareExecution", "", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "externalProjectPath", "", "isPreviewMode", "", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "getEnvironmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "runConfiguration", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "projectPath", "getDefaultBuildLayoutParameters", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "getBuildLayoutParameters", "isGradleInstallationHomeDir", "homePath", "prepareJvmForExecution", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider$SdkInfo;", "checkForWslJdkOnWindows", "getEnvironmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "localEnvironment", "lock", "R", "action", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "jdkConfigurationException", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkException;", "key", "waitForGradleJvmResolving", "lookupProvider", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider;", "findGradleJar", "Ljava/io/File;", "files", "", "([Ljava/io/File;)Ljava/io/File;", "GradleEnvironmentConfigurationProvider", "Companion", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalGradleExecutionAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalGradleExecutionAware.kt\norg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,228:1\n14#2:229\n*S KotlinDebug\n*F\n+ 1 LocalGradleExecutionAware.kt\norg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware\n*L\n225#1:229\n*E\n"})
public final class LocalGradleExecutionAware
implements GradleExecutionAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String LOCAL_TARGET_TYPE_ID = "local";

    public void prepareExecution(@NotNull ExternalSystemTask task2, @NotNull String externalProjectPath2, boolean isPreviewMode, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!isPreviewMode) {
            this.prepareJvmForExecution(task2, externalProjectPath2, taskNotificationListener, project2);
        }
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.getEnvironmentConfiguration(runConfiguration, project2);
        if (targetEnvironmentConfiguration == null) {
            return null;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = targetEnvironmentConfiguration;
        return new GradleEnvironmentConfigurationProvider(targetEnvironmentConfiguration2);
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull String projectPath, boolean isPreviewMode, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.localEnvironment();
        if (targetEnvironmentConfiguration == null) {
            return null;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = targetEnvironmentConfiguration;
        return new GradleEnvironmentConfigurationProvider(targetEnvironmentConfiguration2);
    }

    @Override
    @NotNull
    public BuildLayoutParameters getDefaultBuildLayoutParameters(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new LocalBuildLayoutParameters(project2, null);
    }

    @Override
    @NotNull
    public BuildLayoutParameters getBuildLayoutParameters(@NotNull Project project2, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return new LocalBuildLayoutParameters(project2, projectPath);
    }

    @Override
    public boolean isGradleInstallationHomeDir(@NotNull Project project2, @NotNull String homePath) {
        boolean found;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        File libs = new File(homePath, "lib");
        if (!libs.isDirectory()) {
            if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
                LOG.info("Gradle sdk check failed for the path '" + homePath + "'. Reason: it doesn't have a child directory named 'lib'");
            }
            return false;
        }
        boolean bl = found = this.findGradleJar(libs.listFiles()) != null;
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            LOG.info("Gradle home check " + (found ? "passed" : "failed") + " for the path '" + homePath + "'");
        }
        return found;
    }

    @ApiStatus.Internal
    @Nullable
    public final SdkLookupProvider.SdkInfo prepareJvmForExecution(@NotNull ExternalSystemTask task2, @NotNull String externalProjectPath2, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object r = this.lock(project2, LocalGradleExecutionAware::prepareJvmForExecution$lambda$0);
        Intrinsics.checkNotNullExpressionValue(r, (String)"lock(...)");
        GradleSettings settings = (GradleSettings)((Object)r);
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings.getLinkedProjectSettings(externalProjectPath2);
        if (gradleProjectSettings == null) {
            return null;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String originalGradleJvm = projectSettings.getGradleJvm();
        SdkLookupProvider provider = (SdkLookupProvider)this.lock(project2, arg_0 -> LocalGradleExecutionAware.prepareJvmForExecution$lambda$1(projectSettings, arg_0));
        Object sdkInfo = null;
        sdkInfo = this.lock(project2, arg_0 -> LocalGradleExecutionAware.prepareJvmForExecution$lambda$2(provider, projectSettings, originalGradleJvm, arg_0));
        if (sdkInfo instanceof SdkLookupProvider.SdkInfo.Undefined || sdkInfo instanceof SdkLookupProvider.SdkInfo.Unresolved || sdkInfo instanceof SdkLookupProvider.SdkInfo.Resolving) {
            this.waitForGradleJvmResolving(provider, task2, taskNotificationListener);
            if (projectSettings.getGradleJvm() == null) {
                String string = originalGradleJvm;
                if (string == null) {
                    string = "#USE_PROJECT_JDK";
                }
                projectSettings.setGradleJvm(string);
            }
            sdkInfo = this.lock(project2, arg_0 -> LocalGradleExecutionAware.prepareJvmForExecution$lambda$3(provider, projectSettings, arg_0));
        }
        String gradleJvm = projectSettings.getGradleJvm();
        if (!(sdkInfo instanceof SdkLookupProvider.SdkInfo.Resolved)) {
            LOG.warn("Gradle JVM (" + gradleJvm + ") isn't resolved: " + sdkInfo);
            throw this.jdkConfigurationException("gradle.jvm.is.invalid");
        }
        String string = ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo).getHomePath();
        if (string == null) {
            LocalGradleExecutionAware $this$prepareJvmForExecution_u24lambda_u244 = this;
            boolean bl = false;
            LOG.warn("No Gradle JVM (" + gradleJvm + ") home path: " + sdkInfo);
            throw $this$prepareJvmForExecution_u24lambda_u244.jdkConfigurationException("gradle.jvm.is.invalid");
        }
        String homePath = string;
        String string2 = projectSettings.getExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalProjectPath(...)");
        this.checkForWslJdkOnWindows(homePath, string2, task2);
        if (!JdkUtil.checkForJdk((String)homePath)) {
            LOG.warn("Invalid Gradle JVM (" + gradleJvm + ") home path: " + sdkInfo);
            throw this.jdkConfigurationException("gradle.jvm.is.invalid");
        }
        if (!JdkUtil.checkForJre((String)homePath)) {
            LOG.warn("Gradle JVM (" + gradleJvm + ") is JRE instead JDK: " + sdkInfo);
            throw this.jdkConfigurationException("gradle.jvm.is.jre");
        }
        return sdkInfo;
    }

    private final void checkForWslJdkOnWindows(String homePath, String externalProjectPath2, ExternalSystemTask task2) {
        if (WSLUtil.isSystemCompatible() && WslPath.Companion.isWslUncPath(homePath) && !WslPath.Companion.isWslUncPath(externalProjectPath2)) {
            boolean isResolveProjectTask = task2 instanceof ExternalSystemResolveProjectTask;
            String message = GradleBundle.message("gradle.incorrect.jvm.wslJdk.on.win.issue.description", new Object[0]);
            Intrinsics.checkNotNull((Object)message);
            throw new BuildIssueException((BuildIssue)new IncorrectGradleJdkIssue(externalProjectPath2, homePath, message, isResolveProjectTask));
        }
    }

    private final TargetEnvironmentConfiguration getEnvironmentConfiguration(ExternalSystemRunConfiguration runConfiguration, Project project2) {
        GradleRunConfiguration gradleRunConfiguration = runConfiguration instanceof GradleRunConfiguration ? (GradleRunConfiguration)runConfiguration : null;
        if (gradleRunConfiguration == null) {
            return null;
        }
        GradleRunConfiguration gradleRunConfiguration2 = gradleRunConfiguration;
        String string = gradleRunConfiguration2.getOptions().getRemoteTarget();
        if (string == null) {
            return this.localEnvironment();
        }
        String targetName = string;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.Companion.getInstance(project2).getTargets().findByName(targetName);
        if (targetEnvironmentConfiguration == null) {
            return this.localEnvironment();
        }
        return targetEnvironmentConfiguration;
    }

    private final TargetEnvironmentConfiguration localEnvironment() {
        return Registry.Companion.is("gradle.tooling.use.external.process", false) ? (TargetEnvironmentConfiguration)new TargetEnvironmentConfiguration(){
            private String projectRootOnTarget;
            {
                this.projectRootOnTarget = "";
            }

            public String getProjectRootOnTarget() {
                return this.projectRootOnTarget;
            }

            public void setProjectRootOnTarget(String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.projectRootOnTarget = string;
            }
        } : null;
    }

    private final <R> R lock(Project $this$lock, Function1<? super Project, ? extends R> action) {
        return (R)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> LocalGradleExecutionAware.lock$lambda$6($this$lock, action), (int)1, null);
    }

    private final ExternalSystemJdkException jdkConfigurationException(@PropertyKey(resourceBundle="messages.GradleBundle") String key) {
        String errorMessage = GradleBundle.message(key, new Object[0]);
        String openSettingsMessage = GradleBundle.message("gradle.open.gradle.settings", new Object[0]);
        String string = errorMessage + " <a href='%s'>" + openSettingsMessage + "</a> \n";
        Object[] objectArray = new Object[]{"#open_external_system_settings"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String exceptionMessage = string2;
        String[] stringArray = new String[]{"#open_external_system_settings"};
        return new ExternalSystemJdkException(exceptionMessage, null, stringArray);
    }

    private final void waitForGradleJvmResolving(SdkLookupProvider lookupProvider, ExternalSystemTask task2, ExternalSystemTaskNotificationListener taskNotificationListener) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("Do not perform synchronous wait for sdk downloading in EDT - causes deadlock.");
            throw this.jdkConfigurationException("gradle.jvm.is.being.resolved.error");
        }
        ProgressIndicator progressIndicator = lookupProvider.getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new ProgressIndicatorBase();
        }
        ProgressIndicator progressIndicator2 = progressIndicator;
        String string = GradleBundle.message("gradle.jvm.is.being.resolved", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GradleExecutionAwareUtilsKt.submitProgressStarted(task2, taskNotificationListener, progressIndicator2, progressIndicator2, string);
        ProgressIndicatorListener.whenProgressFractionChanged((ProgressIndicator)progressIndicator2, arg_0 -> LocalGradleExecutionAware.waitForGradleJvmResolving$lambda$8(arg_0 -> LocalGradleExecutionAware.waitForGradleJvmResolving$lambda$7(task2, taskNotificationListener, progressIndicator2, arg_0), arg_0));
        GradleExecutionAwareUtilsKt.whenTaskCanceled(task2, (Function0<Unit>)((Function0)() -> LocalGradleExecutionAware.waitForGradleJvmResolving$lambda$9(progressIndicator2)));
        lookupProvider.waitForLookup();
        String string2 = GradleBundle.message("gradle.jvm.has.been.resolved", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        GradleExecutionAwareUtilsKt.submitProgressFinished(task2, taskNotificationListener, progressIndicator2, progressIndicator2, string2);
    }

    private final File findGradleJar(File[] files) {
        if (files == null) {
            return null;
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])files);
        while (iterator.hasNext()) {
            File file;
            File file2 = file = (File)iterator.next();
            Intrinsics.checkNotNull((Object)file2);
            if (!GradleInstallationManager.GRADLE_JAR_FILE_PATTERN.matcher(file2.getName()).matches()) continue;
            return file;
        }
        if (GradleEnvironment.DEBUG_GRADLE_HOME_PROCESSING) {
            StringBuilder filesInfo = new StringBuilder();
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])files);
            while (iterator2.hasNext()) {
                File file;
                File file3 = file = (File)iterator2.next();
                Intrinsics.checkNotNull((Object)file3);
                filesInfo.append(file3.getAbsolutePath()).append(';');
            }
            if (((CharSequence)filesInfo).length() > 0) {
                filesInfo.setLength(filesInfo.length() - 1);
            }
            LOG.info("Gradle sdk check fails. Reason: no one of the given files matches gradle JAR pattern (" + GradleInstallationManager.GRADLE_JAR_FILE_PATTERN + "). Files: " + filesInfo);
        }
        return null;
    }

    private static final GradleSettings prepareJvmForExecution$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GradleSettings.getInstance(it);
    }

    private static final SdkLookupProvider prepareJvmForExecution$lambda$1(GradleProjectSettings $projectSettings, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GradleJvmResolutionUtil.getGradleJvmLookupProvider(it, $projectSettings);
    }

    private static final SdkLookupProvider.SdkInfo prepareJvmForExecution$lambda$2(SdkLookupProvider $provider, GradleProjectSettings $projectSettings, String $originalGradleJvm, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GradleJvmUtil.nonblockingResolveGradleJvmInfo($provider, it, $projectSettings.getExternalProjectPath(), $originalGradleJvm);
    }

    private static final SdkLookupProvider.SdkInfo prepareJvmForExecution$lambda$3(SdkLookupProvider $provider, GradleProjectSettings $projectSettings, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GradleJvmUtil.nonblockingResolveGradleJvmInfo($provider, it, $projectSettings.getExternalProjectPath(), $projectSettings.getGradleJvm());
    }

    private static final Object lock$lambda$6$lambda$5(Project $this_lock, Function1 $action) {
        if ($this_lock.isDisposed()) {
            throw new ProcessCanceledException();
        }
        return $action.invoke((Object)$this_lock);
    }

    private static final Object lock$lambda$6(Project $this_lock, Function1 $action) {
        return ActionsKt.runWriteAction(() -> LocalGradleExecutionAware.lock$lambda$6$lambda$5($this_lock, $action));
    }

    private static final Unit waitForGradleJvmResolving$lambda$7(ExternalSystemTask $task, ExternalSystemTaskNotificationListener $taskNotificationListener, ProgressIndicator $progressIndicator, Double it) {
        String string = GradleBundle.message("gradle.jvm.is.being.resolved", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GradleExecutionAwareUtilsKt.submitProgressStatus($task, $taskNotificationListener, $progressIndicator, $progressIndicator, string);
        return Unit.INSTANCE;
    }

    private static final void waitForGradleJvmResolving$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit waitForGradleJvmResolving$lambda$9(ProgressIndicator $progressIndicator) {
        $progressIndicator.cancel();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalGradleExecutionAware.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LOCAL_TARGET_TYPE_ID", "", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalGradleExecutionAware$GradleEnvironmentConfigurationProvider;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;", "targetEnvironmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "<init>", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)V", "environmentConfiguration", "getEnvironmentConfiguration", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "pathMapper", "Lcom/intellij/util/PathMapper;", "getPathMapper", "()Lcom/intellij/util/PathMapper;", "intellij.gradle"})
    private static final class GradleEnvironmentConfigurationProvider
    implements GradleServerConfigurationProvider {
        @NotNull
        private final TargetEnvironmentConfiguration environmentConfiguration;
        @Nullable
        private final PathMapper pathMapper;

        public GradleEnvironmentConfigurationProvider(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
            Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
            this.environmentConfiguration = targetEnvironmentConfiguration;
        }

        @NotNull
        public TargetEnvironmentConfiguration getEnvironmentConfiguration() {
            return this.environmentConfiguration;
        }

        @Nullable
        public PathMapper getPathMapper() {
            return this.pathMapper;
        }
    }
}

