/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.IncompatibleGradleJvmAndGradleBuildIssue;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJvmAndGradleIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "getGradleVersion", "Lorg/gradle/util/GradleVersion;", "getJavaVersion", "Lcom/intellij/util/lang/JavaVersion;", "isUnsupportedClassVersionIssue", "rootCause", "", "isUnsupportedJavaRuntimeIssue", "isCouldNotDetermineJavaIssue", "detectJavaVersionIfCouldNotDetermineJavaIssue", "Companion", "intellij.gradle"})
@ApiStatus.Internal
public final class IncompatibleGradleJvmAndGradleIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String COULD_NOT_CREATE_SERVICE_OF_TYPE_PREFIX = "Could not create service of type ";
    @NotNull
    private static final String USING_BUILD_SCOPE_SERVICES = " using BuildScopeServices.";
    @NotNull
    private static final String COULD_NOT_DETERMINE_JAVA_VERSION_MESSAGE = "Could not determine Java version.";
    @NotNull
    private static final String COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX = "org.gradle.api.GradleException: Could not determine Java version using executable ";

    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)COULD_NOT_CREATE_SERVICE_OF_TYPE_PREFIX, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)failureCause, (CharSequence)USING_BUILD_SCOPE_SERVICES, (boolean)false, (int)2, null);
    }

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        GradleVersion gradleVersion = this.getGradleVersion(issueData);
        JavaVersion javaVersion = this.getJavaVersion(issueData);
        if (gradleVersion != null && javaVersion != null) {
            if (!GradleJvmSupportMatrix.Companion.isSupported(gradleVersion, javaVersion)) {
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion, javaVersion, issueData.getProjectPath());
            }
        } else {
            Intrinsics.checkNotNull((Object)rootCause);
            if (this.isCouldNotDetermineJavaIssue(rootCause)) {
                JavaVersion javaVersion2 = this.detectJavaVersionIfCouldNotDetermineJavaIssue(rootCause);
                if (javaVersion2 == null) {
                    javaVersion2 = javaVersion;
                }
                JavaVersion detectedJavaVersion = javaVersion2;
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion, detectedJavaVersion, issueData.getProjectPath());
            }
            if (this.isUnsupportedClassVersionIssue(rootCause)) {
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion, javaVersion, issueData.getProjectPath());
            }
            if (this.isUnsupportedJavaRuntimeIssue(rootCause)) {
                return (BuildIssue)new IncompatibleGradleJvmAndGradleBuildIssue(gradleVersion, javaVersion, issueData.getProjectPath());
            }
        }
        return null;
    }

    private final GradleVersion getGradleVersion(GradleIssueData issueData) {
        if (issueData.getBuildEnvironment() != null) {
            return GradleVersion.version((String)issueData.getBuildEnvironment().getGradle().getGradleVersion());
        }
        return null;
    }

    private final JavaVersion getJavaVersion(GradleIssueData issueData) {
        if (issueData.getBuildEnvironment() != null) {
            return ExternalSystemJdkUtil.getJavaVersion((String)issueData.getBuildEnvironment().getJava().getJavaHome().getPath());
        }
        return null;
    }

    private final boolean isUnsupportedClassVersionIssue(Throwable rootCause) {
        return Intrinsics.areEqual((Object)rootCause.getClass().getSimpleName(), (Object)UnsupportedClassVersionError.class.getSimpleName());
    }

    private final boolean isUnsupportedJavaRuntimeIssue(Throwable rootCause) {
        return Intrinsics.areEqual((Object)rootCause.getClass().getSimpleName(), (Object)UnsupportedJavaRuntimeException.class.getSimpleName());
    }

    private final boolean isCouldNotDetermineJavaIssue(Throwable rootCause) {
        String rootCauseText = rootCause.toString();
        if (StringsKt.startsWith$default((String)rootCauseText, (String)COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX, (boolean)false, (int)2, null)) {
            return true;
        }
        return Intrinsics.areEqual((Object)rootCause.getMessage(), (Object)COULD_NOT_DETERMINE_JAVA_VERSION_MESSAGE);
    }

    private final JavaVersion detectJavaVersionIfCouldNotDetermineJavaIssue(Throwable rootCause) {
        File javaHome;
        String rootCauseText = rootCause.toString();
        char[] cArray = new char[]{'.'};
        String javaExeCandidate = StringsKt.trimEnd((String)StringsKt.substringAfter$default((String)rootCauseText, (String)COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX, null, (int)2, null), (char[])cArray);
        File file = new File(javaExeCandidate).getParentFile();
        File file2 = javaHome = file != null ? file.getParentFile() : null;
        if (javaHome != null && javaHome.isDirectory()) {
            return ExternalSystemJdkUtil.getJavaVersion((String)javaHome.getPath());
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJvmAndGradleIssueChecker$Companion;", "", "<init>", "()V", "COULD_NOT_CREATE_SERVICE_OF_TYPE_PREFIX", "", "USING_BUILD_SCOPE_SERVICES", "COULD_NOT_DETERMINE_JAVA_VERSION_MESSAGE", "COULD_NOT_DETERMINE_JAVA_USING_EXECUTABLE_PREFIX", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

