/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.find.editorHeaderActions.Embeddable;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.impl.livePreview.LivePreview;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.LivePreviewPresentation;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalIcons;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u0003:\u00043456B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020\u0010H\u0016J\b\u0010$\u001a\u00020\u0010H\u0002J\b\u0010%\u001a\u00020\u0010H\u0002J\b\u0010&\u001a\u00020\u0010H\u0002J\b\u0010'\u001a\u00020\u0010H\u0002J\r\u0010(\u001a\u00070)\u00a2\u0006\u0002\b*H\u0002J\u0017\u0010+\u001a\t\u0018\u00010)\u00a2\u0006\u0002\b*2\u0006\u0010,\u001a\u00020)H\u0002J\b\u0010-\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\b\u0010/\u001a\u00020\u001dH\u0016J\b\u00100\u001a\u00020\u0010H\u0016J\b\u00101\u001a\u00020\u0010H\u0016J\b\u00102\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchResultsListener;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "model", "Lcom/intellij/find/FindModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "selectionModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;", "closeCallback", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/find/FindModel;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/output/TerminalSelectionModel;Lkotlin/jvm/functions/Function0;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "component", "Lcom/intellij/find/SearchReplaceComponent;", "searchResults", "Lcom/intellij/find/impl/livePreview/SearchResults;", "livePreviewController", "Lcom/intellij/find/impl/livePreview/LivePreviewController;", "isSearchInBlock", "", "createSearchComponent", "findModelChanged", "searchFieldDocumentChanged", "searchResultsUpdated", "sr", "cursorMoved", "updateResults", "updateMultiLineStateIfNeeded", "updateUiWithFindModel", "updateEmptyText", "getEmptyText", "", "Lorg/jetbrains/annotations/Nls;", "checkRegex", "text", "getFindModel", "getComponent", "hasMatches", "searchForward", "searchBackward", "close", "TerminalSearchPresentation", "TerminalSearchResults", "SearchInBlockAction", "Companion", "intellij.terminal"})
public final class BlockTerminalSearchSession
implements SearchSession,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final FindModel model;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final Function0<Unit> closeCallback;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final SearchReplaceComponent component;
    @NotNull
    private final SearchResults searchResults;
    @NotNull
    private final LivePreviewController livePreviewController;
    private boolean isSearchInBlock;
    @NotNull
    private static final Key<Boolean> SEARCH_IN_BLOCK_KEY;

    public BlockTerminalSearchSession(@NotNull Project project, @NotNull EditorEx editor, @NotNull FindModel model, @NotNull TerminalOutputModel outputModel, @NotNull TerminalSelectionModel selectionModel, @NotNull Function0<Unit> closeCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter(closeCallback, (String)"closeCallback");
        this.project = project;
        this.editor = editor;
        this.model = model;
        this.outputModel = outputModel;
        this.selectionModel = selectionModel;
        this.closeCallback = closeCallback;
        Disposable disposable = Disposer.newDisposable((String)BlockTerminalSearchSession.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.component = this.createSearchComponent();
        this.searchResults = new TerminalSearchResults();
        this.livePreviewController = new LivePreviewController(this.searchResults, (SearchSession)this, this.disposable);
        this.isSearchInBlock = Companion.isSearchInBlock(this.model);
        this.searchResults.setMatchesLimit(10000);
        this.livePreviewController.on();
        this.livePreviewController.setLivePreview(new LivePreview(this.searchResults, (LivePreviewPresentation)new TerminalSearchPresentation((Editor)this.editor)));
        this.component.addListener((SearchReplaceComponent.Listener)this);
        this.searchResults.addListener((SearchResults.SearchResultsListener)this);
        this.model.addObserver(new FindModel.FindModelObserver(){
            private boolean preventRecursion;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void findModelChanged(FindModel findModel) {
                if (!this.preventRecursion) {
                    try {
                        this.preventRecursion = true;
                        this.findModelChanged();
                    }
                    finally {
                        this.preventRecursion = false;
                    }
                }
            }
        });
        this.selectionModel.addListener(new TerminalSelectionModel.TerminalSelectionListener(){

            @Override
            public void selectionChanged(List<? extends CommandBlock> oldSelection, List<? extends CommandBlock> newSelection) {
                Intrinsics.checkNotNullParameter(oldSelection, (String)"oldSelection");
                Intrinsics.checkNotNullParameter(newSelection, (String)"newSelection");
                Companion.setSearchInBlock(model, !((Collection)newSelection).isEmpty());
                searchResults.clear();
                this.updateResults();
            }
        }, this.disposable);
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getEditor() == editor) {
                    Disposer.dispose((Disposable)disposable);
                    livePreviewController.dispose();
                }
            }
        }, this.disposable);
        Object[] objectArray = new Object[]{0, 0};
        this.component.setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
        this.updateUiWithFindModel();
        this.updateMultiLineStateIfNeeded();
        ActionsKt.invokeLater$default(null, () -> BlockTerminalSearchSession._init_$lambda$1(this), (int)1, null);
    }

    public /* synthetic */ BlockTerminalSearchSession(Project project, EditorEx editorEx, FindModel findModel, TerminalOutputModel terminalOutputModel, TerminalSelectionModel terminalSelectionModel, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function0 = BlockTerminalSearchSession::_init_$lambda$0;
        }
        this(project, editorEx, findModel, terminalOutputModel, terminalSelectionModel, (Function0<Unit>)function0);
    }

    private final SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent;
        AnAction[] anActionArray = new AnAction[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction()};
        SearchReplaceComponent.Builder builder = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)this.editor.getContentComponent(), (SearchSession)this).addPrimarySearchActions(anActionArray);
        anActionArray = new AnAction[]{new SearchInBlockAction(), new ToggleMatchCase(), new ToggleRegex()};
        SearchReplaceComponent searchReplaceComponent2 = builder.addExtraSearchActions(anActionArray).withNewLineButton(false).withCloseAction(this::close).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent2, (String)"build(...)");
        SearchReplaceComponent it = searchReplaceComponent = searchReplaceComponent2;
        boolean bl = false;
        JTextComponent jTextComponent = it.getSearchTextComponent();
        JTextArea jTextArea = jTextComponent instanceof JTextArea ? (JTextArea)jTextComponent : null;
        if (jTextArea != null) {
            jTextArea.setColumns(14);
        }
        UiSizeUtilKt.setPreferredWidth((JComponent)((JComponent)it), (int)JBUI.scale((int)500));
        UiSizeUtilKt.setMaximumWidth((JComponent)((JComponent)it), (int)JBUI.scale((int)500));
        it.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)0, (int)1, (int)1, (int)0));
        return searchReplaceComponent;
    }

    private final void findModelChanged() {
        FindModel findModel;
        if (Companion.isSearchInBlock(this.model) != this.isSearchInBlock) {
            this.isSearchInBlock = Companion.isSearchInBlock(this.model);
            if (this.isSearchInBlock && this.selectionModel.getPrimarySelection() == null) {
                FindResult findResult = this.searchResults.getCursor();
                int offset = findResult != null ? findResult.getStartOffset() : this.editor.getCaretModel().getOffset();
                CommandBlock commandBlock = TerminalOutputModelKt.getByOffset(this.outputModel, offset);
                if (commandBlock != null) {
                    CommandBlock block = commandBlock;
                    boolean bl = false;
                    this.selectionModel.setSelectedBlocks(CollectionsKt.listOf((Object)block));
                }
            } else if (!this.isSearchInBlock) {
                this.selectionModel.setSelectedBlocks(CollectionsKt.emptyList());
            }
        }
        this.updateUiWithFindModel();
        this.searchResults.clear();
        this.updateResults();
        FindModel $this$findModelChanged_u24lambda_u244 = findModel = FindManager.getInstance((Project)this.project).getFindInFileModel();
        boolean bl = false;
        $this$findModelChanged_u24lambda_u244.setStringToFind(this.model.getStringToFind());
        $this$findModelChanged_u24lambda_u244.setCaseSensitive(this.model.isCaseSensitive());
        $this$findModelChanged_u24lambda_u244.setRegularExpressions(this.model.isRegularExpressions());
    }

    public void searchFieldDocumentChanged() {
        if (this.editor.isDisposed()) {
            return;
        }
        this.model.setStringToFind(this.component.getSearchTextComponent().getText());
        this.updateResults();
        this.updateMultiLineStateIfNeeded();
    }

    public void searchResultsUpdated(@NotNull SearchResults sr) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sr, (String)"sr");
        if (sr.getFindModel() == null) {
            return;
        }
        int matchesCount = sr.getMatchesCount();
        int cursorIndex = sr.getCursorVisualIndex();
        if (matchesCount > this.searchResults.getMatchesLimit()) {
            var6_4 = new Object[]{this.searchResults.getMatchesLimit()};
            string = ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])var6_4);
        } else if (cursorIndex != -1) {
            var6_4 = new Object[]{cursorIndex, matchesCount};
            string = ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])var6_4);
        } else {
            var6_4 = new Object[]{0, matchesCount};
            string = ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])var6_4);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String status = string2;
        this.component.setStatusText(status);
        this.component.updateActions();
    }

    public void cursorMoved() {
        this.component.updateActions();
    }

    private final void updateResults() {
        String string = this.model.getStringToFind();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringToFind(...)");
        String text = string;
        if (((CharSequence)text).length() > 0) {
            String string2;
            if (this.model.isRegularExpressions() && (string2 = this.checkRegex(text)) != null) {
                String warning = string2;
                boolean bl = false;
                this.searchResults.clear();
                this.component.setStatusText(warning);
                return;
            }
            this.livePreviewController.updateInBackground(this.model, true);
        } else {
            Object[] objectArray = new Object[]{0, 0};
            this.component.setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])objectArray));
            this.searchResults.clear();
        }
    }

    private final void updateMultiLineStateIfNeeded() {
        String string = this.component.getSearchTextComponent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.model.setMultiline(StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null));
    }

    private final void updateUiWithFindModel() {
        this.component.update(this.model.getStringToFind(), this.model.getStringToReplace(), this.model.isReplaceState(), this.model.isMultiline());
        this.updateEmptyText();
    }

    private final void updateEmptyText() {
        JTextComponent jTextComponent = this.component.getSearchTextComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
        JTextComponent searchComponent = jTextComponent;
        if (searchComponent instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)searchComponent).getEmptyText().setText(this.getEmptyText());
        }
    }

    private final String getEmptyText() {
        if (Companion.isSearchInBlock(this.model)) {
            String string = TerminalBundle.message("search.in.block", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return StringsKt.replace$default((String)string, (String)"\u001b", (String)"", (boolean)false, (int)4, null);
        }
        List options = (List)new SmartList();
        if (this.model.isCaseSensitive()) {
            String string = BlockTerminalSearchSession.getEmptyText$getOptionText("find.case.sensitive");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmptyText$getOptionText(...)");
            options.add(string);
        }
        if (this.model.isRegularExpressions()) {
            String string = BlockTerminalSearchSession.getEmptyText$getOptionText("find.regex");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEmptyText$getOptionText(...)");
            options.add(string);
        }
        String string = switch (options.size()) {
            case 0 -> ApplicationBundle.message((String)"editorsearch.search.hint", (Object[])new Object[0]);
            case 1 -> {
                Object[] var4_2 = new Object[]{options.get(0)};
                yield FindBundle.message((String)"emptyText.used.option", (Object[])var4_2);
            }
            default -> {
                Object[] var4_2 = new Object[]{options.get(0), options.get(1)};
                yield FindBundle.message((String)"emptyText.used.options", (Object[])var4_2);
            }
        };
        Intrinsics.checkNotNull((Object)string);
        String text = string;
        String string2 = StringUtil.capitalize((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capitalize(...)");
        return string2;
    }

    private final String checkRegex(String text) {
        try {
            new Regex(text);
        }
        catch (PatternSyntaxException e) {
            return FindBundle.message((String)"find.incorrect.regexp", (Object[])new Object[0]);
        }
        CharSequence charSequence = text;
        return new Regex("\\|+").matches(charSequence) ? ApplicationBundle.message((String)"editorsearch.empty.string.matches", (Object[])new Object[0]) : null;
    }

    @NotNull
    public FindModel getFindModel() {
        return this.model;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.component;
    }

    public boolean hasMatches() {
        return this.searchResults.hasMatches();
    }

    public void searchForward() {
        this.livePreviewController.moveCursor(SearchResults.Direction.DOWN);
    }

    public void searchBackward() {
        this.livePreviewController.moveCursor(SearchResults.Direction.UP);
    }

    public void close() {
        Disposer.dispose((Disposable)this.disposable);
        this.livePreviewController.dispose();
        this.closeCallback.invoke();
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(BlockTerminalSearchSession this$0) {
        this$0.component.updateActions();
        return Unit.INSTANCE;
    }

    private static final String getEmptyText$getOptionText(String key) {
        String string = FindBundle.message((String)key, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return StringUtil.toLowerCase((String)StringsKt.replace$default((String)string, (String)"\u001b", (String)"", (boolean)false, (int)4, null));
    }

    static {
        Key key = Key.create((String)"SearchInBlock");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SEARCH_IN_BLOCK_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession$Companion;", "", "<init>", "()V", "SEARCH_IN_BLOCK_KEY", "Lcom/intellij/openapi/util/Key;", "", "value", "isSearchInBlock", "Lcom/intellij/find/FindModel;", "(Lcom/intellij/find/FindModel;)Z", "setSearchInBlock", "(Lcom/intellij/find/FindModel;Z)V", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSearchInBlock(@NotNull FindModel $this$isSearchInBlock) {
            Intrinsics.checkNotNullParameter((Object)$this$isSearchInBlock, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isSearchInBlock.getCopyableUserData(SEARCH_IN_BLOCK_KEY), (Object)true);
        }

        public final void setSearchInBlock(@NotNull FindModel $this$isSearchInBlock, boolean value) {
            Intrinsics.checkNotNullParameter((Object)$this$isSearchInBlock, (String)"<this>");
            $this$isSearchInBlock.putCopyableUserData(SEARCH_IN_BLOCK_KEY, (Object)value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession$SearchInBlockAction;", "Lcom/intellij/find/editorHeaderActions/Embeddable;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "Lcom/intellij/find/editorHeaderActions/EditorHeaderToggleAction;", "<init>", "()V", "isSelected", "", "session", "Lcom/intellij/find/SearchSession;", "setSelected", "", "selected", "intellij.terminal"})
    private static final class SearchInBlockAction
    extends EditorHeaderToggleAction
    implements Embeddable,
    TooltipDescriptionProvider {
        public SearchInBlockAction() {
            super(TerminalBundle.message("search.in.block", new Object[0]), TerminalIcons.SearchInBlock, TerminalIcons.SearchInBlock, TerminalIcons.SearchInBlock);
        }

        protected boolean isSelected(@NotNull SearchSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            FindModel findModel = session2.getFindModel();
            Intrinsics.checkNotNullExpressionValue((Object)findModel, (String)"getFindModel(...)");
            return Companion.isSearchInBlock(findModel);
        }

        protected void setSelected(@NotNull SearchSession session2, boolean selected) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            FindModel findModel = session2.getFindModel();
            Intrinsics.checkNotNullExpressionValue((Object)findModel, (String)"getFindModel(...)");
            Companion.setSearchInBlock(findModel, selected);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession$TerminalSearchPresentation;", "Lcom/intellij/find/impl/livePreview/LivePreviewPresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "defaultAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getDefaultAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "cursorAttributes", "getCursorAttributes", "defaultLayer", "", "getDefaultLayer", "()I", "cursorLayer", "getCursorLayer", "intellij.terminal"})
    private static final class TerminalSearchPresentation
    implements LivePreviewPresentation {
        @NotNull
        private final Editor editor;
        private final int defaultLayer;
        private final int cursorLayer;

        public TerminalSearchPresentation(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.defaultLayer = 6001;
            this.cursorLayer = 6002;
        }

        @NotNull
        public TextAttributes getDefaultAttributes() {
            TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(BlockTerminalColors.SEARCH_ENTRY);
            if (textAttributes == null) {
                textAttributes = new TextAttributes();
            }
            return textAttributes;
        }

        @NotNull
        public TextAttributes getCursorAttributes() {
            TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(BlockTerminalColors.CURRENT_SEARCH_ENTRY);
            if (textAttributes == null) {
                textAttributes = new TextAttributes();
            }
            return textAttributes;
        }

        public int getDefaultLayer() {
            return this.defaultLayer;
        }

        public int getCursorLayer() {
            return this.cursorLayer;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession$TerminalSearchResults;", "Lcom/intellij/find/impl/livePreview/SearchResults;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession;)V", "getLocalSearchArea", "Lcom/intellij/find/impl/livePreview/SearchResults$SearchArea;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findModel", "Lcom/intellij/find/FindModel;", "firstOccurrenceAtOrAfterCaret", "Lcom/intellij/find/FindResult;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nBlockTerminalSearchSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalSearchSession.kt\norg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession$TerminalSearchResults\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1053#2:320\n360#2,7:321\n*S KotlinDebug\n*F\n+ 1 BlockTerminalSearchSession.kt\norg/jetbrains/plugins/terminal/block/output/BlockTerminalSearchSession$TerminalSearchResults\n*L\n266#1:320\n287#1:321,7\n*E\n"})
    private final class TerminalSearchResults
    extends SearchResults {
        public TerminalSearchResults() {
            super((Editor)BlockTerminalSearchSession.this.editor, BlockTerminalSearchSession.this.project);
        }

        @NotNull
        protected SearchResults.SearchArea getLocalSearchArea(@NotNull Editor editor, @NotNull FindModel findModel) {
            SearchResults.SearchArea searchArea;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
            if (Companion.isSearchInBlock(findModel)) {
                Iterable $this$sortedBy$iv = BlockTerminalSearchSession.this.selectionModel.getSelectedBlocks();
                boolean $i$f$sortedBy = false;
                List blocks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CommandBlock it = (CommandBlock)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStartOffset());
                        it = (CommandBlock)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
                    }
                });
                int[] starts = new int[blocks.size()];
                int[] ends = new int[blocks.size()];
                int n = ((Collection)blocks).size();
                for (int index = 0; index < n; ++index) {
                    starts[index] = ((CommandBlock)blocks.get(index)).getStartOffset();
                    ends[index] = ((CommandBlock)blocks.get(index)).getEndOffset();
                }
                SearchResults.SearchArea searchArea2 = SearchResults.SearchArea.create((int[])starts, (int[])ends);
                Intrinsics.checkNotNull((Object)searchArea2);
                searchArea = searchArea2;
            } else {
                int[] nArray = new int[]{0};
                int[] nArray2 = nArray;
                nArray = new int[]{Integer.MAX_VALUE};
                SearchResults.SearchArea searchArea3 = SearchResults.SearchArea.create((int[])nArray2, (int[])nArray);
                searchArea = searchArea3;
                Intrinsics.checkNotNullExpressionValue((Object)searchArea3, (String)"create(...)");
            }
            return searchArea;
        }

        @Nullable
        protected FindResult firstOccurrenceAtOrAfterCaret() {
            FindResult findResult;
            int index;
            block4: {
                int n;
                int topY = this.getEditor().getScrollingModel().getVisibleArea().y + 3 * this.getEditor().getLineHeight();
                LogicalPosition logicalPosition = this.getEditor().xyToLogicalPosition(new Point(0, topY));
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                LogicalPosition topLogicalPosition = logicalPosition;
                int topOffset = this.getEditor().logicalPositionToOffset(topLogicalPosition);
                List list = this.getOccurrences();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOccurrences(...)");
                List $this$indexOfFirst$iv = list;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FindResult it = (FindResult)item$iv;
                    boolean bl = false;
                    if (it.getStartOffset() >= topOffset) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index > 0) {
                findResult = (FindResult)this.getOccurrences().get(index);
            } else {
                List list = this.getOccurrences();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOccurrences(...)");
                findResult = (FindResult)CollectionsKt.lastOrNull((List)list);
            }
            return findResult;
        }
    }
}

