/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.lower.decoys;

import androidx.compose.compiler.plugins.kotlin.FeatureFlags;
import androidx.compose.compiler.plugins.kotlin.ModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityInferencer;
import androidx.compose.compiler.plugins.kotlin.lower.ModuleLoweringPass;
import androidx.compose.compiler.plugins.kotlin.lower.decoys.AbstractDecoysLowering;
import androidx.compose.compiler.plugins.kotlin.lower.decoys.DecoyFqNames;
import androidx.compose.compiler.plugins.kotlin.lower.decoys.DecoyTransformBaseKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureFactory;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010#\u001a\u00020$*\u00020%H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Landroidx/compose/compiler/plugins/kotlin/lower/decoys/RecordDecoySignaturesTransformer;", "Landroidx/compose/compiler/plugins/kotlin/lower/decoys/AbstractDecoysLowering;", "Landroidx/compose/compiler/plugins/kotlin/lower/ModuleLoweringPass;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "symbolRemapper", "Lorg/jetbrains/kotlin/ir/util/DeepCopySymbolRemapper;", "signatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "metrics", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "stabilityInferencer", "Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer;", "featureFlags", "Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;Lorg/jetbrains/kotlin/ir/util/DeepCopySymbolRemapper;Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer;Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;)V", "getSignatureBuilder", "()Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "getMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "lower", "", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "findNearestCommonSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "sig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "canBeLinkedAgainst", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nRecordDecoySignaturesTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordDecoySignaturesTransformer.kt\nandroidx/compose/compiler/plugins/kotlin/lower/decoys/RecordDecoySignaturesTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class RecordDecoySignaturesTransformer
extends AbstractDecoysLowering
implements ModuleLoweringPass {
    @NotNull
    private final IdSignatureFactory signatureBuilder;
    @NotNull
    private final KotlinMangler.IrMangler mangler;

    public RecordDecoySignaturesTransformer(@NotNull IrPluginContext pluginContext, @NotNull DeepCopySymbolRemapper symbolRemapper, @NotNull IdSignatureFactory signatureBuilder, @NotNull ModuleMetrics metrics, @NotNull KotlinMangler.IrMangler mangler, @NotNull StabilityInferencer stabilityInferencer, @NotNull FeatureFlags featureFlags) {
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        Intrinsics.checkNotNullParameter((Object)symbolRemapper, (String)"symbolRemapper");
        Intrinsics.checkNotNullParameter((Object)signatureBuilder, (String)"signatureBuilder");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)stabilityInferencer, (String)"stabilityInferencer");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        super(pluginContext, symbolRemapper, metrics, stabilityInferencer, signatureBuilder, featureFlags);
        this.signatureBuilder = signatureBuilder;
        this.mangler = mangler;
    }

    @Override
    @NotNull
    public IdSignatureFactory getSignatureBuilder() {
        return this.signatureBuilder;
    }

    @NotNull
    public final KotlinMangler.IrMangler getMangler() {
        return this.mangler;
    }

    @Override
    public void lower(@NotNull IrModuleFragment module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.transformChildrenVoid((IrElement)module);
    }

    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!DecoyTransformBaseKt.isDecoy((IrDeclaration)declaration) || !this.canBeLinkedAgainst((IrDeclaration)declaration)) {
            return super.visitFunction(declaration);
        }
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation((IrAnnotationContainer)((IrAnnotationContainer)declaration), (FqName)DecoyFqNames.INSTANCE.getDecoy());
        Intrinsics.checkNotNull((Object)irConstructorCall);
        IrConstructorCall decoyAnnotation = irConstructorCall;
        IrFunctionSymbol decoyFunction = this.getSymbolRemapper().getReferencedFunction(this.getComposableForDecoy(declaration));
        IdSignature sig = this.getSignatureBuilder().computeSignature((IrDeclaration)decoyFunction.getOwner());
        IdSignature.CommonSignature commonSignature = this.findNearestCommonSignature(sig);
        if (commonSignature == null) {
            throw new IllegalStateException((DumpIrTreeKt.dump$default((IrElement)((IrElement)declaration), null, (int)1, null) + " produced unsupported signature " + sig).toString());
        }
        Object[] objectArray = new String[]{commonSignature.getPackageFqName(), commonSignature.getDeclarationFqName(), String.valueOf(commonSignature.getId()), String.valueOf(commonSignature.getMask())};
        decoyAnnotation.putValueArgument(1, this.irVarargString(CollectionsKt.listOf((Object[])objectArray)));
        return super.visitFunction(declaration);
    }

    private final IdSignature.CommonSignature findNearestCommonSignature(IdSignature sig) {
        IdSignature idSignature = sig;
        return idSignature instanceof IdSignature.CommonSignature ? (IdSignature.CommonSignature)sig : (idSignature instanceof IdSignature.CompositeSignature ? this.findNearestCommonSignature(((IdSignature.CompositeSignature)sig).getInner()) : null);
    }

    private final boolean canBeLinkedAgainst(IrDeclaration $this$canBeLinkedAgainst) {
        KotlinMangler.IrMangler $this$canBeLinkedAgainst_u24lambda_u240 = this.mangler;
        boolean bl = false;
        return $this$canBeLinkedAgainst_u24lambda_u240.isExported((Object)$this$canBeLinkedAgainst, false);
    }
}

