/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MacroDefinitionRepository
extends NodeRepository<MacroDefinitionBlock> {
    private final ArrayList<MacroDefinitionBlock> myReferencedMacroDefinitionBlocks = new ArrayList();

    public void addMacrosReference(MacroDefinitionBlock macroDefinitionBlock, MacroReference macros) {
        if (!macroDefinitionBlock.isReferenced()) {
            this.myReferencedMacroDefinitionBlocks.add(macroDefinitionBlock);
        }
        macroDefinitionBlock.setFirstReferenceOffset(macros.getStartOffset());
    }

    public void resolveMacrosOrdinals() {
        this.myReferencedMacroDefinitionBlocks.sort(Comparator.comparing(MacroDefinitionBlock::getFirstReferenceOffset));
        int ordinal = 0;
        for (MacroDefinitionBlock macroDefinitionBlock : this.myReferencedMacroDefinitionBlocks) {
            macroDefinitionBlock.setOrdinal(++ordinal);
        }
    }

    public List<MacroDefinitionBlock> getReferencedMacroDefinitionBlocks() {
        return this.myReferencedMacroDefinitionBlocks;
    }

    public MacroDefinitionRepository(DataHolder options) {
        super(MacrosExtension.MACRO_DEFINITIONS_KEEP.get(options));
    }

    @Override
    @NotNull
    public DataKey<MacroDefinitionRepository> getDataKey() {
        return MacrosExtension.MACRO_DEFINITIONS;
    }

    @Override
    @NotNull
    public DataKey<KeepType> getKeepDataKey() {
        return MacrosExtension.MACRO_DEFINITIONS_KEEP;
    }

    @Override
    @NotNull
    public Set<MacroDefinitionBlock> getReferencedElements(Node parent) {
        HashSet<MacroDefinitionBlock> references = new HashSet<MacroDefinitionBlock>();
        this.visitNodes(parent, value2 -> {
            MacroDefinitionBlock reference;
            if (value2 instanceof MacroReference && (reference = ((MacroReference)value2).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, MacroReference.class);
        return references;
    }
}

