/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.data;

import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.data.TableCellFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.query.JTableColumnByIdentifierQuery;

public class TableCellByColumnId
implements TableCellFinder {
    public final int row;
    public final Object columnId;

    public static TableCellBuilder row(int row) {
        return new TableCellBuilder(row);
    }

    protected TableCellByColumnId(int row, @Nonnull Object columnId) {
        this.row = row;
        this.columnId = columnId;
    }

    @Override
    @Nonnull
    @RunsInEDT
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        return TableCellByColumnId.findCell(table, this.row, this.columnId);
    }

    @Nonnull
    @RunsInEDT
    private static TableCell findCell(@Nonnull JTable table, int row, @Nonnull Object columnId) {
        TableCell result = GuiActionRunner.execute(() -> {
            int column = JTableColumnByIdentifierQuery.columnIndexByIdentifier(table, columnId);
            if (column == -1) {
                TableCellByColumnId.failColumnIndexNotFound(columnId);
            }
            table.convertColumnIndexToView(table.getColumn(columnId).getModelIndex());
            return new TableCell(row, column);
        });
        return Preconditions.checkNotNull(result);
    }

    private static ActionFailedException failColumnIndexNotFound(Object columnId) {
        throw ActionFailedException.actionFailure(Strings.concat("Unable to find a column with id ", Strings.quote(columnId)));
    }

    public String toString() {
        return Strings.concat(this.getClass().getName(), "[row=", String.valueOf(this.row), ", columnId=", Strings.quote(this.columnId), "]");
    }

    public static class TableCellBuilder {
        private final int row;

        TableCellBuilder(int row) {
            this.row = row;
        }

        public TableCellByColumnId columnId(@Nonnull Object columnId) {
            return new TableCellByColumnId(this.row, columnId);
        }
    }
}

