/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.CommonBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"getChangeBrowserSettings", "Lcom/intellij/openapi/vcs/versionBrowser/ChangeBrowserSettings;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "showCommittedChanges", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "askMaxCount", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
public final class BrowseCommittedChangesActionKt {
    private static final ChangeBrowserSettings getChangeBrowserSettings(AbstractVcs vcs) {
        ChangeBrowserSettings changeBrowserSettings = vcs.getConfiguration().changeBrowserSettings.computeIfAbsent(vcs.getName(), arg_0 -> BrowseCommittedChangesActionKt.getChangeBrowserSettings$lambda$2(arg_0 -> BrowseCommittedChangesActionKt.getChangeBrowserSettings$lambda$1(vcs, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)changeBrowserSettings, (String)"computeIfAbsent(...)");
        return changeBrowserSettings;
    }

    private static final void showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        int maxCount;
        if (!settings.isAnyFilterSpecified()) {
            Project project = vcs.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            v1 = BrowseCommittedChangesActionKt.askMaxCount(project);
        } else {
            v1 = maxCount = 0;
        }
        if (maxCount < 0) {
            return;
        }
        RepositoryLocation repositoryLocation = CommittedChangesCache.getInstance(vcs.getProject()).getLocationCache().getLocation(vcs, VcsUtil.getFilePath((VirtualFile)file), false);
        if (repositoryLocation == null) {
            Object[] objectArray = new Object[]{file.getPresentableUrl()};
            VcsBalloonProblemNotifier.showOverVersionControlView(vcs.getProject(), VcsBundle.message((String)"changes.notification.content.repository.location.not.found.for", (Object[])objectArray), MessageType.ERROR);
            return;
        }
        AbstractVcsHelper abstractVcsHelper = AbstractVcsHelper.getInstance((Project)vcs.getProject());
        CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
        Intrinsics.checkNotNull((Object)committedChangesProvider);
        abstractVcsHelper.openCommittedChangesTab(committedChangesProvider, repositoryLocation, settings, maxCount, null);
    }

    private static final int askMaxCount(Project project) {
        return switch (Messages.showYesNoCancelDialog((Project)project, (String)VcsBundle.message((String)"browse.changes.no.filter.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.recent.button", (Object[])new Object[0]), (String)VcsBundle.message((String)"browse.changes.show.all.button", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) {
            case 2 -> -1;
            case 0 -> 50;
            default -> 0;
        };
    }

    private static final ChangeBrowserSettings getChangeBrowserSettings$lambda$1(AbstractVcs $vcs, String vcsName) {
        ChangeBrowserSettings changeBrowserSettings;
        CommittedChangesProvider committedChangesProvider = $vcs.getCommittedChangesProvider();
        Intrinsics.checkNotNull((Object)committedChangesProvider);
        ChangeBrowserSettings changeBrowserSettings2 = committedChangesProvider.createDefaultSettings();
        Intrinsics.checkNotNullExpressionValue((Object)changeBrowserSettings2, (String)"createDefaultSettings(...)");
        ChangeBrowserSettings it = changeBrowserSettings = changeBrowserSettings2;
        boolean bl = false;
        Project project = $vcs.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)project)).initPersistencePlainComponent((Object)it, "VcsManager.ChangeBrowser." + vcsName, PluginManagerCore.CORE_ID);
        return changeBrowserSettings;
    }

    private static final ChangeBrowserSettings getChangeBrowserSettings$lambda$2(Function1 $tmp0, Object p0) {
        return (ChangeBrowserSettings)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ChangeBrowserSettings access$getChangeBrowserSettings(AbstractVcs vcs) {
        return BrowseCommittedChangesActionKt.getChangeBrowserSettings(vcs);
    }

    public static final /* synthetic */ void access$showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        BrowseCommittedChangesActionKt.showCommittedChanges(vcs, file, settings);
    }
}

