/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class VcsDirtyScopeManagerImpl
extends VcsDirtyScopeManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsDirtyScopeManagerImpl.class);
    private final Project project;
    @NotNull
    private DirtBuilder myDirtBuilder;
    @Nullable
    private DirtBuilder myDirtInProgress;
    @Nullable
    private ActionCallback myRefreshInProgress;
    private boolean myReady;
    private final Object LOCK;

    @NotNull
    public static VcsDirtyScopeManagerImpl getInstanceImpl(@NotNull Project project) {
        if (project == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(0);
        }
        VcsDirtyScopeManagerImpl vcsDirtyScopeManagerImpl = (VcsDirtyScopeManagerImpl)VcsDirtyScopeManagerImpl.getInstance((Project)project);
        if (vcsDirtyScopeManagerImpl == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(1);
        }
        return vcsDirtyScopeManagerImpl;
    }

    public VcsDirtyScopeManagerImpl(@NotNull Project project) {
        if (project == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(2);
        }
        this.myDirtBuilder = new DirtBuilder();
        this.LOCK = new Object();
        this.project = project;
        MessageBusConnection busConnection = this.project.getMessageBus().connect();
        busConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                boolean isGenericEvent;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean bl = isGenericEvent = event.getAddedFileType() == null && event.getRemovedFileType() == null;
                if (isGenericEvent) {
                    ApplicationManager.getApplication().invokeLater(() -> VcsDirtyScopeManagerImpl.this.markEverythingDirty(), ModalityState.nonModal(), VcsDirtyScopeManagerImpl.this.project.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl$1", "fileTypesChanged"));
            }
        });
        if (Registry.is((String)"ide.hide.excluded.files")) {
            busConnection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> VcsDirtyScopeManagerImpl.this.markEverythingDirty(), ModalityState.nonModal(), VcsDirtyScopeManagerImpl.this.project.getDisposed());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl$2", "rootsChanged"));
                }
            });
        }
    }

    private static ProjectLevelVcsManager getVcsManager(@NotNull Project project) {
        if (project == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(3);
        }
        return ProjectLevelVcsManager.getInstance((Project)project);
    }

    private void startListenForChanges() {
        ReadAction.run(() -> {
            boolean ready = !this.project.isDisposed() && this.project.isOpen();
            Object object = this.LOCK;
            synchronized (object) {
                this.myReady = ready;
            }
            if (ready) {
                this.project.getService(VcsDirtyScopeVfsListener.class);
                this.markEverythingDirty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEverythingDirty() {
        ActionCallback ongoingRefresh;
        boolean wasReady;
        if (!this.project.isOpen() || this.project.isDisposed() || VcsDirtyScopeManagerImpl.getVcsManager(this.project).getAllActiveVcss().length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("everything dirty: " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
        }
        Object object = this.LOCK;
        synchronized (object) {
            wasReady = this.myReady;
            if (wasReady) {
                this.myDirtBuilder.markEverythingDirty();
            }
            ongoingRefresh = this.myRefreshInProgress;
        }
        if (wasReady) {
            ChangeListManagerImpl.getInstanceImpl(this.project).scheduleUpdateImpl();
            if (ongoingRefresh != null) {
                ongoingRefresh.setRejected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
            this.myDirtBuilder = new DirtBuilder();
            this.myDirtInProgress = null;
            this.myRefreshInProgress = null;
        }
    }

    @NotNull
    private Map<VcsRoot, Set<FilePath>> groupByVcs(@Nullable Iterable<? extends FilePath> from) {
        if (from == null) {
            Map<VcsRoot, Set<FilePath>> map = Collections.emptyMap();
            if (map == null) {
                VcsDirtyScopeManagerImpl.$$$reportNull$$$0(4);
            }
            return map;
        }
        ProjectLevelVcsManager vcsManager = VcsDirtyScopeManagerImpl.getVcsManager(this.project);
        HashMap<VcsRoot, Set<FilePath>> map = new HashMap<VcsRoot, Set<FilePath>>();
        for (FilePath filePath : from) {
            VcsRoot vcsRoot = vcsManager.getVcsRootObjectFor(filePath);
            if (vcsRoot == null || vcsRoot.getVcs() == null) continue;
            Set pathSet = map.computeIfAbsent(vcsRoot, key -> {
                HashingStrategy<FilePath> strategy = VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(key.getVcs());
                return strategy == null ? new HashSet() : CollectionFactory.createCustomHashingStrategySet(strategy);
            });
            pathSet.add(filePath);
        }
        HashMap<VcsRoot, Set<FilePath>> hashMap = map;
        if (hashMap == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    private Map<VcsRoot, Set<FilePath>> groupFilesByVcs(@Nullable Collection<? extends VirtualFile> from) {
        if (from == null) {
            Map<VcsRoot, Set<FilePath>> map = Collections.emptyMap();
            if (map == null) {
                VcsDirtyScopeManagerImpl.$$$reportNull$$$0(6);
            }
            return map;
        }
        return this.groupByVcs(() -> ContainerUtil.mapIterator(from.iterator(), file -> VcsUtil.getFilePath((VirtualFile)file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileVcsPathsDirty(@NotNull Map<VcsRoot, Set<FilePath>> filesConverted, @NotNull Map<VcsRoot, Set<FilePath>> dirsConverted) {
        if (filesConverted == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(7);
        }
        if (dirsConverted == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(8);
        }
        if (filesConverted.isEmpty() && dirsConverted.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("dirty files: %s; dirty dirs: %s; %s", VcsDirtyScopeManagerImpl.toString(filesConverted), VcsDirtyScopeManagerImpl.toString(dirsConverted), VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass()));
        }
        boolean hasSomethingDirty = false;
        for (VcsRoot vcsRoot : ContainerUtil.union(filesConverted.keySet(), dirsConverted.keySet())) {
            Set files = ContainerUtil.notNullize(filesConverted.get(vcsRoot));
            Set dirs = ContainerUtil.notNullize(dirsConverted.get(vcsRoot));
            Object object = this.LOCK;
            synchronized (object) {
                if (this.myReady) {
                    hasSomethingDirty |= this.myDirtBuilder.addDirtyFiles(vcsRoot, files, dirs);
                }
            }
        }
        if (hasSomethingDirty) {
            ChangeListManagerImpl.getInstanceImpl(this.project).scheduleUpdateImpl();
        }
    }

    public void filePathsDirty(@Nullable Collection<? extends FilePath> filesDirty, @Nullable Collection<? extends FilePath> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupByVcs(filesDirty), this.groupByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void filesDirty(@Nullable Collection<? extends VirtualFile> filesDirty, @Nullable Collection<? extends VirtualFile> dirsRecursivelyDirty) {
        try {
            this.fileVcsPathsDirty(this.groupFilesByVcs(filesDirty), this.groupFilesByVcs(dirsRecursivelyDirty));
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void fileDirty(@NotNull VirtualFile file) {
        if (file == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(9);
        }
        this.fileDirty(VcsUtil.getFilePath((VirtualFile)file));
    }

    public void fileDirty(@NotNull FilePath file) {
        if (file == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(10);
        }
        this.filePathsDirty(Collections.singleton(file), null);
    }

    public void dirDirtyRecursively(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(11);
        }
        this.dirDirtyRecursively(VcsUtil.getFilePath((VirtualFile)dir));
    }

    public void dirDirtyRecursively(@NotNull FilePath path) {
        if (path == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(12);
        }
        this.filePathsDirty(null, Collections.singleton(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsInvalidated retrieveScopes() {
        DirtBuilder dirtBuilder;
        ActionCallback callback = new ActionCallback();
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return null;
            }
            LOG.assertTrue(this.myDirtInProgress == null);
            this.myDirtInProgress = dirtBuilder = this.myDirtBuilder;
            this.myDirtBuilder = new DirtBuilder();
            this.myRefreshInProgress = callback;
        }
        return this.calculateInvalidated(dirtBuilder, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDirtyScopes() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return false;
            }
            LOG.assertTrue(this.myDirtInProgress == null);
            return !this.myDirtBuilder.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changesProcessed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtInProgress = null;
            this.myRefreshInProgress = null;
        }
    }

    @NotNull
    private VcsInvalidated calculateInvalidated(@NotNull DirtBuilder dirt, @NotNull ActionCallback callback) {
        if (dirt == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(13);
        }
        if (callback == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(14);
        }
        boolean isEverythingDirty = dirt.isEverythingDirty();
        List<VcsModifiableDirtyScope> scopes = dirt.buildScopes(this.project);
        return new VcsInvalidated(scopes, isEverythingDirty, callback);
    }

    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(15);
        }
        Collection collection = (Collection)ReadAction.compute(() -> {
            ArrayList<FilePath> result2 = new ArrayList<FilePath>();
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.myReady) {
                    return Collections.emptyList();
                }
                for (FilePath fp : files) {
                    if (!this.myDirtBuilder.isFileDirty(fp) && (this.myDirtInProgress == null || !this.myDirtInProgress.isFileDirty(fp))) continue;
                    result2.add(fp);
                }
            }
            return result2;
        });
        if (collection == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    private static String toString(@NotNull Map<VcsRoot, Set<FilePath>> filesByVcs) {
        if (filesByVcs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(17);
        }
        String string = StringUtil.join(filesByVcs.keySet(), vcs -> vcs.getVcs() + ": " + StringUtil.join((Collection)((Collection)filesByVcs.get(vcs)), path -> path.getPath(), (String)"\n"), (String)"\n");
        if (string == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    private static Class<?> findFirstInterestingCallerClass() {
        for (int i = 1; i <= 7; ++i) {
            Class clazz = ReflectionUtil.findCallerClass((int)i);
            if (clazz != null && clazz.getName().contains(VcsDirtyScopeManagerImpl.class.getName())) continue;
            return clazz;
        }
        return null;
    }

    @Nullable
    public static HashingStrategy<FilePath> getDirtyScopeHashingStrategy(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsDirtyScopeManagerImpl.$$$reportNull$$$0(19);
        }
        return vcs.needsCaseSensitiveDirtyScope() ? ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesConverted";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsConverted";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesByVcs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByVcs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "groupFilesByVcs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "whatFilesDirty";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsManager";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileVcsPathsDirty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fileDirty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dirDirtyRecursively";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateInvalidated";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "whatFilesDirty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyScopeHashingStrategy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 16, 18 -> new IllegalStateException(string);
        };
    }

    static final class MyStartupActivity
    implements VcsStartupActivity {
        MyStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            VcsDirtyScopeManagerImpl.getInstanceImpl(project).startListenForChanges();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.DIRTY_SCOPE_MANAGER.getOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl$MyStartupActivity", "runActivity"));
        }
    }
}

