/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaHighlightingSessionStatisticsCollector;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectBackedByJacksonBase;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"resolveLocalSchemaNode", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "maybeEmptyReference", "", "currentSchemaNode", "Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectBackedByJacksonBase;", "resolveRemoteSchemaByUrl", "reference", "schemaNode", "service", "Lcom/jetbrains/jsonSchema/ide/JsonSchemaService;", "resolveIdOrDynamicAnchor", "idOrAnchorName", "resolveReference", "intellij.json"})
public final class JsonSchemaRefResolverKt {
    @Nullable
    public static final JsonSchemaObject resolveLocalSchemaNode(@NotNull String maybeEmptyReference, @NotNull JsonSchemaObjectBackedByJacksonBase currentSchemaNode) {
        Intrinsics.checkNotNullParameter((Object)maybeEmptyReference, (String)"maybeEmptyReference");
        Intrinsics.checkNotNullParameter((Object)currentSchemaNode, (String)"currentSchemaNode");
        JsonSchemaHighlightingSessionStatisticsCollector.Companion.getInstance().reportSchemaUsageFeature(JsonSchemaFusCountedFeature.LocalReferenceResolveRequest);
        return StringsKt.startsWith$default((String)maybeEmptyReference, (String)"#/", (boolean)false, (int)2, null) ? JsonSchemaRefResolverKt.resolveReference(maybeEmptyReference, currentSchemaNode) : (StringsKt.startsWith$default((String)maybeEmptyReference, (String)"/", (boolean)false, (int)2, null) ? JsonSchemaRefResolverKt.resolveReference(maybeEmptyReference, currentSchemaNode) : (Intrinsics.areEqual((Object)maybeEmptyReference, (Object)"#") ? (JsonSchemaObject)currentSchemaNode.getRootSchemaObject() : (StringsKt.startsWith$default((String)maybeEmptyReference, (String)"#", (boolean)false, (int)2, null) ? JsonSchemaRefResolverKt.resolveIdOrDynamicAnchor(maybeEmptyReference, currentSchemaNode) : null)));
    }

    private static final JsonSchemaObject resolveRemoteSchemaByUrl(String reference, JsonSchemaObject schemaNode, JsonSchemaService service) {
        VirtualFile virtualFile;
        JsonSchemaObject value = JsonSchemaObjectReadingUtils.fetchSchemaFromRefDefinition(reference, schemaNode, service, schemaNode.isRefRecursive());
        if (!JsonFileResolver.isHttpPath(reference)) {
            service.registerReference(reference);
        } else if (value != null && (virtualFile = service.resolveSchemaFile(value)) != null && !(virtualFile instanceof HttpVirtualFile)) {
            service.registerReference(virtualFile.getName());
        }
        return value;
    }

    private static final JsonSchemaObject resolveIdOrDynamicAnchor(String idOrAnchorName, JsonSchemaObjectBackedByJacksonBase currentSchemaNode) {
        String effectiveSchemaNodePointer;
        CharSequence charSequence;
        char[] cArray = new char[]{'#'};
        String maybeExistingIdOrAnchor = StringsKt.trimStart((String)idOrAnchorName, (char[])cArray);
        String string = currentSchemaNode.getRootSchemaObject().resolveDynamicAnchor(maybeExistingIdOrAnchor);
        if (string == null) {
            string = currentSchemaNode.getRootSchemaObject().resolveId(maybeExistingIdOrAnchor);
        }
        if ((charSequence = (CharSequence)(effectiveSchemaNodePointer = string)) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        return currentSchemaNode.getRootSchemaObject().getSchemaObjectByAbsoluteJsonPointer(effectiveSchemaNodePointer);
    }

    private static final JsonSchemaObject resolveReference(String reference, JsonSchemaObjectBackedByJacksonBase currentSchemaNode) {
        char[] cArray = new char[]{'#'};
        String maybeCorrectJsonPointer = StringsKt.trimStart((String)reference, (char[])cArray);
        return currentSchemaNode.getRootSchemaObject().getSchemaObjectByAbsoluteJsonPointer(maybeCorrectJsonPointer);
    }

    public static final /* synthetic */ JsonSchemaObject access$resolveRemoteSchemaByUrl(String reference, JsonSchemaObject schemaNode, JsonSchemaService service) {
        return JsonSchemaRefResolverKt.resolveRemoteSchemaByUrl(reference, schemaNode, service);
    }
}

