/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.Attributes;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmConstructor;
import kotlin.metadata.KmDeclarationContainer;
import kotlin.metadata.KmFunction;
import kotlin.metadata.KmPackage;
import kotlin.metadata.KmProperty;
import kotlin.metadata.Visibility;
import kotlin.metadata.jvm.JvmExtensionsKt;
import kotlin.metadata.jvm.JvmMetadataUtil;
import kotlin.metadata.jvm.JvmMetadataVersion;
import kotlin.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jvm.abi.JvmAbiMetadataProcessorKt;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u001a\u001c\u0010\u000b\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a:\u0010\u0012\u001a\u00020\u000f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a$\u0010\u0012\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a,\u0010\u0012\u001a\u00020\u000f*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0004*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0004*\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\u001b"}, d2={"abiMetadataProcessor", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "annotationVisitor", "removeDataClassCopyIfConstructorIsPrivate", "", "preserveDeclarationOrder", "classesToBeDeleted", "", "", "pruneClass", "treatInternalAsPrivate", "kotlinClassHeaderVisitor", "body", "Lkotlin/Function1;", "Lkotlin/Metadata;", "", "visitKotlinMetadata", "header", "removePrivateDeclarations", "Lkotlin/metadata/KmClass;", "removeCopyAlongWithConstructor", "Lkotlin/metadata/KmPackage;", "Lkotlin/metadata/KmDeclarationContainer;", "copyFunShouldBeDeleted", "removeDataClassCopy", "shouldRemove", "Lkotlin/metadata/Visibility;", "jvm-abi-gen"})
@SourceDebugExtension(value={"SMAP\nJvmAbiMetadataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n13409#2,2:224\n13409#2,2:226\n1#3:228\n2632#4,3:229\n*S KotlinDebug\n*F\n+ 1 JvmAbiMetadataProcessor.kt\norg/jetbrains/kotlin/jvm/abi/JvmAbiMetadataProcessorKt\n*L\n140#1:224,2\n146#1:226,2\n215#1:229,3\n*E\n"})
public final class JvmAbiMetadataProcessorKt {
    @NotNull
    public static final AnnotationVisitor abiMetadataProcessor(@NotNull AnnotationVisitor annotationVisitor, boolean removeDataClassCopyIfConstructorIsPrivate, boolean preserveDeclarationOrder, @NotNull Set<String> classesToBeDeleted, boolean pruneClass, boolean treatInternalAsPrivate) {
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"annotationVisitor");
        Intrinsics.checkNotNullParameter(classesToBeDeleted, (String)"classesToBeDeleted");
        return JvmAbiMetadataProcessorKt.kotlinClassHeaderVisitor((Function1<? super Metadata, Unit>)((Function1)arg_0 -> JvmAbiMetadataProcessorKt.abiMetadataProcessor$lambda$4(annotationVisitor, removeDataClassCopyIfConstructorIsPrivate, preserveDeclarationOrder, classesToBeDeleted, pruneClass, treatInternalAsPrivate, arg_0)));
    }

    private static final AnnotationVisitor kotlinClassHeaderVisitor(Function1<? super Metadata, Unit> body) {
        return new AnnotationVisitor(body){
            private int kind;
            private int[] metadataVersion;
            private List<String> data1;
            private List<String> data2;
            private String extraString;
            private String packageName;
            private int extraInt;
            final /* synthetic */ Function1<Metadata, Unit> $body;
            {
                this.$body = $body;
                super(589824);
                this.kind = 1;
                this.metadataVersion = new int[0];
                this.data1 = new ArrayList<E>();
                this.data2 = new ArrayList<E>();
            }

            public final int getKind() {
                return this.kind;
            }

            public final void setKind(int n) {
                this.kind = n;
            }

            public final int[] getMetadataVersion() {
                return this.metadataVersion;
            }

            public final void setMetadataVersion(int[] nArray) {
                Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
                this.metadataVersion = nArray;
            }

            public final List<String> getData1() {
                return this.data1;
            }

            public final void setData1(List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data1 = list;
            }

            public final List<String> getData2() {
                return this.data2;
            }

            public final void setData2(List<String> list) {
                Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
                this.data2 = list;
            }

            public final String getExtraString() {
                return this.extraString;
            }

            public final void setExtraString(String string) {
                this.extraString = string;
            }

            public final String getPackageName() {
                return this.packageName;
            }

            public final void setPackageName(String string) {
                this.packageName = string;
            }

            public final int getExtraInt() {
                return this.extraInt;
            }

            public final void setExtraInt(int n) {
                this.extraInt = n;
            }

            public void visit(String name, Object value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                switch (name) {
                    case "k": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.kind = (Integer)value;
                        break;
                    }
                    case "xi": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                        this.extraInt = (Integer)value;
                        break;
                    }
                    case "mv": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.IntArray");
                        this.metadataVersion = (int[])value;
                        break;
                    }
                    case "xs": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.extraString = (String)value;
                        break;
                    }
                    case "pn": {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        this.packageName = (String)value;
                    }
                }
            }

            public AnnotationVisitor visitArray(String name) {
                List<String> list;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)"d1")) {
                    list = this.data1;
                } else if (Intrinsics.areEqual((Object)string, (Object)"d2")) {
                    list = this.data2;
                } else {
                    return null;
                }
                List<String> destination = list;
                return new AnnotationVisitor(destination){
                    final /* synthetic */ List<String> $destination;
                    {
                        this.$destination = $destination;
                        super(589824);
                    }

                    public void visit(String name, Object value) {
                        Collection collection = this.$destination;
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        collection.add((String)value);
                    }
                };
            }

            public void visitEnd() {
                Collection $this$toTypedArray$iv = this.data1;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = this.data2;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                this.$body.invoke((Object)JvmMetadataUtil.Metadata(this.kind, this.metadataVersion, thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]), this.extraString, this.packageName, this.extraInt));
            }
        };
    }

    private static final void visitKotlinMetadata(AnnotationVisitor $this$visitKotlinMetadata, Metadata header) {
        String it;
        String element$iv;
        int n;
        int n2;
        boolean $i$f$forEach;
        String[] $this$forEach$iv;
        AnnotationVisitor annotationVisitor;
        $this$visitKotlinMetadata.visit("k", (Object)header.k());
        $this$visitKotlinMetadata.visit("mv", (Object)header.mv());
        if (!(header.d1().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u246 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d1");
            boolean bl = false;
            $this$forEach$iv = header.d1();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl2 = false;
                $this$visitKotlinMetadata_u24lambda_u246.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u246.visitEnd();
        }
        if (!(header.d2().length == 0)) {
            AnnotationVisitor $this$visitKotlinMetadata_u24lambda_u248 = annotationVisitor = $this$visitKotlinMetadata.visitArray("d2");
            boolean bl = false;
            $this$forEach$iv = header.d2();
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl3 = false;
                $this$visitKotlinMetadata_u24lambda_u248.visit(null, (Object)it);
            }
            $this$visitKotlinMetadata_u24lambda_u248.visitEnd();
        }
        if (((CharSequence)header.xs()).length() > 0) {
            $this$visitKotlinMetadata.visit("xs", (Object)header.xs());
        }
        if (((CharSequence)header.pn()).length() > 0) {
            $this$visitKotlinMetadata.visit("pn", (Object)header.pn());
        }
        if (header.xi() != 0) {
            $this$visitKotlinMetadata.visit("xi", (Object)header.xi());
        }
        $this$visitKotlinMetadata.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    private static final void removePrivateDeclarations(KmClass $this$removePrivateDeclarations, boolean removeCopyAlongWithConstructor, boolean preserveDeclarationOrder, Set<String> classesToBeDeleted, boolean pruneClass, boolean treatInternalAsPrivate) {
        void it;
        String string;
        $this$removePrivateDeclarations.getConstructors().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$10(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$9(pruneClass, treatInternalAsPrivate, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)$this$removePrivateDeclarations, (String)"null cannot be cast to non-null type kotlin.metadata.KmDeclarationContainer");
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($this$removePrivateDeclarations, JvmAbiMetadataProcessorKt.copyFunShouldBeDeleted($this$removePrivateDeclarations, removeCopyAlongWithConstructor), preserveDeclarationOrder, pruneClass, treatInternalAsPrivate);
        $this$removePrivateDeclarations.getNestedClasses().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$12(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$11(classesToBeDeleted, $this$removePrivateDeclarations, arg_0), arg_0));
        String string2 = string = $this$removePrivateDeclarations.getCompanionObject();
        KmClass kmClass = $this$removePrivateDeclarations;
        boolean bl = false;
        boolean bl2 = classesToBeDeleted.contains($this$removePrivateDeclarations.getName() + '$' + (String)it);
        kmClass.setCompanionObject(!bl2 ? string : null);
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final void removePrivateDeclarations(KmPackage $this$removePrivateDeclarations, boolean preserveDeclarationOrder, boolean pruneClass, boolean treatInternalAsPrivate) {
        Intrinsics.checkNotNull((Object)$this$removePrivateDeclarations, (String)"null cannot be cast to non-null type kotlin.metadata.KmDeclarationContainer");
        JvmAbiMetadataProcessorKt.removePrivateDeclarations($this$removePrivateDeclarations, false, preserveDeclarationOrder, pruneClass, treatInternalAsPrivate);
        JvmExtensionsKt.getLocalDelegatedProperties($this$removePrivateDeclarations).clear();
    }

    private static final void removePrivateDeclarations(KmDeclarationContainer $this$removePrivateDeclarations, boolean copyFunShouldBeDeleted, boolean preserveDeclarationOrder, boolean pruneClass, boolean treatInternalAsPrivate) {
        $this$removePrivateDeclarations.getFunctions().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$15(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$14(pruneClass, treatInternalAsPrivate, copyFunShouldBeDeleted, arg_0), arg_0));
        $this$removePrivateDeclarations.getProperties().removeIf(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$17(arg_0 -> JvmAbiMetadataProcessorKt.removePrivateDeclarations$lambda$16(pruneClass, treatInternalAsPrivate, arg_0), arg_0));
        if (!preserveDeclarationOrder) {
            Function1[] function1Array = new Function1[]{removePrivateDeclarations.6.INSTANCE, JvmAbiMetadataProcessorKt::removePrivateDeclarations$lambda$18};
            CollectionsKt.sortWith($this$removePrivateDeclarations.getFunctions(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
            function1Array = new Function1[]{removePrivateDeclarations.8.INSTANCE, JvmAbiMetadataProcessorKt::removePrivateDeclarations$lambda$19};
            CollectionsKt.sortWith($this$removePrivateDeclarations.getProperties(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        }
        for (KmProperty property : $this$removePrivateDeclarations.getProperties()) {
            if (Attributes.isConst(property)) continue;
            Attributes.setHasConstant(property, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean copyFunShouldBeDeleted(KmClass $this$copyFunShouldBeDeleted, boolean removeDataClassCopy) {
        boolean bl;
        if (!removeDataClassCopy) return false;
        if (!Attributes.isData($this$copyFunShouldBeDeleted)) return false;
        Iterable $this$none$iv = $this$copyFunShouldBeDeleted.getConstructors();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            KmConstructor it = (KmConstructor)element$iv;
            boolean bl2 = false;
            if (!Attributes.isSecondary(it)) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private static final boolean shouldRemove(Visibility $this$shouldRemove, boolean treatInternalAsPrivate) {
        return $this$shouldRemove == Visibility.PRIVATE || $this$shouldRemove == Visibility.PRIVATE_TO_THIS || $this$shouldRemove == Visibility.LOCAL || treatInternalAsPrivate && $this$shouldRemove == Visibility.INTERNAL;
    }

    private static final Unit abiMetadataProcessor$lambda$4$lambda$2$lambda$1(boolean $removeDataClassCopyIfConstructorIsPrivate, boolean $preserveDeclarationOrder, Set $classesToBeDeleted, boolean $pruneClass, boolean $treatInternalAsPrivate, KotlinClassMetadata metadata) {
        block1: {
            KotlinClassMetadata kotlinClassMetadata;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                    kotlinClassMetadata = metadata;
                    if (!(kotlinClassMetadata instanceof KotlinClassMetadata.Class)) break block0;
                    JvmAbiMetadataProcessorKt.removePrivateDeclarations(((KotlinClassMetadata.Class)metadata).getKmClass(), $removeDataClassCopyIfConstructorIsPrivate, $preserveDeclarationOrder, $classesToBeDeleted, $pruneClass, $treatInternalAsPrivate);
                    break block1;
                }
                if (!(kotlinClassMetadata instanceof KotlinClassMetadata.FileFacade)) break block2;
                JvmAbiMetadataProcessorKt.removePrivateDeclarations(((KotlinClassMetadata.FileFacade)metadata).getKmPackage(), $preserveDeclarationOrder, $pruneClass, $treatInternalAsPrivate);
                break block1;
            }
            if (!(kotlinClassMetadata instanceof KotlinClassMetadata.MultiFileClassPart)) break block1;
            JvmAbiMetadataProcessorKt.removePrivateDeclarations(((KotlinClassMetadata.MultiFileClassPart)metadata).getKmPackage(), $preserveDeclarationOrder, $pruneClass, $treatInternalAsPrivate);
        }
        return Unit.INSTANCE;
    }

    private static final Unit abiMetadataProcessor$lambda$4(AnnotationVisitor $annotationVisitor, boolean $removeDataClassCopyIfConstructorIsPrivate, boolean $preserveDeclarationOrder, Set $classesToBeDeleted, boolean $pruneClass, boolean $treatInternalAsPrivate, Metadata header) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        int[] v22 = object2 = header.mv();
        boolean bl = false;
        Integer n = ArraysKt.getOrNull((int[])v22, (int)0);
        int major = n != null ? n : 0;
        Integer n2 = ArraysKt.getOrNull((int[])v22, (int)1);
        int minor = n2 != null ? n2 : 0;
        int[] nArray = (int[])(major > 1 || major == 1 && minor >= 4 ? object2 : null);
        if (nArray == null) {
            object2 = new int[]{1, 4};
            nArray = object2;
        }
        int[] metadataVersion = nArray;
        try {
            boolean bl2 = false;
            object2 = Result.constructor-impl((Object)KotlinClassMetadata.Companion.transform(header, (Function1<? super KotlinClassMetadata, Unit>)((Function1)arg_0 -> JvmAbiMetadataProcessorKt.abiMetadataProcessor$lambda$4$lambda$2$lambda$1($removeDataClassCopyIfConstructorIsPrivate, $preserveDeclarationOrder, $classesToBeDeleted, $pruneClass, $treatInternalAsPrivate, arg_0))));
        }
        catch (Throwable v22) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)v22));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable cause = throwable;
            boolean bl3 = false;
            if (Boolean.parseBoolean(System.getProperty("idea.is.unit.test"))) {
                String actual = "" + metadataVersion[0] + '.' + metadataVersion[1];
                String expected = JvmMetadataVersion.LATEST_STABLE_SUPPORTED.toString();
                throw new AssertionError("jvm-abi-gen can't process class file with the new metadata version because the version of kotlinx-metadata-jvm it depends on is too old.\nClass file has metadata version " + actual + ", but default metadata version of kotlinx-metadata-jvm is " + expected + ", so it can process class files with metadata version up to +1 from that (because of Kotlin/JVM's one-version forward compatibility policy).\nTo fix this error, ensure that jvm-abi-gen depends on the latest version of kotlinx-metadata-jvm.\nIf this happens during the update of the default language version in the project, make sure that a version of kotlinx-metadata-jvm has been published that supports this version, and update \"versions.kotlinx-metadata-jvm\" in `gradle/versions.properties`.", cause);
            }
            object = header;
        }
        Metadata newHeader = (Metadata)object;
        JvmAbiMetadataProcessorKt.visitKotlinMetadata($annotationVisitor, newHeader);
        return Unit.INSTANCE;
    }

    private static final boolean removePrivateDeclarations$lambda$9(boolean $pruneClass, boolean $treatInternalAsPrivate, KmConstructor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pruneClass || JvmAbiMetadataProcessorKt.shouldRemove(Attributes.getVisibility(it), $treatInternalAsPrivate);
    }

    private static final boolean removePrivateDeclarations$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$11(Set $classesToBeDeleted, KmClass $this_removePrivateDeclarations, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $classesToBeDeleted.contains($this_removePrivateDeclarations.getName() + '$' + it);
    }

    private static final boolean removePrivateDeclarations$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$14(boolean $pruneClass, boolean $treatInternalAsPrivate, boolean $copyFunShouldBeDeleted, KmFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pruneClass || JvmAbiMetadataProcessorKt.shouldRemove(Attributes.getVisibility(it), $treatInternalAsPrivate) || $copyFunShouldBeDeleted && Intrinsics.areEqual((Object)it.getName(), (Object)"copy");
    }

    private static final boolean removePrivateDeclarations$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removePrivateDeclarations$lambda$16(boolean $pruneClass, boolean $treatInternalAsPrivate, KmProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pruneClass || JvmAbiMetadataProcessorKt.shouldRemove(Attributes.getVisibility(it), $treatInternalAsPrivate);
    }

    private static final boolean removePrivateDeclarations$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Comparable removePrivateDeclarations$lambda$18(KmFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)String.valueOf(JvmExtensionsKt.getSignature(it)));
    }

    private static final Comparable removePrivateDeclarations$lambda$19(KmProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)String.valueOf(JvmExtensionsKt.getGetterSignature(it)));
    }
}

