/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.telemetry;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MavenFilteringSpanDataCollector
implements SpanExporter {
    private static final long SPAN_DURATION_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(15L);
    @NotNull
    private final Map<String, SpanData> collectedSpans = new ConcurrentHashMap<String, SpanData>();

    @NotNull
    public CompletableResultCode export(@NotNull Collection<SpanData> spans) {
        if (spans == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(0);
        }
        for (SpanData span : spans) {
            this.collectedSpans.put(span.getSpanId(), span);
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        if (completableResultCode == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(1);
        }
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode flush() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        if (completableResultCode == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(2);
        }
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode shutdown() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        if (completableResultCode == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(3);
        }
        return completableResultCode;
    }

    @NotNull
    public Collection<SpanData> getCollectedSpans() {
        HashMap<String, SpanData> processedSpans = new HashMap<String, SpanData>();
        for (Map.Entry<String, SpanData> entry : this.collectedSpans.entrySet()) {
            SpanData span = entry.getValue();
            if (!MavenFilteringSpanDataCollector.isValid(span)) continue;
            processedSpans.put(entry.getKey(), span);
            String parentSpanId = span.getParentSpanId();
            MavenFilteringSpanDataCollector.addParent(processedSpans, this.collectedSpans, parentSpanId);
        }
        this.collectedSpans.clear();
        Collection<SpanData> collection = processedSpans.values();
        if (collection == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static void addParent(@NotNull Map<String, SpanData> target, @NotNull Map<String, SpanData> source, @NotNull String spanId) {
        SpanData span;
        if (target == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(5);
        }
        if (source == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(6);
        }
        if (spanId == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(7);
        }
        if (!target.containsKey(spanId) && (span = source.get(spanId)) != null) {
            target.put(spanId, span);
            String parentSpanId = span.getParentSpanId();
            if (parentSpanId != null) {
                MavenFilteringSpanDataCollector.addParent(target, source, parentSpanId);
            }
        }
    }

    private static boolean isValid(@NotNull SpanData span) {
        if (span == null) {
            MavenFilteringSpanDataCollector.$$$reportNull$$$0(8);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spans";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/telemetry/MavenFilteringSpanDataCollector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/telemetry/MavenFilteringSpanDataCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "export";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "flush";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdown";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectedSpans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addParent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

