/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.capitalization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotateCapitalizationIntention
implements IntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner element;
        if (project == null) {
            AnnotateCapitalizationIntention.$$$reportNull$$$0(0);
        }
        return (element = AnnotateCapitalizationIntention.getElement(editor, file)) != null && (ApplicationManager.getApplication().isUnitTestMode() || !BaseIntentionAction.canModify((PsiElement)element)) && AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (String[])new String[]{Nls.class.getName()}) == null;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            AnnotateCapitalizationIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaI18nBundle.message("intention.family.annotate.capitalization.type", new Object[0]);
        if (string == null) {
            AnnotateCapitalizationIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiModifierListOwner modifierListOwner;
        if (project == null) {
            AnnotateCapitalizationIntention.$$$reportNull$$$0(3);
        }
        if ((modifierListOwner = AnnotateCapitalizationIntention.getElement(editor, file)) == null) {
            throw new IncorrectOperationException();
        }
        BaseListPopupStep<Nls.Capitalization> step = new BaseListPopupStep<Nls.Capitalization>(null, new Nls.Capitalization[]{Nls.Capitalization.Title, Nls.Capitalization.Sentence}){

            public PopupStep<?> onChosen(Nls.Capitalization selectedValue, boolean finalChoice) {
                WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                    String nls = Nls.class.getName();
                    PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@" + nls + "(capitalization = " + nls + ".Capitalization." + selectedValue.toString() + ")", (PsiElement)modifierListOwner);
                    new AddAnnotationFix(Nls.class.getName(), modifierListOwner, annotation.getParameterList().getAttributes(), new String[0]).applyFix();
                });
                return FINAL_CHOICE;
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiModifierListOwner getElement(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
        if (parameter == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method == null) {
            return null;
        }
        PsiType type = parameter.getType();
        return type.equalsToText("java.lang.String") ? parameter : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/capitalization/AnnotateCapitalizationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/capitalization/AnnotateCapitalizationIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

