/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FileCollectionFactory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.StampsStorage;

public final class BuildOperations {
    private BuildOperations() {
    }

    public static void ensureFSStateInitialized(@NotNull CompileContext context, @NotNull BuildTarget<?> target, boolean readOnly) throws IOException {
        if (context == null) {
            BuildOperations.$$$reportNull$$$0(0);
        }
        if (target == null) {
            BuildOperations.$$$reportNull$$$0(1);
        }
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        BuildTargetConfiguration configuration = projectDescriptor.getTargetsState().getTargetConfiguration(target);
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
            StampsStorage<?> stampStorage = projectDescriptor.dataManager.getFileStampStorage(target);
            FSOperations.markDirtyFiles(context, target, CompilationRound.CURRENT, stampStorage, true, null, null);
            projectDescriptor.fsState.markInitialScanPerformed(target);
            if (!readOnly) {
                configuration.save(context);
            }
        } else {
            boolean isTargetDirty = false;
            if (context.getScope().isBuildForced(target) || (isTargetDirty = configuration.isTargetDirty(context.getProjectDescriptor())) || !projectDescriptor.getBuildRootIndex().getTargetRoots(target, context).isEmpty() && configuration.outputRootWasDeleted(context)) {
                if (isTargetDirty) {
                    configuration.logDiagnostics(context);
                }
                BuildOperations.initTargetFSState(context, target, true);
                if (!readOnly) {
                    if (!context.getScope().isBuildForced(target)) {
                        IncProjectBuilder.clearOutputFiles(context, target);
                    }
                    projectDescriptor.dataManager.cleanTargetStorages(target);
                    configuration.save(context);
                }
            } else if (!projectDescriptor.fsState.isInitialScanPerformed(target)) {
                BuildOperations.initTargetFSState(context, target, false);
            }
        }
    }

    private static void initTargetFSState(CompileContext context, BuildTarget<?> target, boolean forceMarkDirty) throws IOException {
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        StampsStorage<?> stampStorage = projectDescriptor.dataManager.getFileStampStorage(target);
        Set currentFiles = FileCollectionFactory.createCanonicalFileSet();
        FSOperations.markDirtyFiles(context, target, CompilationRound.CURRENT, stampStorage, forceMarkDirty, currentFiles, null);
        BuildFSState fsState = projectDescriptor.fsState;
        SourceToOutputMapping sourceToOutputMap = projectDescriptor.dataManager.getSourceToOutputMap(target);
        Iterator<String> it = sourceToOutputMap.getSourcesIterator();
        while (it.hasNext()) {
            String path = it.next();
            File file = new File(path);
            if (currentFiles.contains(file)) continue;
            fsState.registerDeleted(context, target, file, stampStorage);
        }
        projectDescriptor.fsState.markInitialScanPerformed(target);
    }

    public static void markTargetsUpToDate(CompileContext context, BuildTargetChunk chunk) throws IOException {
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        BuildFSState fsState = projectDescriptor.fsState;
        for (BuildTarget<?> target : chunk.getTargets()) {
            projectDescriptor.getTargetsState().getTargetConfiguration(target).storeNonexistentOutputRoots(context);
        }
        if (Utils.errorsDetected(context) || context.getCancelStatus().isCanceled()) {
            return;
        }
        boolean marked = BuildOperations.dropRemovedPaths(context, chunk);
        for (BuildTarget<?> target : chunk.getTargets()) {
            if (target instanceof ModuleBuildTarget) {
                context.clearNonIncrementalMark((ModuleBuildTarget)target);
            }
            StampsStorage<?> stampStorage = projectDescriptor.dataManager.getFileStampStorage(target);
            long targetBuildStartStamp = context.getCompilationStartStamp(target);
            for (BuildRootDescriptor buildRootDescriptor : projectDescriptor.getBuildRootIndex().getTargetRoots(target, context)) {
                marked |= fsState.markAllUpToDate(context, buildRootDescriptor, stampStorage, targetBuildStartStamp);
            }
        }
        if (marked) {
            context.processMessage(DoneSomethingNotification.INSTANCE);
        }
    }

    private static boolean dropRemovedPaths(CompileContext context, BuildTargetChunk chunk) throws IOException {
        Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context);
        boolean dropped = false;
        if (map != null) {
            for (BuildTarget<?> target : chunk.getTargets()) {
                Collection paths = (Collection)map.remove(target);
                if (paths == null) continue;
                SourceToOutputMapping storage = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
                for (String path : paths) {
                    storage.remove(path);
                }
                dropped = true;
            }
        }
        return dropped;
    }

    public static <R extends BuildRootDescriptor, T extends BuildTarget<R>> Map<T, Set<File>> cleanOutputsCorrespondingToChangedFiles(CompileContext context, DirtyFilesHolder<R, T> dirtyFilesHolder) throws ProjectBuildException {
        final BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        try {
            final HashMap cleanedSources = new HashMap();
            final Set dirsToDelete = FileCollectionFactory.createCanonicalFileSet();
            final ArrayList<String> deletedPaths = new ArrayList<String>();
            dirtyFilesHolder.processDirtyFiles(new FileProcessor<R, T>(){
                private final Map<T, SourceToOutputMapping> mappingsCache = new HashMap();
                private final Object2IntMap<T> idsCache = new Object2IntOpenHashMap();

                @Override
                public boolean apply(@NotNull T target, @NotNull File file, @NotNull R sourceRoot) throws IOException {
                    int targetId;
                    SourceToOutputMapping srcToOut;
                    if (target == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (sourceRoot == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((srcToOut = this.mappingsCache.get(target)) == null) {
                        srcToOut = dataManager.getSourceToOutputMap((BuildTarget<?>)target);
                        this.mappingsCache.put(target, srcToOut);
                    }
                    if (!this.idsCache.containsKey(target)) {
                        targetId = dataManager.getTargetsState().getBuildTargetId((BuildTarget<?>)target);
                        this.idsCache.put(target, targetId);
                    } else {
                        targetId = this.idsCache.getInt(target);
                    }
                    Collection<String> outputs = srcToOut.getOutputs(file.getPath());
                    if (outputs == null) {
                        return true;
                    }
                    boolean shouldPruneOutputDirs = target instanceof ModuleBasedTarget;
                    ArrayList<String> deletedForThisSource = new ArrayList<String>(outputs.size());
                    for (String output : outputs) {
                        BuildOperations.deleteRecursively(output, deletedForThisSource, shouldPruneOutputDirs ? dirsToDelete : null);
                    }
                    deletedPaths.addAll(deletedForThisSource);
                    dataManager.getOutputToTargetMapping().removeMappings(deletedForThisSource, targetId, srcToOut);
                    Set cleaned = (Set)cleanedSources.get(target);
                    if (cleaned == null) {
                        cleaned = FileCollectionFactory.createCanonicalFileSet();
                        cleanedSources.put(target, cleaned);
                    }
                    cleaned.add(file);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "target";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceRoot";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/jps/incremental/BuildOperations$1";
                    objectArray[2] = "apply";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (!deletedPaths.isEmpty()) {
                ProjectBuilderLogger logger;
                if (JavaBuilderUtil.isCompileJavaIncrementally(context) && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled()) {
                    logger.logDeletedFiles(deletedPaths);
                }
                context.processMessage(new FileDeletedEvent(deletedPaths));
            }
            FSOperations.pruneEmptyDirs(context, dirsToDelete);
            return cleanedSources;
        }
        catch (Exception e) {
            throw new ProjectBuildException(e);
        }
    }

    public static boolean deleteRecursively(@NotNull String path, @NotNull Collection<? super String> deletedPaths, @Nullable Set<? super File> parentDirs) {
        File parent;
        File file;
        boolean deleted;
        if (path == null) {
            BuildOperations.$$$reportNull$$$0(2);
        }
        if (deletedPaths == null) {
            BuildOperations.$$$reportNull$$$0(3);
        }
        if ((deleted = BuildOperations.deleteRecursively(file = new File(path), deletedPaths)) && parentDirs != null && (parent = file.getParentFile()) != null) {
            parentDirs.add(parent);
        }
        return deleted;
    }

    private static boolean deleteRecursively(File file, final Collection<? super String> deletedPaths) {
        try {
            Files.walkFileTree(file.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        try {
                            Files.delete(f);
                        }
                        catch (AccessDeniedException e) {
                            if (f.toFile().delete()) break block2;
                            throw e;
                        }
                    }
                    deletedPaths.add(FileUtilRt.toSystemIndependentName((String)f.toString()));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    block2: {
                        try {
                            Files.delete(dir);
                        }
                        catch (AccessDeniedException e) {
                            if (dir.toFile().delete()) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedPaths";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/BuildOperations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureFSStateInitialized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRecursively";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

