/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlinx.metadata.Attributes;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmConstructor;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.KmPropertyAccessorAttributes;
import kotlinx.metadata.KmType;
import kotlinx.metadata.KmTypeAlias;
import kotlinx.metadata.KmTypeParameter;
import kotlinx.metadata.KmTypeProjection;
import kotlinx.metadata.KmValueParameter;
import kotlinx.metadata.Modality;
import kotlinx.metadata.Visibility;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.GraphDataOutput;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.impl.RW;
import org.jetbrains.jps.dependency.java.JvmMetadata;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.javac.Iterators;

public final class KotlinMeta
implements JvmMetadata<KotlinMeta, Diff> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final int myKind;
    private final int @NotNull [] myVersion;
    private final String @NotNull [] myData1;
    private final String @NotNull [] myData2;
    @NotNull
    private final String myExtraString;
    @NotNull
    private final String myPackageName;
    private final int myExtraInt;
    private KotlinClassMetadata[] myCachedMeta;
    private static final Map<Visibility, Integer> VISIBILITY_LEVEL = Map.of(Visibility.LOCAL, 1, Visibility.PRIVATE_TO_THIS, 2, Visibility.PRIVATE, 3, Visibility.PROTECTED, 4, Visibility.INTERNAL, 5, Visibility.PUBLIC, 6);

    public KotlinMeta(int kind, int @Nullable [] version, String @Nullable [] data1, String @Nullable [] data2, @Nullable String extraString, @Nullable String packageName, int extraInt) {
        this.myKind = kind;
        this.myVersion = version != null ? version : EMPTY_INT_ARRAY;
        this.myData1 = data1 != null ? data1 : EMPTY_STRING_ARRAY;
        this.myData2 = data2 != null ? data2 : EMPTY_STRING_ARRAY;
        this.myExtraString = extraString != null ? extraString : "";
        this.myPackageName = packageName != null ? packageName : "";
        this.myExtraInt = extraInt;
    }

    public KotlinMeta(GraphDataInput in) throws IOException {
        this.myKind = in.readInt();
        int versionsCount = in.readInt();
        this.myVersion = versionsCount > 0 ? new int[versionsCount] : EMPTY_INT_ARRAY;
        for (int idx = 0; idx < versionsCount; ++idx) {
            this.myVersion[idx] = in.readInt();
        }
        this.myData1 = RW.readCollection(in, in::readUTF).toArray(EMPTY_STRING_ARRAY);
        this.myData2 = RW.readCollection(in, in::readUTF).toArray(EMPTY_STRING_ARRAY);
        this.myExtraString = in.readUTF();
        this.myPackageName = in.readUTF();
        this.myExtraInt = in.readInt();
    }

    @Override
    public void write(GraphDataOutput out) throws IOException {
        out.writeInt(this.myKind);
        out.writeInt(this.myVersion.length);
        for (int elem : this.myVersion) {
            out.writeInt(elem);
        }
        RW.writeCollection(out, Arrays.asList(this.myData1), out::writeUTF);
        RW.writeCollection(out, Arrays.asList(this.myData2), out::writeUTF);
        out.writeUTF(this.myExtraString);
        out.writeUTF(this.myPackageName);
        out.writeInt(this.myExtraInt);
    }

    public int getKind() {
        return this.myKind;
    }

    public int @NotNull [] getVersion() {
        if (this.myVersion == null) {
            KotlinMeta.$$$reportNull$$$0(0);
        }
        return this.myVersion;
    }

    public String @NotNull [] getData1() {
        if (this.myData1 == null) {
            KotlinMeta.$$$reportNull$$$0(1);
        }
        return this.myData1;
    }

    public String @NotNull [] getData2() {
        if (this.myData2 == null) {
            KotlinMeta.$$$reportNull$$$0(2);
        }
        return this.myData2;
    }

    @NotNull
    public String getExtraString() {
        String string = this.myExtraString;
        if (string == null) {
            KotlinMeta.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            KotlinMeta.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Integer getExtraInt() {
        Integer n = this.myExtraInt;
        if (n == null) {
            KotlinMeta.$$$reportNull$$$0(5);
        }
        return n;
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        return other instanceof KotlinMeta;
    }

    @Override
    public int diffHashCode() {
        return KotlinMeta.class.hashCode();
    }

    @Override
    public Diff difference(KotlinMeta past) {
        return new Diff(past);
    }

    public KotlinClassMetadata getClassMetadata() {
        if (this.myCachedMeta == null) {
            try {
                this.myCachedMeta = new KotlinClassMetadata[]{KotlinClassMetadata.readLenient((Metadata)new KotlinClassHeader(Integer.valueOf(this.getKind()), this.getVersion(), this.getData1(), this.getData2(), this.getExtraString(), this.getPackageName(), this.getExtraInt()))};
            }
            catch (Throwable e) {
                this.myCachedMeta = new KotlinClassMetadata[]{null};
            }
        }
        return this.myCachedMeta[0];
    }

    public Iterable<KmProperty> getKmProperties() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container != null ? container.getProperties() : Collections.emptyList();
    }

    public Iterable<KmFunction> getKmFunctions() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container != null ? container.getFunctions() : Collections.emptyList();
    }

    public Iterable<KmTypeAlias> getKmTypeAliases() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container != null ? container.getTypeAliases() : Collections.emptyList();
    }

    public Iterable<KmConstructor> getKmConstructors() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container instanceof KmClass ? ((KmClass)container).getConstructors() : Collections.emptyList();
    }

    public Iterable<KmTypeParameter> getTypeParameters() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container instanceof KmClass ? ((KmClass)container).getTypeParameters() : Collections.emptyList();
    }

    public Iterable<String> getSealedSubclasses() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container instanceof KmClass ? ((KmClass)container).getSealedSubclasses() : Collections.emptyList();
    }

    public Visibility getContainerVisibility() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container instanceof KmClass ? Attributes.getVisibility((KmClass)((KmClass)container)) : Visibility.PUBLIC;
    }

    @Nullable
    public Modality getContainerModality() {
        KmDeclarationContainer container = this.getDeclarationContainer();
        return container instanceof KmClass ? Attributes.getModality((KmClass)((KmClass)container)) : null;
    }

    @Nullable
    public KmDeclarationContainer getDeclarationContainer() {
        KotlinClassMetadata clsMeta = this.getClassMetadata();
        if (clsMeta instanceof KotlinClassMetadata.Class) {
            return ((KotlinClassMetadata.Class)clsMeta).getKmClass();
        }
        if (clsMeta instanceof KotlinClassMetadata.FileFacade) {
            return ((KotlinClassMetadata.FileFacade)clsMeta).getKmPackage();
        }
        if (clsMeta instanceof KotlinClassMetadata.MultiFileClassPart) {
            return ((KotlinClassMetadata.MultiFileClassPart)clsMeta).getKmPackage();
        }
        return null;
    }

    private static boolean kmTypeProjectionEquals(KmTypeProjection p1, KmTypeProjection p2) {
        if (p1 == null) {
            return p2 == null;
        }
        return p2 != null && Objects.equals(p1.getVariance(), p2.getVariance()) && KotlinMeta.kmTypesEqual(p1.getType(), p2.getType());
    }

    private static boolean kmTypesEqual(KmType t1, KmType t2) {
        if (t1 == null) {
            return t2 == null;
        }
        return t2 != null && Attributes.isNullable((KmType)t1) == Attributes.isNullable((KmType)t2) && Objects.equals(t1.getClassifier(), t2.getClassifier()) && KotlinMeta.kmTypesEqual(t1.getOuterType(), t2.getOuterType()) && Iterators.equals((Iterable)t1.getArguments(), (Iterable)t2.getArguments(), KotlinMeta::kmTypeProjectionEquals);
    }

    private static int getVisibilityLevel(Visibility v) {
        Integer level = VISIBILITY_LEVEL.get(v);
        return level != null ? level : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/dependency/java/KotlinMeta";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getData1";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData2";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraInt";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public final class Diff
    implements Difference {
        private final KotlinMeta myPast;
        private final Supplier<Difference.Specifier<KmFunction, KmFunctionsDiff>> myFunctionsDiff;
        private final Supplier<Difference.Specifier<KmConstructor, KmConstructorsDiff>> myConstructorsDiff;
        private final Supplier<Difference.Specifier<KmProperty, KmPropertiesDiff>> myPropertiesDiff;
        private final Supplier<Difference.Specifier<KmTypeAlias, KmTypeAliasDiff>> myAliasesDiff;
        private final Supplier<Difference.Specifier<String, ?>> mySealedSubclassesDiff;

        Diff(KotlinMeta past) {
            this.myPast = past;
            this.myFunctionsDiff = Utils.lazyValue(() -> Difference.deepDiff(this.myPast.getKmFunctions(), KotlinMeta.this.getKmFunctions(), (f1, f2) -> Objects.equals(JvmExtensionsKt.getSignature((KmFunction)f1), JvmExtensionsKt.getSignature((KmFunction)f2)), f -> Objects.hashCode(JvmExtensionsKt.getSignature((KmFunction)f)), KmFunctionsDiff::new));
            this.myConstructorsDiff = Utils.lazyValue(() -> Difference.deepDiff(this.myPast.getKmConstructors(), KotlinMeta.this.getKmConstructors(), (c1, c2) -> Objects.equals(JvmExtensionsKt.getSignature((KmConstructor)c1), JvmExtensionsKt.getSignature((KmConstructor)c2)), c -> Objects.hashCode(JvmExtensionsKt.getSignature((KmConstructor)c)), KmConstructorsDiff::new));
            this.myPropertiesDiff = Utils.lazyValue(() -> Difference.deepDiff(this.myPast.getKmProperties(), KotlinMeta.this.getKmProperties(), (p1, p2) -> Objects.equals(p1.getName(), p2.getName()), p -> Objects.hashCode(p.getName()), KmPropertiesDiff::new));
            this.myAliasesDiff = Utils.lazyValue(() -> Difference.deepDiff(this.myPast.getKmTypeAliases(), KotlinMeta.this.getKmTypeAliases(), (a1, a2) -> Objects.equals(a1.getName(), a2.getName()), a -> Objects.hashCode(a.getName()), KmTypeAliasDiff::new));
            this.mySealedSubclassesDiff = Utils.lazyValue(() -> Difference.diff(this.myPast.getSealedSubclasses(), KotlinMeta.this.getSealedSubclasses()));
        }

        @Override
        public boolean unchanged() {
            return !this.kindChanged() && !this.versionChanged() && !this.packageChanged() && !this.extraChanged() && !this.typeParametersVarianceChanged() && !this.containerVisibilityChanged() && !this.containerModalityChanged() && this.sealedSubclasses().unchanged() && this.functions().unchanged() && this.properties().unchanged() && this.constructors().unchanged() && this.typeAliases().unchanged();
        }

        public boolean kindChanged() {
            return this.myPast.myKind != KotlinMeta.this.myKind;
        }

        public boolean versionChanged() {
            return !Arrays.equals(this.myPast.myVersion, KotlinMeta.this.myVersion);
        }

        public boolean packageChanged() {
            return !Objects.equals(this.myPast.myPackageName, KotlinMeta.this.myPackageName);
        }

        public boolean containerModalityChanged() {
            return this.myPast.getContainerModality() != KotlinMeta.this.getContainerModality();
        }

        public boolean containerVisibilityChanged() {
            return this.myPast.getContainerVisibility() != KotlinMeta.this.getContainerVisibility();
        }

        public boolean containerAccessRestricted() {
            return KotlinMeta.getVisibilityLevel(KotlinMeta.this.getContainerVisibility()) < KotlinMeta.getVisibilityLevel(this.myPast.getContainerVisibility());
        }

        public boolean extraChanged() {
            return this.myPast.myExtraInt != KotlinMeta.this.myExtraInt || !Objects.equals(this.myPast.myExtraString, KotlinMeta.this.myExtraString);
        }

        public boolean typeParametersVarianceChanged() {
            return !Iterators.equals(this.myPast.getTypeParameters(), KotlinMeta.this.getTypeParameters(), (p1, p2) -> p1.getVariance() == p2.getVariance());
        }

        public Difference.Specifier<String, ?> sealedSubclasses() {
            return this.mySealedSubclassesDiff.get();
        }

        public Difference.Specifier<KmFunction, KmFunctionsDiff> functions() {
            return this.myFunctionsDiff.get();
        }

        public Difference.Specifier<KmConstructor, KmConstructorsDiff> constructors() {
            return this.myConstructorsDiff.get();
        }

        public Difference.Specifier<KmProperty, KmPropertiesDiff> properties() {
            return this.myPropertiesDiff.get();
        }

        public Difference.Specifier<KmTypeAlias, KmTypeAliasDiff> typeAliases() {
            return this.myAliasesDiff.get();
        }
    }

    public static final class KmPropertiesDiff
    implements Difference {
        private final KmProperty past;
        private final KmProperty now;

        public KmPropertiesDiff(KmProperty past, KmProperty now) {
            this.past = past;
            this.now = now;
        }

        @Override
        public boolean unchanged() {
            return !this.typeChanged() && !this.visibilityChanged() && !this.customAccessorAdded();
        }

        public boolean typeChanged() {
            return !KotlinMeta.kmTypesEqual(this.past.getReturnType(), this.now.getReturnType());
        }

        public boolean becameNullable() {
            return !Attributes.isNullable((KmType)this.past.getReturnType()) && Attributes.isNullable((KmType)this.now.getReturnType());
        }

        public boolean becameNotNull() {
            return Attributes.isNullable((KmType)this.past.getReturnType()) && !Attributes.isNullable((KmType)this.now.getReturnType());
        }

        public boolean visibilityChanged() {
            return Attributes.getVisibility((KmProperty)this.past) != Attributes.getVisibility((KmProperty)this.now) || KmPropertiesDiff.getGetterVisibility(this.past) != KmPropertiesDiff.getGetterVisibility(this.now) || KmPropertiesDiff.getSetterVisibility(this.past) != KmPropertiesDiff.getSetterVisibility(this.now);
        }

        public boolean accessRestricted() {
            return KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmProperty)this.now)) < KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmProperty)this.past));
        }

        public boolean getterAccessRestricted() {
            return KotlinMeta.getVisibilityLevel(KmPropertiesDiff.getGetterVisibility(this.now)) < KotlinMeta.getVisibilityLevel(KmPropertiesDiff.getGetterVisibility(this.past));
        }

        public boolean setterAccessRestricted() {
            return KotlinMeta.getVisibilityLevel(KmPropertiesDiff.getSetterVisibility(this.now)) < KotlinMeta.getVisibilityLevel(KmPropertiesDiff.getSetterVisibility(this.past));
        }

        public boolean customAccessorAdded() {
            return !KmPropertiesDiff.hasCustomGetter(this.past) && KmPropertiesDiff.hasCustomGetter(this.now) || !KmPropertiesDiff.hasCustomSetter(this.past) && KmPropertiesDiff.hasCustomSetter(this.now);
        }

        private static Visibility getGetterVisibility(KmProperty prop) {
            return Attributes.getVisibility((KmPropertyAccessorAttributes)prop.getGetter());
        }

        private static Visibility getSetterVisibility(KmProperty prop) {
            KmPropertyAccessorAttributes setter = prop.getSetter();
            return setter != null ? Attributes.getVisibility((KmPropertyAccessorAttributes)setter) : Visibility.PUBLIC;
        }

        private static boolean hasCustomGetter(KmProperty prop) {
            return Attributes.isNotDefault((KmPropertyAccessorAttributes)prop.getGetter());
        }

        private static boolean hasCustomSetter(KmProperty prop) {
            KmPropertyAccessorAttributes setter = prop.getSetter();
            return setter != null && Attributes.isNotDefault((KmPropertyAccessorAttributes)setter);
        }
    }

    public static final class KmConstructorsDiff
    implements Difference {
        private final KmConstructor past;
        private final KmConstructor now;

        public KmConstructorsDiff(KmConstructor past, KmConstructor now) {
            this.past = past;
            this.now = now;
        }

        @Override
        public boolean unchanged() {
            return !this.argsBecameNotNull() && !this.visibilityChanged() && !this.hasDefaultDeclarationChanges();
        }

        public boolean visibilityChanged() {
            return Attributes.getVisibility((KmConstructor)this.past) != Attributes.getVisibility((KmConstructor)this.now);
        }

        public boolean accessRestricted() {
            return KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmConstructor)this.now)) < KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmConstructor)this.past));
        }

        public boolean argsBecameNotNull() {
            Iterator<KmType> nowIt = KmConstructorsDiff.getParameterTypes(this.now).iterator();
            for (KmType pastParam : KmConstructorsDiff.getParameterTypes(this.past)) {
                if (!nowIt.hasNext()) break;
                KmType nowParam = nowIt.next();
                if (!Attributes.isNullable((KmType)pastParam) || Attributes.isNullable((KmType)nowParam)) continue;
                return true;
            }
            return false;
        }

        public boolean hasDefaultDeclarationChanges() {
            int before = Iterators.count((Iterable)Iterators.filter((Iterable)this.past.getValueParameters(), Attributes::getDeclaresDefaultValue));
            int after = Iterators.count((Iterable)Iterators.filter((Iterable)this.now.getValueParameters(), Attributes::getDeclaresDefaultValue));
            if (before == 0) {
                return after > 0;
            }
            return after < before;
        }

        private static Iterable<KmType> getParameterTypes(KmConstructor f) {
            return Iterators.map((Iterable)f.getValueParameters(), KmValueParameter::getType);
        }
    }

    public static final class KmTypeAliasDiff
    implements Difference {
        private final KmTypeAlias past;
        private final KmTypeAlias now;

        public KmTypeAliasDiff(KmTypeAlias past, KmTypeAlias now) {
            this.past = past;
            this.now = now;
        }

        @Override
        public boolean unchanged() {
            return !this.visibilityChanged() && !this.underlyingTypeChanged();
        }

        public boolean visibilityChanged() {
            return Attributes.getVisibility((KmTypeAlias)this.past) != Attributes.getVisibility((KmTypeAlias)this.now);
        }

        public boolean accessRestricted() {
            return KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmTypeAlias)this.now)) < KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmTypeAlias)this.past));
        }

        public boolean underlyingTypeChanged() {
            return !KotlinMeta.kmTypesEqual(this.past.getUnderlyingType(), this.now.getUnderlyingType());
        }
    }

    public static final class KmFunctionsDiff
    implements Difference {
        private final KmFunction past;
        private final KmFunction now;

        public KmFunctionsDiff(KmFunction past, KmFunction now) {
            this.past = past;
            this.now = now;
        }

        @Override
        public boolean unchanged() {
            return !this.becameNullable() && !this.argsBecameNotNull() && !this.visibilityChanged() && !this.receiverParameterChanged() && !this.hasDefaultDeclarationChanges() && !this.parameterArgumentsChanged();
        }

        public boolean becameNullable() {
            return !Attributes.isNullable((KmType)this.past.getReturnType()) && Attributes.isNullable((KmType)this.now.getReturnType());
        }

        public boolean visibilityChanged() {
            return Attributes.getVisibility((KmFunction)this.past) != Attributes.getVisibility((KmFunction)this.now);
        }

        public boolean accessRestricted() {
            return KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmFunction)this.now)) < KotlinMeta.getVisibilityLevel(Attributes.getVisibility((KmFunction)this.past));
        }

        public boolean argsBecameNotNull() {
            Iterator<KmType> nowIt = KmFunctionsDiff.getParameterTypes(this.now).iterator();
            for (KmType pastParam : KmFunctionsDiff.getParameterTypes(this.past)) {
                if (!nowIt.hasNext()) break;
                KmType nowParam = nowIt.next();
                if (!Attributes.isNullable((KmType)pastParam) || Attributes.isNullable((KmType)nowParam)) continue;
                return true;
            }
            return false;
        }

        public boolean receiverParameterChanged() {
            return !KotlinMeta.kmTypesEqual(this.past.getReceiverParameterType(), this.now.getReceiverParameterType());
        }

        public boolean hasDefaultDeclarationChanges() {
            int before = Iterators.count((Iterable)Iterators.filter((Iterable)this.past.getValueParameters(), Attributes::getDeclaresDefaultValue));
            int after = Iterators.count((Iterable)Iterators.filter((Iterable)this.now.getValueParameters(), Attributes::getDeclaresDefaultValue));
            if (before == 0) {
                return after > 0;
            }
            return after < before;
        }

        public boolean parameterArgumentsChanged() {
            return !Iterators.equals(KmFunctionsDiff.getParameterTypes(this.past), KmFunctionsDiff.getParameterTypes(this.now), (pastType, nowType) -> Iterators.equals((Iterable)pastType.getArguments(), (Iterable)nowType.getArguments(), (x$0, x$1) -> KotlinMeta.kmTypeProjectionEquals(x$0, x$1)));
        }

        private static Iterable<KmType> getParameterTypes(KmFunction f) {
            return Iterators.filter((Iterable)Iterators.flat(List.of(f.getContextReceiverTypes(), Iterators.asIterable((Object)f.getReceiverParameterType()), Iterators.map((Iterable)f.getValueParameters(), KmValueParameter::getType))), Objects::nonNull);
        }
    }
}

