/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class JpsCachesLoaderUtil {
    private static final Logger LOG = Logger.getInstance(JpsCachesLoaderUtil.class);
    public static final String LOADER_TMP_FOLDER_NAME = "jps-cache-loader";
    public static final String INTELLIJ_REPO_NAME = "intellij.git";
    public static final ExecutorService EXECUTOR_SERVICE = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"JpsCacheLoader Pool", (Executor)ProcessIOExecutorService.INSTANCE, (int)JpsCachesLoaderUtil.getThreadPoolSize());

    private JpsCachesLoaderUtil() {
    }

    private static int getThreadPoolSize() {
        int threadsCount = Runtime.getRuntime().availableProcessors() - 1;
        LOG.info("Executor service will be configured with " + threadsCount + " threads");
        return threadsCount;
    }

    public static void delete(@NotNull File dir, boolean asynchronously) {
        if (dir == null) {
            JpsCachesLoaderUtil.$$$reportNull$$$0(0);
        }
        if (!asynchronously) {
            FileUtil.delete((File)dir);
            return;
        }
        LOG.info("Deleting asynchronously... " + dir.getPath());
        try {
            File temp = JpsCachesLoaderUtil.getEmptyTempDir();
            Path moved = Files.move(dir.toPath(), temp.toPath(), new CopyOption[0]);
            EXECUTOR_SERVICE.execute(() -> JpsCachesLoaderUtil.delete(moved));
        }
        catch (IOException e) {
            LOG.warn("Unable to move directory: " + e.getMessage());
            FileUtil.delete((File)dir);
        }
    }

    public static void runCleanUpAsynchronously() {
        LOG.info("Running clean-up asynchronously...");
        Path pluginTemp = Path.of(PathManager.getPluginTempPath(), new String[0]);
        try (Stream<Path> stream = Files.list(pluginTemp);){
            List files = stream.filter(file -> file.getFileName().toString().startsWith(JpsCachesLoaderUtil.getPrefix())).collect(Collectors.toList());
            if (!files.isEmpty()) {
                EXECUTOR_SERVICE.execute(() -> files.forEach(JpsCachesLoaderUtil::delete));
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to run clean-up task: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delete(@NotNull Path dir) {
        File empty;
        if (dir == null) {
            JpsCachesLoaderUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isUnix && (empty = JpsCachesLoaderUtil.getEmptyTempDir()).mkdir()) {
            try {
                ArrayList<String> command = new ArrayList<String>();
                command.add("rsync");
                command.add("-a");
                command.add("--delete");
                command.add(empty.getPath() + "/");
                command.add(dir + "/");
                ProcessBuilder builder = new ProcessBuilder(command);
                Process process = builder.start();
                process.waitFor();
                int exitCode = process.exitValue();
                LOG.info("rsync exited with " + exitCode);
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("rsync failed: " + e.getMessage());
            }
            finally {
                FileUtil.delete((File)empty);
            }
        }
        FileUtil.delete((File)dir.toFile());
    }

    @NotNull
    private static File getEmptyTempDir() {
        File pluginTemp = new File(PathManager.getPluginTempPath());
        String prefix = JpsCachesLoaderUtil.getPrefix() + UUID.randomUUID();
        File file = FileUtil.findSequentNonexistentFile((File)pluginTemp, (String)prefix, (String)"");
        if (file == null) {
            JpsCachesLoaderUtil.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    private static String getPrefix() {
        return "jps-cache-loader-";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/cache/JpsCachesLoaderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/cache/JpsCachesLoaderUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyTempDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

