/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmTypes {
    private static final Map<Class<?>, Type> TYPES_MAP = new ConcurrentHashMap();
    public static final Type OBJECT_TYPE = AsmTypes.getType(Object.class);
    public static final Type JAVA_STRING_TYPE = AsmTypes.getType(String.class);
    public static final Type JAVA_THROWABLE_TYPE = AsmTypes.getType(Throwable.class);
    public static final Type JAVA_CLASS_TYPE = AsmTypes.getType(Class.class);
    public static final Type JAVA_CLASS_ARRAY_TYPE = Type.getObjectType((String)("[" + JAVA_CLASS_TYPE.getDescriptor()));
    public static final Type ENUM_TYPE = AsmTypes.getType(Enum.class);
    public static final Type NUMBER_TYPE = AsmTypes.getType(Number.class);
    public static final Type BOOLEAN_WRAPPER_TYPE = AsmTypes.getType(Boolean.class);
    public static final Type CHARACTER_WRAPPER_TYPE = AsmTypes.getType(Character.class);
    public static final Type VOID_WRAPPER_TYPE = AsmTypes.getType(Void.class);
    public static final Type UNIT_TYPE = Type.getObjectType((String)"kotlin/Unit");
    public static final Type LAMBDA = Type.getObjectType((String)"kotlin/jvm/internal/Lambda");
    public static final Type FUNCTION_ADAPTER = Type.getObjectType((String)"kotlin/jvm/internal/FunctionAdapter");
    public static final Type FUNCTION_REFERENCE = Type.getObjectType((String)"kotlin/jvm/internal/FunctionReference");
    public static final Type FUNCTION_REFERENCE_IMPL = Type.getObjectType((String)"kotlin/jvm/internal/FunctionReferenceImpl");
    public static final Type PROPERTY_REFERENCE0 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference0");
    public static final Type PROPERTY_REFERENCE1 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference1");
    public static final Type PROPERTY_REFERENCE2 = Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference2");
    public static final Type MUTABLE_PROPERTY_REFERENCE0 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference0");
    public static final Type MUTABLE_PROPERTY_REFERENCE1 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference1");
    public static final Type MUTABLE_PROPERTY_REFERENCE2 = Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference2");
    public static final Type FUNCTION = Type.getObjectType((String)"kotlin/Function");
    public static final Type FUNCTION0 = Type.getObjectType((String)"kotlin/jvm/functions/Function0");
    public static final Type FUNCTION1 = Type.getObjectType((String)"kotlin/jvm/functions/Function1");
    public static final Type[] PROPERTY_REFERENCE_IMPL = new Type[]{Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference0Impl"), Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference1Impl"), Type.getObjectType((String)"kotlin/jvm/internal/PropertyReference2Impl")};
    public static final Type[] MUTABLE_PROPERTY_REFERENCE_IMPL = new Type[]{Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference0Impl"), Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference1Impl"), Type.getObjectType((String)"kotlin/jvm/internal/MutablePropertyReference2Impl")};
    public static final Type K_CLASS_TYPE = AsmTypes.reflect("KClass");
    public static final Type K_CLASS_ARRAY_TYPE = Type.getObjectType((String)("[" + K_CLASS_TYPE.getDescriptor()));
    public static final Type K_CLASSIFIER_TYPE = AsmTypes.reflect("KClassifier");
    public static final Type K_DECLARATION_CONTAINER_TYPE = AsmTypes.reflect("KDeclarationContainer");
    public static final Type K_FUNCTION = AsmTypes.reflect("KFunction");
    public static final Type K_PROPERTY_TYPE = AsmTypes.reflect("KProperty");
    public static final Type K_PROPERTY0_TYPE = AsmTypes.reflect("KProperty0");
    public static final Type K_PROPERTY1_TYPE = AsmTypes.reflect("KProperty1");
    public static final Type K_PROPERTY2_TYPE = AsmTypes.reflect("KProperty2");
    public static final Type K_MUTABLE_PROPERTY0_TYPE = AsmTypes.reflect("KMutableProperty0");
    public static final Type K_MUTABLE_PROPERTY1_TYPE = AsmTypes.reflect("KMutableProperty1");
    public static final Type K_MUTABLE_PROPERTY2_TYPE = AsmTypes.reflect("KMutableProperty2");
    public static final Type K_TYPE = AsmTypes.reflect("KType");
    public static final Type K_TYPE_PROJECTION = AsmTypes.reflect("KTypeProjection");
    public static final Type K_TYPE_PROJECTION_COMPANION = AsmTypes.reflect("KTypeProjection$Companion");
    public static final Type K_TYPE_PARAMETER = AsmTypes.reflect("KTypeParameter");
    public static final Type K_VARIANCE = AsmTypes.reflect("KVariance");
    public static final Type SUSPEND_FUNCTION_TYPE = Type.getObjectType((String)"kotlin/coroutines/jvm/internal/SuspendFunction");
    public static final String REFLECTION = "kotlin/jvm/internal/Reflection";
    public static final String REF_TYPE_PREFIX = "kotlin/jvm/internal/Ref$";
    public static final Type OBJECT_REF_TYPE = Type.getObjectType((String)"kotlin/jvm/internal/Ref$ObjectRef");
    public static final Type DEFAULT_CONSTRUCTOR_MARKER = Type.getObjectType((String)"kotlin/jvm/internal/DefaultConstructorMarker");
    public static final Type ENUM_ENTRIES = Type.getObjectType((String)"kotlin/enums/EnumEntries");
    public static final List<Type> OPTIMIZED_PROPERTY_REFERENCE_SUPERTYPES = CollectionsKt.flatten(Arrays.asList(Arrays.asList(PROPERTY_REFERENCE_IMPL), Arrays.asList(MUTABLE_PROPERTY_REFERENCE_IMPL)));

    @NotNull
    private static Type reflect(@NotNull String className) {
        if (className == null) {
            AsmTypes.$$$reportNull$$$0(0);
        }
        Type type2 = Type.getObjectType((String)("kotlin/reflect/" + className));
        if (type2 == null) {
            AsmTypes.$$$reportNull$$$0(1);
        }
        return type2;
    }

    public static boolean isSharedVarType(@NotNull Type type2) {
        if (type2 == null) {
            AsmTypes.$$$reportNull$$$0(2);
        }
        return type2.getSort() == 10 && type2.getInternalName().startsWith(REF_TYPE_PREFIX);
    }

    @NotNull
    public static Type sharedTypeForPrimitive(@NotNull PrimitiveType primitiveType) {
        if (primitiveType == null) {
            AsmTypes.$$$reportNull$$$0(3);
        }
        String typeName = primitiveType.getTypeName().getIdentifier();
        Type type2 = Type.getObjectType((String)(REF_TYPE_PREFIX + typeName + "Ref"));
        if (type2 == null) {
            AsmTypes.$$$reportNull$$$0(4);
        }
        return type2;
    }

    @NotNull
    public static Type valueTypeForPrimitive(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case BOOLEAN: {
                Type type2 = Type.BOOLEAN_TYPE;
                if (type2 == null) {
                    AsmTypes.$$$reportNull$$$0(5);
                }
                return type2;
            }
            case CHAR: {
                Type type3 = Type.CHAR_TYPE;
                if (type3 == null) {
                    AsmTypes.$$$reportNull$$$0(6);
                }
                return type3;
            }
            case BYTE: {
                Type type4 = Type.BYTE_TYPE;
                if (type4 == null) {
                    AsmTypes.$$$reportNull$$$0(7);
                }
                return type4;
            }
            case SHORT: {
                Type type5 = Type.SHORT_TYPE;
                if (type5 == null) {
                    AsmTypes.$$$reportNull$$$0(8);
                }
                return type5;
            }
            case INT: {
                Type type6 = Type.INT_TYPE;
                if (type6 == null) {
                    AsmTypes.$$$reportNull$$$0(9);
                }
                return type6;
            }
            case FLOAT: {
                Type type7 = Type.FLOAT_TYPE;
                if (type7 == null) {
                    AsmTypes.$$$reportNull$$$0(10);
                }
                return type7;
            }
            case LONG: {
                Type type8 = Type.LONG_TYPE;
                if (type8 == null) {
                    AsmTypes.$$$reportNull$$$0(11);
                }
                return type8;
            }
            case DOUBLE: {
                Type type9 = Type.DOUBLE_TYPE;
                if (type9 == null) {
                    AsmTypes.$$$reportNull$$$0(12);
                }
                return type9;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Type getType(@NotNull Class<?> javaClass) {
        if (javaClass == null) {
            AsmTypes.$$$reportNull$$$0(13);
        }
        Type type2 = TYPES_MAP.computeIfAbsent(javaClass, k -> Type.getType((Class)javaClass));
        if (type2 == null) {
            AsmTypes.$$$reportNull$$$0(14);
        }
        return type2;
    }

    public static boolean isOptimizedPropertyReferenceSupertype(@NotNull Type type2) {
        if (type2 == null) {
            AsmTypes.$$$reportNull$$$0(15);
        }
        return OPTIMIZED_PROPERTY_REFERENCE_SUPERTYPES.contains(type2);
    }

    private AsmTypes() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/jvm/AsmTypes";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/jvm/AsmTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "reflect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sharedTypeForPrimitive";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "valueTypeForPrimitive";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reflect";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSharedVarType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sharedTypeForPrimitive";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isOptimizedPropertyReferenceSupertype";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

