/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.CacheTextLayoutInput;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextMeasurerKt;
import androidx.compose.ui.text.caches.LruCache;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/text/TextLayoutCache;", "", "capacity", "", "(I)V", "lruCache", "Landroidx/compose/ui/text/caches/LruCache;", "Landroidx/compose/ui/text/CacheTextLayoutInput;", "Landroidx/compose/ui/text/TextLayoutResult;", "get", "key", "Landroidx/compose/ui/text/TextLayoutInput;", "put", "value", "remove", "ui-text"})
@StabilityInferred(parameters=0)
public final class TextLayoutCache {
    @NotNull
    private final LruCache<CacheTextLayoutInput, TextLayoutResult> lruCache;
    public static final int $stable = 8;

    public TextLayoutCache(int capacity) {
        this.lruCache = new LruCache(capacity);
    }

    public /* synthetic */ TextLayoutCache(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = TextMeasurerKt.access$getDefaultCacheSize$p();
        }
        this(n);
    }

    @Nullable
    public final TextLayoutResult get(@NotNull TextLayoutInput key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        TextLayoutResult textLayoutResult = this.lruCache.get(new CacheTextLayoutInput(key));
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult resultFromCache = textLayoutResult;
        if (resultFromCache.getMultiParagraph().getIntrinsics().getHasStaleResolvedFonts()) {
            return null;
        }
        return resultFromCache;
    }

    @Nullable
    public final TextLayoutResult put(@NotNull TextLayoutInput key, @NotNull TextLayoutResult value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.lruCache.put(new CacheTextLayoutInput(key), value);
    }

    @Nullable
    public final TextLayoutResult remove(@NotNull TextLayoutInput key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.lruCache.remove(new CacheTextLayoutInput(key));
    }

    public TextLayoutCache() {
        this(0, 1, null);
    }
}

