/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.observable.util.BindUtil;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.BundledMaven3;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\u001d\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f0\u001b\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\u001aH\u0014\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u000e\u0012\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenEnvironmentSettingsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "runImportAfter", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;Ljava/lang/Runnable;)V", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "userSettingsProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "defaultUserSettingsProperty", "localRepositoryProperty", "defaultLocalRepositoryProperty", "doOKAction", "", "doCancelAction", "resolveDefaultUserSettingsFile", "resolveDefaultLocalRepository", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenEnvironmentSettingsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenEnvironmentSettingsDialog.kt\norg/jetbrains/idea/maven/wizards/MavenEnvironmentSettingsDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class MavenEnvironmentSettingsDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final MavenGeneralSettings settings;
    @NotNull
    private final Runnable runImportAfter;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private final GraphProperty<String> userSettingsProperty;
    @NotNull
    private final GraphProperty<String> defaultUserSettingsProperty;
    @NotNull
    private final GraphProperty<String> localRepositoryProperty;
    @NotNull
    private final GraphProperty<String> defaultLocalRepositoryProperty;

    public MavenEnvironmentSettingsDialog(@NotNull Project project, @NotNull MavenGeneralSettings settings, @NotNull Runnable runImportAfter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)runImportAfter, (String)"runImportAfter");
        super(project);
        this.project = project;
        this.settings = settings;
        this.runImportAfter = runImportAfter;
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.userSettingsProperty = this.propertyGraph.lazyProperty((Function0)new Function0<String>((Object)this.settings){

            public final String invoke() {
                return ((MavenGeneralSettings)this.receiver).getUserSettingsFile();
            }
        });
        this.defaultUserSettingsProperty = this.propertyGraph.lazyProperty((Function0)new Function0<String>((Object)this){

            public final String invoke() {
                return MavenEnvironmentSettingsDialog.access$resolveDefaultUserSettingsFile((MavenEnvironmentSettingsDialog)((Object)this.receiver));
            }
        });
        this.localRepositoryProperty = this.propertyGraph.lazyProperty((Function0)new Function0<String>((Object)this.settings){

            public final String invoke() {
                return ((MavenGeneralSettings)this.receiver).getLocalRepository();
            }
        });
        this.defaultLocalRepositoryProperty = this.propertyGraph.lazyProperty((Function0)new Function0<String>((Object)this){

            public final String invoke() {
                return MavenEnvironmentSettingsDialog.access$resolveDefaultLocalRepository((MavenEnvironmentSettingsDialog)((Object)this.receiver));
            }
        });
        this.setTitle(MavenConfigurableBundle.message("maven.settings.environment.settings.title", new Object[0]));
        this.init();
        this.defaultLocalRepositoryProperty.dependsOn((ObservableProperty)this.userSettingsProperty, () -> MavenEnvironmentSettingsDialog._init_$lambda$0(this));
    }

    protected void doOKAction() {
        super.doOKAction();
        this.runImportAfter.run();
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.runImportAfter.run();
    }

    private final String resolveDefaultUserSettingsFile() {
        String string = MavenUtil.resolveUserSettingsFile("").getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private final String resolveDefaultLocalRepository() {
        MavenHomeType it = this.settings.getMavenHomeType();
        boolean bl = false;
        StaticResolvedMavenHomeType staticResolvedMavenHomeType = it instanceof StaticResolvedMavenHomeType ? (StaticResolvedMavenHomeType)it : null;
        StaticResolvedMavenHomeType staticResolvedMavenHomeType2 = staticResolvedMavenHomeType;
        if (staticResolvedMavenHomeType == null) {
            staticResolvedMavenHomeType2 = BundledMaven3.INSTANCE;
        }
        StaticResolvedMavenHomeType mavenHomeType = staticResolvedMavenHomeType2;
        String string = MavenUtil.resolveLocalRepository("", mavenHomeType, (String)this.userSettingsProperty.get()).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        return actionArray;
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return BuilderKt.panel(arg_0 -> MavenEnvironmentSettingsDialog.createCenterPanel$lambda$7(this, arg_0));
    }

    private static final String _init_$lambda$0(MavenEnvironmentSettingsDialog this$0) {
        return this$0.resolveDefaultLocalRepository();
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3$lambda$2(MavenEnvironmentSettingsDialog this$0, TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        BindUtil.bindEmptyText((TextFieldWithBrowseButton)$this$applyToComponent, (ObservableProperty)((ObservableProperty)PropertyOperationUtil.toUiPathProperty((ObservableMutableProperty)((ObservableMutableProperty)this$0.defaultUserSettingsProperty))));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$3(MavenEnvironmentSettingsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(MavenProjectBundle.message("maven.select.maven.settings.file", new Object[0]));
        Intrinsics.checkNotNull((Object)fileChooserDescriptor);
        TextFieldWithBrowseButtonKt.columns((Cell)TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, (Project)this$0.project, null, (int)4, null), (ObservableMutableProperty)((ObservableMutableProperty)this$0.userSettingsProperty)).applyToComponent(arg_0 -> MavenEnvironmentSettingsDialog.createCenterPanel$lambda$7$lambda$3$lambda$2(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE), (int)25);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$5$lambda$4(MavenEnvironmentSettingsDialog this$0, TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        BindUtil.bindEmptyText((TextFieldWithBrowseButton)$this$applyToComponent, (ObservableProperty)((ObservableProperty)PropertyOperationUtil.toUiPathProperty((ObservableMutableProperty)((ObservableMutableProperty)this$0.defaultLocalRepositoryProperty))));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$5(MavenEnvironmentSettingsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(MavenProjectBundle.message("maven.select.local.repository", new Object[0]));
        Intrinsics.checkNotNull((Object)fileChooserDescriptor);
        TextFieldWithBrowseButtonKt.columns((Cell)TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, (Project)this$0.project, null, (int)4, null), (ObservableMutableProperty)((ObservableMutableProperty)this$0.localRepositoryProperty)).applyToComponent(arg_0 -> MavenEnvironmentSettingsDialog.createCenterPanel$lambda$7$lambda$5$lambda$4(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE), (int)25);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7$lambda$6(MavenEnvironmentSettingsDialog this$0) {
        this$0.settings.setUserSettingsFile((String)this$0.userSettingsProperty.get());
        this$0.settings.setLocalRepository((String)this$0.localRepositoryProperty.get());
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$7(MavenEnvironmentSettingsDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(MavenConfigurableBundle.message("maven.settings.environment.user.settings", new Object[0]) + ":", arg_0 -> MavenEnvironmentSettingsDialog.createCenterPanel$lambda$7$lambda$3(this$0, arg_0));
        $this$panel.row(MavenConfigurableBundle.message("maven.settings.environment.local.repository", new Object[0]) + ":", arg_0 -> MavenEnvironmentSettingsDialog.createCenterPanel$lambda$7$lambda$5(this$0, arg_0));
        $this$panel.onApply(() -> MavenEnvironmentSettingsDialog.createCenterPanel$lambda$7$lambda$6(this$0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$resolveDefaultUserSettingsFile(MavenEnvironmentSettingsDialog $this) {
        return $this.resolveDefaultUserSettingsFile();
    }

    public static final /* synthetic */ String access$resolveDefaultLocalRepository(MavenEnvironmentSettingsDialog $this) {
        return $this.resolveDefaultLocalRepository();
    }
}

