/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenInSpecificPath;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.DummyIndexer;
import org.jetbrains.idea.maven.server.DummyMavenServerConnector;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenIndexingConnectorImpl;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerManagerEx;
import org.jetbrains.idea.maven.server.MavenServerManagerImpl;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0016J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0006H\u0017J\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\"\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0006H\u0002J \u0010$\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020\u0013H\u0016J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\b\u0010*\u001a\u00020\u0013H\u0017J\b\u0010+\u001a\u00020\u0013H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020\u000fH\u0016J\n\u0010.\u001a\u0004\u0018\u00010\u000fH\u0002J \u0010/\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0006H\u0016J\b\u00103\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u00104\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u00105\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerManagerImpl;", "Lorg/jetbrains/idea/maven/server/MavenServerManager;", "<init>", "()V", "myMultimoduleDirToConnectorMap", "", "", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "isShutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myIndexingConnector", "Lorg/jetbrains/idea/maven/server/MavenIndexingConnectorImpl;", "myIndexerWrapper", "Lorg/jetbrains/idea/maven/server/MavenIndexerWrapper;", "eventListenerJar", "Ljava/io/File;", "getAllConnectors", "", "restartMavenConnectors", "", "project", "Lcom/intellij/openapi/project/Project;", "wait", "", "condition", "Ljava/util/function/Predicate;", "doGetConnector", "workingDirectory", "getConnectorBlocking", "getConnector", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doGetOrCreateConnector", "multimoduleDirectory", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "findCompatibleConnector", "registerNewConnector", "registerDisposable", "connector", "dispose", "shutdownConnector", "removeConnector", "closeAllConnectorsAndWait", "closeAllConnectorsEventually", "shutdownNow", "getMavenEventListener", "getEventListenerJar", "createEmbedder", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "alwaysOnline", "multiModuleProjectDirectory", "createIndexer", "createDedicatedIndexer", "createLegacyIndexer", "Companion", "intellij.maven"})
public final class MavenServerManagerImpl
implements MavenServerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, MavenServerConnector> myMultimoduleDirToConnectorMap = new HashMap();
    @NotNull
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    @Nullable
    private MavenIndexingConnectorImpl myIndexingConnector;
    @Nullable
    private MavenIndexerWrapper myIndexerWrapper;
    @Nullable
    private File eventListenerJar;

    public MavenServerManagerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                isShutdown.set(true);
                this.closeAllConnectorsEventually();
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)"org.jetbrains.idea.maven", (Object)pluginDescriptor.getPluginId().getIdString())) {
                    isShutdown.set(true);
                    this.closeAllConnectorsEventually();
                }
            }
        });
        connection.subscribe(TrustedProjectsListener.TOPIC, (Object)new TrustedProjectsListener(){

            public void onProjectTrusted(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
                if (manager.isMavenizedProject()) {
                    MavenUtil.restartMavenConnectors(project, true, 3::onProjectTrusted$lambda$0);
                }
            }

            public void onProjectUntrusted(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
                if (manager.isMavenizedProject()) {
                    MavenUtil.restartMavenConnectors(project, true, 3::onProjectUntrusted$lambda$1);
                }
            }

            public void onProjectTrustedFromNotification(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
                if (manager.isMavenizedProject()) {
                    MavenLog.LOG.info("onProjectTrustedFromNotification forceUpdateAllProjectsOrFindAllAvailablePomFiles");
                    manager.forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }
            }

            private static final boolean onProjectTrusted$lambda$0(MavenServerConnector it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DummyMavenServerConnector.Companion.isDummy(it);
            }

            private static final boolean onProjectUntrusted$lambda$1(MavenServerConnector it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return DummyMavenServerConnector.Companion.isDummy(it);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<MavenServerConnector> getAllConnectors() {
        Set<MavenServerConnector> set = Collections.newSetFromMap(new IdentityHashMap());
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            boolean bl = false;
            set.addAll(this.myMultimoduleDirToConnectorMap.values());
            if (this.myIndexingConnector != null) {
                MavenIndexingConnectorImpl mavenIndexingConnectorImpl = this.myIndexingConnector;
                Intrinsics.checkNotNull((Object)mavenIndexingConnectorImpl);
                set.add(mavenIndexingConnectorImpl);
            }
            Unit unit = Unit.INSTANCE;
        }
        Intrinsics.checkNotNull(set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartMavenConnectors(@NotNull Project project, boolean wait, @NotNull Predicate<MavenServerConnector> condition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        List connectorsToShutDown = new ArrayList();
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            boolean bl = false;
            this.getAllConnectors().forEach(arg_0 -> MavenServerManagerImpl.restartMavenConnectors$lambda$2$lambda$1(project, condition, this, connectorsToShutDown, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        MavenProjectsManager.getInstance(project).getEmbeddersManager().reset();
        MavenServerManagerEx.Companion.stopConnectors(project, wait, connectorsToShutDown);
    }

    private final MavenServerConnector doGetConnector(Project project, String workingDirectory) {
        String string = MavenDistributionsCache.getInstance(project).getMultimoduleDirectory(workingDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMultimoduleDirectory(...)");
        String multimoduleDirectory = string;
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
        Intrinsics.checkNotNull((Object)settings);
        Sdk jdk = MavenServerManagerImpl.Companion.getJdk(project, settings);
        MavenServerConnector connector = this.doGetOrCreateConnector(project, multimoduleDirectory, jdk);
        if (connector.isNew()) {
            connector.connect();
        } else if (!MavenServerManagerImpl.Companion.compatibleParameters(project, connector, jdk, multimoduleDirectory)) {
            MavenLog.LOG.info("[connector] " + connector + " is incompatible, restarting");
            this.shutdownConnector(connector, false);
            connector = this.doGetOrCreateConnector(project, multimoduleDirectory, jdk);
            connector.connect();
        }
        if (MavenLog.LOG.isTraceEnabled()) {
            MavenLog.LOG.trace("[connector] get " + connector);
        }
        return connector;
    }

    @Override
    @Deprecated(message="use suspend", replaceWith=@ReplaceWith(expression="getConnector", imports={}))
    @NotNull
    public MavenServerConnector getConnectorBlocking(@NotNull Project project, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        MavenServerConnector connector = this.doGetConnector(project, workingDirectory);
        if (!connector.pingBlocking()) {
            this.shutdownConnector(connector, true);
            connector = this.doGetConnector(project, workingDirectory);
        }
        return connector;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getConnector(@NotNull Project var1_1, @NotNull String var2_2, @NotNull Continuation<? super MavenServerConnector> $completion) {
        if (!($completion instanceof getConnector.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ MavenServerManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getConnector(null, null, (Continuation<? super MavenServerConnector>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = project;
                $continuation.L$2 = workingDirectory;
                $continuation.label = 1;
                v0 = CoroutinesKt.blockingContext((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getConnector$lambda$3(org.jetbrains.idea.maven.server.MavenServerManagerImpl com.intellij.openapi.project.Project java.lang.String ), ()Lorg/jetbrains/idea/maven/server/MavenServerConnector;)((MavenServerManagerImpl)this, (Project)project, (String)workingDirectory), (Continuation)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                workingDirectory = (String)$continuation.L$2;
                project = (Project)$continuation.L$1;
                this = (MavenServerManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                connector = (MavenServerConnector)v0;
                $continuation.L$0 = this;
                $continuation.L$1 = project;
                $continuation.L$2 = workingDirectory;
                $continuation.L$3 = connector;
                $continuation.label = 2;
                v1 = connector.ping((Continuation<? super Boolean>)$continuation);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl43
            }
            case 2: {
                connector = (MavenServerConnector)$continuation.L$3;
                workingDirectory = (String)$continuation.L$2;
                project = (Project)$continuation.L$1;
                this = (MavenServerManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                if (!((Boolean)v1).booleanValue()) {
                    this.shutdownConnector(connector, true);
                    connector = this.doGetConnector(project, workingDirectory);
                }
                return connector;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenServerConnector doGetOrCreateConnector(Project project, String multimoduleDirectory, Sdk jdk) {
        if (this.isShutdown.get()) {
            throw new IllegalStateException("We are closed, sorry. No connectors anymore");
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            MavenServerConnector connector;
            block7: {
                boolean bl = false;
                connector = null;
                MavenServerConnector mavenServerConnector = connector = this.myMultimoduleDirToConnectorMap.get(multimoduleDirectory);
                if (mavenServerConnector == null) break block7;
                MavenServerConnector mavenServerConnector2 = mavenServerConnector;
                return mavenServerConnector2;
            }
            connector = this.findCompatibleConnector(project, jdk, multimoduleDirectory);
            if (connector != null) {
                MavenLog.LOG.debug("[connector] use existing connector for " + connector);
                connector.addMultimoduleDir(multimoduleDirectory);
            } else {
                connector = this.registerNewConnector(project, jdk, multimoduleDirectory);
            }
            this.myMultimoduleDirToConnectorMap.put(multimoduleDirectory, connector);
            MavenServerConnector mavenServerConnector = connector;
            return mavenServerConnector;
        }
    }

    private final MavenServerConnector findCompatibleConnector(Project project, Sdk jdk, String multimoduleDirectory) {
        MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance(project).getMavenDistribution(multimoduleDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
        MavenDistribution distribution = mavenDistribution;
        String string = MavenDistributionsCache.getInstance(project).getVmOptions(multimoduleDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVmOptions(...)");
        String vmOptions = string;
        Iterator<Map.Entry<String, MavenServerConnector>> iterator = this.myMultimoduleDirToConnectorMap.entrySet().iterator();
        while (iterator.hasNext()) {
            MavenServerConnector value = iterator.next().getValue();
            if (!Intrinsics.areEqual((Object)value.getProject(), (Object)project)) continue;
            if (Registry.Companion.is("maven.server.per.idea.project")) {
                return value;
            }
            if (!value.isCompatibleWith(jdk, vmOptions, distribution)) continue;
            return value;
        }
        return null;
    }

    private final MavenServerConnector registerNewConnector(Project project, Sdk jdk, String multimoduleDirectory) {
        MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance(project).getMavenDistribution(multimoduleDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
        MavenDistribution distribution = mavenDistribution;
        String string = MavenDistributionsCache.getInstance(project).getVmOptions(multimoduleDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVmOptions(...)");
        String vmOptions = string;
        Integer debugPort = MavenServerManagerImpl.Companion.getFreeDebugPort();
        MavenServerConnector connector = null;
        if (TrustedProjects.isTrusted((Project)project) || project.isDefault()) {
            MavenServerManager.MavenServerConnectorFactory connectorFactory = (MavenServerManager.MavenServerConnectorFactory)ApplicationManager.getApplication().getService(MavenServerManager.MavenServerConnectorFactory.class);
            connector = connectorFactory.create(project, jdk, vmOptions, debugPort, distribution, multimoduleDirectory);
            MavenLog.LOG.debug("[connector] new maven connector " + connector);
        } else {
            MavenLog.LOG.warn("Project " + project + " not trusted enough. Will not start maven for it");
            connector = new DummyMavenServerConnector(project, jdk, vmOptions, distribution, multimoduleDirectory);
        }
        this.registerDisposable(project, connector);
        return connector;
    }

    private final void registerDisposable(Project project, MavenServerConnector connector) {
        Disposer.register((Disposable)MavenDisposable.getInstance(project), () -> MavenServerManagerImpl.registerDisposable$lambda$6(this, connector));
    }

    public void dispose() {
        this.shutdownNow();
    }

    @Override
    public boolean shutdownConnector(@NotNull MavenServerConnector connector, boolean wait) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        MavenServerConnector connectorToStop = this.removeConnector(connector);
        if (connectorToStop == null) {
            return false;
        }
        connectorToStop.stop(wait);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenServerConnector removeConnector(MavenServerConnector connector) {
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (this.myIndexingConnector != connector) break block5;
                    this.myIndexingConnector = null;
                    this.myIndexerWrapper = null;
                    MavenServerConnector mavenServerConnector = connector;
                    return mavenServerConnector;
                }
                if (this.myMultimoduleDirToConnectorMap.containsValue(connector)) break block6;
                MavenServerConnector mavenServerConnector = null;
                return mavenServerConnector;
            }
            boolean bl = this.myMultimoduleDirToConnectorMap.entrySet().removeIf(arg_0 -> MavenServerManagerImpl.removeConnector$lambda$9$lambda$8(arg_0 -> MavenServerManagerImpl.removeConnector$lambda$9$lambda$7(connector, arg_0), arg_0));
        }
        return connector;
    }

    @Override
    @TestOnly
    public void closeAllConnectorsAndWait() {
        this.shutdownNow();
    }

    private final void closeAllConnectorsEventually() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> MavenServerManagerImpl.closeAllConnectorsEventually$lambda$10(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdownNow() {
        ArrayList<MavenServerConnector> values = null;
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            boolean bl = false;
            values = new ArrayList<MavenServerConnector>(this.myMultimoduleDirToConnectorMap.values());
            Unit unit = Unit.INSTANCE;
        }
        MavenIndexingConnectorImpl indexingConnector = this.myIndexingConnector;
        if (indexingConnector != null) {
            this.shutdownConnector(indexingConnector, true);
        }
        ((Collection)values).forEach(arg_0 -> MavenServerManagerImpl.shutdownNow$lambda$12(this, arg_0));
    }

    @Override
    @NotNull
    public File getMavenEventListener() {
        File file = this.getEventListenerJar();
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    private final File getEventListenerJar() {
        if (this.eventListenerJar != null) {
            return this.eventListenerJar;
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        if (pluginFileOrDir.isDirectory()) {
            File file = this.eventListenerJar = MavenServerManagerImpl.Companion.getEventSpyPathForLocalBuild();
            Intrinsics.checkNotNull((Object)file);
            if (!file.exists()) {
                MavenLog.LOG.warn("Event listener does not exist: Please run rebuild for maven modules:\ncommunity/plugins/maven/maven-event-listener");
            }
        } else {
            File file = this.eventListenerJar = new File(root, "maven-event-listener.jar");
            Intrinsics.checkNotNull((Object)file);
            if (!file.exists()) {
                MavenLog.LOG.warn("Event listener does not exist at " + this.eventListenerJar + ". It should be built as part of plugin layout process and bundled along with maven plugin jars");
            }
        }
        return this.eventListenerJar;
    }

    @Override
    @NotNull
    public MavenEmbedderWrapper createEmbedder(@NotNull Project project, boolean alwaysOnline, @NotNull String multiModuleProjectDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)multiModuleProjectDirectory, (String)"multiModuleProjectDirectory");
        return new MavenEmbedderWrapper(project, multiModuleProjectDirectory, alwaysOnline, this){
            private MavenServerConnector myConnector;
            private final Mutex createMutex;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $multiModuleProjectDirectory;
            final /* synthetic */ boolean $alwaysOnline;
            final /* synthetic */ MavenServerManagerImpl this$0;
            {
                this.$project = $project;
                this.$multiModuleProjectDirectory = $multiModuleProjectDirectory;
                this.$alwaysOnline = $alwaysOnline;
                this.this$0 = $receiver;
                super($project);
                this.createMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
            }

            public final Mutex getCreateMutex() {
                return this.createMutex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            protected Object create(Continuation<? super MavenServerEmbedder> $completion) throws RemoteException {
                if (!($completion instanceof createEmbedder.create.1)) ** GOTO lbl-1000
                var8_2 = $completion;
                if ((var8_2.label & -2147483648) != 0) {
                    var8_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ createEmbedder.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.create((Continuation<? super MavenServerEmbedder>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$withLock_u24default$iv = this.createMutex;
                        owner$iv = null;
                        $i$f$withLock = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = $this$withLock_u24default$iv;
                        $continuation.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                        if (v0 == var9_4) {
                            return var9_4;
                        }
                        ** GOTO lbl31
                    }
                    case 1: {
                        $i$f$withLock = false;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                        this = $continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl31:
                        // 3 sources

                        $i$a$-withLock$default-MavenServerManagerImpl$createEmbedder$1$create$2 = false;
                        $continuation.L$0 = $this$withLock_u24default$iv;
                        $continuation.L$1 = null;
                        $continuation.label = 2;
                        v1 = this.doCreate((Continuation<? super MavenServerEmbedder>)$continuation);
                        ** if (v1 != var9_4) goto lbl39
lbl38:
                        // 1 sources

                        return var9_4;
lbl39:
                        // 1 sources

                        ** GOTO lbl49
                    }
                    case 2: {
                        $i$f$withLock = false;
                        $i$a$-withLock$default-MavenServerManagerImpl$createEmbedder$1$create$2 = false;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl49:
                            // 2 sources

                            var6_13 = (MavenServerEmbedder)v1;
                        }
                        catch (Throwable var5_12) {
                            throw var5_12;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return var6_13;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * Unable to fully structure code
             */
            private final Object doCreate(Continuation<? super MavenServerEmbedder> $completion) throws RemoteException {
                if (!($completion instanceof createEmbedder.doCreate.1)) ** GOTO lbl-1000
                var9_2 = $completion;
                if ((var9_2.label & -2147483648) != 0) {
                    var9_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        boolean Z$0;
                        boolean Z$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ createEmbedder.1 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return createEmbedder.1.access$doCreate(this.this$0, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        settings = org.jetbrains.idea.maven.server.MavenServerManagerImpl$Companion.access$convertSettings(MavenServerManagerImpl.Companion, this.$project, MavenProjectsManager.getInstance(this.$project).getGeneralSettings(), this.$multiModuleProjectDirectory);
                        if (this.$alwaysOnline && settings.isOffline()) {
                            settings = settings.clone();
                            settings.setOffline(false);
                        }
                        transformer = RemotePathTransformerFactory.createForProject(this.$project);
                        sdkPath = MavenUtil.getSdkPath(ProjectRootManager.getInstance((Project)this.$project).getProjectSdk());
                        if (sdkPath != null) {
                            sdkPath = transformer.toRemotePath(sdkPath);
                        }
                        settings.setProjectJdk(sdkPath);
                        forceResolveDependenciesSequentially = Registry.Companion.is("maven.server.force.resolve.dependencies.sequentially");
                        useCustomDependenciesResolver = Registry.Companion.is("maven.server.use.custom.dependencies.resolver");
                        var7_10 = this;
                        $continuation.L$0 = this;
                        $continuation.L$1 = settings;
                        $continuation.L$2 = transformer;
                        $continuation.L$3 = var7_10;
                        $continuation.Z$0 = forceResolveDependenciesSequentially;
                        $continuation.Z$1 = useCustomDependenciesResolver;
                        $continuation.label = 1;
                        v0 = this.this$0.getConnector(this.$project, this.$multiModuleProjectDirectory, (Continuation<? super MavenServerConnector>)$continuation);
                        if (v0 == var10_4) {
                            return var10_4;
                        }
                        ** GOTO lbl44
                    }
                    case 1: {
                        useCustomDependenciesResolver = $continuation.Z$1;
                        forceResolveDependenciesSequentially = $continuation.Z$0;
                        var7_10 = $continuation.L$3;
                        transformer = (RemotePathTransformerFactory.Transformer)$continuation.L$2;
                        settings = (MavenServerSettings)$continuation.L$1;
                        this = $continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl44:
                        // 2 sources

                        var7_10.myConnector = (MavenServerConnector)v0;
                        v1 = this.myConnector;
                        Intrinsics.checkNotNull((Object)v1);
                        return v1.createEmbedder(new MavenEmbedderSettings((MavenServerSettings)var2_5, transformer.toRemotePath(this.$multiModuleProjectDirectory), forceResolveDependenciesSequentially != false, useCustomDependenciesResolver != false));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            protected synchronized void cleanup() {
                super.cleanup();
                if (this.myConnector != null) {
                    MavenServerConnector mavenServerConnector = this.myConnector;
                    Intrinsics.checkNotNull((Object)mavenServerConnector);
                    this.this$0.shutdownConnector(mavenServerConnector, false);
                }
            }

            public static final /* synthetic */ Object access$doCreate(createEmbedder.1 $this, Continuation $completion) {
                return $this.doCreate((Continuation<? super MavenServerEmbedder>)$completion);
            }
        };
    }

    @Override
    @NotNull
    public MavenIndexerWrapper createIndexer() {
        MavenIndexerWrapper mavenIndexerWrapper = this.createDedicatedIndexer();
        Intrinsics.checkNotNull((Object)mavenIndexerWrapper);
        return mavenIndexerWrapper;
    }

    @Override
    @NotNull
    public MavenIndexerWrapper createIndexer(@NotNull Project project) {
        MavenIndexerWrapper mavenIndexerWrapper;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (Registry.Companion.is("maven.dedicated.indexer")) {
            MavenIndexerWrapper mavenIndexerWrapper2 = this.createDedicatedIndexer();
            mavenIndexerWrapper = mavenIndexerWrapper2;
            Intrinsics.checkNotNull((Object)mavenIndexerWrapper2);
        } else {
            mavenIndexerWrapper = this.createLegacyIndexer(project);
        }
        return mavenIndexerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MavenIndexerWrapper createDedicatedIndexer() {
        if (this.myIndexerWrapper != null) {
            return this.myIndexerWrapper;
        }
        Map<String, MavenServerConnector> map = this.myMultimoduleDirToConnectorMap;
        synchronized (map) {
            block5: {
                boolean bl = false;
                if (this.myIndexerWrapper == null) break block5;
                MavenIndexerWrapper mavenIndexerWrapper = this.myIndexerWrapper;
                return mavenIndexerWrapper;
            }
            String workingDir = SystemUtils.getUserHome().getAbsolutePath();
            this.myIndexerWrapper = new MavenIndexerWrapper(this, workingDir){
                final /* synthetic */ MavenServerManagerImpl this$0;
                final /* synthetic */ String $workingDir;
                {
                    this.this$0 = $receiver;
                    this.$workingDir = $workingDir;
                }

                protected MavenIndices createMavenIndices(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.Companion.getInstance().getIndicesDir().toFile(), project);
                    Disposer.register((Disposable)MavenDisposable.getInstance(project), (Disposable)indices);
                    return indices;
                }

                protected MavenServerIndexer createBlocking() throws RemoteException {
                    MavenServerConnector indexingConnector;
                    MavenServerConnector mavenServerConnector = indexingConnector = this.getIndexingConnector();
                    Intrinsics.checkNotNull((Object)mavenServerConnector);
                    return mavenServerConnector.createIndexer();
                }

                protected Object create(Continuation<? super MavenServerIndexer> $completion) throws RemoteException {
                    MavenServerConnector indexingConnector;
                    MavenServerConnector mavenServerConnector = indexingConnector = this.getIndexingConnector();
                    Intrinsics.checkNotNull((Object)mavenServerConnector);
                    return mavenServerConnector.createIndexer();
                }

                protected synchronized void handleRemoteError(RemoteException e) {
                    MavenIndexingConnectorImpl indexingConnector;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.handleRemoteError(e);
                    if (this.waitIfNotIdeaShutdown() && (indexingConnector = MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0)) != null && !indexingConnector.checkConnected()) {
                        this.this$0.shutdownConnector(indexingConnector, true);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final MavenServerConnector getIndexingConnector() {
                    if (MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0) != null) {
                        return MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0);
                    }
                    Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
                    Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInternalJdk(...)");
                    Sdk jdk = sdk;
                    Map map = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(this.this$0);
                    MavenServerManagerImpl mavenServerManagerImpl = this.this$0;
                    String string = this.$workingDir;
                    Map map2 = map;
                    synchronized (map2) {
                        block5: {
                            boolean bl = false;
                            if (MavenServerManagerImpl.access$getMyIndexingConnector$p(mavenServerManagerImpl) == null) break block5;
                            MavenServerConnector mavenServerConnector = MavenServerManagerImpl.access$getMyIndexingConnector$p(mavenServerManagerImpl);
                            return mavenServerConnector;
                        }
                        Integer n = org.jetbrains.idea.maven.server.MavenServerManagerImpl$Companion.access$getFreeDebugPort(MavenServerManagerImpl.Companion);
                        LocalMavenDistribution localMavenDistribution = MavenDistributionsCache.resolveEmbeddedMavenHome();
                        Intrinsics.checkNotNullExpressionValue((Object)localMavenDistribution, (String)"resolveEmbeddedMavenHome(...)");
                        MavenDistribution mavenDistribution = localMavenDistribution;
                        Intrinsics.checkNotNull((Object)string);
                        MavenServerManagerImpl.access$setMyIndexingConnector$p(mavenServerManagerImpl, new MavenIndexingConnectorImpl(jdk, "", n, mavenDistribution, string));
                        Unit unit = Unit.INSTANCE;
                    }
                    MavenIndexingConnectorImpl mavenIndexingConnectorImpl = MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0);
                    Intrinsics.checkNotNull((Object)mavenIndexingConnectorImpl);
                    mavenIndexingConnectorImpl.connect();
                    return MavenServerManagerImpl.access$getMyIndexingConnector$p(this.this$0);
                }

                private final boolean waitIfNotIdeaShutdown() {
                    try {
                        Thread.sleep(100L);
                        return true;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
            };
            Unit unit = Unit.INSTANCE;
        }
        return this.myIndexerWrapper;
    }

    private final MavenIndexerWrapper createLegacyIndexer(Project project) {
        String path = project.getBasePath();
        if (path == null) {
            path = new File(".").getPath();
        }
        String finalPath = path;
        if (MavenWslUtil.tryGetWslDistributionForPath(path) != null) {
            return new MavenIndexerWrapper(){

                protected MavenIndices createMavenIndices(Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.Companion.getInstance().getIndicesDir().toFile(), project);
                    Disposer.register((Disposable)MavenDisposable.getInstance(project), (Disposable)indices);
                    return indices;
                }

                protected MavenServerIndexer createBlocking() {
                    return new DummyIndexer();
                }

                protected Object create(Continuation<? super MavenServerIndexer> $completion) {
                    return new DummyIndexer();
                }
            };
        }
        return new MavenIndexerWrapper(this, project, finalPath){
            final /* synthetic */ MavenServerManagerImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $finalPath;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$finalPath = $finalPath;
            }

            protected MavenIndices createMavenIndices(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MavenIndices indices = new MavenIndices(this, MavenSystemIndicesManager.Companion.getInstance().getIndicesDir().toFile(), project);
                Disposer.register((Disposable)MavenDisposable.getInstance(project), (Disposable)indices);
                return indices;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected MavenServerIndexer createBlocking() throws RemoteException {
                String workingDirectory;
                Ref.ObjectRef connector = new Ref.ObjectRef();
                Map map = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(this.this$0);
                MavenServerManagerImpl mavenServerManagerImpl = this.this$0;
                String string = this.$finalPath;
                Map map2 = map;
                synchronized (map2) {
                    Object v4;
                    block7: {
                        boolean bl = false;
                        Iterable iterable = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(mavenServerManagerImpl).values();
                        Ref.ObjectRef objectRef = connector;
                        Iterable iterable2 = iterable;
                        for (T t : iterable2) {
                            Object v2;
                            block6: {
                                MavenServerConnector c = (MavenServerConnector)t;
                                boolean bl2 = false;
                                Iterable iterable3 = c.getMultimoduleDirectories();
                                for (T t2 : iterable3) {
                                    String mDir = (String)t2;
                                    boolean bl3 = false;
                                    String string2 = string;
                                    Intrinsics.checkNotNull((Object)string2);
                                    String string3 = mDir;
                                    Intrinsics.checkNotNull((Object)string3);
                                    if (!FileUtil.isAncestor((String)string2, (String)string3, (boolean)false)) continue;
                                    v2 = t2;
                                    break block6;
                                }
                                v2 = null;
                            }
                            boolean bl4 = v2 != null;
                            if (!bl4) continue;
                            v4 = t;
                            break block7;
                        }
                        v4 = null;
                    }
                    objectRef.element = v4;
                    Unit unit = Unit.INSTANCE;
                }
                if (connector.element != null) {
                    Object object = connector.element;
                    Intrinsics.checkNotNull((Object)object);
                    return ((MavenServerConnector)object).createIndexer();
                }
                String string4 = workingDirectory = (String)ObjectUtils.chooseNotNull((Object)this.$project.getBasePath(), (Object)SystemUtils.getUserHome().getAbsolutePath());
                Intrinsics.checkNotNull((Object)string4);
                return this.this$0.getConnectorBlocking(this.$project, string4).createIndexer();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            protected Object create(Continuation<? super MavenServerIndexer> $completion) throws RemoteException {
                if (!($completion instanceof createLegacyIndexer.create.1)) ** GOTO lbl-1000
                var21_2 = $completion;
                if ((var21_2.label & -2147483648) != 0) {
                    var21_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        /* synthetic */ Object result;
                        final /* synthetic */ createLegacyIndexer.2 this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.create((Continuation<? super MavenServerIndexer>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var22_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        connector = new Ref.ObjectRef();
                        var3_6 = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(this.this$0);
                        var4_7 = this.this$0;
                        var5_8 = this.$finalPath;
                        var6_9 = var3_6;
                        synchronized (var6_9) {
                            $i$a$-synchronized-MavenServerManagerImpl$createLegacyIndexer$2$create$2 = false;
                            var8_13 = MavenServerManagerImpl.access$getMyMultimoduleDirToConnectorMap$p(var4_7).values();
                            var9_14 = connector;
                            var10_15 = var8_13;
                            for (T var12_17 : var10_15) {
                                c = (MavenServerConnector)var12_17;
                                $i$a$-find-MavenServerManagerImpl$createLegacyIndexer$2$create$2$1 = false;
                                var15_20 = c.getMultimoduleDirectories();
                                for (T var17_22 : var15_20) {
                                    mDir = (String)var17_22;
                                    $i$a$-find-MavenServerManagerImpl$createLegacyIndexer$2$create$2$1$1 = false;
                                    v0 = var5_8;
                                    Intrinsics.checkNotNull((Object)v0);
                                    v1 = mDir;
                                    Intrinsics.checkNotNull((Object)v1);
                                    if (!FileUtil.isAncestor((String)v0, (String)v1, (boolean)false)) continue;
                                    v2 = var17_22;
                                    ** GOTO lbl39
                                }
                                v2 = null;
lbl39:
                                // 2 sources

                                v3 = v2 != null;
                                if (!v3) continue;
                                v4 = var12_17;
                                ** GOTO lbl44
                            }
                            v4 = null;
lbl44:
                            // 2 sources

                            var9_14.element = v4;
                            var7_11 = Unit.INSTANCE;
                        }
                        if (connector.element != null) {
                            v5 = connector.element;
                            Intrinsics.checkNotNull((Object)v5);
                            return ((MavenServerConnector)v5).createIndexer();
                        }
                        v6 = workingDirectory = (String)ObjectUtils.chooseNotNull((Object)this.$project.getBasePath(), (Object)SystemUtils.getUserHome().getAbsolutePath());
                        Intrinsics.checkNotNull((Object)v6);
                        $continuation.label = 1;
                        v7 = this.this$0.getConnector(this.$project, v6, (Continuation<? super MavenServerConnector>)$continuation);
                        if (v7 == var22_4) {
                            return var22_4;
                        }
                        ** GOTO lbl64
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl64:
                        // 2 sources

                        return ((MavenServerConnector)v7).createIndexer();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        };
    }

    private static final void restartMavenConnectors$lambda$2$lambda$1(Project $project, Predicate $condition, MavenServerManagerImpl this$0, List $connectorsToShutDown, MavenServerConnector it) {
        MavenServerConnector removedConnector;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)$project, (Object)it.getProject()) && $condition.test(it) && (removedConnector = this$0.removeConnector(it)) != null) {
            $connectorsToShutDown.add(removedConnector);
        }
    }

    private static final MavenServerConnector getConnector$lambda$3(MavenServerManagerImpl this$0, Project $project, String $workingDirectory) {
        return this$0.doGetConnector($project, $workingDirectory);
    }

    private static final Boolean registerDisposable$lambda$6$lambda$5(MavenServerManagerImpl this$0, MavenServerConnector $connector) {
        return this$0.shutdownConnector($connector, false);
    }

    private static final void registerDisposable$lambda$6(MavenServerManagerImpl this$0, MavenServerConnector $connector) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> MavenServerManagerImpl.registerDisposable$lambda$6$lambda$5(this$0, $connector));
    }

    private static final boolean removeConnector$lambda$9$lambda$7(MavenServerConnector $connector, Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getValue() == $connector;
    }

    private static final boolean removeConnector$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void closeAllConnectorsEventually$lambda$10(MavenServerManagerImpl this$0) {
        this$0.shutdownNow();
    }

    private static final void shutdownNow$lambda$12(MavenServerManagerImpl this$0, MavenServerConnector c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this$0.shutdownConnector(c, true);
    }

    public static final /* synthetic */ Map access$getMyMultimoduleDirToConnectorMap$p(MavenServerManagerImpl $this) {
        return $this.myMultimoduleDirToConnectorMap;
    }

    public static final /* synthetic */ MavenIndexingConnectorImpl access$getMyIndexingConnector$p(MavenServerManagerImpl $this) {
        return $this.myIndexingConnector;
    }

    public static final /* synthetic */ void access$setMyIndexingConnector$p(MavenServerManagerImpl $this, MavenIndexingConnectorImpl mavenIndexingConnectorImpl) {
        $this.myIndexingConnector = mavenIndexingConnectorImpl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerManagerImpl$Companion;", "", "<init>", "()V", "freeDebugPort", "", "getFreeDebugPort", "()Ljava/lang/Integer;", "getJdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lorg/jetbrains/idea/maven/project/MavenWorkspaceSettings;", "compatibleParameters", "", "connector", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "jdk", "multimoduleDirectory", "", "eventSpyPathForLocalBuild", "Ljava/io/File;", "getEventSpyPathForLocalBuild", "()Ljava/io/File;", "convertSettings", "Lorg/jetbrains/idea/maven/server/MavenServerSettings;", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "multiModuleProjectDirectory", "getGlobalConfigFromMavenConfig", "transformer", "Lorg/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final Integer getFreeDebugPort() {
            if (Registry.Companion.is("maven.server.debug")) {
                try {
                    return NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    MavenLog.LOG.warn((Throwable)e);
                }
            }
            return null;
        }

        private final Sdk getJdk(Project project, MavenWorkspaceSettings settings) {
            String string = settings.getImportingSettings().getJdkForImporter();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJdkForImporter(...)");
            String jdkForImporterName = string;
            Sdk jdk = null;
            try {
                jdk = MavenUtil.getJdk(project, jdkForImporterName);
            }
            catch (ExternalSystemJdkException e) {
                jdk = MavenUtil.getJdk(project, "#USE_PROJECT_JDK");
                MavenSyncConsole mavenSyncConsole = MavenProjectsManager.getInstance(project).getSyncConsole();
                String string2 = SyncBundle.message("importing.jdk.changed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                Object[] objectArray = new Object[]{jdkForImporterName, jdk.getName()};
                String string3 = SyncBundle.message("importing.jdk.changed.description", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                mavenSyncConsole.addWarning(string2, string3);
            }
            if (JavaSdkVersionUtil.isAtLeast((Sdk)jdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_8)) {
                return jdk;
            }
            MavenLog.LOG.info("Selected jdk [" + jdk.getName() + "] is not JDK1.8+ Will use internal jdk instead");
            Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInternalJdk(...)");
            return sdk;
        }

        private final boolean compatibleParameters(Project project, MavenServerConnector connector, Sdk jdk, String multimoduleDirectory) {
            if (Registry.Companion.is("maven.server.per.idea.project")) {
                return true;
            }
            MavenDistributionsCache cache = MavenDistributionsCache.getInstance(project);
            MavenDistribution mavenDistribution = cache.getMavenDistribution(multimoduleDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
            MavenDistribution distribution = mavenDistribution;
            String string = cache.getVmOptions(multimoduleDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVmOptions(...)");
            String vmOptions = string;
            return connector.isCompatibleWith(jdk, vmOptions, distribution);
        }

        private final File getEventSpyPathForLocalBuild() {
            File root = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
            return new File(root.getParent(), "intellij.maven.server.eventListener");
        }

        private final MavenServerSettings convertSettings(Project project, MavenGeneralSettings settings, String multiModuleProjectDirectory) {
            MavenGeneralSettings settings2 = settings;
            if (settings2 == null) {
                settings2 = MavenWorkspaceSettingsComponent.getInstance(project).getSettings().getGeneralSettings();
            }
            RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(project);
            MavenServerSettings result2 = new MavenServerSettings();
            MavenGeneralSettings mavenGeneralSettings = settings2;
            Intrinsics.checkNotNull((Object)mavenGeneralSettings);
            result2.setLoggingLevel(mavenGeneralSettings.getOutputLevel().getLevel());
            result2.setOffline(settings2.isWorkOffline());
            result2.setUpdateSnapshots(settings2.isAlwaysUpdateSnapshots());
            MavenDistribution mavenDistribution = MavenDistributionsCache.getInstance(project).getMavenDistribution(multiModuleProjectDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
            MavenDistribution mavenDistribution2 = mavenDistribution;
            String remotePath = transformer.toRemotePath(((Object)mavenDistribution2.getMavenHome()).toString());
            result2.setMavenHomePath(remotePath);
            File userSettings = MavenWslUtil.getUserSettings(project, settings2.getUserSettingsFile(), settings2.getMavenConfig());
            String userSettingsPath = ((Object)userSettings.toPath().toAbsolutePath()).toString();
            result2.setUserSettingsPath(transformer.toRemotePath(userSettingsPath));
            String string = settings2.getLocalRepository();
            File file = mavenDistribution2.getMavenHome().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            String localRepository = MavenWslUtil.getLocalRepo(project, string, new MavenInSpecificPath(file), settings2.getUserSettingsFile(), settings2.getMavenConfig()).getAbsolutePath();
            result2.setLocalRepositoryPath(transformer.toRemotePath(localRepository));
            Intrinsics.checkNotNull((Object)transformer);
            File file2 = this.getGlobalConfigFromMavenConfig(project, settings2, transformer);
            if (file2 == null) {
                file2 = MavenUtil.resolveGlobalSettingsFile(mavenDistribution2.getMavenHome().toFile());
            }
            result2.setGlobalSettingsPath(transformer.toRemotePath(file2.getAbsolutePath()));
            return result2;
        }

        private final File getGlobalConfigFromMavenConfig(Project project, MavenGeneralSettings settings, RemotePathTransformerFactory.Transformer transformer) {
            MavenConfig mavenConfig = settings.getMavenConfig();
            if (mavenConfig == null) {
                return null;
            }
            String filePath = mavenConfig.getFilePath(MavenConfigSettings.ALTERNATE_GLOBAL_SETTINGS);
            if (filePath == null) {
                return null;
            }
            return new File(filePath);
        }

        public static final /* synthetic */ MavenServerSettings access$convertSettings(Companion $this, Project project, MavenGeneralSettings settings, String multiModuleProjectDirectory) {
            return $this.convertSettings(project, settings, multiModuleProjectDirectory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

