/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.plugins.groovy;

import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.plugins.groovy.GroovyPluginConfiguratorKt;
import org.jetbrains.idea.maven.project.MavenProject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "CONTRIBUTOR_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$PluginContributor;", "getAdditionalFolders", "Ljava/util/stream/Stream;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AdditionalFolder;", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$FoldersContext;", "getGroovySources", "Lkotlin/sequences/Sequence;", "", "isForMain", "", "getFoldersToExclude", "getGroovyPluginsInProject", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "PluginContributor", "GroovyPlugin", "KnownPlugins", "intellij.maven"})
public final class GroovyPluginConfigurator
implements MavenWorkspaceConfigurator {
    @NotNull
    private final ExtensionPointName<PluginContributor> CONTRIBUTOR_EP = ExtensionPointName.Companion.create("org.jetbrains.idea.maven.importing.groovy.foldersConfiguratorContributor");

    @Override
    @NotNull
    public Stream<MavenWorkspaceConfigurator.AdditionalFolder> getAdditionalFolders(@NotNull MavenWorkspaceConfigurator.FoldersContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return StreamsKt.asStream((Sequence)SequencesKt.plus((Sequence)SequencesKt.map(this.getGroovySources(context2, true), GroovyPluginConfigurator::getAdditionalFolders$lambda$0), (Sequence)SequencesKt.map(this.getGroovySources(context2, false), GroovyPluginConfigurator::getAdditionalFolders$lambda$1)));
    }

    private final Sequence<String> getGroovySources(MavenWorkspaceConfigurator.FoldersContext context2, boolean isForMain) {
        return SequencesKt.flatMapIterable(this.getGroovyPluginsInProject(context2), arg_0 -> GroovyPluginConfigurator.getGroovySources$lambda$2(isForMain, arg_0));
    }

    @Override
    @NotNull
    public Stream<String> getFoldersToExclude(@NotNull MavenWorkspaceConfigurator.FoldersContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return StreamsKt.asStream((Sequence)SequencesKt.flatMapIterable(this.getGroovyPluginsInProject(context2), arg_0 -> GroovyPluginConfigurator.getFoldersToExclude$lambda$3(context2, arg_0)));
    }

    private final Sequence<MavenPlugin> getGroovyPluginsInProject(MavenWorkspaceConfigurator.FoldersContext context2) {
        Sequence sequence = ArraysKt.asSequence((Object[])KnownPlugins.values());
        Stream stream = this.CONTRIBUTOR_EP.getExtensionList().stream().flatMap(arg_0 -> GroovyPluginConfigurator.getGroovyPluginsInProject$lambda$5(GroovyPluginConfigurator::getGroovyPluginsInProject$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"flatMap(...)");
        Sequence allPlugins = SequencesKt.plus((Sequence)sequence, (Sequence)StreamsKt.asSequence(stream));
        return SequencesKt.mapNotNull((Sequence)allPlugins, arg_0 -> GroovyPluginConfigurator.getGroovyPluginsInProject$lambda$6(context2, arg_0));
    }

    private static final MavenWorkspaceConfigurator.AdditionalFolder getAdditionalFolders$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MavenWorkspaceConfigurator.AdditionalFolder(it, MavenWorkspaceConfigurator.FolderType.SOURCE);
    }

    private static final MavenWorkspaceConfigurator.AdditionalFolder getAdditionalFolders$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new MavenWorkspaceConfigurator.AdditionalFolder(it, MavenWorkspaceConfigurator.FolderType.TEST_SOURCE);
    }

    private static final Iterable getGroovySources$lambda$2(boolean $isForMain, MavenPlugin it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GroovyPluginConfiguratorKt.collectGroovyFolders(it, $isForMain);
    }

    private static final Iterable getFoldersToExclude$lambda$3(MavenWorkspaceConfigurator.FoldersContext $context, MavenPlugin it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GroovyPluginConfiguratorKt.collectIgnoredFolders($context.getMavenProject(), it);
    }

    private static final Stream getGroovyPluginsInProject$lambda$4(PluginContributor it) {
        return it.getAdditionalPlugins().stream();
    }

    private static final Stream getGroovyPluginsInProject$lambda$5(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final MavenPlugin getGroovyPluginsInProject$lambda$6(MavenWorkspaceConfigurator.FoldersContext $context, GroovyPlugin it) {
        return it.findInProject($context.getMavenProject());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0010J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin;", "", "groupId", "", "getGroupId", "()Ljava/lang/String;", "artifactId", "getArtifactId", "requiredDependency", "Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin$PluginDependency;", "getRequiredDependency", "()Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin$PluginDependency;", "findInProject", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "PluginDependency", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nGroovyPluginConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyPluginConfigurator.kt\norg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n2632#2,3:101\n*S KotlinDebug\n*F\n+ 1 GroovyPluginConfigurator.kt\norg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin\n*L\n36#1:101,3\n*E\n"})
    public static interface GroovyPlugin {
        @NotNull
        public String getGroupId();

        @NotNull
        public String getArtifactId();

        @Nullable
        public PluginDependency getRequiredDependency();

        @Nullable
        default public MavenPlugin findInProject(@NotNull MavenProject mavenProject) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            MavenPlugin plugin = MavenProject.findPlugin$default(mavenProject, this.getGroupId(), this.getArtifactId(), false, 4, null);
            if (plugin == null) {
                return null;
            }
            PluginDependency dependency = this.getRequiredDependency();
            if (dependency != null) {
                boolean bl;
                block6: {
                    List list = plugin.getDependencies();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
                    Iterable $this$none$iv = list;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            MavenId id = (MavenId)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)dependency.getGroupId(), (Object)id.getGroupId()) && Intrinsics.areEqual((Object)dependency.getArtifactId(), (Object)id.getArtifactId()))) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return null;
                }
            }
            return plugin;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin$PluginDependency;", "", "groupId", "", "artifactId", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getGroupId", "()Ljava/lang/String;", "getArtifactId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.maven"})
        public static final class PluginDependency {
            @NotNull
            private final String groupId;
            @NotNull
            private final String artifactId;

            public PluginDependency(@NotNull String groupId, @NotNull String artifactId) {
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                this.groupId = groupId;
                this.artifactId = artifactId;
            }

            @NotNull
            public final String getGroupId() {
                return this.groupId;
            }

            @NotNull
            public final String getArtifactId() {
                return this.artifactId;
            }

            @NotNull
            public final String component1() {
                return this.groupId;
            }

            @NotNull
            public final String component2() {
                return this.artifactId;
            }

            @NotNull
            public final PluginDependency copy(@NotNull String groupId, @NotNull String artifactId) {
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                return new PluginDependency(groupId, artifactId);
            }

            public static /* synthetic */ PluginDependency copy$default(PluginDependency pluginDependency, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = pluginDependency.groupId;
                }
                if ((n & 2) != 0) {
                    string2 = pluginDependency.artifactId;
                }
                return pluginDependency.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "PluginDependency(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ")";
            }

            public int hashCode() {
                int result2 = this.groupId.hashCode();
                result2 = result2 * 31 + this.artifactId.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PluginDependency)) {
                    return false;
                }
                PluginDependency pluginDependency = (PluginDependency)other;
                if (!Intrinsics.areEqual((Object)this.groupId, (Object)pluginDependency.groupId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.artifactId, (Object)pluginDependency.artifactId);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B%\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$KnownPlugins;", "Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin;", "", "groupId", "", "artifactId", "requiredDependency", "Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin$PluginDependency;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin$PluginDependency;)V", "getGroupId", "()Ljava/lang/String;", "getArtifactId", "getRequiredDependency", "()Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin$PluginDependency;", "GROOVY_1_0", "GROOVY_1_1_PLUS", "GROOVY_GMAVEN", "GROOVY_GMAVEN_PLUS", "GROOVY_ECLIPSE_COMPILER", "intellij.maven"})
    public static final class KnownPlugins
    extends Enum<KnownPlugins>
    implements GroovyPlugin {
        @NotNull
        private final String groupId;
        @NotNull
        private final String artifactId;
        @Nullable
        private final GroovyPlugin.PluginDependency requiredDependency;
        public static final /* enum */ KnownPlugins GROOVY_1_0 = new KnownPlugins("GROOVY_1_0", 0, "org.codehaus.groovy.maven", "gmaven-plugin", null, 4, null);
        public static final /* enum */ KnownPlugins GROOVY_1_1_PLUS = new KnownPlugins("GROOVY_1_1_PLUS", 1, "org.codehaus.gmaven", "gmaven-plugin", null, 4, null);
        public static final /* enum */ KnownPlugins GROOVY_GMAVEN = new KnownPlugins("GROOVY_GMAVEN", 2, "org.codehaus.gmaven", "groovy-maven-plugin", null, 4, null);
        public static final /* enum */ KnownPlugins GROOVY_GMAVEN_PLUS = new KnownPlugins("GROOVY_GMAVEN_PLUS", 3, "org.codehaus.gmavenplus", "gmavenplus-plugin", null, 4, null);
        public static final /* enum */ KnownPlugins GROOVY_ECLIPSE_COMPILER = new KnownPlugins("org.apache.maven.plugins", "maven-compiler-plugin", new GroovyPlugin.PluginDependency("org.codehaus.groovy", "groovy-eclipse-compiler"));
        private static final /* synthetic */ KnownPlugins[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private KnownPlugins(String groupId, String artifactId, GroovyPlugin.PluginDependency requiredDependency) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.requiredDependency = requiredDependency;
        }

        /* synthetic */ KnownPlugins(String string, int n, String string2, String string3, GroovyPlugin.PluginDependency pluginDependency, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                pluginDependency = null;
            }
            this(string2, string3, pluginDependency);
        }

        @Override
        @NotNull
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        @NotNull
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        @Nullable
        public GroovyPlugin.PluginDependency getRequiredDependency() {
            return this.requiredDependency;
        }

        public static KnownPlugins[] values() {
            return (KnownPlugins[])$VALUES.clone();
        }

        public static KnownPlugins valueOf(String value) {
            return Enum.valueOf(KnownPlugins.class, value);
        }

        @NotNull
        public static EnumEntries<KnownPlugins> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = knownPluginsArray = new KnownPlugins[]{KnownPlugins.GROOVY_1_0, KnownPlugins.GROOVY_1_1_PLUS, KnownPlugins.GROOVY_GMAVEN, KnownPlugins.GROOVY_GMAVEN_PLUS, KnownPlugins.GROOVY_ECLIPSE_COMPILER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$PluginContributor;", "", "getAdditionalPlugins", "", "Lorg/jetbrains/idea/maven/plugins/groovy/GroovyPluginConfigurator$GroovyPlugin;", "intellij.maven"})
    public static interface PluginContributor {
        @NotNull
        public List<GroovyPlugin> getAdditionalPlugins();
    }
}

