/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import com.intellij.util.ArrayUtilRt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightJavaInspectionTestCase
extends LightJavaCodeInsightFixtureTestCase {
    public static final String INSPECTION_GADGETS_TEST_DATA_PATH = "/java/java-tests/testData/ig/";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        for (String environmentClass : this.getEnvironmentClasses()) {
            this.myFixture.addClass(environmentClass);
        }
        InspectionProfileEntry inspection = this.getInspection();
        if (inspection != null) {
            this.myFixture.enableInspections(inspection);
            Project project = this.myFixture.getProject();
            HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)inspection.getShortName());
            InspectionProfileImpl currentProfile = ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile();
            HighlightDisplayLevel errorLevel = currentProfile.getErrorLevel(displayKey, null);
            if (errorLevel == HighlightDisplayLevel.DO_NOT_SHOW) {
                currentProfile.setErrorLevel(displayKey, HighlightDisplayLevel.WARNING, project);
            }
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)ModuleManager.getInstance((Project)this.getProject()).getModules()[0]).getSdk();
        if (((LightJavaCodeInsightFixtureTestCase.ProjectDescriptor)JAVA_1_7).getSdkName().equals(sdk == null ? null : sdk.getName())) {
            PsiClass object = JavaPsiFacade.getInstance((Project)this.getProject()).findClass("java.lang.Object", GlobalSearchScope.allScope((Project)this.getProject()));
            LightJavaInspectionTestCase.assertNotNull((Object)object);
            PsiClass component = JavaPsiFacade.getInstance((Project)this.getProject()).findClass("java.awt.Component", GlobalSearchScope.allScope((Project)this.getProject()));
            LightJavaInspectionTestCase.assertNotNull((Object)component);
        }
    }

    @Nullable
    protected abstract InspectionProfileEntry getInspection();

    @Language(value="JAVA")
    protected String[] getEnvironmentClasses() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    protected void addEnvironmentClass(@Language(value="JAVA") @NotNull String classText) {
        if (classText == null) {
            LightJavaInspectionTestCase.$$$reportNull$$$0(0);
        }
        this.myFixture.addClass(classText);
    }

    protected final void doStatementTest(@Language(value="JAVA", prefix="@SuppressWarnings(\"all\") class X { void m() {", suffix="}}") @NotNull String statementText) {
        if (statementText == null) {
            LightJavaInspectionTestCase.$$$reportNull$$$0(1);
        }
        this.doTest("class X { void m() {" + statementText + "}}");
    }

    protected final void doMemberTest(@Language(value="JAVA", prefix="@SuppressWarnings(\"all\") class X {", suffix="}") @NotNull String memberText) {
        if (memberText == null) {
            LightJavaInspectionTestCase.$$$reportNull$$$0(2);
        }
        this.doTest("class X {" + memberText + "}");
    }

    protected final void doTest(@Language(value="JAVA") @NotNull String classText) {
        if (classText == null) {
            LightJavaInspectionTestCase.$$$reportNull$$$0(3);
        }
        this.doTest(classText, "X.java");
    }

    protected final void assertQuickFixNotAvailable(String name) {
        LightJavaInspectionTestCase.assertEmpty(this.myFixture.filterAvailableIntentions(name));
    }

    protected final void checkQuickFix(String name, @Language(value="JAVA") String result) {
        IntentionAction intention = this.myFixture.getAvailableIntention(name, new String[0]);
        LightJavaInspectionTestCase.assertNotNull((Object)intention);
        this.myFixture.launchAction(intention);
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        this.myFixture.checkResult(result);
    }

    protected final void checkQuickFix(String intentionName) {
        IntentionAction intention = this.myFixture.getAvailableIntention(intentionName, new String[0]);
        LightJavaInspectionTestCase.assertNotNull((Object)intention);
        this.myFixture.launchAction(intention);
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        this.myFixture.checkResultByFile(this.getTestName(false) + ".after.java");
    }

    protected final void checkQuickFixAll() {
        InspectionProfileEntry inspection = InspectionTestUtil.instantiateTool(this.getInspectionClass());
        assert (inspection != null) : "getInspection() needs to return a non-null value for checkQuickFixAll() to work";
        this.checkQuickFix(InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{inspection.getDisplayName()}));
    }

    protected final void doTest(@Language(value="JAVA") @NotNull String classText, String fileName) {
        if (classText == null) {
            LightJavaInspectionTestCase.$$$reportNull$$$0(4);
        }
        StringBuilder newText = new StringBuilder();
        int start = 0;
        int end = classText.indexOf("/*");
        while (end >= 0) {
            newText.append(classText, start, end);
            start = end + 2;
            end = classText.indexOf("*/", end);
            if (end < 0) {
                throw new IllegalArgumentException("invalid class text");
            }
            String text = classText.substring(start, end);
            if (text.isEmpty()) {
                newText.append("</warning>");
            } else if ("!".equals(text)) {
                newText.append("</error>");
            } else if ("_".equals(text)) {
                newText.append("<caret>");
            } else if (text.startsWith("!")) {
                newText.append("<error descr=\"").append(text.substring(1)).append("\">");
            } else if (text.startsWith(" ")) {
                newText.append("/*").append(text).append("*/");
            } else {
                newText.append("<warning descr=\"").append(text).append("\">");
            }
            start = end + 2;
            end = classText.indexOf("/*", end + 1);
        }
        newText.append(classText, start, classText.length());
        this.myFixture.configureByText(fileName, newText.toString());
        this.myFixture.testHighlighting(true, false, false, new String[0]);
    }

    @Override
    protected String getBasePath() {
        String className = this.getInspectionClass().getName();
        String[] words = className.split("\\.");
        StringBuilder basePath = new StringBuilder(INSPECTION_GADGETS_TEST_DATA_PATH);
        int lastWordIndex = words.length - 1;
        for (int i2 = 0; i2 < lastWordIndex; ++i2) {
            String word = words[i2];
            if (word.equals("ig")) {
                word = "igtest";
            }
            basePath.append(word).append('/');
        }
        String lastWord = words[lastWordIndex];
        lastWord = StringUtil.trimEnd((String)lastWord, (String)"Inspection");
        int length = lastWord.length();
        boolean upperCase = false;
        for (int i3 = 0; i3 < length; ++i3) {
            char ch = lastWord.charAt(i3);
            if (Character.isUpperCase(ch)) {
                if (!upperCase) {
                    upperCase = true;
                    if (i3 != 0) {
                        basePath.append('_');
                    }
                }
                basePath.append(Character.toLowerCase(ch));
                continue;
            }
            upperCase = false;
            basePath.append(ch);
        }
        return basePath.toString();
    }

    protected Class<? extends InspectionProfileEntry> getInspectionClass() {
        InspectionProfileEntry inspection = this.getInspection();
        LightJavaInspectionTestCase.assertNotNull((String)"File-based tests should either return an inspection or override this method", (Object)inspection);
        return inspection.getClass();
    }

    protected final void doTest() {
        this.doNamedTest(this.getTestName(false));
    }

    protected final void doNamedTest(String name) {
        this.myFixture.configureByFile(name + ".java");
        this.myFixture.testHighlighting(true, false, false, new String[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberText";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/LightJavaInspectionTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addEnvironmentClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doStatementTest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doMemberTest";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doTest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

