/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.codeVision;

import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.CodeVisionHost;
import com.intellij.codeInsight.codeVision.CodeVisionInitializer;
import com.intellij.codeInsight.codeVision.CodeVisionProvider;
import com.intellij.codeInsight.codeVision.settings.CodeVisionSettings;
import com.intellij.codeInsight.codeVision.ui.model.CodeVisionListData;
import com.intellij.codeInsight.codeVision.ui.renderers.CodeVisionInlayRenderer;
import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0014J1\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0010\"\u00020\rH\u0004\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/utils/codeVision/CodeVisionTestCase;", "Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase;", "<init>", "()V", "onlyCodeVisionHintsAllowed", "", "getOnlyCodeVisionHintsAllowed", "()Z", "setUp", "", "tearDown", "testProviders", "expectedText", "", "fileName", "enabledProviderGroupIds", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "dumpCodeVisionHints", "sourceText", "Companion", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nCodeVisionTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionTestCase.kt\ncom/intellij/testFramework/utils/codeVision/CodeVisionTestCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1863#2,2:82\n1557#2:84\n1628#2,3:85\n1863#2,2:88\n1863#2,2:90\n*S KotlinDebug\n*F\n+ 1 CodeVisionTestCase.kt\ncom/intellij/testFramework/utils/codeVision/CodeVisionTestCase\n*L\n34#1:82,2\n50#1:84\n50#1:85,3\n50#1:88,2\n59#1:90,2\n*E\n"})
public abstract class CodeVisionTestCase
extends InlayHintsProviderTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String AUTHOR_HINT = "John Smith +2";

    protected boolean getOnlyCodeVisionHintsAllowed() {
        return false;
    }

    @Override
    protected void setUp() {
        RegistryValue registryValue = Registry.Companion.get("editor.codeVision.new");
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getTestRootDisposable(...)");
        registryValue.setValue(true, disposable);
        TestModeFlags.set((Key)CodeVisionHost.Companion.isCodeVisionTestKey(), (Object)true, (Disposable)this.getTestRootDisposable());
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() {
        try {
            CodeVisionSettings settings = CodeVisionSettings.Companion.getInstance();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            CodeVisionHost codeVisionHost = CodeVisionInitializer.Companion.getInstance(project).getCodeVisionHost();
            Iterable $this$forEach$iv = codeVisionHost.getProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CodeVisionProvider it = (CodeVisionProvider)element$iv;
                boolean bl = false;
                settings.setProviderEnabled(it.getGroupId(), true);
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void testProviders(@NotNull String expectedText, @NotNull String fileName, String ... enabledProviderGroupIds) {
        Iterator $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)enabledProviderGroupIds, (String)"enabledProviderGroupIds");
        CodeVisionSettings settings = CodeVisionSettings.Companion.getInstance();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CodeVisionHost codeVisionHost = CodeVisionInitializer.Companion.getInstance(project).getCodeVisionHost();
        Iterable $this$map$iv = codeVisionHost.getProviders();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            CodeVisionProvider codeVisionProvider = (CodeVisionProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGroupId());
        }
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            settings.setProviderEnabled(it, ArraysKt.contains((Object[])enabledProviderGroupIds, (Object)it));
        }
        String sourceText = InlayDumpUtil.INSTANCE.removeHints(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        Editor editor2 = this.myFixture.getEditor();
        this.getProject().putUserData(CodeVisionHost.Companion.isCodeVisionTestKey(), (Object)true);
        Iterable $this$forEach$iv2 = codeVisionHost.getProviders();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CodeVisionProvider it = (CodeVisionProvider)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getId(), (Object)"vcs.code.vision") || !ArraysKt.contains((Object[])enabledProviderGroupIds, (Object)it.getGroupId())) continue;
            Editor editor3 = this.myFixture.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
            PsiFile psiFile = this.myFixture.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
            it.preparePreview(editor3, psiFile);
        }
        this.myFixture.doHighlighting();
        Intrinsics.checkNotNull((Object)editor2);
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getTestRootDisposable(...)");
        codeVisionHost.calculateCodeVisionSync(editor2, disposable);
        String actualText = this.dumpCodeVisionHints(sourceText);
        BasePlatformTestCase.assertEquals((String)expectedText, (String)actualText);
    }

    private final String dumpCodeVisionHints(String sourceText) {
        Function1 function1 = arg_0 -> CodeVisionTestCase.dumpCodeVisionHints$lambda$4(this, arg_0);
        Function2 function2 = CodeVisionTestCase::dumpCodeVisionHints$lambda$6;
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        PsiFile psiFile2 = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile2);
        Document document = this.myFixture.getDocument(psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return InlayDumpUtil.dumpHintsInternal$default((InlayDumpUtil)InlayDumpUtil.INSTANCE, (String)sourceText, (Function1)function1, (Function2)function2, (PsiFile)psiFile, (Editor)editor2, (Document)document, (int)0, (int)64, null);
    }

    private static final boolean dumpCodeVisionHints$lambda$4(CodeVisionTestCase this$0, Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean rendererSupported = it.getRenderer() instanceof CodeVisionInlayRenderer;
        if (this$0.getOnlyCodeVisionHintsAllowed() && !rendererSupported) {
            throw new IllegalStateException("renderer not supported".toString());
        }
        return rendererSupported;
    }

    private static final CharSequence dumpCodeVisionHints$lambda$6$lambda$5(CodeVisionEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLongPresentation();
    }

    private static final String dumpCodeVisionHints$lambda$6(EditorCustomElementRenderer editorCustomElementRenderer, Inlay inlay) {
        Intrinsics.checkNotNullParameter((Object)editorCustomElementRenderer, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)inlay, (String)"inlay");
        Object object = inlay.getUserData(CodeVisionListData.KEY);
        Intrinsics.checkNotNull((Object)object);
        return CollectionsKt.joinToString$default((Iterable)((CodeVisionListData)object).getVisibleLens(), (CharSequence)"   ", (CharSequence)"[", (CharSequence)"]", (int)0, null, CodeVisionTestCase::dumpCodeVisionHints$lambda$6$lambda$5, (int)24, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/testFramework/utils/codeVision/CodeVisionTestCase$Companion;", "", "<init>", "()V", "AUTHOR_HINT", "", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

