/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.structuralsearch.MatchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExprTypePredicate
extends MatchPredicate {
    private final RegExpPredicate myDelegate;
    private final boolean myWithinHierarchy;
    private final boolean needsTypeParameters;
    private final boolean needsFullyQualified;
    private final boolean needsArrayType;
    private final boolean needsAnnotations;
    private final boolean myCaseSensitive;
    private final List<String> myTypes;

    public ExprTypePredicate(@NotNull String type, String baseName, boolean withinHierarchy, boolean caseSensitiveMatch, boolean target, boolean regex) {
        if (type == null) {
            ExprTypePredicate.$$$reportNull$$$0(0);
        }
        this.myDelegate = regex ? new RegExpPredicate(type, caseSensitiveMatch, baseName, false, target) : null;
        this.myWithinHierarchy = withinHierarchy;
        this.needsTypeParameters = type.indexOf(60) >= 0;
        this.needsFullyQualified = type.indexOf(46) >= 0;
        this.needsArrayType = type.indexOf(91) >= 0;
        this.needsAnnotations = type.indexOf(64) >= 0;
        this.myCaseSensitive = caseSensitiveMatch;
        this.myTypes = regex ? null : ExprTypePredicate.split(type);
    }

    private static List<String> split(String types) {
        int index;
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while ((index = types.indexOf(124, pos)) != -1) {
            String token = MatchUtil.normalizeWhiteSpace((String)types.substring(pos, index));
            if (!token.isEmpty()) {
                result.add(token);
            }
            pos = index + 1;
        }
        if (pos < types.length()) {
            result.add(MatchUtil.normalizeWhiteSpace((String)types.substring(pos)));
        }
        return result;
    }

    public boolean match(@NotNull PsiElement match, int start, int end, @NotNull MatchContext context) {
        if (match == null) {
            ExprTypePredicate.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ExprTypePredicate.$$$reportNull$$$0(2);
        }
        if (match instanceof PsiIdentifier) {
            match = match.getParent();
        } else if (match instanceof PsiExpressionStatement) {
            match = ((PsiExpressionStatement)match).getExpression();
        }
        if (!(match instanceof PsiExpression)) {
            return false;
        }
        PsiType type = this.evalType((PsiExpression)match, context);
        return type != null && this.doMatchWithTheType(type, context, match, null);
    }

    protected PsiType evalType(@NotNull PsiExpression match, @NotNull MatchContext context) {
        PsiElement psiElement;
        if (match == null) {
            ExprTypePredicate.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ExprTypePredicate.$$$reportNull$$$0(4);
        }
        if (match instanceof PsiFunctionalExpression) {
            PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)match;
            return functionalExpression.getFunctionalInterfaceType();
        }
        if (match instanceof PsiReferenceExpression && (psiElement = match.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)psiElement;
            return call.getType();
        }
        return match.getType();
    }

    private boolean doMatchWithTheType(@NotNull PsiType type, @NotNull MatchContext context, @NotNull PsiElement matchedNode, @Nullable Set<? super PsiType> visited) {
        if (type == null) {
            ExprTypePredicate.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ExprTypePredicate.$$$reportNull$$$0(6);
        }
        if (matchedNode == null) {
            ExprTypePredicate.$$$reportNull$$$0(7);
        }
        List<String> permutations = this.getTextPermutations(type);
        for (String permutation : permutations) {
            if (!(this.myDelegate == null ? this.doMatch(permutation) : this.myDelegate.doMatch(permutation, context, matchedNode))) continue;
            return true;
        }
        if (this.myWithinHierarchy) {
            if (visited == null) {
                visited = new HashSet<PsiType>();
                visited.add((PsiType)type);
            }
            for (PsiType superType : type.getSuperTypes()) {
                if (!visited.add((PsiType)superType) || !this.doMatchWithTheType(superType, context, matchedNode, visited)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doMatch(String text) {
        return ContainerUtil.exists(this.myTypes, type -> this.myCaseSensitive ? type.equals(text) : type.equalsIgnoreCase(text));
    }

    private List<String> getTextPermutations(PsiType type) {
        String dimensions;
        String annotationString = this.getAnnotationString(type);
        if (type instanceof PsiArrayType) {
            if (!this.needsArrayType) {
                return Collections.emptyList();
            }
            dimensions = StringUtil.repeat((String)"[]", (int)type.getArrayDimensions());
            type = type.getDeepComponentType();
        } else {
            dimensions = "";
        }
        SmartList result = new SmartList();
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            StringBuilder typeText = new StringBuilder();
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                ExprTypePredicate.buildText(aClass, substitutor, true, typeText);
                typeText.append(dimensions);
                String typeString = annotationString + typeText;
                if (this.needsTypeParameters) {
                    result.add(typeString);
                }
                ExprTypePredicate.addWithoutTypeParameters(typeString, dimensions, (List<? super String>)result);
                if (typeText.indexOf(".") >= 0) {
                    typeText.setLength(0);
                    ExprTypePredicate.buildText(aClass, substitutor, false, typeText);
                    typeText.append(dimensions);
                    String outerClassQualified = annotationString + typeText;
                    if (this.needsTypeParameters) {
                        result.add(outerClassQualified);
                    }
                    ExprTypePredicate.addWithoutTypeParameters(outerClassQualified, dimensions, (List<? super String>)result);
                }
                if (!this.needsFullyQualified) {
                    return result;
                }
            }
        }
        String fullyQualified = annotationString + type.getCanonicalText() + dimensions;
        if (this.needsTypeParameters) {
            result.add(fullyQualified);
        }
        ExprTypePredicate.addWithoutTypeParameters(fullyQualified, dimensions, (List<? super String>)result);
        return result;
    }

    @NotNull
    private String getAnnotationString(PsiType type) {
        if (!this.needsAnnotations) {
            return "";
        }
        PsiAnnotation[] annotations = type.getAnnotations();
        if (annotations.length <= 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (PsiAnnotation annotation : annotations) {
            PsiElement referenceNameElement;
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null || (referenceNameElement = nameReferenceElement.getReferenceNameElement()) == null) continue;
            result.append('@').append(referenceNameElement.getText()).append(annotation.getParameterList().getText()).append(' ');
        }
        String string = result.toString();
        if (string == null) {
            ExprTypePredicate.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void addWithoutTypeParameters(String typeText, String suffix, List<? super String> result) {
        int lt = typeText.indexOf("<");
        if (lt >= 0) {
            result.add(typeText.substring(0, lt) + suffix);
        } else if (result.isEmpty() || !result.get(result.size() - 1).equals(typeText)) {
            result.add(typeText);
        }
    }

    private static void buildText(PsiClass aClass, PsiSubstitutor substitutor, boolean qualifyInnerClasses, StringBuilder text) {
        PsiTypeParameter[] parameters;
        PsiElement parent;
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            PsiClassType.ClassResolveResult baseResolveResult = baseClassType.resolveGenerics();
            PsiClass baseClass = baseResolveResult.getElement();
            if (baseClass != null) {
                ExprTypePredicate.buildText(baseClass, substitutor == null ? null : baseResolveResult.getSubstitutor(), qualifyInnerClasses, text);
            } else {
                text.append(baseClassType.getCanonicalText());
            }
            return;
        }
        if (qualifyInnerClasses && (parent = aClass.getParent()) instanceof PsiClass && !(parent instanceof PsiAnonymousClass)) {
            ExprTypePredicate.buildText((PsiClass)parent, substitutor, true, text);
            text.append('.');
        }
        text.append(aClass.getName());
        if (substitutor != null && (parameters = aClass.getTypeParameters()).length > 0) {
            int pos = text.length();
            text.append('<');
            Map substitutionMap = substitutor.getSubstitutionMap();
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                PsiClassType classType;
                PsiClassType.ClassResolveResult result;
                PsiClass aClass1;
                PsiTypeParameter parameter = parameters[i];
                PsiType parameterType = (PsiType)substitutionMap.get(parameter);
                if (parameterType == null) {
                    text.setLength(pos);
                    return;
                }
                if (i > 0) {
                    text.append(',');
                }
                if (parameterType instanceof PsiClassType && (aClass1 = (result = (classType = (PsiClassType)parameterType).resolveGenerics()).getElement()) != null) {
                    ExprTypePredicate.buildText(aClass1, result.getSubstitutor(), qualifyInnerClasses, text);
                    continue;
                }
                text.append(parameterType.getPresentableText());
            }
            text.append('>');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/predicates/ExprTypePredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/predicates/ExprTypePredicate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evalType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doMatchWithTheType";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

