/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.core.JavaPsiBundle;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.PsiCodeFragmentImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.JavaPredefinedConfigurations;
import com.intellij.structuralsearch.JavaReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.JavaCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.predicates.ExprTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.FormalArgTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaStructuralSearchProfile
extends StructuralSearchProfile {
    private static final Key<Map<String, ParameterInfo>> PARAMETER_CONTEXT = new Key("PARAMETER_CONTEXT");
    private static final Key<Integer> PARAMETER_LENGTH = new Key("PARAMETER_LENGTH");
    public static final PatternContext DEFAULT_CONTEXT = new PatternContext("default", () -> SSRBundle.message((String)"pattern.context.default", (Object[])new Object[0]));
    public static final PatternContext MEMBER_CONTEXT = new PatternContext("member", () -> SSRBundle.message((String)"pattern.context.class.member", (Object[])new Object[0]));
    private static final List<PatternContext> PATTERN_CONTEXTS = List.of(DEFAULT_CONTEXT, MEMBER_CONTEXT);
    private static final Set<String> PRIMITIVE_TYPES = Set.of("short", "boolean", "double", "long", "int", "float", "char", "byte");
    private static final Set<String> RESERVED_WORDS = Set.of("Modifier", "Instance", "packageLocal");

    @NotNull
    public String getText(@NotNull PsiElement match, int start, int end) {
        PsiElement parent;
        if (match == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        if (match instanceof PsiIdentifier && (parent = match.getParent()) instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            if (!(parent instanceof PsiExpression)) {
                String text = referenceElement.getText();
                if (end != -1) {
                    String string = text.substring(start, end);
                    if (string == null) {
                        JavaStructuralSearchProfile.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                if (parameterList != null) {
                    String string = text.substring(start, parameterList.getStartOffsetInParent());
                    if (string == null) {
                        JavaStructuralSearchProfile.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                String string = text;
                if (string == null) {
                    JavaStructuralSearchProfile.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            String string = matchText;
            if (string == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = matchText.substring(start, end == -1 ? matchText.length() : end);
        if (string == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getTypedVarString(@NotNull PsiElement element) {
        String text;
        if (element == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiReceiverParameter) {
            text = ((PsiReceiverParameter)element).getIdentifier().getText();
        } else if (element instanceof PsiNamedElement) {
            text = ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiAnnotation) {
            PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)element).getNameReferenceElement();
            text = referenceElement == null ? null : referenceElement.getText();
        } else if (element instanceof PsiNameValuePair) {
            text = ((PsiNameValuePair)element).getName();
        } else {
            int i;
            text = element.getText();
            if (StringUtil.startsWithChar((CharSequence)text, (char)'@')) {
                text = text.substring(1);
            }
            if (StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                text = text.substring(0, text.length() - 1);
            } else if (element instanceof PsiExpressionStatement && (i = text.indexOf(59)) != -1) {
                text = text.substring(0, i);
            }
        }
        if (text == null) {
            text = element.getText();
        }
        String string = text;
        if (string == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String getMeaningfulText(@NotNull PsiElement element) {
        if (element == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() != null) {
            String text;
            PsiElement resolve = ((PsiReferenceExpression)element).resolve();
            if (resolve instanceof PsiClass) {
                return element.getText();
            }
            PsiElement referencedElement = ((PsiReferenceExpression)element).getReferenceNameElement();
            String string = text = referencedElement != null ? referencedElement.getText() : "";
            if (resolve == null && !text.isEmpty() && Character.isUpperCase(text.charAt(0))) {
                return element.getText();
            }
            return text;
        }
        return super.getMeaningfulText(element);
    }

    @Nullable
    public String getAlternativeText(@NotNull PsiElement node, @NotNull String previousText) {
        if (node == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        if (previousText == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (node instanceof PsiJavaCodeReferenceElement || node instanceof PsiClass) {
            PsiElement element;
            PsiElement psiElement = element = node instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)node).resolve() : node;
            if (element instanceof PsiClass) {
                String text = ((PsiClass)element).getQualifiedName();
                if (previousText.equals(text)) {
                    text = ((PsiClass)element).getName();
                }
                return text;
            }
        } else if (node instanceof PsiLiteralExpression || node instanceof PsiComment) {
            return node.getText();
        }
        return null;
    }

    @NotNull
    public PsiElement updateCurrentNode(@NotNull PsiElement targetNode) {
        if (targetNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        if (targetNode instanceof PsiCodeBlock && ((PsiCodeBlock)targetNode).getStatementCount() == 1) {
            PsiElement targetNodeParent = targetNode.getParent();
            if (targetNodeParent instanceof PsiBlockStatement) {
                targetNodeParent = targetNodeParent.getParent();
            }
            if (targetNodeParent instanceof PsiIfStatement || targetNodeParent instanceof PsiLoopStatement) {
                targetNode = targetNodeParent;
            }
        }
        PsiElement psiElement = targetNode;
        if (psiElement == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement extendMatchedByDownUp(@NotNull PsiElement targetNode) {
        PsiElement parent;
        if (targetNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (targetNode instanceof PsiIdentifier) {
            targetNode = targetNode.getParent();
        }
        if ((parent = targetNode.getParent()) instanceof PsiTypeElement || parent instanceof PsiStatement || parent instanceof PsiLocalVariable) {
            targetNode = parent;
        }
        PsiElement psiElement = targetNode;
        if (psiElement == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement getPresentableElement(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(15);
        }
        if ((element = super.getPresentableElement(element)) instanceof PsiReferenceExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiMethodCallExpression) {
                PsiElement psiElement = parent2;
                if (psiElement == null) {
                    JavaStructuralSearchProfile.$$$reportNull$$$0(16);
                }
                return psiElement;
            }
        } else if (element instanceof PsiJavaCodeReferenceElement && ((parent = element.getParent()) instanceof PsiTypeElement || parent instanceof PsiNewExpression || parent instanceof PsiAnnotation || parent instanceof PsiAnonymousClass)) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(17);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    public void compile(PsiElement @NotNull [] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(19);
        }
        if (elements == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(20);
        }
        new JavaCompilingVisitor(globalVisitor).compile(elements);
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(21);
        }
        return new JavaMatchingVisitor(globalVisitor);
    }

    public boolean isMatchNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        if (element instanceof PsiJavaToken) {
            return element instanceof PsiKeyword && PRIMITIVE_TYPES.contains(element.getText()) && element.getParent() instanceof PsiNewExpression;
        }
        return true;
    }

    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new JavaCompiledPattern();
    }

    @NotNull
    public List<MatchPredicate> getCustomPredicates(@NotNull MatchVariableConstraint constraint, @NotNull String name, @NotNull MatchOptions options) {
        ExprTypePredicate predicate;
        if (constraint == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(22);
        }
        if (name == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(23);
        }
        if (options == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(24);
        }
        SmartList result = new SmartList();
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfExprType())) {
            predicate = new ExprTypePredicate(constraint.isRegexExprType() ? constraint.getNameOfExprType() : constraint.getExpressionTypes(), name, constraint.isExprTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults(), constraint.isRegexExprType());
            result.add(constraint.isInvertExprType() ? new NotPredicate((MatchPredicate)predicate) : predicate);
        }
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfFormalArgType())) {
            predicate = new FormalArgTypePredicate(constraint.isRegexFormalType() ? constraint.getNameOfFormalArgType() : constraint.getExpectedTypes(), name, constraint.isFormalArgTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults(), constraint.isRegexFormalType());
            result.add(constraint.isInvertFormalType() ? new NotPredicate((MatchPredicate)predicate) : predicate);
        }
        SmartList smartList = result;
        if (smartList == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(26);
        }
        return language == JavaLanguage.INSTANCE;
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(27);
        }
        if (replaceOptions == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(28);
        }
        return new JavaReplaceHandler(project, replaceOptions);
    }

    public boolean supportsShortenFQNames() {
        return true;
    }

    public boolean supportsUseStaticImports() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PsiElement @NotNull [] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, String contextId, @NotNull Project project, boolean physical) {
        if (text == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(29);
        }
        if (context == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(30);
        }
        if (fileType == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(31);
        }
        if (language == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(32);
        }
        if (project == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(33);
        }
        if (MEMBER_CONTEXT.getId().equals(contextId)) {
            context = PatternTreeContext.Class;
        }
        if (context == PatternTreeContext.Block) {
            List<PsiElement> result;
            block22: {
                PsiElement[] classPattern;
                JavaCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project).createCodeBlockCodeFragment(text, null, physical);
                result = JavaStructuralSearchProfile.getNonWhitespaceChildren((PsiElement)fragment);
                if (result.isEmpty()) {
                    if (PsiElement.EMPTY_ARRAY == null) {
                        JavaStructuralSearchProfile.$$$reportNull$$$0(34);
                    }
                    return PsiElement.EMPTY_ARRAY;
                }
                if (JavaStructuralSearchProfile.shouldTryExpressionPattern(result)) {
                    PsiElement[] expressionPattern2;
                    block23: {
                        try {
                            expressionPattern2 = this.createPatternTree(text, PatternTreeContext.Expression, fileType, language, contextId, project, physical);
                            if (expressionPattern2.length != 1) break block22;
                            if (expressionPattern2 != null) break block23;
                        }
                        catch (IncorrectOperationException expressionPattern2) {
                            break block22;
                        }
                        JavaStructuralSearchProfile.$$$reportNull$$$0(35);
                    }
                    return expressionPattern2;
                }
                if (JavaStructuralSearchProfile.shouldTryClassPattern(result) && (classPattern = this.createPatternTree(text, PatternTreeContext.Class, fileType, language, contextId, project, physical)).length <= result.size()) {
                    if (classPattern == null) {
                        JavaStructuralSearchProfile.$$$reportNull$$$0(36);
                    }
                    return classPattern;
                }
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(37);
            }
            return psiElementArray;
        }
        if (context == PatternTreeContext.Class) {
            JavaCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project).createMemberCodeFragment(text, null, physical);
            List<PsiElement> result = JavaStructuralSearchProfile.getNonWhitespaceChildren((PsiElement)fragment);
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(38);
            }
            return psiElementArray;
        }
        if (context == PatternTreeContext.Expression) {
            PsiElement[] psiElementArray;
            PsiExpressionCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)project).createExpressionCodeFragment(text, null, null, physical);
            PsiExpression expression = fragment.getExpression();
            if (expression == null) {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            } else {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = expression;
            }
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(39);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = new PsiElement[]{PsiFileFactory.getInstance((Project)project).createFileFromText("__dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text)};
        if (psiElementArray == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(40);
        }
        return psiElementArray;
    }

    private static List<PsiElement> getNonWhitespaceChildren(PsiElement fragment) {
        SmartList result = new SmartList();
        for (PsiElement element = fragment.getFirstChild(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiWhiteSpace) continue;
            result.add(element);
        }
        return result;
    }

    private static boolean shouldTryExpressionPattern(@NotNull List<? extends PsiElement> elements) {
        PsiElement lastChild;
        PsiElement firstElement;
        if (elements == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(41);
        }
        return elements.size() >= 1 && elements.size() <= 3 && (firstElement = elements.get(0)) instanceof PsiDeclarationStatement && (lastChild = firstElement.getLastChild()) instanceof PsiErrorElement && PsiTreeUtil.prevLeaf((PsiElement)lastChild) instanceof PsiErrorElement;
    }

    private static boolean shouldTryClassPattern(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(42);
        }
        if (elements.isEmpty()) {
            return false;
        }
        PsiElement firstElement = elements.get(0);
        if (firstElement instanceof PsiDeclarationStatement && firstElement.getFirstChild() instanceof PsiClass) {
            return true;
        }
        if (elements.size() < 2) {
            return false;
        }
        PsiElement secondElement = elements.get(1);
        PsiElement lastElement = elements.get(elements.size() - 1);
        if (firstElement instanceof PsiDocComment) {
            return true;
        }
        if (firstElement instanceof PsiDeclarationStatement && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiErrorElement && secondElement instanceof PsiExpressionStatement && PsiTreeUtil.lastChild((PsiElement)secondElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiSwitchLabelStatement && ((PsiSwitchLabelStatement)firstElement).isDefaultCase() && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement && secondElement instanceof PsiDeclarationStatement) {
            return true;
        }
        return firstElement instanceof PsiExpressionStatement && firstElement.getFirstChild() instanceof PsiMethodCallExpression && firstElement.getLastChild() instanceof PsiErrorElement && lastElement instanceof PsiBlockStatement;
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return JavaCodeContextType.Generic.class;
    }

    @NotNull
    public List<PatternContext> getPatternContexts() {
        if (!Registry.is((String)"ssr.in.editor.problem.highlighting")) {
            List list = super.getPatternContexts();
            if (list == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(43);
            }
            return list;
        }
        List<PatternContext> list = PATTERN_CONTEXTS;
        if (list == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public PsiCodeFragment createCodeFragment(@NotNull Project project, @NotNull String text, String contextId) {
        if (project == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(45);
        }
        if (text == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(46);
        }
        PsiCodeFragmentImpl fragment = MEMBER_CONTEXT.getId().equals(contextId) ? (PsiCodeFragmentImpl)JavaCodeFragmentFactory.getInstance((Project)project).createMemberCodeFragment(text, null, true) : (PsiCodeFragmentImpl)JavaCodeFragmentFactory.getInstance((Project)project).createCodeBlockCodeFragment(text, null, true);
        fragment.setIntentionActionsFilter(intentionAction -> false);
        PsiCodeFragmentImpl psiCodeFragmentImpl = fragment;
        if (psiCodeFragmentImpl == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(47);
        }
        return psiCodeFragmentImpl;
    }

    @NotNull
    public String getCodeFragmentText(@NotNull PsiFile fragment) {
        if (fragment == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(48);
        }
        List imports = StringUtil.split((String)((JavaCodeFragment)fragment).importsToString(), (String)",");
        final Map importMap = imports.stream().collect(Collectors.toMap(s -> s.substring(s.lastIndexOf(46) + 1), Function.identity()));
        final StringBuilder result = new StringBuilder();
        fragment.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
            }

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!reference.isQualified()) {
                    String text = reference.getText();
                    String fqName = (String)importMap.get(text);
                    result.append(fqName != null ? fqName : text);
                } else {
                    super.visitReferenceElement(reference);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitElement(element);
                if (element.getFirstChild() == null) {
                    result.append(element.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/structuralsearch/JavaStructuralSearchProfile$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        String string = result.toString();
        if (string == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(49);
        }
        return string;
    }

    public boolean shouldShowProblem(@NotNull PsiErrorElement error) {
        PsiElement greatGreatGrandParent;
        PsiElement greatGrandParent;
        String text;
        PsiElement prev;
        if (error == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(50);
        }
        String description = error.getErrorDescription();
        PsiElement parent = error.getParent();
        if (parent instanceof PsiClass && !(parent instanceof PsiCodeFragment) && JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]).equals(description) && (prev = error.getPrevSibling()) instanceof PsiTypeElement && (StringUtil.startsWithChar((CharSequence)(text = prev.getText()), (char)'$') && StringUtil.endsWithChar((CharSequence)text, (char)'$') || text.startsWith("__$_"))) {
            return false;
        }
        if (parent instanceof PsiTryStatement && JavaPsiBundle.message((String)"expected.catch.or.finally", (Object[])new Object[0]).equals(description)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (parent instanceof PsiStatement && grandParent instanceof PsiCodeFragment) {
            PsiStatement statement;
            int count = PsiTreeUtil.countChildrenOfType((PsiElement)grandParent, PsiStatement.class);
            if (count == 1 && ((statement = (PsiStatement)parent) instanceof PsiExpressionStatement || statement instanceof PsiDeclarationStatement)) {
                if (JavaPsiBundle.message((String)"expected.semicolon", (Object[])new Object[0]).equals(description) && error.getNextSibling() == null) {
                    return false;
                }
                if (JavaPsiBundle.message((String)"expected.identifier.or.type", (Object[])new Object[0]).equals(description)) {
                    return false;
                }
                if (JavaPsiBundle.message((String)"expected.identifier", (Object[])new Object[0]).equals(description)) {
                    return false;
                }
            }
        } else if (parent instanceof PsiReferenceParameterList && grandParent instanceof PsiJavaCodeReferenceElement && (greatGrandParent = grandParent.getParent()) instanceof PsiTypeElement && (greatGreatGrandParent = greatGrandParent.getParent()) instanceof PsiDeclarationStatement && PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)greatGreatGrandParent) == null && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)greatGreatGrandParent) == null && JavaPsiBundle.message((String)"expected.gt.or.comma", (Object[])new Object[0]).equals(description)) {
            return false;
        }
        return true;
    }

    public void checkSearchPattern(@NotNull CompiledPattern pattern) {
        if (pattern == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(51);
        }
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    public void checkReplacementPattern(@NotNull Project project, @NotNull ReplaceOptions options) {
        boolean searchIsExpression;
        if (project == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(52);
        }
        if (options == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(53);
        }
        MatchOptions matchOptions = options.getMatchOptions();
        LanguageFileType fileType = matchOptions.getFileType();
        Language dialect = matchOptions.getDialect();
        PatternContext patternContext = matchOptions.getPatternContext();
        PsiElement[] statements = this.createPatternTree(options.getReplacement(), PatternTreeContext.Block, fileType, dialect, patternContext.getId(), project, false);
        ValidatingVisitor visitor = new ValidatingVisitor();
        for (PsiElement statement : statements) {
            statement.accept((PsiElementVisitor)visitor);
        }
        boolean replaceIsExpression = JavaStructuralSearchProfile.isExpressionTemplate(Arrays.asList(statements));
        CompiledPattern compiledPattern = PatternCompiler.compilePattern((Project)project, (MatchOptions)matchOptions, (boolean)false, (boolean)false);
        if (compiledPattern == null) {
            return;
        }
        PsiElement targetNode = compiledPattern.getTargetNode();
        boolean bl = searchIsExpression = targetNode != null ? this.getPresentableElement(targetNode) instanceof PsiExpression : JavaStructuralSearchProfile.isExpressionTemplate(compiledPattern.getVariableNodes("__context__"));
        if (searchIsExpression && !replaceIsExpression) {
            throw new UnsupportedPatternException(SSRBundle.message((String)"replacement.template.is.not.expression.error.message", (Object[])new Object[0]));
        }
    }

    private static boolean isExpressionTemplate(List<PsiElement> elements) {
        if (elements.size() != 1) {
            return false;
        }
        PsiElement element = elements.get(0);
        return element instanceof PsiExpression || element instanceof PsiExpressionStatement && element.getLastChild() instanceof PsiErrorElement;
    }

    public LanguageFileType getDefaultFileType(LanguageFileType currentDefaultFileType) {
        return JavaFileType.INSTANCE;
    }

    public Configuration @NotNull [] getPredefinedTemplates() {
        Configuration[] configurationArray = JavaPredefinedConfigurations.createPredefinedTemplates();
        if (configurationArray == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(54);
        }
        return configurationArray;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, @NotNull ReplaceOptions options, final @NotNull ReplacementBuilder builder) {
        if (node == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(55);
        }
        if (options == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(56);
        }
        if (builder == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(57);
        }
        final JavaStructuralSearchProfile profile = this;
        node.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.visitElement((PsiElement)expression);
            }

            public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
                if (pair == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitNameValuePair(pair);
                this.setParameterContext((PsiElement)pair, (PsiElement)pair.getNameIdentifier(), (PsiElement)pair.getValue());
            }

            public void visitParameter(@NotNull PsiParameter parameter) {
                PsiElement scope;
                if (parameter == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((scope = parameter.getDeclarationScope()) instanceof PsiCatchSection || scope instanceof PsiForeachStatement) {
                    return;
                }
                this.setParameterContext((PsiElement)parameter, (PsiElement)parameter.getNameIdentifier(), (PsiElement)parameter.getTypeElement());
            }

            private void setParameterContext(@NotNull PsiElement element, PsiElement nameIdentifier, @Nullable PsiElement scopeElement) {
                ParameterInfo nameInfo;
                if (element == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((nameInfo = builder.findParameterization(nameIdentifier)) == null) {
                    return;
                }
                nameInfo.setArgumentContext(false);
                final HashMap<String, ParameterInfo> infos = new HashMap<String, ParameterInfo>();
                infos.put(nameInfo.getName(), nameInfo);
                nameInfo.putUserData(PARAMETER_CONTEXT, infos);
                nameInfo.setElement(element);
                if (scopeElement == null) {
                    return;
                }
                scopeElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        ParameterInfo typeInfo;
                        String type;
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (profile.isReplacementTypedVariable(type = element.getText()) && (typeInfo = builder.findParameterization(element)) != null) {
                            typeInfo.setArgumentContext(false);
                            typeInfo.putUserData(PARAMETER_CONTEXT, Collections.emptyMap());
                            infos.put(typeInfo.getName(), typeInfo);
                            return;
                        }
                        super.visitElement(element);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/JavaStructuralSearchProfile$2$1", "visitElement"));
                    }
                });
                int length = element.getTextLength() - infos.keySet().stream().mapToInt(key -> key.length() + 2).sum();
                nameInfo.putUserData(PARAMETER_LENGTH, (Object)length);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pair";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/structuralsearch/JavaStructuralSearchProfile$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNameValuePair";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParameter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setParameterContext";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleSubstitution(@NotNull ParameterInfo info, @NotNull MatchResult match, @NotNull StringBuilder result, @NotNull ReplacementInfo replacementInfo) {
        String replacementString;
        if (info == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(58);
        }
        if (match == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(59);
        }
        if (result == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(60);
        }
        if (replacementInfo == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(61);
        }
        if (!info.getName().equals(match.getName())) return;
        boolean forceAddingNewLine = false;
        int offset = 0;
        PsiElement element = info.getElement();
        Map typeInfos = (Map)info.getUserData(PARAMETER_CONTEXT);
        if (typeInfos != null) {
            if (element instanceof PsiParameter) {
                int parameterEnd = info.getStartIndex();
                Integer length = (Integer)info.getUserData(PARAMETER_LENGTH);
                assert (length != null);
                int parameterStart = parameterEnd - length;
                String template = result.substring(parameterStart, parameterEnd);
                replacementString = JavaStructuralSearchProfile.handleParameter(info, replacementInfo, -parameterStart, template);
                result.delete(parameterStart, parameterEnd);
                offset -= template.length();
            } else {
                if (!(element instanceof PsiNameValuePair)) return;
                int parameterStart = info.getStartIndex();
                Integer length = (Integer)info.getUserData(PARAMETER_LENGTH);
                assert (length != null);
                int parameterEnd = parameterStart + length;
                String template = result.substring(parameterStart, parameterEnd);
                replacementString = JavaStructuralSearchProfile.handleParameter(info, replacementInfo, -parameterStart, template);
                result.delete(parameterStart, parameterEnd);
            }
        } else if (match.hasChildren() && !match.isScopeMatch()) {
            StringBuilder buf = new StringBuilder();
            PsiElement previous = null;
            boolean stripSemicolon = false;
            for (MatchResult matchResult : match.getChildren()) {
                PsiElement currentElement = matchResult.getMatch();
                boolean bl = stripSemicolon = !(currentElement instanceof PsiField);
                if (previous != null) {
                    PsiElement parent = currentElement.getParent();
                    if (parent instanceof PsiVariable || parent instanceof PsiTypeElement || parent instanceof PsiTypeParameter) {
                        JavaStructuralSearchProfile.addSeparatorText(previous.getParent(), parent, buf);
                    } else if (parent instanceof PsiClass || parent instanceof PsiReferenceList) {
                        JavaStructuralSearchProfile.addSeparatorTextMatchedInAnyOrder(currentElement, parent instanceof PsiClass ? PsiMember.class : PsiJavaCodeReferenceElement.class, buf);
                    } else if (info.isStatementContext() || info.isArgumentContext() || parent instanceof PsiPolyadicExpression || parent instanceof PsiArrayInitializerExpression) {
                        JavaStructuralSearchProfile.addSeparatorText(previous, currentElement, buf);
                    } else {
                        buf.append(" ");
                    }
                }
                buf.append(matchResult.getMatchImage());
                forceAddingNewLine = currentElement instanceof PsiComment;
                previous = matchResult.getMatch();
            }
            replacementString = stripSemicolon ? StringUtil.trimEnd((String)buf.toString(), (char)';') : buf.toString();
        } else {
            PsiElement matchElement = match.getMatch();
            if (info.isStatementContext()) {
                forceAddingNewLine = matchElement instanceof PsiComment;
            }
            String matchImage = match.getMatchImage();
            replacementString = !(matchElement instanceof PsiField) ? StringUtil.trimEnd((String)matchImage, (char)';') : matchImage;
        }
        offset = Replacer.insertSubstitution((StringBuilder)result, (int)offset, (ParameterInfo)info, (String)replacementString);
        offset = JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, match);
        if (!forceAddingNewLine || !info.isStatementContext()) return;
        result.insert(info.getStartIndex() + offset + 1, '\n');
    }

    private static void addSeparatorTextMatchedInAnyOrder(PsiElement element, Class<? extends PsiElement> aClass, StringBuilder out) {
        PsiElement prev = PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, aClass);
        assert (prev != null);
        JavaStructuralSearchProfile.addSeparatorText(prev, element, out);
    }

    private static void addSeparatorText(PsiElement left, PsiElement right, StringBuilder out) {
        for (PsiElement e = left.getNextSibling(); e != null && e != right; e = e.getNextSibling()) {
            out.append(e.getText());
        }
    }

    public void handleNoSubstitution(@NotNull ParameterInfo info, @NotNull StringBuilder result) {
        PsiElement element;
        PsiElement prevSibling;
        if (info == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(62);
        }
        if (result == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(63);
        }
        if ((prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)(element = info.getElement()))) instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(prevSibling)) {
            int start = info.getBeforeDelimiterPos() - (prevSibling.getTextLength() - 1);
            int end = info.getStartIndex();
            result.delete(start, end);
            return;
        }
        PsiElement nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        if (JavaStructuralSearchProfile.isRemovableToken(nextSibling)) {
            int start = info.getStartIndex();
            int end = info.getAfterDelimiterPos() + nextSibling.getTextLength();
            result.delete(start, end);
            return;
        }
        if (element instanceof PsiTypeElement && nextSibling instanceof PsiIdentifier) {
            int start = info.getStartIndex();
            int end = info.getAfterDelimiterPos();
            result.delete(start, end);
            return;
        }
        if (element == null || !(element.getParent() instanceof PsiForStatement)) {
            JavaStructuralSearchProfile.removeExtraSemicolon(info, 0, result, null);
        }
    }

    private static boolean isRemovableToken(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnnotationParameterList || parent instanceof PsiAssertStatement || parent instanceof PsiExpressionList || parent instanceof PsiParameterList || parent instanceof PsiPolyadicExpression || parent instanceof PsiReferenceExpression || parent instanceof PsiReferenceList || parent instanceof PsiReferenceParameterList || parent instanceof PsiResourceList || parent instanceof PsiTypeParameterList || parent instanceof PsiAnnotation || parent instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return false;
        }
        String text = element.getText();
        if (text.length() != 1) {
            return true;
        }
        return switch (text.charAt(0)) {
            case '(', ')', '<', '>', '[', ']', '{', '}' -> false;
            default -> true;
        };
    }

    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof PsiIdentifier;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set = RESERVED_WORDS;
        if (set == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(64);
        }
        return set;
    }

    public boolean isDocCommentOwner(@NotNull PsiElement match) {
        if (match == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(65);
        }
        return match instanceof PsiMember;
    }

    private static String handleParameter(@NotNull ParameterInfo info, ReplacementInfo replacementInfo, int offset, String template) {
        if (info == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(66);
        }
        MatchResult matchResult = replacementInfo.getNamedMatchResult(info.getName());
        assert (matchResult != null);
        StringBuilder result = new StringBuilder();
        if (matchResult.isMultipleMatch()) {
            PsiElement previous = null;
            for (MatchResult child : matchResult.getChildren()) {
                PsiElement match = child.getMatch().getParent();
                if (previous != null) {
                    JavaStructuralSearchProfile.addSeparatorText(previous, match, result);
                }
                JavaStructuralSearchProfile.appendParameter(info, child, offset + result.length(), result.append(template));
                previous = match;
            }
        } else {
            result.append(template);
            JavaStructuralSearchProfile.appendParameter(info, matchResult, offset, result);
        }
        return result.toString();
    }

    private static void appendParameter(ParameterInfo parameterInfo, MatchResult matchResult, int offset, StringBuilder out) {
        Map infos = (Map)parameterInfo.getUserData(PARAMETER_CONTEXT);
        assert (infos != null);
        SmartList matches = new SmartList((Collection)matchResult.getChildren());
        matches.add(matchResult);
        matches.sort(Comparator.comparingInt(result -> result.getMatch().getTextOffset()).reversed());
        for (MatchResult match : matches) {
            ParameterInfo typeInfo = (ParameterInfo)infos.get(match.getName());
            if (typeInfo == null) continue;
            out.insert(typeInfo.getStartIndex() + offset, match.getMatchImage());
        }
    }

    private static int removeExtraSemicolon(ParameterInfo info, int offset, StringBuilder result, MatchResult match) {
        if (!info.isStatementContext()) {
            return offset;
        }
        int index = offset + info.getStartIndex();
        if (result.charAt(index) != ';') {
            return offset;
        }
        PsiElement matchElement = match == null ? null : (match.isMultipleMatch() ? ((MatchResult)match.getChildren().get(match.size() - 1)).getMatch() : match.getMatch());
        if (matchElement == null || matchElement instanceof PsiComment || result.charAt(index - 1) == '}' && !(matchElement instanceof PsiDeclarationStatement) && !(matchElement instanceof PsiNewExpression) && !(matchElement instanceof PsiArrayInitializerExpression)) {
            result.deleteCharAt(index);
            --offset;
        }
        return offset;
    }

    public boolean isApplicableConstraint(@NotNull String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        if (constraintName == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(67);
        }
        switch (constraintName) {
            case "TEXT": {
                return !completePattern;
            }
            case "TEXT HIERARCHY": {
                if (variableNode != null) {
                    PsiElement parent = variableNode.getParent();
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        PsiElement grandParent = parent.getParent();
                        if (grandParent instanceof PsiTypeElement || grandParent instanceof PsiReferenceList || grandParent instanceof PsiReferenceExpression || grandParent instanceof PsiNewExpression || grandParent instanceof PsiAnonymousClass) {
                            return true;
                        }
                    } else {
                        if (parent instanceof PsiClass) {
                            return true;
                        }
                        if (JavaStructuralSearchProfile.isMemberSurroundedByClass(parent)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            case "EXPECTED TYPE": {
                PsiElement grandParent;
                if (variableNode != null && ((grandParent = variableNode.getParent().getParent()) instanceof PsiExpressionStatement ? JavaStructuralSearchProfile.isCompleteStatement((PsiExpressionStatement)grandParent) : grandParent instanceof PsiStatement)) {
                    return false;
                }
            }
            case "TYPE": 
            case "TYPE REGEX": {
                PsiElement child;
                if (variableNode instanceof PsiExpressionStatement && (child = variableNode.getLastChild()) instanceof PsiErrorElement) {
                    PsiErrorElement errorElement = (PsiErrorElement)child;
                    return JavaPsiBundle.message((String)"expected.semicolon", (Object[])new Object[0]).equals(errorElement.getErrorDescription());
                }
                return variableNode != null && variableNode.getParent() instanceof PsiExpression;
            }
            case "MINIMUM ZERO": {
                if (target || variableNode == null) {
                    return false;
                }
                return JavaStructuralSearchProfile.isApplicableMinCount(variableNode) || JavaStructuralSearchProfile.isApplicableMinMaxCount(variableNode);
            }
            case "MAXIMUM UNLIMITED": {
                if (target || variableNode == null) {
                    return false;
                }
                return JavaStructuralSearchProfile.isApplicableMaxCount(variableNode) || JavaStructuralSearchProfile.isApplicableMinMaxCount(variableNode);
            }
            case "REFERENCE": {
                if (completePattern || variableNode == null) {
                    return false;
                }
                if (variableNode instanceof PsiLiteralExpression && ((PsiLiteralExpression)variableNode).getValue() instanceof String) {
                    return true;
                }
                PsiElement parent = variableNode.getParent();
                return parent instanceof PsiJavaCodeReferenceElement;
            }
        }
        return super.isApplicableConstraint(constraintName, variableNode, completePattern, target);
    }

    private static boolean isApplicableMinCount(@NotNull PsiElement variableNode) {
        PsiElement greatGrandParent;
        PsiElement parent;
        if (variableNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(68);
        }
        if ((parent = variableNode.getParent()) instanceof PsiContinueStatement) {
            return true;
        }
        if (parent instanceof PsiBreakStatement) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (parent instanceof PsiPatternVariable && grandParent instanceof PsiTypeTestPattern) {
            return true;
        }
        if (grandParent instanceof PsiReferenceList) {
            return true;
        }
        if (grandParent instanceof PsiPolyadicExpression) {
            return ((PsiPolyadicExpression)grandParent).getOperands().length > 2;
        }
        if (parent instanceof PsiReferenceExpression) {
            if (grandParent instanceof PsiReferenceExpression) {
                return true;
            }
            if (grandParent instanceof PsiReturnStatement) {
                return true;
            }
            if (grandParent instanceof PsiAssertStatement) {
                return ((PsiAssertStatement)grandParent).getAssertDescription() == parent;
            }
            if (grandParent instanceof PsiNameValuePair) {
                return ((PsiNameValuePair)grandParent).getValue() == parent;
            }
            if (grandParent instanceof PsiForStatement) {
                return true;
            }
        }
        if (grandParent instanceof PsiVariable) {
            return ((PsiVariable)grandParent).getInitializer() == parent;
        }
        if (grandParent instanceof PsiNewExpression) {
            return ((PsiNewExpression)grandParent).getArrayInitializer() != null;
        }
        if (grandParent instanceof PsiTypeElement) {
            greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiTypeElement) {
                PsiType type = ((PsiTypeElement)greatGrandParent).getType();
                return type instanceof PsiWildcardType && ((PsiWildcardType)type).isExtends();
            }
            if (greatGrandParent instanceof PsiMethod || greatGrandParent instanceof PsiVariable) {
                return true;
            }
        }
        if (grandParent instanceof PsiExpressionStatement) {
            greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiForStatement && !PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)greatGrandParent).getBody(), (PsiElement)variableNode, (boolean)true)) {
                return true;
            }
            if (JavaStructuralSearchProfile.isCompleteStatement((PsiExpressionStatement)grandParent)) {
                if (greatGrandParent instanceof PsiLoopStatement || greatGrandParent instanceof PsiIfStatement && ((PsiIfStatement)greatGrandParent).getElseBranch() != grandParent) {
                    return false;
                }
                return !(greatGrandParent instanceof PsiCodeBlock) || !(greatGrandParent.getParent() instanceof JavaDummyHolder) || PsiTreeUtil.getChildrenOfAnyType((PsiElement)greatGrandParent, (Class[])new Class[]{PsiStatement.class, PsiComment.class}).size() > 1;
            }
        }
        return false;
    }

    private static boolean isApplicableMaxCount(@NotNull PsiElement variableNode) {
        PsiElement parent;
        if (variableNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(69);
        }
        if ((parent = variableNode.getParent()) instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)parent;
            if (localVariable instanceof PsiResourceVariable) {
                return false;
            }
            return !localVariable.getTypeElement().isInferredType();
        }
        if (parent instanceof PsiField) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiPolyadicExpression) {
            return true;
        }
        if (grandParent instanceof PsiExpressionStatement && JavaStructuralSearchProfile.isCompleteStatement((PsiExpressionStatement)grandParent)) {
            PsiElement greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)greatGrandParent;
                return forStatement.getInitialization() == grandParent || forStatement.getUpdate() == grandParent;
            }
            return greatGrandParent instanceof PsiCodeBlock || greatGrandParent instanceof PsiCodeFragment;
        }
        if (grandParent instanceof PsiReferenceList) {
            PsiElement greatGrandParent = grandParent.getParent();
            return !(greatGrandParent instanceof PsiClass) || ((PsiClass)greatGrandParent).getExtendsList() != grandParent || greatGrandParent instanceof PsiTypeParameter;
        }
        return false;
    }

    private static boolean isApplicableMinMaxCount(@NotNull PsiElement variableNode) {
        PsiElement greatGrandParent;
        if (variableNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(70);
        }
        if (variableNode instanceof PsiDocToken) {
            return true;
        }
        PsiElement parent = variableNode.getParent();
        if (JavaStructuralSearchProfile.isMemberSurroundedByClass(parent)) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiCatchSection && parent instanceof PsiParameter) {
            return true;
        }
        if (grandParent instanceof PsiAnnotation && !(grandParent.getParent().getNextSibling() instanceof PsiErrorElement)) {
            return true;
        }
        if (grandParent instanceof PsiParameterList || grandParent instanceof PsiArrayInitializerMemberValue || grandParent instanceof PsiExpressionList || grandParent instanceof PsiCaseLabelElementList || grandParent instanceof PsiTypeParameterList || grandParent instanceof PsiResourceList || grandParent instanceof PsiResourceExpression || grandParent instanceof PsiArrayInitializerExpression) {
            return true;
        }
        if (grandParent instanceof PsiTypeElement && ((greatGrandParent = grandParent.getParent()) instanceof PsiReferenceParameterList || greatGrandParent instanceof PsiClass)) {
            return true;
        }
        if (grandParent instanceof PsiAnnotationParameterList && parent instanceof PsiNameValuePair) {
            return ((PsiNameValuePair)parent).getNameIdentifier() == variableNode;
        }
        return false;
    }

    private static boolean isMemberSurroundedByClass(PsiElement parent) {
        PsiMember member;
        block5: {
            block4: {
                if (!(parent instanceof PsiMember)) break block4;
                member = (PsiMember)parent;
                if (!(parent instanceof PsiTypeParameter)) break block5;
            }
            return false;
        }
        PsiClass aClass = member.getContainingClass();
        if (aClass == null) {
            return false;
        }
        @NonNls String name = aClass.getName();
        return name != null && !"_Dummy_".equals(name);
    }

    private static boolean isCompleteStatement(PsiExpressionStatement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiForStatement && ((PsiForStatement)parent).getUpdate() == element) {
            return true;
        }
        PsiElement lastChild = element.getLastChild();
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            lastChild = lastChild.getPrevSibling();
        }
        return PsiUtil.isJavaToken((PsiElement)lastChild, (IElementType)JavaTokenType.SEMICOLON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 12, 14, 16, 17, 18, 25, 34, 35, 36, 37, 38, 39, 40, 43, 44, 47, 49, 54, 64 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 54: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/JavaStructuralSearchProfile";
                break;
            }
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousText";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 20: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 27: 
            case 33: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 29: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 58: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementInfo";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/JavaStructuralSearchProfile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCurrentNode";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extendMatchedByDownUp";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableElement";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomPredicates";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternContexts";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeFragment";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentText";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedTemplates";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 49: 
            case 54: 
            case 64: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypedVarString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMeaningfulText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extendMatchedByDownUp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPredicates";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "shouldTryExpressionPattern";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldTryClassPattern";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFragment";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getCodeFragmentText";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowProblem";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkSearchPattern";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "handleSubstitution";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "handleNoSubstitution";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentOwner";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "handleParameter";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableConstraint";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableMinCount";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableMaxCount";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableMinMaxCount";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7, 12, 14, 16, 17, 18, 25, 34, 35, 36, 37, 38, 39, 40, 43, 44, 47, 49, 54, 64 -> new IllegalStateException(string);
        };
    }

    class ValidatingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        ValidatingVisitor() {
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                ValidatingVisitor.$$$reportNull$$$0(0);
            }
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null || !nameReferenceElement.getText().equals("Modifier")) {
                return;
            }
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                for (PsiAnnotationMemberValue v : AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)pair.getValue())) {
                    ValidatingVisitor.checkModifier(StringUtil.unquoteString((String)v.getText()));
                }
            }
        }

        private static void checkModifier(String name) {
            if (!"Instance".equals(name) && !"packageLocal".equals(name) && ArrayUtil.find((Object[])JavaMatchingVisitor.MODIFIERS, (Object)name) < 0) {
                throw new MalformedPatternException(SSRBundle.message((String)"invalid.modifier.type", (Object[])new Object[]{name}));
            }
        }

        public void visitErrorElement(@NotNull PsiErrorElement element) {
            if (element == null) {
                ValidatingVisitor.$$$reportNull$$$0(1);
            }
            super.visitErrorElement(element);
            if (JavaStructuralSearchProfile.this.shouldShowProblem(element)) {
                throw new MalformedPatternException(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/JavaStructuralSearchProfile$ValidatingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitErrorElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

