/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 53391288449370L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(549969720 + 9241, -549969720 + -15018, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(549969720 + 9240, -549969720 + -32218, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 94673898095962L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.e();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-66059280 - -((char)-1181), 66059280 - (char)-7259, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-66059280 - -((char)-1182), 66059280 - (char)-11586, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-66059280 - -((char)-1179), -66059280 - -((char)-3449), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 53016023397895L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.e();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1052885310 + -29369, -1052885310 + -18455, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1052885310 + -29368, -1052885310 + -((char)-24267), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1052885310 + -29367, 1052885310 + (char)-20462, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1052885310 + -29374, 1052885310 + 23678, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1052885310 + -29373, -1052885310 + -26866, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1052885310 + -29367, 1052885310 + (char)-20462, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1052885310 + -29372, -1052885310 + -((char)-21500), (int)l2));
            if (!ActionTimestamp.e()) {
                SshAgentIpcService.e(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 101412594769258L;
                    nArray = SshAgentIpcService.e();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    int[] nArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 80921478632390L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            nArray = SshAgentIpcService.e();
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (nArray == null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10692), -131070 + -((char)-10136), (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10696), 131070 + (char)-27501, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10687), -131070 + -((char)-20318), (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10696), 131070 + (char)-27501, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10686), 131070 + (char)-23741, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10692), -131070 + -((char)-10136), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10696), 131070 + (char)-27501, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10689), 131070 + (char)-12037, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (nArray == null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10692), -131070 + -((char)-10136), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10696), 131070 + (char)-27501, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10688), 131070 + (char)-27678, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10696), 131070 + (char)-27501, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10715), 131070 + (char)-21588, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10696), 131070 + (char)-27501, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10686), 131070 + (char)-23741, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10692), -131070 + -((char)-10136), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10696), 131070 + (char)-27501, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-131070 + -((char)-10714), -131070 + -((char)-30477), (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 19538952866294L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1146600360 + -18232, -1146600360 + -32086, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 127790254264593L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-2092270410 + -((char)-10512), 2092270410 + (char)-20773, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u00edQ\u0093\u00f7\u00c9\u00fe\u00f51rRX\u0099F\u008dI\u001b\u00d0\u00fb\u0094\u0014\u00fd\u00ca\u0091\u0082\u0092\u0092\u00e392U\u0095\u00ad=\u00f2\u00e7\u007f\u00e8\u00b1\u0094\u00e4";
                                        var4_3 = "\u00edQ\u0093\u00f7\u00c9\u00fe\u00f51rRX\u0099F\u008dI\u001b\u00d0\u00fb\u0094\u0014\u00fd\u00ca\u0091\u0082\u0092\u0092\u00e392U\u0095\u00ad=\u00f2\u00e7\u007f\u00e8\u00b1\u0094\u00e4".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 92;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 90;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 119;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 102;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 100;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 87;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 75;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 39;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0xFFFFB4D6) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 92;
                                            case 1 -> 108;
                                            case 2 -> 115;
                                            case 3 -> 72;
                                            case 4 -> 226;
                                            case 5 -> 50;
                                            case 6 -> 253;
                                            case 7 -> 216;
                                            case 8 -> 52;
                                            case 9 -> 214;
                                            case 10 -> 85;
                                            case 11 -> 229;
                                            case 12 -> 236;
                                            case 13 -> 130;
                                            case 14 -> 76;
                                            case 15 -> 81;
                                            case 16 -> 39;
                                            case 17 -> 56;
                                            case 18 -> 222;
                                            case 19 -> 124;
                                            case 20 -> 26;
                                            case 21 -> 60;
                                            case 22 -> 90;
                                            case 23 -> 151;
                                            case 24 -> 117;
                                            case 25 -> 230;
                                            case 26 -> 169;
                                            case 27 -> 252;
                                            case 28 -> 129;
                                            case 29 -> 104;
                                            case 30 -> 14;
                                            case 31 -> 43;
                                            case 32 -> 175;
                                            case 33 -> 8;
                                            case 34 -> 166;
                                            case 35 -> 215;
                                            case 36 -> 46;
                                            case 37 -> 19;
                                            case 38 -> 173;
                                            case 39 -> 55;
                                            case 40 -> 248;
                                            case 41 -> 61;
                                            case 42 -> 88;
                                            case 43 -> 18;
                                            case 44 -> 25;
                                            case 45 -> 87;
                                            case 46 -> 7;
                                            case 47 -> 157;
                                            case 48 -> 127;
                                            case 49 -> 190;
                                            case 50 -> 126;
                                            case 51 -> 48;
                                            case 52 -> 82;
                                            case 53 -> 15;
                                            case 54 -> 53;
                                            case 55 -> 156;
                                            case 56 -> 187;
                                            case 57 -> 102;
                                            case 58 -> 109;
                                            case 59 -> 134;
                                            case 60 -> 199;
                                            case 61 -> 149;
                                            case 62 -> 140;
                                            case 63 -> 78;
                                            case 64 -> 122;
                                            case 65 -> 1;
                                            case 66 -> 221;
                                            case 67 -> 209;
                                            case 68 -> 34;
                                            case 69 -> 121;
                                            case 70 -> 247;
                                            case 71 -> 184;
                                            case 72 -> 161;
                                            case 73 -> 16;
                                            case 74 -> 131;
                                            case 75 -> 185;
                                            case 76 -> 148;
                                            case 77 -> 54;
                                            case 78 -> 243;
                                            case 79 -> 154;
                                            case 80 -> 207;
                                            case 81 -> 232;
                                            case 82 -> 143;
                                            case 83 -> 228;
                                            case 84 -> 239;
                                            case 85 -> 245;
                                            case 86 -> 188;
                                            case 87 -> 3;
                                            case 88 -> 66;
                                            case 89 -> 202;
                                            case 90 -> 44;
                                            case 91 -> 80;
                                            case 92 -> 86;
                                            case 93 -> 21;
                                            case 94 -> 113;
                                            case 95 -> 139;
                                            case 96 -> 68;
                                            case 97 -> 137;
                                            case 98 -> 5;
                                            case 99 -> 213;
                                            case 100 -> 251;
                                            case 101 -> 74;
                                            case 102 -> 231;
                                            case 103 -> 141;
                                            case 104 -> 225;
                                            case 105 -> 89;
                                            case 106 -> 224;
                                            case 107 -> 24;
                                            case 108 -> 165;
                                            case 109 -> 31;
                                            case 110 -> 150;
                                            case 111 -> 234;
                                            case 112 -> 205;
                                            case 113 -> 181;
                                            case 114 -> 155;
                                            case 115 -> 70;
                                            case 116 -> 40;
                                            case 117 -> 176;
                                            case 118 -> 118;
                                            case 119 -> 49;
                                            case 120 -> 33;
                                            case 121 -> 96;
                                            case 122 -> 196;
                                            case 123 -> 200;
                                            case 124 -> 211;
                                            case 125 -> 179;
                                            case 126 -> 106;
                                            case 127 -> 135;
                                            case 128 -> 168;
                                            case 129 -> 136;
                                            case 130 -> 198;
                                            case 131 -> 158;
                                            case 132 -> 144;
                                            case 133 -> 112;
                                            case 134 -> 227;
                                            case 135 -> 67;
                                            case 136 -> 9;
                                            case 137 -> 116;
                                            case 138 -> 45;
                                            case 139 -> 41;
                                            case 140 -> 35;
                                            case 141 -> 171;
                                            case 142 -> 255;
                                            case 143 -> 153;
                                            case 144 -> 36;
                                            case 145 -> 203;
                                            case 146 -> 244;
                                            case 147 -> 64;
                                            case 148 -> 138;
                                            case 149 -> 94;
                                            case 150 -> 163;
                                            case 151 -> 212;
                                            case 152 -> 204;
                                            case 153 -> 22;
                                            case 154 -> 249;
                                            case 155 -> 73;
                                            case 156 -> 128;
                                            case 157 -> 192;
                                            case 158 -> 167;
                                            case 159 -> 57;
                                            case 160 -> 170;
                                            case 161 -> 42;
                                            case 162 -> 186;
                                            case 163 -> 10;
                                            case 164 -> 210;
                                            case 165 -> 120;
                                            case 166 -> 217;
                                            case 167 -> 197;
                                            case 168 -> 84;
                                            case 169 -> 147;
                                            case 170 -> 58;
                                            case 171 -> 69;
                                            case 172 -> 220;
                                            case 173 -> 219;
                                            case 174 -> 241;
                                            case 175 -> 100;
                                            case 176 -> 13;
                                            case 177 -> 174;
                                            case 178 -> 183;
                                            case 179 -> 246;
                                            case 180 -> 12;
                                            case 181 -> 191;
                                            case 182 -> 240;
                                            case 183 -> 27;
                                            case 184 -> 142;
                                            case 185 -> 152;
                                            case 186 -> 218;
                                            case 187 -> 250;
                                            case 188 -> 235;
                                            case 189 -> 194;
                                            case 190 -> 105;
                                            case 191 -> 62;
                                            case 192 -> 4;
                                            case 193 -> 91;
                                            case 194 -> 98;
                                            case 195 -> 177;
                                            case 196 -> 23;
                                            case 197 -> 75;
                                            case 198 -> 59;
                                            case 199 -> 0;
                                            case 200 -> 180;
                                            case 201 -> 20;
                                            case 202 -> 208;
                                            case 203 -> 193;
                                            case 204 -> 37;
                                            case 205 -> 77;
                                            case 206 -> 132;
                                            case 207 -> 237;
                                            case 208 -> 28;
                                            case 209 -> 201;
                                            case 210 -> 172;
                                            case 211 -> 125;
                                            case 212 -> 164;
                                            case 213 -> 254;
                                            case 214 -> 145;
                                            case 215 -> 119;
                                            case 216 -> 51;
                                            case 217 -> 79;
                                            case 218 -> 114;
                                            case 219 -> 182;
                                            case 220 -> 2;
                                            case 221 -> 195;
                                            case 222 -> 38;
                                            case 223 -> 146;
                                            case 224 -> 162;
                                            case 225 -> 99;
                                            case 226 -> 133;
                                            case 227 -> 97;
                                            case 228 -> 160;
                                            case 229 -> 189;
                                            case 230 -> 103;
                                            case 231 -> 110;
                                            case 232 -> 123;
                                            case 233 -> 29;
                                            case 234 -> 223;
                                            case 235 -> 111;
                                            case 236 -> 11;
                                            case 237 -> 107;
                                            case 238 -> 206;
                                            case 239 -> 71;
                                            case 240 -> 30;
                                            case 241 -> 32;
                                            case 242 -> 6;
                                            case 243 -> 101;
                                            case 244 -> 83;
                                            case 245 -> 233;
                                            case 246 -> 238;
                                            case 247 -> 242;
                                            case 248 -> 95;
                                            case 249 -> 17;
                                            case 250 -> 47;
                                            case 251 -> 159;
                                            case 252 -> 65;
                                            case 253 -> 63;
                                            case 254 -> 178;
                                            default -> 93;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (nArray != null) break block32;
                            if (!ActionTimestamp.e()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.e(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 30906130044917L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.e();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-454550760 + -((char)-4829), -454550760 + -((char)-2193), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-454550760 + -((char)-4833), 454550760 + (char)-21574, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-454550760 + -((char)-4820), 454681830 - (char)-5972, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-454550760 + -((char)-4829), -454550760 + -((char)-2193), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-454550760 + -((char)-4833), 454550760 + (char)-21574, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-454550760 + -((char)-4821), 454681830 - (char)-5954, (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 63273464131795L;
                        int[] nArray2 = SshAgentIpcService.e();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(5898150 + 19238, -5898150 + -11547, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(5898150 + 19239, -5898150 + -5455, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 32556585475990L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                nArray = SshAgentIpcService.e();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(733336650 + (char)-28340, 733336650 + (char)-26752, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(733336650 + (char)-28336, -733336650 + -21237, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(733336650 + (char)-28351, 733336650 + (char)-22628, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(733336650 + (char)-28336, -733336650 + -21237, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(733336650 + (char)-28346, -733336650 + -15525, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(733336650 + (char)-28340, 733336650 + (char)-26752, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(733336650 + (char)-28336, -733336650 + -21237, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(733336650 + (char)-28352, -733336650 + -19179, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(733336650 + (char)-28340, 733336650 + (char)-26752, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(733336650 + (char)-28336, -733336650 + -21237, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(733336650 + (char)-28357, 733336650 + (char)-28317, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(733336650 + (char)-28340, 733336650 + (char)-26752, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(733336650 + (char)-28336, -733336650 + -21237, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(733336650 + (char)-28358, 733336650 + 21412, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 121628165266370L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.e();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1013564310 + -23208, -1013564310 + -19660, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1013564310 + -23196, 1013564310 + (char)-26369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1013564310 + -23191, -1013564310 + -19940, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1013564310 + -23192, -1013564310 + -((char)-30053), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1013564310 + -23208, -1013564310 + -19660, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1013564310 + -23196, 1013564310 + (char)-26369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1013564310 + -23189, -1013564310 + -((char)-32392), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1013564310 + -23208, -1013564310 + -19660, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1013564310 + -23196, 1013564310 + (char)-26369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1013564310 + -23190, 1013564310 + (char)-23689, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1013564310 + -23208, -1013564310 + -19660, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1013564310 + -23196, 1013564310 + (char)-26369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1013564310 + -23187, -1013564310 + -((char)-18614), (int)l2));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1013564310 + -23208, -1013564310 + -19660, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1013564310 + -23196, 1013564310 + (char)-26369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1013564310 + -23188, 1013564310 + (char)-18656, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u009cy)\u00d0at0\u0000\u0014l\u00f1\u000f&[\"\u00d8\u00d0\u0096[\u0003,m>\u009cu\u00d2\u00a0\fR\u0006\u00ecx'\u00f0\u00ca1\u0018\u00b8\u00a2\u00f5|\u0086\u00aca\u00c1i\u0004\u00f3\u00b7\u0015\u00b2\u00c1f\u00d0\u00abb\u00ae\u00c3\u0014\u00ef\u00c2\t\u00c9\u00beEN\u00fbu\u00d6\u00b2\u00a3\u00058\u009c\u00bdl\u0083\b_EQ&<\u008c\u009d\u00fd\u0005%\u008d\u001eN\u00f7\u001e\u00d8\u0093\u00b4\u00e9?\u00da\u00f4u~\u0086Z`lhLY\u0080\u00dd\u00ba\u0094t|\u0015\u0002$\u00a2\u00dd5^\u0010\u0010@\u007fC\u00b1\u0096\u00e37\u00ab{\u00efw\u00b0\u00cf'\u0097/\t\u0001\u00d1\u008a\u00b2Q\u00cd\u00a5:#\u0010\u007f$\u00a4\u00daj\u008e\u00a8\u0006\u0088Z\t\u0006\u0000\u00f1n\u00f5?7\u00b6AM\u008cG\u0007\u00aaq\u00ac\u00fe\u00deGI\u0014DN\u001b\u001e\u0089n\u008d-Z3A2\u00fd\u0094_\u00a1c\u00fc\u00f5\u00e5u'\u00f1Iw`wm\u00a2x\u00a9\u00a9$\u00a5\u00b4\u00fa\f\u00eb\u0094\u0006\u00f0\u00b1\u008f\u00d2S\u00be\u0084\"\b>:}\u00c9\u00b9q-B\f\u00c9\u000e\u0093Ty\u00a0\u00db\u007f\u00cf=\u00b3\u00eeF\u00b6\u0093|\u00e7\u0084\u00d6d\u00b18\u00e8G\u0090\u00e6\u0088?Z\u00d7\u00bf-\u00b2\u001a\u00b8\u00a0\u00ce\u00b4\u00f81\u00c1K\u00f1`\u008a\u00f8~\u00a7%\u00b5\u00b6\u00b0[\u00cc\u00e7sKe\u0011^N\u00bc\u0001\u00bf\u0010\u00ac\u0081\u00f8I\u00f1\u00ccL\u0087^wb\u00afm\u00e5\u00eaW\u00b1\u00f9\u001fM\u00ca\u0006\u00c2i\u00bf>\u00d9'\u0013q\u00d2\t#\u00eb\u0081\u000f.6 .j\u0089k\u00d6_\u0094Fj\u008fF\u000b\u001a\u00c4\u00e9\r6\u008b2\u001a\u00f2\u009d\u001e\u0015\u0082\u00dd\u00fa-S\u00e7r\u00ea\u00c4c\u0010\u0017\u009b7\u00a4U\u001d \u00a9\u0098\u00eb)\u00a1\u00ac\u009b\u000e\u00da&H\u00ea\u00e9u\u00a8\u001e6\u00b0\u0092\u00f6\u007fH\u00e3Kd\u007f\u0006\u00d1HA\u0090\u00fd\u00c5\f1\u000b,\u00eb[\u001a4L\u000b\u00ad\u0018\u0007\u00a2\u0088\u00f1\u0090\u00b3\u00a8\u00fe\u0007\u009d\u00b9r\u00da$\u000e\u001a(\u00f9\u008d\u00dc\u000b\u0082\u00ec\u00b5\u0094&m{+o\u0097\u00fb\u0091U\t\b x,\u00eapE\u00c9\u0087\u0097\u0010!P\u00b7\u00fb\u0017?(\u0002w^9\u000f\u00d2G\u00f7{\u000f\u008e\u00a1\u001b\u00d1\u0011$\u00f5$\u0018\f\"\u00f6\u008cq\n\u0087\u00a6\u00e3\u00fa\u009cw\u0006^\u00e0\u00b4,\u00b8C\u00a8\u00ee\u0015/\u00b4\u00cf\u00f8\u00e20\b\r\u00f2 u\u0089\u008aH\u000e\u00af\u00d4X\t\u00fa\u00c0\u001f\u00d2\u0006(\u00de\u00d2w\u00f6\u001b\u00db\u00d1\u00d1\u00ac0\u00c1\u00d3\u00ae\u00c8 \u008a\u00d2\u00ad\u00c0\u00a3 \u001a\u0011x\u00be\u00c6\u00f5\u0081v`\u008c\r\n$\u00ea\u00ea\u00ccC)n\u0099\u00d4\u00a4\u0018O\u00e5C'c\f\u0098I\u00bf\u0015\u00a6\u00eb\u0091\u00b4\u00d8\u008f\u0002\u00e5\u00acY$B\u0086\u00d3)`\f\u00a3\u001a\u00dd\u00a4\u00a8\u00ba\u00f5\u007f+_B\u0091\u0083\u00a9#\u00d6\u00b7]\u00d4\u00adY\u0087\u00d6\u0019\u00de\u001a_\u00ac\u00d9\u008e\u0014\u0085\u0089C\u00b0C\u009bL\n";
                var4_3 = "\u009cy)\u00d0at0\u0000\u0014l\u00f1\u000f&[\"\u00d8\u00d0\u0096[\u0003,m>\u009cu\u00d2\u00a0\fR\u0006\u00ecx'\u00f0\u00ca1\u0018\u00b8\u00a2\u00f5|\u0086\u00aca\u00c1i\u0004\u00f3\u00b7\u0015\u00b2\u00c1f\u00d0\u00abb\u00ae\u00c3\u0014\u00ef\u00c2\t\u00c9\u00beEN\u00fbu\u00d6\u00b2\u00a3\u00058\u009c\u00bdl\u0083\b_EQ&<\u008c\u009d\u00fd\u0005%\u008d\u001eN\u00f7\u001e\u00d8\u0093\u00b4\u00e9?\u00da\u00f4u~\u0086Z`lhLY\u0080\u00dd\u00ba\u0094t|\u0015\u0002$\u00a2\u00dd5^\u0010\u0010@\u007fC\u00b1\u0096\u00e37\u00ab{\u00efw\u00b0\u00cf'\u0097/\t\u0001\u00d1\u008a\u00b2Q\u00cd\u00a5:#\u0010\u007f$\u00a4\u00daj\u008e\u00a8\u0006\u0088Z\t\u0006\u0000\u00f1n\u00f5?7\u00b6AM\u008cG\u0007\u00aaq\u00ac\u00fe\u00deGI\u0014DN\u001b\u001e\u0089n\u008d-Z3A2\u00fd\u0094_\u00a1c\u00fc\u00f5\u00e5u'\u00f1Iw`wm\u00a2x\u00a9\u00a9$\u00a5\u00b4\u00fa\f\u00eb\u0094\u0006\u00f0\u00b1\u008f\u00d2S\u00be\u0084\"\b>:}\u00c9\u00b9q-B\f\u00c9\u000e\u0093Ty\u00a0\u00db\u007f\u00cf=\u00b3\u00eeF\u00b6\u0093|\u00e7\u0084\u00d6d\u00b18\u00e8G\u0090\u00e6\u0088?Z\u00d7\u00bf-\u00b2\u001a\u00b8\u00a0\u00ce\u00b4\u00f81\u00c1K\u00f1`\u008a\u00f8~\u00a7%\u00b5\u00b6\u00b0[\u00cc\u00e7sKe\u0011^N\u00bc\u0001\u00bf\u0010\u00ac\u0081\u00f8I\u00f1\u00ccL\u0087^wb\u00afm\u00e5\u00eaW\u00b1\u00f9\u001fM\u00ca\u0006\u00c2i\u00bf>\u00d9'\u0013q\u00d2\t#\u00eb\u0081\u000f.6 .j\u0089k\u00d6_\u0094Fj\u008fF\u000b\u001a\u00c4\u00e9\r6\u008b2\u001a\u00f2\u009d\u001e\u0015\u0082\u00dd\u00fa-S\u00e7r\u00ea\u00c4c\u0010\u0017\u009b7\u00a4U\u001d \u00a9\u0098\u00eb)\u00a1\u00ac\u009b\u000e\u00da&H\u00ea\u00e9u\u00a8\u001e6\u00b0\u0092\u00f6\u007fH\u00e3Kd\u007f\u0006\u00d1HA\u0090\u00fd\u00c5\f1\u000b,\u00eb[\u001a4L\u000b\u00ad\u0018\u0007\u00a2\u0088\u00f1\u0090\u00b3\u00a8\u00fe\u0007\u009d\u00b9r\u00da$\u000e\u001a(\u00f9\u008d\u00dc\u000b\u0082\u00ec\u00b5\u0094&m{+o\u0097\u00fb\u0091U\t\b x,\u00eapE\u00c9\u0087\u0097\u0010!P\u00b7\u00fb\u0017?(\u0002w^9\u000f\u00d2G\u00f7{\u000f\u008e\u00a1\u001b\u00d1\u0011$\u00f5$\u0018\f\"\u00f6\u008cq\n\u0087\u00a6\u00e3\u00fa\u009cw\u0006^\u00e0\u00b4,\u00b8C\u00a8\u00ee\u0015/\u00b4\u00cf\u00f8\u00e20\b\r\u00f2 u\u0089\u008aH\u000e\u00af\u00d4X\t\u00fa\u00c0\u001f\u00d2\u0006(\u00de\u00d2w\u00f6\u001b\u00db\u00d1\u00d1\u00ac0\u00c1\u00d3\u00ae\u00c8 \u008a\u00d2\u00ad\u00c0\u00a3 \u001a\u0011x\u00be\u00c6\u00f5\u0081v`\u008c\r\n$\u00ea\u00ea\u00ccC)n\u0099\u00d4\u00a4\u0018O\u00e5C'c\f\u0098I\u00bf\u0015\u00a6\u00eb\u0091\u00b4\u00d8\u008f\u0002\u00e5\u00acY$B\u0086\u00d3)`\f\u00a3\u001a\u00dd\u00a4\u00a8\u00ba\u00f5\u007f+_B\u0091\u0083\u00a9#\u00d6\u00b7]\u00d4\u00adY\u0087\u00d6\u0019\u00de\u001a_\u00ac\u00d9\u008e\u0014\u0085\u0089C\u00b0C\u009bL\n".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 77;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00e9\u00ee&\u00fa\u007f\u00ba\u0087>k\u001d\u00d2\u00f6D\u00f4\u0090\u00c8\u00b0\u0086GI\u00cc(\u000f\u00ce\u009b\u00f3\u0091 \u0000\u00b6\u00c6^Y\u0096\u00cc\u0096\u00bd\u001f\u0012";
                    var4_3 = "\u00e9\u00ee&\u00fa\u007f\u00ba\u0087>k\u001d\u00d2\u00f6D\u00f4\u0090\u00c8\u00b0\u0086GI\u00cc(\u000f\u00ce\u009b\u00f3\u0091 \u0000\u00b6\u00c6^Y\u0096\u00cc\u0096\u00bd\u001f\u0012".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 51;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 98;
                            break;
                        }
                        case 1: {
                            v15 = 3;
                            break;
                        }
                        case 2: {
                            v15 = 28;
                            break;
                        }
                        case 3: {
                            v15 = 90;
                            break;
                        }
                        case 4: {
                            v15 = 13;
                            break;
                        }
                        case 5: {
                            v15 = 105;
                            break;
                        }
                        default: {
                            v15 = 119;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x3A0B) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 104;
                case 1 -> 137;
                case 2 -> 161;
                case 3 -> 142;
                case 4 -> 113;
                case 5 -> 218;
                case 6 -> 203;
                case 7 -> 194;
                case 8 -> 86;
                case 9 -> 154;
                case 10 -> 221;
                case 11 -> 230;
                case 12 -> 110;
                case 13 -> 226;
                case 14 -> 152;
                case 15 -> 50;
                case 16 -> 166;
                case 17 -> 92;
                case 18 -> 33;
                case 19 -> 101;
                case 20 -> 103;
                case 21 -> 220;
                case 22 -> 216;
                case 23 -> 69;
                case 24 -> 132;
                case 25 -> 2;
                case 26 -> 83;
                case 27 -> 181;
                case 28 -> 175;
                case 29 -> 254;
                case 30 -> 167;
                case 31 -> 158;
                case 32 -> 39;
                case 33 -> 234;
                case 34 -> 70;
                case 35 -> 62;
                case 36 -> 77;
                case 37 -> 63;
                case 38 -> 139;
                case 39 -> 26;
                case 40 -> 172;
                case 41 -> 16;
                case 42 -> 252;
                case 43 -> 237;
                case 44 -> 240;
                case 45 -> 156;
                case 46 -> 165;
                case 47 -> 114;
                case 48 -> 30;
                case 49 -> 117;
                case 50 -> 27;
                case 51 -> 141;
                case 52 -> 209;
                case 53 -> 186;
                case 54 -> 124;
                case 55 -> 79;
                case 56 -> 75;
                case 57 -> 1;
                case 58 -> 18;
                case 59 -> 255;
                case 60 -> 247;
                case 61 -> 229;
                case 62 -> 249;
                case 63 -> 235;
                case 64 -> 211;
                case 65 -> 14;
                case 66 -> 68;
                case 67 -> 170;
                case 68 -> 159;
                case 69 -> 73;
                case 70 -> 176;
                case 71 -> 21;
                case 72 -> 61;
                case 73 -> 140;
                case 74 -> 202;
                case 75 -> 58;
                case 76 -> 29;
                case 77 -> 183;
                case 78 -> 10;
                case 79 -> 90;
                case 80 -> 37;
                case 81 -> 205;
                case 82 -> 49;
                case 83 -> 184;
                case 84 -> 80;
                case 85 -> 59;
                case 86 -> 66;
                case 87 -> 22;
                case 88 -> 251;
                case 89 -> 193;
                case 90 -> 119;
                case 91 -> 53;
                case 92 -> 225;
                case 93 -> 4;
                case 94 -> 231;
                case 95 -> 9;
                case 96 -> 214;
                case 97 -> 148;
                case 98 -> 20;
                case 99 -> 174;
                case 100 -> 3;
                case 101 -> 180;
                case 102 -> 52;
                case 103 -> 46;
                case 104 -> 134;
                case 105 -> 147;
                case 106 -> 160;
                case 107 -> 138;
                case 108 -> 116;
                case 109 -> 232;
                case 110 -> 67;
                case 111 -> 207;
                case 112 -> 64;
                case 113 -> 54;
                case 114 -> 42;
                case 115 -> 179;
                case 116 -> 195;
                case 117 -> 55;
                case 118 -> 149;
                case 119 -> 48;
                case 120 -> 78;
                case 121 -> 145;
                case 122 -> 19;
                case 123 -> 199;
                case 124 -> 111;
                case 125 -> 215;
                case 126 -> 244;
                case 127 -> 182;
                case 128 -> 190;
                case 129 -> 155;
                case 130 -> 144;
                case 131 -> 187;
                case 132 -> 185;
                case 133 -> 57;
                case 134 -> 13;
                case 135 -> 168;
                case 136 -> 120;
                case 137 -> 31;
                case 138 -> 123;
                case 139 -> 125;
                case 140 -> 130;
                case 141 -> 239;
                case 142 -> 41;
                case 143 -> 5;
                case 144 -> 105;
                case 145 -> 250;
                case 146 -> 162;
                case 147 -> 97;
                case 148 -> 228;
                case 149 -> 17;
                case 150 -> 143;
                case 151 -> 81;
                case 152 -> 198;
                case 153 -> 131;
                case 154 -> 100;
                case 155 -> 0;
                case 156 -> 192;
                case 157 -> 189;
                case 158 -> 71;
                case 159 -> 85;
                case 160 -> 65;
                case 161 -> 51;
                case 162 -> 76;
                case 163 -> 177;
                case 164 -> 246;
                case 165 -> 219;
                case 166 -> 35;
                case 167 -> 127;
                case 168 -> 128;
                case 169 -> 248;
                case 170 -> 87;
                case 171 -> 191;
                case 172 -> 151;
                case 173 -> 56;
                case 174 -> 94;
                case 175 -> 28;
                case 176 -> 241;
                case 177 -> 102;
                case 178 -> 23;
                case 179 -> 129;
                case 180 -> 178;
                case 181 -> 227;
                case 182 -> 169;
                case 183 -> 133;
                case 184 -> 96;
                case 185 -> 82;
                case 186 -> 153;
                case 187 -> 47;
                case 188 -> 109;
                case 189 -> 121;
                case 190 -> 98;
                case 191 -> 84;
                case 192 -> 223;
                case 193 -> 171;
                case 194 -> 6;
                case 195 -> 126;
                case 196 -> 108;
                case 197 -> 206;
                case 198 -> 164;
                case 199 -> 95;
                case 200 -> 253;
                case 201 -> 60;
                case 202 -> 201;
                case 203 -> 11;
                case 204 -> 89;
                case 205 -> 233;
                case 206 -> 15;
                case 207 -> 43;
                case 208 -> 212;
                case 209 -> 210;
                case 210 -> 34;
                case 211 -> 217;
                case 212 -> 7;
                case 213 -> 107;
                case 214 -> 122;
                case 215 -> 200;
                case 216 -> 196;
                case 217 -> 88;
                case 218 -> 38;
                case 219 -> 157;
                case 220 -> 208;
                case 221 -> 245;
                case 222 -> 213;
                case 223 -> 74;
                case 224 -> 112;
                case 225 -> 224;
                case 226 -> 40;
                case 227 -> 24;
                case 228 -> 8;
                case 229 -> 44;
                case 230 -> 99;
                case 231 -> 12;
                case 232 -> 136;
                case 233 -> 91;
                case 234 -> 222;
                case 235 -> 106;
                case 236 -> 146;
                case 237 -> 45;
                case 238 -> 204;
                case 239 -> 173;
                case 240 -> 163;
                case 241 -> 36;
                case 242 -> 236;
                case 243 -> 115;
                case 244 -> 118;
                case 245 -> 188;
                case 246 -> 25;
                case 247 -> 238;
                case 248 -> 32;
                case 249 -> 243;
                case 250 -> 93;
                case 251 -> 197;
                case 252 -> 72;
                case 253 -> 150;
                case 254 -> 135;
                default -> 242;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 68792603045390L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(111933780 - (char)-1062, 111802710 + (char)-8534, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 23408632224848L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.e();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1060487370 - 29093, 1060487370 - (char)-23751, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1060487370 - 29092, 1060487370 - 17055, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1060487370 - 29091, 1060487370 - 21814, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = ":\u00ecC\u0019 r\u00e2Q\u0010B\u00d7\u00bd\u00dfE\u0011\u00b7d\u00e1\u00a8_T\u00f5AAi";
                    var4_3 = ":\u00ecC\u0019 r\u00e2Q\u0010B\u00d7\u00bd\u00dfE\u0011\u00b7d\u00e1\u00a8_T\u00f5AAi".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 48;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "S\u00f4R&N5H\u00d6&\u000e\u0012.y\u0014s!\u00a3\u0099\u00a1.\u00f22\u000e[\u00b1\u0013A\u00f6\u00d2\u00e3\u00ea\u00e9\u0015\u0004M\u00e6\u00c9T=\u00ac\u001f\u00b2\u000b\u00a1\u00cf&\u0003\u00b4;\u0084e\u00c1\u00c8\u00b8\u00fb|\u0094\u00b2$";
                        var4_3 = "S\u00f4R&N5H\u00d6&\u000e\u0012.y\u0014s!\u00a3\u0099\u00a1.\u00f22\u000e[\u00b1\u0013A\u00f6\u00d2\u00e3\u00ea\u00e9\u0015\u0004M\u00e6\u00c9T=\u00ac\u001f\u00b2\u000b\u00a1\u00cf&\u0003\u00b4;\u0084e\u00c1\u00c8\u00b8\u00fb|\u0094\u00b2$".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 66;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 32;
                                break;
                            }
                            case 1: {
                                v15 = 55;
                                break;
                            }
                            case 2: {
                                v15 = 56;
                                break;
                            }
                            case 3: {
                                v15 = 117;
                                break;
                            }
                            case 4: {
                                v15 = 87;
                                break;
                            }
                            case 5: {
                                v15 = 97;
                                break;
                            }
                            default: {
                                v15 = 20;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1374) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 215;
                    case 1 -> 233;
                    case 2 -> 35;
                    case 3 -> 16;
                    case 4 -> 164;
                    case 5 -> 209;
                    case 6 -> 38;
                    case 7 -> 113;
                    case 8 -> 162;
                    case 9 -> 191;
                    case 10 -> 115;
                    case 11 -> 175;
                    case 12 -> 133;
                    case 13 -> 36;
                    case 14 -> 208;
                    case 15 -> 213;
                    case 16 -> 135;
                    case 17 -> 199;
                    case 18 -> 57;
                    case 19 -> 145;
                    case 20 -> 63;
                    case 21 -> 224;
                    case 22 -> 86;
                    case 23 -> 64;
                    case 24 -> 219;
                    case 25 -> 202;
                    case 26 -> 116;
                    case 27 -> 70;
                    case 28 -> 142;
                    case 29 -> 241;
                    case 30 -> 54;
                    case 31 -> 103;
                    case 32 -> 197;
                    case 33 -> 106;
                    case 34 -> 236;
                    case 35 -> 22;
                    case 36 -> 247;
                    case 37 -> 60;
                    case 38 -> 107;
                    case 39 -> 131;
                    case 40 -> 183;
                    case 41 -> 226;
                    case 42 -> 180;
                    case 43 -> 121;
                    case 44 -> 73;
                    case 45 -> 242;
                    case 46 -> 83;
                    case 47 -> 11;
                    case 48 -> 170;
                    case 49 -> 58;
                    case 50 -> 172;
                    case 51 -> 163;
                    case 52 -> 246;
                    case 53 -> 13;
                    case 54 -> 120;
                    case 55 -> 205;
                    case 56 -> 111;
                    case 57 -> 118;
                    case 58 -> 139;
                    case 59 -> 33;
                    case 60 -> 204;
                    case 61 -> 159;
                    case 62 -> 62;
                    case 63 -> 239;
                    case 64 -> 179;
                    case 65 -> 96;
                    case 66 -> 152;
                    case 67 -> 105;
                    case 68 -> 221;
                    case 69 -> 167;
                    case 70 -> 21;
                    case 71 -> 240;
                    case 72 -> 217;
                    case 73 -> 223;
                    case 74 -> 143;
                    case 75 -> 1;
                    case 76 -> 10;
                    case 77 -> 4;
                    case 78 -> 144;
                    case 79 -> 178;
                    case 80 -> 168;
                    case 81 -> 222;
                    case 82 -> 140;
                    case 83 -> 20;
                    case 84 -> 50;
                    case 85 -> 136;
                    case 86 -> 169;
                    case 87 -> 195;
                    case 88 -> 24;
                    case 89 -> 206;
                    case 90 -> 123;
                    case 91 -> 250;
                    case 92 -> 9;
                    case 93 -> 200;
                    case 94 -> 95;
                    case 95 -> 109;
                    case 96 -> 252;
                    case 97 -> 76;
                    case 98 -> 248;
                    case 99 -> 114;
                    case 100 -> 98;
                    case 101 -> 15;
                    case 102 -> 122;
                    case 103 -> 51;
                    case 104 -> 184;
                    case 105 -> 243;
                    case 106 -> 81;
                    case 107 -> 232;
                    case 108 -> 102;
                    case 109 -> 104;
                    case 110 -> 255;
                    case 111 -> 182;
                    case 112 -> 132;
                    case 113 -> 30;
                    case 114 -> 230;
                    case 115 -> 244;
                    case 116 -> 68;
                    case 117 -> 190;
                    case 118 -> 80;
                    case 119 -> 129;
                    case 120 -> 189;
                    case 121 -> 128;
                    case 122 -> 46;
                    case 123 -> 158;
                    case 124 -> 157;
                    case 125 -> 229;
                    case 126 -> 124;
                    case 127 -> 84;
                    case 128 -> 198;
                    case 129 -> 218;
                    case 130 -> 7;
                    case 131 -> 127;
                    case 132 -> 225;
                    case 133 -> 153;
                    case 134 -> 237;
                    case 135 -> 193;
                    case 136 -> 25;
                    case 137 -> 8;
                    case 138 -> 59;
                    case 139 -> 146;
                    case 140 -> 99;
                    case 141 -> 71;
                    case 142 -> 216;
                    case 143 -> 148;
                    case 144 -> 94;
                    case 145 -> 211;
                    case 146 -> 52;
                    case 147 -> 137;
                    case 148 -> 23;
                    case 149 -> 3;
                    case 150 -> 134;
                    case 151 -> 29;
                    case 152 -> 5;
                    case 153 -> 125;
                    case 154 -> 44;
                    case 155 -> 173;
                    case 156 -> 141;
                    case 157 -> 91;
                    case 158 -> 150;
                    case 159 -> 130;
                    case 160 -> 100;
                    case 161 -> 49;
                    case 162 -> 53;
                    case 163 -> 19;
                    case 164 -> 176;
                    case 165 -> 61;
                    case 166 -> 41;
                    case 167 -> 112;
                    case 168 -> 227;
                    case 169 -> 48;
                    case 170 -> 88;
                    case 171 -> 82;
                    case 172 -> 92;
                    case 173 -> 207;
                    case 174 -> 160;
                    case 175 -> 67;
                    case 176 -> 17;
                    case 177 -> 231;
                    case 178 -> 39;
                    case 179 -> 32;
                    case 180 -> 235;
                    case 181 -> 93;
                    case 182 -> 87;
                    case 183 -> 47;
                    case 184 -> 149;
                    case 185 -> 34;
                    case 186 -> 78;
                    case 187 -> 89;
                    case 188 -> 155;
                    case 189 -> 110;
                    case 190 -> 26;
                    case 191 -> 90;
                    case 192 -> 6;
                    case 193 -> 27;
                    case 194 -> 37;
                    case 195 -> 251;
                    case 196 -> 101;
                    case 197 -> 187;
                    case 198 -> 201;
                    case 199 -> 174;
                    case 200 -> 245;
                    case 201 -> 65;
                    case 202 -> 171;
                    case 203 -> 234;
                    case 204 -> 181;
                    case 205 -> 69;
                    case 206 -> 254;
                    case 207 -> 166;
                    case 208 -> 97;
                    case 209 -> 138;
                    case 210 -> 249;
                    case 211 -> 147;
                    case 212 -> 177;
                    case 213 -> 188;
                    case 214 -> 40;
                    case 215 -> 151;
                    case 216 -> 108;
                    case 217 -> 66;
                    case 218 -> 196;
                    case 219 -> 56;
                    case 220 -> 212;
                    case 221 -> 228;
                    case 222 -> 214;
                    case 223 -> 72;
                    case 224 -> 14;
                    case 225 -> 119;
                    case 226 -> 75;
                    case 227 -> 55;
                    case 228 -> 2;
                    case 229 -> 31;
                    case 230 -> 154;
                    case 231 -> 253;
                    case 232 -> 18;
                    case 233 -> 12;
                    case 234 -> 192;
                    case 235 -> 74;
                    case 236 -> 165;
                    case 237 -> 43;
                    case 238 -> 45;
                    case 239 -> 126;
                    case 240 -> 186;
                    case 241 -> 117;
                    case 242 -> 28;
                    case 243 -> 185;
                    case 244 -> 220;
                    case 245 -> 210;
                    case 246 -> 77;
                    case 247 -> 203;
                    case 248 -> 194;
                    case 249 -> 156;
                    case 250 -> 42;
                    case 251 -> 85;
                    case 252 -> 79;
                    case 253 -> 161;
                    case 254 -> 0;
                    default -> 238;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 5625834527337L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "eA\r0\u0013%j<\tbK\u001e:^gw \r";
                    var5_4 = "eA\r0\u0013%j<\tbK\u001e:^gw \r".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 67;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 77;
                                    break;
                                }
                                case 1: {
                                    v11 = 103;
                                    break;
                                }
                                case 2: {
                                    v11 = 60;
                                    break;
                                }
                                case 3: {
                                    v11 = 29;
                                    break;
                                }
                                case 4: {
                                    v11 = 53;
                                    break;
                                }
                                case 5: {
                                    v11 = 10;
                                    break;
                                }
                                default: {
                                    v11 = 26;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 36356414611010L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "|\u0002n\u00056\u000b\u0013\u0004z\u001cb\u001f\nv\u0003i\u001f:\t\u000b\\\u0002`\tv\u0003i\u001f:\t\u000bP\b\rq\u0005t\u00120\u0004\u0011P\u000fs\u00181\r";
                    var5_4 = "|\u0002n\u00056\u000b\u0013\u0004z\u001cb\u001f\nv\u0003i\u001f:\t\u000b\\\u0002`\tv\u0003i\u001f:\t\u000bP\b\rq\u0005t\u00120\u0004\u0011P\u000fs\u00181\r".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 20;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "U#K!\u0015';\u0006U#K!\u0019-";
                        var5_4 = "U#K!\u0015';\u0006U#K!\u0019-".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 55;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 33;
                                break;
                            }
                            case 1: {
                                v15 = 120;
                                break;
                            }
                            case 2: {
                                v15 = 19;
                                break;
                            }
                            case 3: {
                                v15 = 101;
                                break;
                            }
                            case 4: {
                                v15 = 75;
                                break;
                            }
                            case 5: {
                                v15 = 126;
                                break;
                            }
                            default: {
                                v15 = 107;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 83385284469042L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1505601090 - (char)-31968, -1505601090 - -28571, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 56981125541003L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "]]$\u00ac\u001a\u0003\u00daj`\u0005\u0098\u0003\u00ba\u00a3*\r+t\u00fa\u0007\u00d7\u00f2\u009e\u00d1s7\u00a9\u00af\u00a0\u0010\u00b5\u00bd\u00ee\u00d5j=\u0002\u0015)+\u0001aS\u00b7a\u00c9\u0005c\u0001\u00c5\u00e3\u00c53\u00c4\u00c5 \ffB\u00b3\u00eeb\u00a9\u00e3\u0018\u00c9\u00c9\u001e\u00192^8\u00e2\u00bb\u0006\u00a9\u00e45\u00efV\u00feSO\u00a4G(91\u00a3vP\u00abkC+\u00ea\u0007\u00bf\u00b8\u0084\u00ec\u0097\u000e\u00ab";
                    var4_3 = "]]$\u00ac\u001a\u0003\u00daj`\u0005\u0098\u0003\u00ba\u00a3*\r+t\u00fa\u0007\u00d7\u00f2\u009e\u00d1s7\u00a9\u00af\u00a0\u0010\u00b5\u00bd\u00ee\u00d5j=\u0002\u0015)+\u0001aS\u00b7a\u00c9\u0005c\u0001\u00c5\u00e3\u00c53\u00c4\u00c5 \ffB\u00b3\u00eeb\u00a9\u00e3\u0018\u00c9\u00c9\u001e\u00192^8\u00e2\u00bb\u0006\u00a9\u00e45\u00efV\u00feSO\u00a4G(91\u00a3vP\u00abkC+\u00ea\u0007\u00bf\u00b8\u0084\u00ec\u0097\u000e\u00ab".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 88;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0000\u00f01\u0015\u00f8L9R'\u00aa\u00a98/\u00f5\u0087\u00e8L\u00e0%\u00dae\u00af\u008a\u00bd\u00e4>\u00ef&)\u00d0Y\u00eb\u0004\u00e0E\u00f4\u001e#\u0094\u00f9}u^\u0012gH\\A#\u00ed2\u0091\u00b79e\u0011\u00c2K\u008aM'7\u000b7\u00cbz\u00b7\u0097\u00a7<\u00188P~\u00d2\u009e\u0094#?\u00fa\u00df\u0096\u0091:\u00989\u0094\u0080mbW\u00a9\u00cb";
                        var4_3 = "\u0000\u00f01\u0015\u00f8L9R'\u00aa\u00a98/\u00f5\u0087\u00e8L\u00e0%\u00dae\u00af\u008a\u00bd\u00e4>\u00ef&)\u00d0Y\u00eb\u0004\u00e0E\u00f4\u001e#\u0094\u00f9}u^\u0012gH\\A#\u00ed2\u0091\u00b79e\u0011\u00c2K\u008aM'7\u000b7\u00cbz\u00b7\u0097\u00a7<\u00188P~\u00d2\u009e\u0094#?\u00fa\u00df\u0096\u0091:\u00989\u0094\u0080mbW\u00a9\u00cb".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 25;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 52;
                                break;
                            }
                            case 1: {
                                v15 = 47;
                                break;
                            }
                            case 2: {
                                v15 = 114;
                                break;
                            }
                            case 3: {
                                v15 = 84;
                                break;
                            }
                            case 4: {
                                v15 = 62;
                                break;
                            }
                            case 5: {
                                v15 = 77;
                                break;
                            }
                            default: {
                                v15 = 12;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8210) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 76;
                    case 1 -> 24;
                    case 2 -> 193;
                    case 3 -> 198;
                    case 4 -> 88;
                    case 5 -> 204;
                    case 6 -> 248;
                    case 7 -> 231;
                    case 8 -> 78;
                    case 9 -> 7;
                    case 10 -> 148;
                    case 11 -> 77;
                    case 12 -> 247;
                    case 13 -> 237;
                    case 14 -> 151;
                    case 15 -> 212;
                    case 16 -> 141;
                    case 17 -> 236;
                    case 18 -> 220;
                    case 19 -> 214;
                    case 20 -> 251;
                    case 21 -> 137;
                    case 22 -> 149;
                    case 23 -> 184;
                    case 24 -> 196;
                    case 25 -> 86;
                    case 26 -> 163;
                    case 27 -> 103;
                    case 28 -> 147;
                    case 29 -> 235;
                    case 30 -> 160;
                    case 31 -> 232;
                    case 32 -> 30;
                    case 33 -> 216;
                    case 34 -> 91;
                    case 35 -> 13;
                    case 36 -> 246;
                    case 37 -> 129;
                    case 38 -> 176;
                    case 39 -> 139;
                    case 40 -> 138;
                    case 41 -> 171;
                    case 42 -> 252;
                    case 43 -> 52;
                    case 44 -> 53;
                    case 45 -> 106;
                    case 46 -> 242;
                    case 47 -> 177;
                    case 48 -> 17;
                    case 49 -> 27;
                    case 50 -> 116;
                    case 51 -> 46;
                    case 52 -> 168;
                    case 53 -> 199;
                    case 54 -> 211;
                    case 55 -> 243;
                    case 56 -> 172;
                    case 57 -> 126;
                    case 58 -> 234;
                    case 59 -> 180;
                    case 60 -> 19;
                    case 61 -> 108;
                    case 62 -> 110;
                    case 63 -> 140;
                    case 64 -> 197;
                    case 65 -> 146;
                    case 66 -> 50;
                    case 67 -> 2;
                    case 68 -> 233;
                    case 69 -> 45;
                    case 70 -> 31;
                    case 71 -> 72;
                    case 72 -> 238;
                    case 73 -> 97;
                    case 74 -> 250;
                    case 75 -> 67;
                    case 76 -> 113;
                    case 77 -> 6;
                    case 78 -> 75;
                    case 79 -> 119;
                    case 80 -> 9;
                    case 81 -> 218;
                    case 82 -> 143;
                    case 83 -> 56;
                    case 84 -> 219;
                    case 85 -> 201;
                    case 86 -> 61;
                    case 87 -> 188;
                    case 88 -> 157;
                    case 89 -> 191;
                    case 90 -> 159;
                    case 91 -> 74;
                    case 92 -> 90;
                    case 93 -> 132;
                    case 94 -> 42;
                    case 95 -> 112;
                    case 96 -> 58;
                    case 97 -> 79;
                    case 98 -> 111;
                    case 99 -> 215;
                    case 100 -> 145;
                    case 101 -> 48;
                    case 102 -> 99;
                    case 103 -> 253;
                    case 104 -> 3;
                    case 105 -> 104;
                    case 106 -> 40;
                    case 107 -> 241;
                    case 108 -> 182;
                    case 109 -> 114;
                    case 110 -> 4;
                    case 111 -> 154;
                    case 112 -> 167;
                    case 113 -> 1;
                    case 114 -> 16;
                    case 115 -> 134;
                    case 116 -> 73;
                    case 117 -> 102;
                    case 118 -> 230;
                    case 119 -> 213;
                    case 120 -> 209;
                    case 121 -> 101;
                    case 122 -> 125;
                    case 123 -> 122;
                    case 124 -> 175;
                    case 125 -> 161;
                    case 126 -> 115;
                    case 127 -> 49;
                    case 128 -> 14;
                    case 129 -> 18;
                    case 130 -> 92;
                    case 131 -> 25;
                    case 132 -> 83;
                    case 133 -> 153;
                    case 134 -> 26;
                    case 135 -> 156;
                    case 136 -> 224;
                    case 137 -> 96;
                    case 138 -> 105;
                    case 139 -> 55;
                    case 140 -> 127;
                    case 141 -> 144;
                    case 142 -> 222;
                    case 143 -> 68;
                    case 144 -> 82;
                    case 145 -> 166;
                    case 146 -> 20;
                    case 147 -> 170;
                    case 148 -> 39;
                    case 149 -> 70;
                    case 150 -> 158;
                    case 151 -> 123;
                    case 152 -> 63;
                    case 153 -> 202;
                    case 154 -> 51;
                    case 155 -> 164;
                    case 156 -> 33;
                    case 157 -> 192;
                    case 158 -> 43;
                    case 159 -> 47;
                    case 160 -> 65;
                    case 161 -> 94;
                    case 162 -> 124;
                    case 163 -> 11;
                    case 164 -> 178;
                    case 165 -> 8;
                    case 166 -> 165;
                    case 167 -> 183;
                    case 168 -> 128;
                    case 169 -> 240;
                    case 170 -> 174;
                    case 171 -> 69;
                    case 172 -> 37;
                    case 173 -> 239;
                    case 174 -> 84;
                    case 175 -> 133;
                    case 176 -> 130;
                    case 177 -> 203;
                    case 178 -> 81;
                    case 179 -> 5;
                    case 180 -> 36;
                    case 181 -> 225;
                    case 182 -> 135;
                    case 183 -> 244;
                    case 184 -> 60;
                    case 185 -> 185;
                    case 186 -> 136;
                    case 187 -> 179;
                    case 188 -> 227;
                    case 189 -> 181;
                    case 190 -> 23;
                    case 191 -> 35;
                    case 192 -> 228;
                    case 193 -> 205;
                    case 194 -> 150;
                    case 195 -> 229;
                    case 196 -> 245;
                    case 197 -> 206;
                    case 198 -> 169;
                    case 199 -> 95;
                    case 200 -> 120;
                    case 201 -> 87;
                    case 202 -> 71;
                    case 203 -> 210;
                    case 204 -> 15;
                    case 205 -> 41;
                    case 206 -> 98;
                    case 207 -> 66;
                    case 208 -> 189;
                    case 209 -> 44;
                    case 210 -> 255;
                    case 211 -> 142;
                    case 212 -> 21;
                    case 213 -> 254;
                    case 214 -> 57;
                    case 215 -> 85;
                    case 216 -> 131;
                    case 217 -> 59;
                    case 218 -> 12;
                    case 219 -> 107;
                    case 220 -> 0;
                    case 221 -> 34;
                    case 222 -> 62;
                    case 223 -> 32;
                    case 224 -> 208;
                    case 225 -> 223;
                    case 226 -> 100;
                    case 227 -> 187;
                    case 228 -> 190;
                    case 229 -> 38;
                    case 230 -> 10;
                    case 231 -> 226;
                    case 232 -> 64;
                    case 233 -> 109;
                    case 234 -> 89;
                    case 235 -> 200;
                    case 236 -> 80;
                    case 237 -> 28;
                    case 238 -> 162;
                    case 239 -> 152;
                    case 240 -> 207;
                    case 241 -> 93;
                    case 242 -> 173;
                    case 243 -> 118;
                    case 244 -> 22;
                    case 245 -> 29;
                    case 246 -> 221;
                    case 247 -> 186;
                    case 248 -> 155;
                    case 249 -> 117;
                    case 250 -> 194;
                    case 251 -> 217;
                    case 252 -> 54;
                    case 253 -> 249;
                    case 254 -> 195;
                    default -> 121;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 33998394484699L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(566615610 + (char)-29183, 566615610 + 25052, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 94418999279983L;
                    int[] nArray = SshAgentIpcService.e();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1561699050 + 26532, 1561699050 + (char)-12512, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 181450876L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0098&\u00aa0`\u0003\u0013\u00fe\u008d";
                var4_3 = "\u0098&\u00aa0`\u0003\u0013\u00fe\u008d".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 115;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 13;
                                break;
                            }
                            case 1: {
                                v11 = 83;
                                break;
                            }
                            case 2: {
                                v11 = 45;
                                break;
                            }
                            case 3: {
                                v11 = 102;
                                break;
                            }
                            case 4: {
                                v11 = 48;
                                break;
                            }
                            case 5: {
                                v11 = 118;
                                break;
                            }
                            default: {
                                v11 = 79;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8BE0) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 15;
                    case 1 -> 240;
                    case 2 -> 172;
                    case 3 -> 90;
                    case 4 -> 102;
                    case 5 -> 227;
                    case 6 -> 208;
                    case 7 -> 29;
                    case 8 -> 192;
                    case 9 -> 167;
                    case 10 -> 92;
                    case 11 -> 199;
                    case 12 -> 216;
                    case 13 -> 149;
                    case 14 -> 94;
                    case 15 -> 157;
                    case 16 -> 74;
                    case 17 -> 22;
                    case 18 -> 197;
                    case 19 -> 40;
                    case 20 -> 237;
                    case 21 -> 246;
                    case 22 -> 57;
                    case 23 -> 144;
                    case 24 -> 152;
                    case 25 -> 148;
                    case 26 -> 50;
                    case 27 -> 109;
                    case 28 -> 206;
                    case 29 -> 64;
                    case 30 -> 104;
                    case 31 -> 78;
                    case 32 -> 4;
                    case 33 -> 91;
                    case 34 -> 198;
                    case 35 -> 41;
                    case 36 -> 28;
                    case 37 -> 101;
                    case 38 -> 220;
                    case 39 -> 5;
                    case 40 -> 248;
                    case 41 -> 245;
                    case 42 -> 1;
                    case 43 -> 134;
                    case 44 -> 45;
                    case 45 -> 3;
                    case 46 -> 202;
                    case 47 -> 53;
                    case 48 -> 35;
                    case 49 -> 219;
                    case 50 -> 81;
                    case 51 -> 165;
                    case 52 -> 201;
                    case 53 -> 205;
                    case 54 -> 255;
                    case 55 -> 135;
                    case 56 -> 209;
                    case 57 -> 39;
                    case 58 -> 110;
                    case 59 -> 75;
                    case 60 -> 147;
                    case 61 -> 153;
                    case 62 -> 61;
                    case 63 -> 80;
                    case 64 -> 26;
                    case 65 -> 16;
                    case 66 -> 221;
                    case 67 -> 48;
                    case 68 -> 60;
                    case 69 -> 190;
                    case 70 -> 179;
                    case 71 -> 128;
                    case 72 -> 88;
                    case 73 -> 145;
                    case 74 -> 7;
                    case 75 -> 173;
                    case 76 -> 24;
                    case 77 -> 189;
                    case 78 -> 253;
                    case 79 -> 77;
                    case 80 -> 164;
                    case 81 -> 72;
                    case 82 -> 120;
                    case 83 -> 93;
                    case 84 -> 232;
                    case 85 -> 224;
                    case 86 -> 105;
                    case 87 -> 243;
                    case 88 -> 141;
                    case 89 -> 116;
                    case 90 -> 96;
                    case 91 -> 65;
                    case 92 -> 112;
                    case 93 -> 241;
                    case 94 -> 228;
                    case 95 -> 51;
                    case 96 -> 238;
                    case 97 -> 131;
                    case 98 -> 66;
                    case 99 -> 73;
                    case 100 -> 14;
                    case 101 -> 222;
                    case 102 -> 47;
                    case 103 -> 184;
                    case 104 -> 83;
                    case 105 -> 84;
                    case 106 -> 171;
                    case 107 -> 111;
                    case 108 -> 154;
                    case 109 -> 71;
                    case 110 -> 32;
                    case 111 -> 234;
                    case 112 -> 27;
                    case 113 -> 207;
                    case 114 -> 97;
                    case 115 -> 247;
                    case 116 -> 156;
                    case 117 -> 67;
                    case 118 -> 36;
                    case 119 -> 210;
                    case 120 -> 89;
                    case 121 -> 137;
                    case 122 -> 95;
                    case 123 -> 6;
                    case 124 -> 200;
                    case 125 -> 159;
                    case 126 -> 178;
                    case 127 -> 117;
                    case 128 -> 21;
                    case 129 -> 87;
                    case 130 -> 142;
                    case 131 -> 103;
                    case 132 -> 8;
                    case 133 -> 115;
                    case 134 -> 69;
                    case 135 -> 23;
                    case 136 -> 174;
                    case 137 -> 140;
                    case 138 -> 218;
                    case 139 -> 166;
                    case 140 -> 125;
                    case 141 -> 2;
                    case 142 -> 138;
                    case 143 -> 49;
                    case 144 -> 119;
                    case 145 -> 62;
                    case 146 -> 52;
                    case 147 -> 217;
                    case 148 -> 250;
                    case 149 -> 244;
                    case 150 -> 239;
                    case 151 -> 226;
                    case 152 -> 11;
                    case 153 -> 113;
                    case 154 -> 143;
                    case 155 -> 212;
                    case 156 -> 214;
                    case 157 -> 98;
                    case 158 -> 193;
                    case 159 -> 85;
                    case 160 -> 0;
                    case 161 -> 150;
                    case 162 -> 191;
                    case 163 -> 38;
                    case 164 -> 123;
                    case 165 -> 252;
                    case 166 -> 151;
                    case 167 -> 203;
                    case 168 -> 160;
                    case 169 -> 33;
                    case 170 -> 254;
                    case 171 -> 168;
                    case 172 -> 231;
                    case 173 -> 182;
                    case 174 -> 37;
                    case 175 -> 130;
                    case 176 -> 195;
                    case 177 -> 251;
                    case 178 -> 180;
                    case 179 -> 44;
                    case 180 -> 176;
                    case 181 -> 161;
                    case 182 -> 124;
                    case 183 -> 18;
                    case 184 -> 183;
                    case 185 -> 25;
                    case 186 -> 188;
                    case 187 -> 127;
                    case 188 -> 132;
                    case 189 -> 56;
                    case 190 -> 13;
                    case 191 -> 43;
                    case 192 -> 155;
                    case 193 -> 169;
                    case 194 -> 31;
                    case 195 -> 213;
                    case 196 -> 242;
                    case 197 -> 86;
                    case 198 -> 225;
                    case 199 -> 100;
                    case 200 -> 249;
                    case 201 -> 17;
                    case 202 -> 79;
                    case 203 -> 236;
                    case 204 -> 58;
                    case 205 -> 34;
                    case 206 -> 235;
                    case 207 -> 99;
                    case 208 -> 10;
                    case 209 -> 12;
                    case 210 -> 63;
                    case 211 -> 59;
                    case 212 -> 42;
                    case 213 -> 55;
                    case 214 -> 185;
                    case 215 -> 211;
                    case 216 -> 76;
                    case 217 -> 187;
                    case 218 -> 186;
                    case 219 -> 126;
                    case 220 -> 196;
                    case 221 -> 46;
                    case 222 -> 129;
                    case 223 -> 158;
                    case 224 -> 177;
                    case 225 -> 233;
                    case 226 -> 229;
                    case 227 -> 136;
                    case 228 -> 107;
                    case 229 -> 194;
                    case 230 -> 70;
                    case 231 -> 82;
                    case 232 -> 108;
                    case 233 -> 170;
                    case 234 -> 19;
                    case 235 -> 30;
                    case 236 -> 181;
                    case 237 -> 146;
                    case 238 -> 215;
                    case 239 -> 223;
                    case 240 -> 121;
                    case 241 -> 68;
                    case 242 -> 162;
                    case 243 -> 133;
                    case 244 -> 139;
                    case 245 -> 20;
                    case 246 -> 54;
                    case 247 -> 230;
                    case 248 -> 163;
                    case 249 -> 114;
                    case 250 -> 175;
                    case 251 -> 204;
                    case 252 -> 9;
                    case 253 -> 106;
                    case 254 -> 118;
                    default -> 122;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

