/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.router.RouterInfo;

public class DatabaseStoreMessage
extends FastI2NPMessageImpl {
    public static final int MESSAGE_TYPE = 1;
    private Hash _key;
    private DatabaseEntry _dbEntry;
    private byte[] _byteCache;
    private long _replyToken;
    private TunnelId _replyTunnel;
    private Hash _replyGateway;
    private boolean _receivedAsReply;

    public DatabaseStoreMessage(I2PAppContext context) {
        super(context);
    }

    public Hash getKey() {
        if (this._key != null) {
            return this._key;
        }
        if (this._dbEntry != null) {
            return this._dbEntry.getHash();
        }
        return null;
    }

    public DatabaseEntry getEntry() {
        return this._dbEntry;
    }

    public void setEntry(DatabaseEntry entry) {
        if (this._dbEntry != null) {
            throw new IllegalStateException();
        }
        this._dbEntry = entry;
    }

    public long getReplyToken() {
        return this._replyToken;
    }

    public void setReplyToken(long token) throws IllegalArgumentException {
        if (token > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Token too large: " + token + " (max=" + 0xFFFFFFFFL + ")");
        }
        if (token < 0L) {
            throw new IllegalArgumentException("Token too small: " + token);
        }
        this._replyToken = token;
    }

    public TunnelId getReplyTunnel() {
        return this._replyTunnel;
    }

    public void setReplyTunnel(TunnelId id) {
        this._replyTunnel = id;
    }

    public Hash getReplyGateway() {
        return this._replyGateway;
    }

    public void setReplyGateway(Hash peer) {
        this._replyGateway = peer;
    }

    public boolean getReceivedAsReply() {
        return this._receivedAsReply;
    }

    public void setReceivedAsReply() {
        this._receivedAsReply = true;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 1) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._key = Hash.create(data, curIndex);
        if (this._key.equals(Hash.FAKE_HASH)) {
            this._context.statManager().addRateData("netDb.DSMAllZeros", 1L);
            throw new I2NPMessageException("DSM all zeros");
        }
        int dbType = data[curIndex += 32] & 0xF;
        this._replyToken = DataHelper.fromLong(data, ++curIndex, 4);
        curIndex += 4;
        if (this._replyToken > 0L) {
            long tunnel = DataHelper.fromLong(data, curIndex, 4);
            if (tunnel > 0L) {
                this._replyTunnel = new TunnelId(tunnel);
            }
            this._replyGateway = Hash.create(data, curIndex += 4);
            curIndex += 32;
        } else {
            this._replyTunnel = null;
            this._replyGateway = null;
        }
        if (DatabaseEntry.isLeaseSet(dbType)) {
            this._dbEntry = dbType == 1 ? new LeaseSet() : (dbType == 3 ? new LeaseSet2() : (dbType == 5 ? new EncryptedLeaseSet() : new MetaLeaseSet()));
            try {
                this._dbEntry.readBytes(new ByteArrayInputStream(data, curIndex, data.length - curIndex));
            }
            catch (DataFormatException dfe) {
                throw new I2NPMessageException("Error reading the leaseSet", dfe);
            }
            catch (IOException ioe) {
                throw new I2NPMessageException("Error reading the leaseSet", ioe);
            }
        } else if ((dbType & 1) == 0) {
            this._dbEntry = new RouterInfo();
            int compressedSize = (int)DataHelper.fromLong(data, curIndex, 2);
            if (compressedSize <= 0 || (curIndex += 2) + compressedSize > data.length || curIndex + compressedSize > dataSize + offset) {
                throw new I2NPMessageException("Compressed RI length: " + compressedSize + " but remaining bytes: " + Math.min(data.length - curIndex, dataSize + offset - curIndex));
            }
            try {
                byte[] decompressed = DataHelper.decompress(data, curIndex, compressedSize);
                if (decompressed.length > 4096) {
                    throw new I2NPMessageException("RI too big: " + decompressed.length);
                }
                this._dbEntry.readBytes(new ByteArrayInputStream(decompressed));
            }
            catch (DataFormatException dfe) {
                throw new I2NPMessageException("Error reading the routerInfo", dfe);
            }
            catch (IOException ioe) {
                throw new I2NPMessageException("Corrupt compressed routerInfo size = " + compressedSize, ioe);
            }
        } else {
            throw new I2NPMessageException("Unknown type " + dbType);
        }
    }

    @Override
    protected int calculateWrittenLength() {
        if (this._dbEntry == null) {
            throw new IllegalStateException("Missing entry");
        }
        int len = 37;
        if (this._replyToken > 0L) {
            len += 36;
        }
        int type = this._dbEntry.getType();
        if (this._dbEntry.isLeaseSet()) {
            if (this._byteCache == null) {
                this._byteCache = this._dbEntry.toByteArray();
            }
        } else if (type == 0) {
            if (this._byteCache == null) {
                byte[] uncompressed = this._dbEntry.toByteArray();
                this._byteCache = DataHelper.compress(uncompressed);
            }
            len += 2;
        } else {
            throw new IllegalStateException("Invalid key type " + type);
        }
        return len += this._byteCache.length;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._dbEntry == null) {
            throw new I2NPMessageException("Missing entry");
        }
        int type = this._dbEntry.getType();
        if (type != 0 && !this._dbEntry.isLeaseSet()) {
            throw new I2NPMessageException("Invalid key type " + type);
        }
        System.arraycopy(this.getKey().getData(), 0, out, curIndex, 32);
        curIndex += 32;
        out[curIndex++] = (byte)type;
        DataHelper.toLong(out, curIndex, 4, this._replyToken);
        curIndex += 4;
        if (this._replyToken > 0L) {
            long replyTunnel = 0L;
            if (this._replyTunnel != null) {
                replyTunnel = this._replyTunnel.getTunnelId();
            }
            DataHelper.toLong(out, curIndex, 4, replyTunnel);
            System.arraycopy(this._replyGateway.getData(), 0, out, curIndex += 4, 32);
            curIndex += 32;
        }
        if (type == 0) {
            DataHelper.toLong(out, curIndex, 2, this._byteCache.length);
            curIndex += 2;
        }
        System.arraycopy(this._byteCache, 0, out, curIndex, this._byteCache.length);
        return curIndex += this._byteCache.length;
    }

    @Override
    public int getType() {
        return 1;
    }

    public int hashCode() {
        return DataHelper.hashCode(this.getKey()) + DataHelper.hashCode(this._dbEntry) + (int)this._replyToken + DataHelper.hashCode(this._replyTunnel) + DataHelper.hashCode(this._replyGateway);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseStoreMessage) {
            DatabaseStoreMessage msg = (DatabaseStoreMessage)object;
            return DataHelper.eq(this.getKey(), msg.getKey()) && DataHelper.eq(this._dbEntry, msg.getEntry()) && this._replyToken == msg._replyToken && DataHelper.eq(this._replyTunnel, msg._replyTunnel) && DataHelper.eq(this._replyGateway, msg._replyGateway);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DatabaseStoreMessage: ");
        buf.append("\n\tExpiration: ").append(new Date(this._expiration));
        buf.append("\n\tUnique ID: ").append(this.getUniqueId());
        if (this._replyToken != 0L) {
            buf.append("\n\tReply token: ").append(this._replyToken);
            buf.append("\n\tReply tunnel: ").append(this._replyTunnel);
            buf.append("\n\tReply gateway: ").append(this._replyGateway);
        }
        buf.append("\n\tKey: ");
        if (this._dbEntry.getType() == 0) {
            buf.append(this.getKey());
        } else {
            buf.append(this.getKey().toBase32());
        }
        buf.append("\n\tEntry: ").append(this._dbEntry);
        buf.append(']');
        return buf.toString();
    }
}

