/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.jboss.galleon.cli.PmCompleterInvocation;

public class GavCompleter
implements OptionCompleter<PmCompleterInvocation> {
    @Override
    public void complete(PmCompleterInvocation ci) {
        Path path = ci.getPmSession().getPmConfiguration().getMavenConfig().getLocalRepository();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try {
            this.doComplete(ci, path);
        }
        catch (IOException e) {
            return;
        }
    }

    private void doComplete(CompleterInvocation ci, Path repoHome) throws IOException {
        ArrayList<String> candidates = new ArrayList<String>();
        String currentValue = ci.getGivenCompleteValue();
        int groupSeparator = currentValue.indexOf(58);
        if (groupSeparator > 0) {
            String[] parts;
            Path currentDir = repoHome;
            for (String part : parts = currentValue.substring(0, groupSeparator).split("\\.")) {
                currentDir = currentDir.resolve(part);
            }
            if (groupSeparator == currentValue.length() - 1) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(currentDir);){
                    for (Path p : stream) {
                        if (!this.isArtifactDir(p)) continue;
                        candidates.add(currentValue + p.getFileName());
                    }
                }
                ci.setAppendSpace(false);
            } else {
                DirectoryStream<Path> stream;
                int artifactSeparator = currentValue.indexOf(58, groupSeparator + 1);
                if (artifactSeparator > 0) {
                    currentDir = currentDir.resolve(currentValue.substring(groupSeparator + 1, artifactSeparator));
                    if (artifactSeparator == currentValue.length() - 1) {
                        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(currentDir);){
                            for (Path p : stream2) {
                                if (!this.isVersionDir(p)) continue;
                                candidates.add(currentValue + p.getFileName());
                            }
                        }
                    } else {
                        String chunk = currentValue.substring(artifactSeparator + 1);
                        String prefix = currentValue.substring(0, artifactSeparator + 1);
                        stream = Files.newDirectoryStream(currentDir);
                        try {
                            for (Path p : stream) {
                                String dirName;
                                if (!this.isVersionDir(p) || !(dirName = p.getFileName().toString()).startsWith(chunk) || dirName.length() == chunk.length()) continue;
                                candidates.add(prefix + p.getFileName());
                            }
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                } else {
                    String chunk = currentValue.substring(groupSeparator + 1);
                    if (Files.exists(currentDir.resolve(chunk), new LinkOption[0]) && this.isArtifactDir(currentDir.resolve(chunk))) {
                        candidates.add(currentValue + ":");
                    }
                    String prefix = currentValue.substring(0, groupSeparator + 1);
                    stream = Files.newDirectoryStream(currentDir);
                    try {
                        for (Path p : stream) {
                            String dirName;
                            if (!this.isArtifactDir(p) || !(dirName = p.getFileName().toString()).startsWith(chunk) || dirName.length() == chunk.length()) continue;
                            candidates.add(prefix + p.getFileName());
                        }
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    ci.setAppendSpace(false);
                }
            }
        } else {
            this.completeGroup(currentValue, candidates, repoHome);
            ci.setAppendSpace(false);
        }
        ci.addAllCompleterValues(candidates);
    }

    private void completeGroup(String currentValue, List<String> candidates, Path repoHome) throws IOException {
        String prefix;
        String chunk;
        Path groupDir = repoHome;
        if (currentValue.isEmpty()) {
            chunk = "";
            prefix = "";
        } else {
            String[] parts = currentValue.split("\\.");
            if (currentValue.charAt(currentValue.length() - 1) == '.') {
                chunk = "";
                prefix = currentValue;
                for (String part : parts) {
                    groupDir = groupDir.resolve(part);
                }
            } else {
                if (parts.length == 1) {
                    chunk = parts[0];
                    prefix = "";
                } else {
                    int i = 0;
                    while (i < parts.length - 1) {
                        groupDir = groupDir.resolve(parts[i++]);
                    }
                    chunk = parts[parts.length - 1];
                    prefix = currentValue.substring(0, currentValue.length() - chunk.length());
                }
                this.trySeparators(groupDir.resolve(chunk), currentValue, candidates);
            }
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(groupDir);){
            for (Path p : stream) {
                if (!this.isGroupDir(p)) continue;
                String dirName = p.getFileName().toString();
                if (!chunk.isEmpty() && (!dirName.startsWith(chunk) || dirName.length() == chunk.length())) continue;
                candidates.add(prefix + dirName);
            }
        }
    }

    private void trySeparators(Path dir, String prefix, List<String> candidates) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            boolean group = false;
            boolean artifact = false;
            for (Path p : stream) {
                if (!artifact && this.isArtifactDir(p)) {
                    candidates.add(prefix + ":");
                    if (group) {
                        return;
                    }
                    artifact = true;
                    continue;
                }
                if (group || !this.isGroupDir(p)) continue;
                candidates.add(prefix + ".");
                if (artifact) {
                    return;
                }
                group = true;
            }
        }
    }

    private boolean isGroupDir(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        if (this.isVersionDir(dir) || this.isArtifactDir(dir)) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            Iterator<Path> iterator = stream.iterator();
            if (iterator.hasNext()) {
                Path p = iterator.next();
                boolean bl = !this.isVersionDir(p);
                return bl;
            }
        }
        return false;
    }

    private boolean isArtifactDir(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path p : stream) {
                if (!this.isVersionDir(p)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean isVersionDir(Path dir) throws IOException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path p : stream) {
                if (!p.getFileName().toString().endsWith(".zip")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

