/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.GUI;

public final class CanvasMouseListener
extends FreeColClientHolder
implements MouseListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseListener.class.getName());

    public CanvasMouseListener(FreeColClient freeColClient) {
        super(freeColClient);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        GUI gui = this.getGUI();
        if (e.isPopupTrigger()) {
            gui.showTilePopup(gui.tileAt(e.getX(), e.getY()));
            return;
        }
        switch (e.getButton()) {
            case 1: {
                if (gui.isGotoStarted()) {
                    gui.performGoto(e.getX(), e.getY());
                    break;
                }
                gui.prepareDrag(e.getX(), e.getY());
                break;
            }
            case 2: {
                gui.performGoto(e.getX(), e.getY());
                break;
            }
            case 3: {
                gui.showTilePopup(gui.tileAt(e.getX(), e.getY()));
                break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.getGUI().traverseGotoPath();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.getGUI().clickAt(e.getClickCount(), e.getX(), e.getY());
    }
}

