/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import com.sun.java.swing.plaf.windows.WindowsTableHeaderUI;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class XPTableHeaderUI
extends WindowsTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent h) {
        return new XPTableHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.originalHeaderRenderer = this.header.getDefaultRenderer();
        if (this.originalHeaderRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new PatchedTableCellRenderer(this.originalHeaderRenderer));
        }
    }

    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof PatchedTableCellRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(c);
    }

    private static class PatchedTableCellRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private TableCellRenderer delegate;

        PatchedTableCellRenderer(TableCellRenderer originalRenderer) {
            this.delegate = originalRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String txtValue = value == null ? " " : value.toString();
            txtValue = txtValue.length() > 0 ? txtValue : " ";
            return this.delegate.getTableCellRendererComponent(table, txtValue, isSelected, hasFocus, row, column);
        }
    }
}

