untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajXjcin1pp4Tjr/m3D3WptDeh01xRf2szPGUj6bJWqqBTJFiXJ2EZGC03ZELG34Ohc8fmj5aU9E1Biml9UM8yowQ=

OpenBSD 7.4 errata 003, November 21, 2023:

patch(1) with explicit patchfile did not work in 7.4 due to overeager
unveil(2) restrictions.

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 003_patch.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install patch(1):
    cd /usr/src/usr.bin/patch
    make obj
    make
    make install

Index: usr.bin/patch/patch.c
===================================================================
RCS file: /cvs/src/usr.bin/patch/patch.c,v
diff -u -p -r1.74 patch.c
--- usr.bin/patch/patch.c	19 Jul 2023 13:26:20 -0000	1.74
+++ usr.bin/patch/patch.c	30 Oct 2023 14:55:52 -0000
@@ -32,6 +32,7 @@

 #include <ctype.h>
 #include <getopt.h>
+#include <libgen.h>
 #include <limits.h>
 #include <paths.h>
 #include <stdio.h>
@@ -213,11 +214,27 @@ main(int argc, char *argv[])
 			perror("unveil");
 			my_exit(2);
 		}
-	if (filearg[0] != NULL)
+	if (filearg[0] != NULL) {
+		char *origdir;
+
 		if (unveil(filearg[0], "rwc") == -1) {
 			perror("unveil");
 			my_exit(2);
 		}
+		if ((origdir = dirname(filearg[0])) == NULL) {
+			perror("dirname");
+			my_exit(2);
+		}
+		if (unveil(origdir, "rwc") == -1) {
+			perror("unveil");
+			my_exit(2);
+		}
+	} else {
+		if (unveil(".", "rwc") == -1) {
+			perror("unveil");
+			my_exit(2);
+		}
+	}
 	if (filearg[1] != NULL)
 		if (unveil(filearg[1], "r") == -1) {
 			perror("unveil");
@@ -228,10 +245,6 @@ main(int argc, char *argv[])
 			perror("unveil");
 			my_exit(2);
 		}
-	if (unveil(".", "rwc") == -1) {
-		perror("unveil");
-		my_exit(2);
-	}
 	if (*rejname != '\0')
 		if (unveil(rejname, "rwc") == -1) {
 			perror("unveil");
