untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFu7Ikt4MN3028ocikx+Cv/PPnHfrZavnrpzj1X8AKVZbRHwmULi5PpJ7aQcCpRxqGeV0ipj0ykM7f5PoCUZbRwU=

OpenBSD 7.3 errata 008, July 12, 2023:

Incomplete validation of ELF headers in execve(2).

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 008_elf.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/exec_elf.c
===================================================================
RCS file: /cvs/src/sys/kern/exec_elf.c,v
diff -u -p -u -r1.180 exec_elf.c
--- sys/kern/exec_elf.c	16 Jan 2023 07:09:11 -0000	1.180
+++ sys/kern/exec_elf.c	10 Jul 2023 16:36:15 -0000
@@ -325,6 +325,11 @@ elf_load_file(struct proc *p, char *path
 		goto bad1;
 
 	for (i = 0; i < eh.e_phnum; i++) {
+		if ((ph[i].p_align > 1) && !powerof2(ph[i].p_align)) {
+			error = EINVAL;
+			goto bad1;
+		}
+
 		if (ph[i].p_type == PT_LOAD) {
 			if (ph[i].p_filesz > ph[i].p_memsz ||
 			    ph[i].p_memsz == 0) {
@@ -526,6 +531,11 @@ exec_elf_makecmds(struct proc *p, struct
 	epp->ep_dsize = ELF_NO_ADDR;
 
 	for (i = 0, pp = ph; i < eh->e_phnum; i++, pp++) {
+		if ((pp->p_align > 1) && !powerof2(pp->p_align)) {
+			error = EINVAL;
+			goto bad;
+		}
+
 		if (pp->p_type == PT_INTERP && !interp) {
 			if (pp->p_filesz < 2 || pp->p_filesz > MAXPATHLEN)
 				goto bad;
@@ -560,7 +570,7 @@ exec_elf_makecmds(struct proc *p, struct
 
 	if (eh->e_type == ET_DYN) {
 		/* need phdr and load sections for PIE */
-		if (!has_phdr || base_ph == NULL) {
+		if (!has_phdr || base_ph == NULL || base_ph->p_vaddr != 0) {
 			error = EINVAL;
 			goto bad;
 		}
