untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ6SONgNO5/HTxPldrHGAx1wiwG2bB9zaLNPAQsiS/gHkDll5PBCqGBMz+noxOlt3dXs19jGB4sl/DoOkkT1ingA=

OpenBSD 6.0 errata 023, May 11, 2017:

Heap-based buffer overflows in freetype can result in out-of-bounds writes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 023_freetype.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install freetype:
    cd /usr/xenocara/lib/freetype
    make obj
    make build

Index: lib/freetype/src/psaux/psobjs.c
===================================================================
RCS file: /cvs/xenocara/lib/freetype/src/psaux/psobjs.c,v
retrieving revision 1.16
diff -u -p -r1.16 psobjs.c
--- lib/freetype/src/psaux/psobjs.c	29 May 2016 11:57:13 -0000	1.16
+++ lib/freetype/src/psaux/psobjs.c	11 May 2017 00:42:36 -0000
@@ -1718,6 +1718,14 @@
     first = outline->n_contours <= 1
             ? 0 : outline->contours[outline->n_contours - 2] + 1;
 
+    /* in malformed fonts it can happen that a contour was started */
+    /* but no points were added                                    */
+    if ( outline->n_contours && first == outline->n_points )
+    {
+      outline->n_contours--;
+      return;
+    }
+
     /* We must not include the last point in the path if it */
     /* is located on the first point.                       */
     if ( outline->n_points > 1 )
Index: lib/freetype/src/psaux/t1decode.c
===================================================================
RCS file: /cvs/xenocara/lib/freetype/src/psaux/t1decode.c,v
retrieving revision 1.17
diff -u -p -r1.17 t1decode.c
--- lib/freetype/src/psaux/t1decode.c	29 May 2016 11:57:13 -0000	1.17
+++ lib/freetype/src/psaux/t1decode.c	11 May 2017 00:42:36 -0000
@@ -783,10 +783,19 @@
             /* point without adding any point to the outline    */
             idx = decoder->num_flex_vectors++;
             if ( idx > 0 && idx < 7 )
+            {
+              /* in malformed fonts it is possible to have other */
+              /* opcodes in the middle of a flex (which don't    */
+              /* increase `num_flex_vectors'); we thus have to   */
+              /* check whether we can add a point                */
+              if ( FT_SET_ERROR( t1_builder_check_points( builder, 1 ) ) )
+                goto Syntax_Error;
+
               t1_builder_add_point( builder,
                                     x,
                                     y,
                                     (FT_Byte)( idx == 3 || idx == 6 ) );
+            }
           }
           break;
 
