untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ7o+A63mXBBV1+V3puGKZ3Z68XY9NHGgRnxKcN7ghQcxfRRpvyqg1SapN+0vWxkNJ1D+qGivFx3yp54JJpdRKwg=

OpenBSD 6.0 errata 037, August 3, 2017:

An integer overflow in wsdisplay_cfg_ioctl() may result in
an out-of-bounds read.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 037_wsdisplay.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/wscons/wsdisplay.c
===================================================================
RCS file: /cvs/src/sys/dev/wscons/wsdisplay.c,v
--- sys/dev/wscons/wsdisplay.c	8 Sep 2015 11:13:20 -0000	1.124
+++ sys/dev/wscons/wsdisplay.c	2 Aug 2017 16:44:07 -0000
@@ -1305,6 +1305,10 @@ wsdisplay_cfg_ioctl(struct wsdisplay_sof
 #define d ((struct wsdisplay_font *)data)
 		if (!sc->sc_accessops->load_font)
 			return (EINVAL);
+		if (d->fontheight > 64 || d->stride > 8) /* 64x64 pixels */
+			return (EINVAL);
+		if (d->numchars > 65536) /* unicode plane */
+			return (EINVAL);
 		fontsz = d->fontheight * d->stride * d->numchars;
 		if (fontsz > WSDISPLAY_MAXFONTSZ)
 			return (EINVAL);
