untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ24PCOyb2HBxKaacU+v/hRSTKWxD36nnioxkUEf8rVVyhIhiqYHZzxv+A+vFP5uZcp2z9fIhREI0uPpgkmODmg4=

OpenBSD 6.0 errata 10, Oct 3, 2016:

A bug in the smtp session logic can lead to a server crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 010_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make depend
    make
    make install

Index: usr.sbin/smtpd/smtp_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtp_session.c,v
retrieving revision 1.284
diff -u -p -r1.284 smtp_session.c
--- usr.sbin/smtpd/smtp_session.c	22 Jul 2016 12:12:29 -0000	1.284
+++ usr.sbin/smtpd/smtp_session.c	2 Oct 2016 17:18:06 -0000
@@ -1151,6 +1151,7 @@ smtp_filter_response(uint64_t id, int qu
 			line = line ? line : "Message rejected";
 			smtp_reply(s, "%d %s", code, line);
 			smtp_enter_state(s, STATE_HELO);
+			s->phase = PHASE_SETUP;
 			io_reload(&s->io);
 			return;
 		}
@@ -1543,6 +1544,7 @@ smtp_data_io_done(struct smtp_session *s
 			smtp_reply(s, "421 Internal server error");
 		smtp_tx_free(s->tx);
 		smtp_enter_state(s, STATE_HELO);
+		s->phase = PHASE_SETUP;
 		io_reload(&s->io);
 	}
 	else {
