/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategoriesListener;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.core.ui.actions.LoadRecentSnapshot;
import org.graalvm.visualvm.uisupport.UISupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class LoadSnapshotAction
extends AbstractAction {
    private static final String ICON_PATH = "org/graalvm/visualvm/core/ui/resources/loadSnapshot.png";
    private static final Image ICON = ImageUtilities.loadImage((String)"org/graalvm/visualvm/core/ui/resources/loadSnapshot.png");
    private String lastFile = null;
    private String lastFilter = null;
    private static LoadSnapshotAction instance;

    public static synchronized LoadSnapshotAction instance() {
        if (instance == null) {
            instance = new LoadSnapshotAction();
            instance.updateEnabled(true);
            RegisteredSnapshotCategories.sharedInstance().addCategoriesListener(new SnapshotCategoriesListener(){

                @Override
                public void categoryRegistered(SnapshotCategory category) {
                    instance.updateEnabled(false);
                }

                @Override
                public void categoryUnregistered(SnapshotCategory category) {
                    instance.updateEnabled(false);
                }
            });
        }
        return instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileFilter fileFilter;
        List<SnapshotCategory> categories = RegisteredSnapshotCategories.sharedInstance().getOpenSnapshotCategories();
        if (categories.isEmpty()) {
            return;
        }
        final ArrayList<FileFilter> fileFilters = new ArrayList<FileFilter>();
        for (SnapshotCategory category : categories) {
            fileFilters.add(category.getFileFilter());
        }
        JFileChooser chooser = new JFileChooser(){

            @Override
            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
                if (!(this.getUI() instanceof BasicFileChooserUI)) {
                    return;
                }
                BasicFileChooserUI ui = (BasicFileChooserUI)this.getUI();
                ui.setFileName(file == null ? "" : file.getName());
            }
        };
        chooser.setDialogTitle(NbBundle.getMessage(LoadSnapshotAction.class, (String)"LBL_Load"));
        chooser.setAcceptAllFileFilterUsed(false);
        FileFilter allFilesFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                for (FileFilter ff : fileFilters) {
                    if (!ff.accept(f)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(LoadSnapshotAction.class, (String)"LBL_All_Snapshots");
            }
        };
        chooser.addChoosableFileFilter(allFilesFilter);
        int filterIndex = -1;
        for (int i = 0; i < fileFilters.size(); ++i) {
            fileFilter = (FileFilter)fileFilters.get(i);
            chooser.addChoosableFileFilter(fileFilter);
            if (!fileFilter.getDescription().equals(this.lastFilter)) continue;
            filterIndex = i;
        }
        if (this.lastFile != null) {
            chooser.setSelectedFile(new File(this.lastFile));
        }
        chooser.setFileFilter(filterIndex == -1 ? allFilesFilter : (FileFilter)fileFilters.get(filterIndex));
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile == null || !selectedFile.exists()) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(LoadSnapshotAction.class, (String)"MSG_Selected_file_does_not_exist"), 0));
            } else {
                fileFilter = chooser.getFileFilter();
                if (fileFilter == allFilesFilter) {
                    for (FileFilter ff : fileFilters) {
                        if (!ff.accept(selectedFile)) continue;
                        this.lastFile = selectedFile.getAbsolutePath();
                        this.lastFilter = null;
                        categories.get(fileFilters.indexOf(ff)).openSnapshot(selectedFile);
                        LoadRecentSnapshot.instance().addFile(selectedFile);
                        return;
                    }
                } else if (fileFilter.accept(selectedFile)) {
                    this.lastFile = selectedFile.getAbsolutePath();
                    this.lastFilter = fileFilter.getDescription();
                    categories.get(fileFilters.indexOf(fileFilter)).openSnapshot(selectedFile);
                    LoadRecentSnapshot.instance().addFile(selectedFile);
                    return;
                }
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(LoadSnapshotAction.class, (String)"MSG_Selected_file_does_not_match_snapshot_type"), 0));
            }
        }
    }

    private void updateEnabled(boolean lazily) {
        final boolean isEnabled = !RegisteredSnapshotCategories.sharedInstance().getOpenSnapshotCategories().isEmpty();
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                LoadSnapshotAction.this.setEnabled(isEnabled);
            }
        };
        if (lazily) {
            UISupport.runInEventDispatchThread((Runnable)updater);
        } else {
            UISupport.runInEventDispatchThreadAndWait((Runnable)updater);
        }
    }

    private LoadSnapshotAction() {
        this.putValue("Name", NbBundle.getMessage(LoadSnapshotAction.class, (String)"LBL_Load1"));
        this.putValue("ShortDescription", NbBundle.getMessage(LoadSnapshotAction.class, (String)"LBL_Load_Snapshot"));
        this.putValue("SmallIcon", new ImageIcon(ICON));
        this.putValue("iconBase", ICON_PATH);
    }
}

