/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.util.Arrays;
import org.openjdk.jmc.common.IState;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class StateElement
implements IState {
    private static final IState[] NO_CHILDREN = new StateElement[0];
    private final Element element;

    StateElement(Element element) {
        this.element = element;
    }

    @Override
    public String getType() {
        return this.element.getNodeName();
    }

    @Override
    public String[] getAttributeKeys() {
        NamedNodeMap nodeMap = this.element.getAttributes();
        String[] keys = new String[nodeMap.getLength()];
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            keys[i] = nodeMap.item(i).getNodeName();
        }
        return keys;
    }

    @Override
    public String getAttribute(String key) {
        Attr attribute = this.element.getAttributeNode(key);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    @Override
    public IState getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !type.equals(node.getNodeName())) continue;
            return new StateElement((Element)node);
        }
        return null;
    }

    @Override
    public IState[] getChildren() {
        return this.getChildren(null);
    }

    @Override
    public IState[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        if (nodes.getLength() == 0) {
            return NO_CHILDREN;
        }
        IState[] children = new IState[nodes.getLength()];
        int index = 0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element) || type != null && !type.equals(node.getNodeName())) continue;
            children[index++] = new StateElement((Element)node);
        }
        if (children.length != index) {
            children = Arrays.copyOf(children, index);
        }
        return children;
    }
}

