/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Response;

public class CalibrationDataResponse
extends Response {
    private double[] methodEntryExitCallTime;
    private double[] methodEntryExitInnerTime;
    private double[] methodEntryExitOuterTime;
    private long[] timerCountsInSecond;

    public CalibrationDataResponse(double[] callTime, double[] innerTime, double[] outerTime, long[] timerCountsInSecond) {
        super(true, 11);
        this.methodEntryExitCallTime = callTime;
        this.methodEntryExitInnerTime = innerTime;
        this.methodEntryExitOuterTime = outerTime;
        this.timerCountsInSecond = timerCountsInSecond;
    }

    CalibrationDataResponse() {
        super(true, 11);
    }

    public double[] getMethodEntryExitCallTime() {
        return this.methodEntryExitCallTime;
    }

    public double[] getMethodEntryExitInnerTime() {
        return this.methodEntryExitInnerTime;
    }

    public double[] getMethodEntryExitOuterTime() {
        return this.methodEntryExitOuterTime;
    }

    public long[] getTimerCountsInSecond() {
        return this.timerCountsInSecond;
    }

    public String toString() {
        return "CalibrationDataResponse, " + super.toString();
    }

    void readObject(ObjectInputStream in) throws IOException {
        int i;
        int len = in.readInt();
        this.methodEntryExitCallTime = new double[len];
        this.methodEntryExitInnerTime = new double[len];
        this.methodEntryExitOuterTime = new double[len];
        for (i = 0; i < len; ++i) {
            this.methodEntryExitCallTime[i] = in.readDouble();
        }
        for (i = 0; i < len; ++i) {
            this.methodEntryExitInnerTime[i] = in.readDouble();
        }
        for (i = 0; i < len; ++i) {
            this.methodEntryExitOuterTime[i] = in.readDouble();
        }
        this.timerCountsInSecond = new long[2];
        this.timerCountsInSecond[0] = in.readLong();
        this.timerCountsInSecond[1] = in.readLong();
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        int len = this.methodEntryExitCallTime.length;
        out.writeInt(len);
        for (i = 0; i < len; ++i) {
            out.writeDouble(this.methodEntryExitCallTime[i]);
        }
        for (i = 0; i < len; ++i) {
            out.writeDouble(this.methodEntryExitInnerTime[i]);
        }
        for (i = 0; i < len; ++i) {
            out.writeDouble(this.methodEntryExitOuterTime[i]);
        }
        out.writeLong(this.timerCountsInSecond[0]);
        out.writeLong(this.timerCountsInSecond[1]);
    }
}

